/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.document;

import com.jidesoft.document.DocumentPane;
import com.jidesoft.document.FloatingDocumentContainer;
import com.jidesoft.document.IDocumentPane;
import com.jidesoft.document.TdiGroup;
import com.jidesoft.document.TdiUtils;
import com.jidesoft.plaf.basic.BasicJideTabbedPaneUI;
import com.jidesoft.swing.Contour;
import com.jidesoft.swing.JideCursors;
import com.jidesoft.swing.JidePopupMenu;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.JideTabbedPane;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.SecurityUtils;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.JLayeredPane;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

class TdiDockingManager
implements SwingConstants,
AWTEventListener {
    double _relativeX;
    double _relativeY;
    private Contour _dragContour;
    private JRootPane _topLevelFrame;
    private JLayeredPane _activeLayerPane;
    private DocumentPane _documentPane;
    private TdiGroup _draggedGroup;
    private Component _draggedComponent;
    protected boolean _glassPaneVisiblity;
    protected Cursor _glassPaneCursor;
    protected PropertyChangeListener _focusPropertyChangeListener;

    public TdiDockingManager(DocumentPane documentPane) {
        this._documentPane = documentPane;
        this.addGlobalEventHandler();
    }

    private void addGlobalEventHandler() {
        if (this.shouldAWTEventListenerBeUsed()) {
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Toolkit.getDefaultToolkit().addAWTEventListener(TdiDockingManager.this, 28L);
                    return null;
                }
            });
        }
        catch (SecurityException securityException) {
            throw new RuntimeException(securityException);
        }
    }

    private boolean shouldAWTEventListenerBeUsed() {
        return SecurityUtils.isAWTEventListenerDisabled() || "true".equals(SecurityUtils.getProperty("jide.disableAWTEventListener", "false"));
    }

    private void removeGlobalEventHandler() {
        if (this.shouldAWTEventListenerBeUsed()) {
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Toolkit.getDefaultToolkit().removeAWTEventListener(TdiDockingManager.this);
                    return null;
                }
            });
        }
        catch (SecurityException securityException) {
            throw new RuntimeException(securityException);
        }
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent) {
        this.handleEvent(aWTEvent);
    }

    private void handleEvent(AWTEvent aWTEvent) {
        Component component;
        if (!(aWTEvent.getID() != 500 && aWTEvent.getID() != 501 && aWTEvent.getID() != 502 || aWTEvent.getSource() instanceof JideTabbedPane.NoFocusButton && ((JideTabbedPane.NoFocusButton)aWTEvent.getSource()).getType() == 0 || !((component = this.getSource(aWTEvent)) instanceof TdiGroup))) {
            this._documentPane._focusActiveDocument = null;
        }
        if (aWTEvent.getID() == 500 || aWTEvent.getID() == 501) {
            if (aWTEvent.getSource() instanceof JideTabbedPane.NoFocusButton && ((JideTabbedPane.NoFocusButton)aWTEvent.getSource()).getType() == 0) {
                return;
            }
            component = this.getSource(aWTEvent);
            if (component != null && component instanceof TdiGroup) {
                Container container = component.getParent();
                if (container instanceof IDocumentPane) {
                    ((IDocumentPane)((Object)container)).activateGroup((TdiGroup)component);
                } else {
                    Container container2 = ((TdiGroup)component).getTopLevelAncestor();
                    if (container2 instanceof FloatingDocumentContainer) {
                        ((FloatingDocumentContainer)((Object)container2)).getDocumentPane().activateGroup(((FloatingDocumentContainer)((Object)container2)).getDocumentGroup());
                    }
                }
                while (component != null) {
                    if ((component = TdiUtils.getGroupOf(component.getParent(), this._documentPane)) == null || !(component instanceof TdiGroup) || !((container = component.getParent()) instanceof IDocumentPane)) continue;
                    ((IDocumentPane)((Object)container)).activateGroup((TdiGroup)component);
                }
            }
        } else if (aWTEvent.getID() == 401 && (((KeyEvent)aWTEvent).getKeyCode() == 27 || ((KeyEvent)aWTEvent).getKeyCode() == 18)) {
            if (this.isDragging()) {
                this.cancelDragging();
            }
        } else if (aWTEvent.getID() == 1004 && aWTEvent instanceof FocusEvent && !"false".equals(SecurityUtils.getProperty("DocumentPane.autoActivateFocusOwner", ""))) {
            Component component2;
            component = this.getSource(aWTEvent);
            if (component == null) {
                component2 = ((FocusEvent)aWTEvent).getComponent();
                Component component3 = ((FocusEvent)aWTEvent).getOppositeComponent();
                Component component4 = TdiUtils.getGroupOf(component2, this._documentPane);
                Component component5 = TdiUtils.getGroupOf(component3, this._documentPane);
                if (component5 != null && component4 == null && TdiUtils.getDocumentComponentOf(component2, this._documentPane) != null) {
                    for (Container container = component2.getParent(); component4 == null && container != null; container = container.getParent()) {
                        component4 = JideSwingUtilities.findFirstComponentByClass(container, TdiGroup.class);
                    }
                    if (component4 != null) {
                        component4.requestFocusInWindow();
                    }
                }
            }
            if (component != null && component instanceof TdiGroup && (component2 = TdiUtils.getDocumentPane((TdiGroup)component)) != null && (((DocumentPane)component2)._focusActiveDocument == null || ((DocumentPane)component2).getDocumentGroup(((DocumentPane)component2)._focusActiveDocument) == component)) {
                ((DocumentPane)component2).activateGroup((TdiGroup)component);
            }
        }
    }

    private Component getSource(AWTEvent aWTEvent) {
        Component component = null;
        if (aWTEvent instanceof MouseEvent && aWTEvent.getID() != 506 && aWTEvent.getID() != 504 && aWTEvent.getID() != 505 && aWTEvent.getID() != 502) {
            MouseEvent mouseEvent = (MouseEvent)aWTEvent;
            Component component2 = mouseEvent.getComponent();
            if (component2 == null) {
                return null;
            }
            component = SwingUtilities.getDeepestComponentAt(component2, mouseEvent.getX(), mouseEvent.getY());
        } else if ((aWTEvent instanceof KeyEvent || aWTEvent instanceof FocusEvent) && aWTEvent.getSource() instanceof Component) {
            component = PortingUtils.getCurrentFocusComponent(aWTEvent);
        }
        return TdiUtils.getGroupOf(component, this._documentPane);
    }

    private JRootPane findRootPane() {
        Container container = SwingUtilities.getAncestorOfClass(JRootPane.class, this._documentPane);
        if (container instanceof JRootPane) {
            return (JRootPane)container;
        }
        throw new RuntimeException("Cannot find top level container.");
    }

    private JRootPane getRootPane() {
        this._topLevelFrame = this.findRootPane();
        return this._topLevelFrame;
    }

    void beginDragging(Component component, TdiGroup tdiGroup, int n) {
        if (component instanceof DocumentPane) {
            this._documentPane = (DocumentPane)component;
            if (!this._documentPane.isGroupsAllowed() || !this._documentPane.isRearrangeAllowed() || this._documentPane.getDocumentCount() <= 1) {
                return;
            }
        }
        if (n < 0) {
            return;
        }
        if (this._documentPane.isUseGlassPaneEnabled()) {
            this._glassPaneVisiblity = this.getRootPane().getGlassPane().isVisible();
            if (!this._glassPaneVisiblity) {
                this._glassPaneCursor = this.getRootPane().getGlassPane().getCursor();
                this.getRootPane().getGlassPane().setVisible(true);
            }
        }
        this._draggedGroup = tdiGroup;
        this._draggedComponent = tdiGroup.getComponentAt(n);
        this._dragContour = new Contour(this._draggedGroup.getTabHeight());
        this._dragContour.setOutlineMode(this._documentPane.isHeavyweightComponentEnabled() ? 2 : 0);
        this._dragContour.setVisible(false);
        this._activeLayerPane = this.getRootPane().getLayeredPane();
        this._activeLayerPane.add((Component)this._dragContour, JLayeredPane.DRAG_LAYER);
    }

    private Rectangle calculateContourBounds(Rectangle rectangle, Component component) {
        return SwingUtilities.convertRectangle(component, rectangle, this._activeLayerPane);
    }

    private void repaintBounds() {
        this._dragContour.repaint();
        this._activeLayerPane.repaint();
    }

    void drag(Component component, int n, int n2) {
        TdiGroup tdiGroup;
        if (!this.isDragging()) {
            return;
        }
        Component component2 = this._documentPane.findComponentAt(n, n2);
        if (component2 == null) {
            if (this._documentPane.isUseGlassPaneEnabled()) {
                this.getRootPane().getGlassPane().setCursor(JideCursors.getPredefinedCursor(23));
            }
            this._dragContour.setAttachedComponent(null);
            this._dragContour.setVisible(false);
            this._dragContour.setAllowDocking(false);
            return;
        }
        if (this._documentPane.isUseGlassPaneEnabled()) {
            this.getRootPane().getGlassPane().setCursor(JideCursors.getPredefinedCursor(22));
        }
        if ((tdiGroup = (TdiGroup)TdiUtils.getGroupOf(component2, this._documentPane)) == null) {
            return;
        }
        if (component2.equals(((BasicJideTabbedPaneUI)tdiGroup.getUI()).getTabPanel())) {
            Rectangle rectangle = tdiGroup.getBounds();
            this._dragContour.setVisible(true);
            this._dragContour.setAllowDocking(true);
            this._dragContour.setAttachedComponent(tdiGroup);
            this._dragContour.setAttachedSide(1);
            if (tdiGroup.getTabPlacement() == 1) {
                rectangle.y += this._dragContour.getTabHeight();
                rectangle.height -= this._dragContour.getTabHeight();
            } else {
                rectangle.height -= this._dragContour.getTabHeight();
            }
            this._dragContour.setBounds(this.calculateContourBounds(rectangle, this._documentPane));
            this.repaintBounds();
            return;
        }
        Point point = SwingUtilities.convertPoint(this._documentPane, n, n2, tdiGroup);
        int n3 = TdiUtils.sideOfComponent(tdiGroup, point.x, point.y);
        boolean bl = false;
        boolean bl2 = false;
        if (this._documentPane.isMoreDocumentGroupAllowed()) {
            if (this._documentPane.getComponentCount() == 1) {
                bl = true;
                bl2 = true;
            } else if (this._documentPane.getOrientation() == 0) {
                bl = true;
            } else {
                bl2 = true;
            }
        }
        if (!this._documentPane.isGroupsAllowed() || this._draggedGroup.equals(tdiGroup) && this._draggedGroup.getTabCount() == 1) {
            bl2 = false;
            bl = false;
        }
        if (n3 == 5 && bl) {
            Rectangle rectangle = tdiGroup.getBounds();
            this._dragContour.setVisible(true);
            this._dragContour.setAllowDocking(true);
            this._dragContour.setAttachedComponent(tdiGroup);
            this._dragContour.setAttachedSide(n3);
            rectangle.y += rectangle.height / 2;
            rectangle.height /= 2;
            this._dragContour.setBounds(this.calculateContourBounds(rectangle, this._documentPane));
            this.repaintBounds();
        } else if (n3 == 3 && bl2) {
            Rectangle rectangle = tdiGroup.getBounds();
            this._dragContour.setVisible(true);
            this._dragContour.setAllowDocking(true);
            this._dragContour.setAttachedComponent(tdiGroup);
            this._dragContour.setAttachedSide(n3);
            rectangle.x += rectangle.width / 2;
            rectangle.width /= 2;
            this._dragContour.setBounds(this.calculateContourBounds(rectangle, this._documentPane));
            this.repaintBounds();
        } else {
            this._dragContour.setBounds(0, 0, 0, 0);
            this._dragContour.setVisible(false);
            this._dragContour.setAllowDocking(false);
            this._dragContour.setAttachedComponent(tdiGroup);
        }
    }

    void pauseDragging() {
        if (this._documentPane.isUseGlassPaneEnabled()) {
            this.getRootPane().getGlassPane().setCursor(this._glassPaneCursor);
        }
        if (this._dragContour != null) {
            this._dragContour.setVisible(false);
            this._dragContour.setAllowDocking(false);
            this._dragContour.setAttachedComponent(null);
        }
    }

    void endDragging(Component component, Point point) {
        if (!this.isDragging()) {
            return;
        }
        if (this._documentPane.isUseGlassPaneEnabled() && !this._glassPaneVisiblity) {
            this.getRootPane().getGlassPane().setVisible(this._glassPaneVisiblity);
            this.getRootPane().getGlassPane().setCursor(this._glassPaneCursor);
        }
        if (this._dragContour != null && this._dragContour.isAllowDocking()) {
            Component component2 = this._dragContour.getAttachedComponent();
            int n = this._dragContour.getAttachedSide();
            if (n == 5) {
                this._documentPane.newDocumentGroup(this.getNameOf(this._draggedComponent), this._documentPane.indexOfPane(component2) + 1, 0);
            } else if (n == 3) {
                this._documentPane.newDocumentGroup(this.getNameOf(this._draggedComponent), this._documentPane.indexOfPane(component2) + 1, 1);
            } else if (n == 1) {
                this._documentPane.moveDocument(this.getNameOf(this._draggedComponent), this._documentPane.indexOfPane(component2));
            }
        } else if (this._dragContour != null && !this._dragContour.isAllowDocking() && this._dragContour.getAttachedComponent() != null) {
            TdiGroup tdiGroup = (TdiGroup)this._dragContour.getAttachedComponent();
            this.showContextMenu(component, point, tdiGroup, this._draggedComponent, false);
        }
        this.cleanUp();
    }

    private void cleanUp() {
        this._dragContour.setVisible(false);
        this._activeLayerPane.remove(this._dragContour);
        this._dragContour = null;
        this._activeLayerPane = null;
        this._draggedGroup = null;
        this._draggedComponent = null;
    }

    public void showContextMenu(Component component, Point point, TdiGroup tdiGroup, Component component2, boolean bl) {
        if (!this._documentPane.isShowContextMenu()) {
            return;
        }
        JidePopupMenu jidePopupMenu = new JidePopupMenu();
        this._documentPane.populateContextMenu(jidePopupMenu, component2, this._draggedGroup, tdiGroup, bl);
        jidePopupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                TdiDockingManager.this._draggedGroup = null;
                TdiDockingManager.this._draggedComponent = null;
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                TdiDockingManager.this._draggedGroup = null;
                TdiDockingManager.this._draggedComponent = null;
            }
        });
        this._documentPane.customizePopupMenu(jidePopupMenu, this.getNameOf(component2), tdiGroup, bl);
        if (jidePopupMenu.getComponentOrientation().isLeftToRight() != this._documentPane.getComponentOrientation().isLeftToRight()) {
            JideSwingUtilities.toggleRTLnLTR(jidePopupMenu);
        }
        if (jidePopupMenu.getComponentCount() > 0) {
            if (point.x + jidePopupMenu.getPreferredSize().width >= this._documentPane.getWidth()) {
                point.x -= jidePopupMenu.getPreferredSize().width;
                if (point.x < 0) {
                    point.x = 0;
                }
            }
            if (point.y + jidePopupMenu.getPreferredSize().height >= this._documentPane.getHeight()) {
                point.y -= jidePopupMenu.getPreferredSize().height;
                if (point.y < 0) {
                    point.y = 0;
                }
            }
            ((JPopupMenu)jidePopupMenu).show(component, point.x, point.y);
        }
    }

    private boolean isDragging() {
        return this._dragContour != null;
    }

    private void cancelDragging() {
        if (this._documentPane.isUseGlassPaneEnabled() && !this._glassPaneVisiblity) {
            this.getRootPane().getGlassPane().setVisible(this._glassPaneVisiblity);
            this.getRootPane().getGlassPane().setCursor(this._glassPaneCursor);
        }
        if (this._dragContour != null) {
            this._dragContour.setVisible(false);
            this._activeLayerPane.remove(this._dragContour);
            this._dragContour = null;
            this._activeLayerPane.repaint();
            this._draggedGroup = null;
            this._draggedComponent = null;
        }
    }

    public String getNameOf(Component component) {
        return this._documentPane.getNameOf(component);
    }

    public void dispose() {
        if (this._documentPane != null) {
            this._documentPane = null;
        }
        this._topLevelFrame = null;
        this.removeGlobalEventHandler();
    }
}

