/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.document;

import com.jidesoft.document.DocumentComponentEvent;
import com.jidesoft.document.DocumentComponentListener;
import com.jidesoft.document.FloatingDocumentContainer;
import com.jidesoft.document.IDocumentPane;
import com.jidesoft.document.PreviousState;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.JideFocusTracker;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.EventListenerList;

public class DocumentComponent {
    private static final Logger LOGGER_EVENT;
    private String _name;
    private String _title;
    private String _tooltip;
    private Icon _icon;
    private Color _background;
    private Color _foreground;
    private JComponent _component;
    private boolean _allowClosing = true;
    private boolean _allowMoving = true;
    private boolean _closable = true;
    private IDocumentPane _documentPane;
    private final EventListenerList listenerList = new EventListenerList();
    private Component _defaultFocusComponent;
    private Component _lastFocusedComponent;
    private JideFocusTracker _currentFocusOwnerTracker;
    private FocusAdapter _focusListener;
    private PreviousState _dockPreviousState;
    private PreviousState _floatPreviousState;
    private PropertyChangeSupport changeSupport;
    public static final String PROPERTY_ICON = "icon";
    public static final String PROPERTY_TITLE = "title";
    public static final String PROPERTY_TOOLTIP = "tooltip";
    public static final String PROPERTY_BACKGROUND = "background";
    public static final String PROPERTY_FOREGROUND = "foreground";
    public static final String PROPERTY_COMPONENT = "component";
    public static final String PROPERTY_CLOSABLE = "closable";
    public static final String PROPERTY_ENABLED = "enabled";

    public DocumentComponent(JComponent jComponent, String string) {
        this(jComponent, string, string, null);
    }

    public DocumentComponent(JComponent jComponent, String string, String string2) {
        this(jComponent, string, string2, null);
    }

    public DocumentComponent(JComponent jComponent, String string, String string2, Icon icon) {
        this._name = string;
        this._title = string2;
        this._icon = icon;
        this._focusListener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                DocumentComponent.this.setLastFocusedComponent(focusEvent.getComponent());
            }
        };
        this.setComponent(jComponent);
    }

    public IDocumentPane getDocumentPane() {
        return this._documentPane;
    }

    public void cleanup() {
        if (this._currentFocusOwnerTracker != null) {
            this._currentFocusOwnerTracker.removeFocusListener(this._focusListener);
            this._currentFocusOwnerTracker.setHighestComponent(null);
            this._currentFocusOwnerTracker = null;
        }
    }

    protected void setDocumentPane(IDocumentPane iDocumentPane) {
        if (this._documentPane instanceof PropertyChangeListener) {
            this.removePropertyChangeListener(PROPERTY_CLOSABLE, (PropertyChangeListener)((Object)this._documentPane));
        }
        this._documentPane = iDocumentPane;
        if (this._documentPane instanceof PropertyChangeListener) {
            this.addPropertyChangeListener(PROPERTY_CLOSABLE, (PropertyChangeListener)((Object)this._documentPane));
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        String string2 = this._name;
        if (!JideSwingUtilities.equals(string2, string)) {
            this._name = string;
            this.renamePreviousState(string2, this._name, this._dockPreviousState);
            this.renamePreviousState(string2, this._name, this._floatPreviousState);
        }
    }

    protected void renamePreviousState(String string, String string2, PreviousState previousState) {
        if (previousState != null && previousState.documentNames != null) {
            List<String> list = previousState.documentNames;
            for (int i = 0; i < list.size(); ++i) {
                String string3 = list.get(i);
                if (!string3.equals(string)) continue;
                list.set(i, string2);
            }
            List<List<String>> list2 = previousState.allDocumentNames;
            for (List list3 : list2) {
                for (int i = 0; i < list3.size(); ++i) {
                    String string4 = (String)list3.get(i);
                    if (!string4.equals(string)) continue;
                    list.set(i, string2);
                }
            }
        }
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String string) {
        String string2 = this._title;
        this._title = string;
        this.firePropertyChange(PROPERTY_TITLE, string2, this._title);
    }

    public String getTooltip() {
        if (this._tooltip == null) {
            String string = this.getTitle();
            if (this.getDocumentPane() != null && this.getDocumentPane().getTitleConverter() != null) {
                string = this.getDocumentPane().getTitleConverter().convert(string);
            }
            return string;
        }
        return this._tooltip;
    }

    public void setTooltip(String string) {
        String string2 = this._tooltip;
        this._tooltip = string;
        this.firePropertyChange(PROPERTY_TOOLTIP, string2, this._tooltip);
    }

    public Icon getIcon() {
        return this._icon;
    }

    public void setIcon(Icon icon) {
        Icon icon2 = this._icon;
        this._icon = icon;
        this.firePropertyChange(PROPERTY_ICON, icon2, this._icon);
    }

    public Color getBackground() {
        return this._background;
    }

    public void setBackground(Color color) {
        Color color2 = this._background;
        this._background = color;
        this.firePropertyChange(PROPERTY_BACKGROUND, color2, this._background);
    }

    public Color getForeground() {
        return this._foreground;
    }

    public void setForeground(Color color) {
        Color color2 = this._foreground;
        this._foreground = color;
        this.firePropertyChange(PROPERTY_FOREGROUND, color2, this._foreground);
    }

    public JComponent getComponent() {
        return this._component;
    }

    public void setComponent(JComponent jComponent) {
        JComponent jComponent2 = this._component;
        if (this._component != null && this._currentFocusOwnerTracker != null) {
            this._currentFocusOwnerTracker.removeFocusListener(this._focusListener);
            this._currentFocusOwnerTracker = null;
        }
        this._component = jComponent;
        if (this._component != null) {
            this._component.setMinimumSize(new Dimension(0, 0));
            this._currentFocusOwnerTracker = this.createFocusTracker(this._component);
            this._currentFocusOwnerTracker.addFocusListener(this._focusListener);
        }
        this.firePropertyChange(PROPERTY_COMPONENT, jComponent2, this._component);
    }

    protected JideFocusTracker createFocusTracker(Container container) {
        return new JideFocusTracker(container);
    }

    public String getDisplayTitle() {
        return this.getTitle();
    }

    public void setAllowClosing(boolean bl) {
        this._allowClosing = bl;
    }

    public boolean allowClosing() {
        return this._allowClosing;
    }

    public void setAllowMoving(boolean bl) {
        this._allowMoving = bl;
    }

    public boolean allowMoving() {
        return this._allowMoving;
    }

    public void addDocumentComponentListener(DocumentComponentListener documentComponentListener) {
        this.listenerList.add(DocumentComponentListener.class, documentComponentListener);
    }

    public void removeDocumentComponentListener(DocumentComponentListener documentComponentListener) {
        this.listenerList.remove(DocumentComponentListener.class, documentComponentListener);
    }

    public DocumentComponentListener[] getDocumentComponentListeners() {
        return (DocumentComponentListener[])this.listenerList.getListeners(DocumentComponentListener.class);
    }

    void fireDocumentComponentEvent(int n) {
        if (LOGGER_EVENT.isLoggable(Level.FINE)) {
            switch (n) {
                case 5999: {
                    LOGGER_EVENT.fine("Document " + this.getName() + " opened");
                    break;
                }
                case 6000: {
                    LOGGER_EVENT.fine("Document " + this.getName() + " closing");
                    break;
                }
                case 6001: {
                    LOGGER_EVENT.fine("Document " + this.getName() + " closed");
                    break;
                }
                case 6002: {
                    LOGGER_EVENT.fine("Document " + this.getName() + " activated");
                    break;
                }
                case 6003: {
                    LOGGER_EVENT.fine("Document " + this.getName() + " deactivated");
                    break;
                }
                case 6004: {
                    LOGGER_EVENT.fine("Document " + this.getName() + " moving");
                    break;
                }
                case 6005: {
                    LOGGER_EVENT.fine("Document " + this.getName() + " moved");
                    break;
                }
                case 6006: {
                    LOGGER_EVENT.fine("Document " + this.getName() + " docked");
                    break;
                }
                case 6007: {
                    LOGGER_EVENT.fine("Document " + this.getName() + " floated");
                    break;
                }
            }
        }
        Object[] objectArray = this.listenerList.getListenerList();
        AWTEvent aWTEvent = null;
        block22: for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != DocumentComponentListener.class) continue;
            if (aWTEvent == null) {
                aWTEvent = new DocumentComponentEvent(this, n);
            }
            switch (aWTEvent.getID()) {
                case 5999: {
                    ((DocumentComponentListener)objectArray[i + 1]).documentComponentOpened((DocumentComponentEvent)aWTEvent);
                    continue block22;
                }
                case 6000: {
                    ((DocumentComponentListener)objectArray[i + 1]).documentComponentClosing((DocumentComponentEvent)aWTEvent);
                    continue block22;
                }
                case 6001: {
                    ((DocumentComponentListener)objectArray[i + 1]).documentComponentClosed((DocumentComponentEvent)aWTEvent);
                    continue block22;
                }
                case 6002: {
                    ((DocumentComponentListener)objectArray[i + 1]).documentComponentActivated((DocumentComponentEvent)aWTEvent);
                    continue block22;
                }
                case 6003: {
                    ((DocumentComponentListener)objectArray[i + 1]).documentComponentDeactivated((DocumentComponentEvent)aWTEvent);
                    continue block22;
                }
                case 6004: {
                    ((DocumentComponentListener)objectArray[i + 1]).documentComponentMoving((DocumentComponentEvent)aWTEvent);
                    continue block22;
                }
                case 6005: {
                    ((DocumentComponentListener)objectArray[i + 1]).documentComponentMoved((DocumentComponentEvent)aWTEvent);
                    continue block22;
                }
                case 6006: {
                    ((DocumentComponentListener)objectArray[i + 1]).documentComponentDocked((DocumentComponentEvent)aWTEvent);
                    continue block22;
                }
                case 6007: {
                    ((DocumentComponentListener)objectArray[i + 1]).documentComponentFloated((DocumentComponentEvent)aWTEvent);
                    continue block22;
                }
            }
        }
    }

    public Component getDefaultFocusComponent() {
        if (this._defaultFocusComponent == null) {
            return this._component;
        }
        return this._defaultFocusComponent;
    }

    public void setDefaultFocusComponent(Component component) {
        this._defaultFocusComponent = component;
    }

    public Component getLastFocusedComponent() {
        return this._lastFocusedComponent;
    }

    protected void setLastFocusedComponent(Component component) {
        this._lastFocusedComponent = component;
    }

    public void refocusLastFocusedComponent() {
        Component component;
        if (this._component != this.getLastFocusedComponent() && JideSwingUtilities.passesFocusabilityTest(component = this.getLastFocusedComponent())) {
            this.requestFocusForComponent(component);
            return;
        }
        if (this._component != this.getDefaultFocusComponent() && JideSwingUtilities.passesFocusabilityTest(component = this.getDefaultFocusComponent())) {
            this.requestFocusForComponent(component);
            return;
        }
        if (!JideSwingUtilities.compositeRequestFocus(this._component)) {
            this.requestFocusForComponent(this._component);
        }
    }

    private void requestFocusForComponent(Component component) {
        Container container;
        component.requestFocusInWindow();
        if (component instanceof JComponent && (container = ((JComponent)component).getTopLevelAncestor()) instanceof FloatingDocumentContainer) {
            if (container instanceof Frame) {
                if (((Frame)container).getState() == 1) {
                    ((Frame)container).setState(0);
                } else {
                    ((Frame)container).toFront();
                }
            } else {
                ((FloatingDocumentContainer)((Object)container)).toFront();
            }
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String string) {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners(string);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        PropertyChangeSupport propertyChangeSupport = this.changeSupport;
        if (propertyChangeSupport == null) {
            return;
        }
        propertyChangeSupport.firePropertyChange(string, object, object2);
    }

    protected void firePropertyChange(String string, boolean bl, boolean bl2) {
        PropertyChangeSupport propertyChangeSupport = this.changeSupport;
        if (propertyChangeSupport == null) {
            return;
        }
        propertyChangeSupport.firePropertyChange(string, bl, bl2);
    }

    protected void firePropertyChange(String string, int n, int n2) {
        PropertyChangeSupport propertyChangeSupport = this.changeSupport;
        if (propertyChangeSupport == null) {
            return;
        }
        propertyChangeSupport.firePropertyChange(string, n, n2);
    }

    public boolean isClosable() {
        return this._closable;
    }

    public void setClosable(boolean bl) {
        boolean bl2 = this._closable;
        if (bl != bl2) {
            this._closable = bl;
            this.firePropertyChange(PROPERTY_CLOSABLE, bl2, this._closable);
        }
    }

    public PreviousState getDockPreviousState() {
        return this._dockPreviousState;
    }

    public void setDockPreviousState(PreviousState previousState) {
        this._dockPreviousState = previousState;
    }

    public PreviousState getFloatPreviousState() {
        return this._floatPreviousState;
    }

    public void setFloatPreviousState(PreviousState previousState) {
        this._floatPreviousState = previousState;
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(2)) {
            Lm.showInvalidProductMessage(DocumentComponent.class.getName(), 2);
        }
        LOGGER_EVENT = Logger.getLogger(DocumentComponentEvent.class.getName());
    }
}

