/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.ContainerContainer;
import com.jidesoft.docking.DefaultDockingManager;
import com.jidesoft.docking.DockableHolder;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.docking.Refocusable;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideSplitPane;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.JideFocusTracker;
import com.jidesoft.utils.SecurityUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.lang.ref.WeakReference;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.plaf.UIResource;

public class Workspace
extends JPanel
implements DockableHolder,
Refocusable {
    private static final Logger LOGGER_FOCUS = Logger.getLogger(DefaultDockingManager.class.getName() + ".focus");
    private DockingManager _dockingManager;
    private boolean _acceptDockableFrame = true;
    private WeakReference<Component> _defaultFocusComponent;
    private WeakReference<Component> _lastFocusedComponent;
    private String _layoutConstraint = null;
    private boolean _adjustOpacityOnFly = false;

    public Workspace() {
        this((DockingManager)null);
    }

    public Workspace(DockingManager dockingManager) {
        super(new BorderLayout());
        this.setDockingManager(dockingManager);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        JideFocusTracker jideFocusTracker = this.createFocusTracker(this);
        jideFocusTracker.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    Workspace.this.setLastFocusedComponent(focusEvent.getComponent());
                }
            }
        });
        this.setOpaque(false);
        this.updateUI();
    }

    protected JideFocusTracker createFocusTracker(Container container) {
        return new JideFocusTracker(container);
    }

    public boolean isAdjustOpacityOnFly() {
        return this._adjustOpacityOnFly;
    }

    public void setAdjustOpacityOnFly(boolean bl) {
        this._adjustOpacityOnFly = bl;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (!this.isOpaque() && this.isAdjustOpacityOnFly() && this.isEmpty(this)) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    private boolean isEmpty(Container container) {
        return container.getComponentCount() == 0 || container.getComponentCount() == 1 && container.getComponent(0) instanceof JideSplitPane && this.isEmpty((Container)container.getComponent(0));
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.getBackground() == null || this.getBackground() instanceof UIResource) {
            this.setBackground(UIDefaultsLookup.getColor("Workspace.background"));
        }
    }

    public boolean isAcceptDockableFrame() {
        return this._acceptDockableFrame;
    }

    public void setAcceptDockableFrame(boolean bl) {
        this._acceptDockableFrame = bl;
    }

    @Override
    public boolean requestFocusInInternalWindow() {
        Component component;
        if (this.getDockingManager() == null) {
            LOGGER_FOCUS.fine("Workspace :requestFocusInInternalWindow: returning false DockingManager == null.");
            return false;
        }
        if (this.getComponentCount() == 0) {
            return this.requestFocusInWindow();
        }
        if (this != this.getFocusedComponent() && this.isAncestorOf(component = this.getFocusedComponent()) && JideSwingUtilities.passesFocusabilityTest(component)) {
            return component.requestFocusInWindow();
        }
        component = this.getDefaultFocusComponent();
        if (this != component && this.isAncestorOf(component) && JideSwingUtilities.passesFocusabilityTest(component)) {
            return component.requestFocusInWindow();
        }
        if (!JideSwingUtilities.compositeRequestFocus(this.getComponent(0))) {
            return this.requestFocusInWindow();
        }
        return true;
    }

    public boolean requestFocusInInternalWindowNew() {
        if (this.getDockingManager() == null) {
            return false;
        }
        Component component = this.getFocusedComponent();
        boolean bl = JideSwingUtilities.passesFocusabilityTest(component);
        if (bl) {
            component.requestFocus();
            return true;
        }
        bl = JideSwingUtilities.compositeRequestFocus(this);
        return bl;
    }

    @Override
    public Component getFocusedComponent() {
        if (this._lastFocusedComponent == null) {
            return this.getDefaultFocusComponent();
        }
        return (Component)this._lastFocusedComponent.get();
    }

    protected void setLastFocusedComponent(Component component) {
        if (component == this) {
            component = null;
        }
        this._lastFocusedComponent = new WeakReference<Component>(component);
    }

    @Override
    public Component getDefaultFocusComponent() {
        return this._defaultFocusComponent != null ? (Component)this._defaultFocusComponent.get() : null;
    }

    @Override
    public void setDefaultFocusComponent(Component component) {
        this._defaultFocusComponent = new WeakReference<Component>(component);
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        if (!(component instanceof ContainerContainer)) {
            this.setAcceptDockableFrame(false);
        }
        super.addImpl(component, object, n);
    }

    public void setDockingManager(DockingManager dockingManager) {
        this._dockingManager = dockingManager;
    }

    @Override
    public DockingManager getDockingManager() {
        return this._dockingManager;
    }

    public String getLayoutConstraint() {
        if (this._layoutConstraint == null || !"vary".equals(this._layoutConstraint) && !"flexible".equals(this._layoutConstraint) && !"fix".equals(this._layoutConstraint)) {
            return SecurityUtils.getProperty("jide.workspaceConstraints", "vary");
        }
        return this._layoutConstraint;
    }

    public void setLayoutConstraint(String string) {
        this._layoutConstraint = string;
    }
}

