/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.AutoHideContainer;
import com.jidesoft.docking.ContainerContainer;
import com.jidesoft.docking.DefaultDockingManager;
import com.jidesoft.docking.DockContext;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.docking.DockingUtils;
import com.jidesoft.docking.FloatingContainer;
import com.jidesoft.docking.FloatingFrames;
import com.jidesoft.docking.FrameContainer;
import com.jidesoft.docking.HiddenFrames;
import com.jidesoft.docking.PreviousState;
import com.jidesoft.docking.Workspace;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.SidePaneGroup;
import com.jidesoft.swing.SidePaneItem;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

class SaveUtils {
    private static final int COC = 1123;
    private static final int FRC = 1124;
    private static final int DF = 1125;
    private static final int WKS = 1126;
    private static final int FLC = 1127;
    protected static final int INVALID_COMPONENT = 65535;
    private static final int HIDE_OFFSCREEN_OFFSET = 10000;

    SaveUtils() {
    }

    static short readShort(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readShort();
    }

    static void writeShort(DataOutputStream dataOutputStream, short s) throws IOException {
        dataOutputStream.writeShort(s);
    }

    static int readInt(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readInt();
    }

    static void writeInt(DataOutputStream dataOutputStream, int n) throws IOException {
        dataOutputStream.writeInt(n);
    }

    static String readString(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        if (n > 0x100000) {
            throw new IOException("The layout is corrupted. Please remove it and try again. The length of the string as " + n + " is too long.");
        }
        if (n == -1) {
            throw new IOException("The layout is corrupted. Please remove it and try again. The string length as -1 is invalid.");
        }
        char[] cArray = new char[n];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = dataInputStream.readChar();
        }
        return new String(cArray);
    }

    static void writeString(DataOutputStream dataOutputStream, String string) throws IOException {
        dataOutputStream.writeInt(string.length());
        for (int i = 0; i < string.length(); ++i) {
            dataOutputStream.writeChar(string.charAt(i));
        }
    }

    static Dimension readSize(DataInputStream dataInputStream) throws IOException {
        Dimension dimension = new Dimension(dataInputStream.readInt(), dataInputStream.readInt());
        return SaveUtils.detectWrongSize(dimension);
    }

    static void writeSize(DataOutputStream dataOutputStream, Component component) throws IOException {
        Dimension dimension = component.getPreferredSize();
        if (dimension == null || SystemInfo.isJdk15Above() && !component.isPreferredSizeSet()) {
            dataOutputStream.writeInt(-1);
            dataOutputStream.writeInt(-1);
        } else {
            dataOutputStream.writeInt(dimension.width);
            dataOutputStream.writeInt(dimension.height);
        }
    }

    static Rectangle readRectangle(DataInputStream dataInputStream) throws IOException {
        return new Rectangle(dataInputStream.readInt(), dataInputStream.readInt(), dataInputStream.readInt(), dataInputStream.readInt());
    }

    static void writeRectangle(DataOutputStream dataOutputStream, Rectangle rectangle) throws IOException {
        if (rectangle == null) {
            dataOutputStream.writeInt(60);
            dataOutputStream.writeInt(60);
            dataOutputStream.writeInt(200);
            dataOutputStream.writeInt(200);
        } else {
            dataOutputStream.writeInt(rectangle.x);
            dataOutputStream.writeInt(rectangle.y);
            dataOutputStream.writeInt(rectangle.width);
            dataOutputStream.writeInt(rectangle.height);
        }
    }

    static short readVersion(DataInputStream dataInputStream) throws IOException {
        return SaveUtils.readShort(dataInputStream);
    }

    static void writeVersion(DataOutputStream dataOutputStream, short s) throws IOException {
        SaveUtils.writeShort(dataOutputStream, s);
    }

    static HiddenFrames readContext(DockingManager dockingManager, DataInputStream dataInputStream, Map<String, DockContext> map) throws IOException {
        HashMap<String, DockContext> hashMap = new HashMap<String, DockContext>(map);
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            int n2;
            String string = SaveUtils.readString(dataInputStream);
            Object object = new DockContext();
            ((DockContext)object).setDockID(dockingManager, dataInputStream.readInt());
            ((DockContext)object).setInitSide(dataInputStream.readInt());
            ((DockContext)object).setInitIndex(dataInputStream.readInt());
            ((DockContext)object).setInitPosition(dataInputStream.readInt() != 0);
            ((DockContext)object).setCanMode(dataInputStream.readInt());
            ((DockContext)object).setInitMode(dataInputStream.readInt());
            ((DockContext)object).setCurrentMode(dataInputStream.readInt());
            if (((DockContext)object).isAutohideShowing()) {
                ((DockContext)object).setCurrentMode(2);
            }
            if (((n2 = dataInputStream.readInt()) & Integer.MIN_VALUE) != 0) {
                n2 &= Integer.MIN_VALUE;
                ((DockContext)object).setAvailable(false);
            }
            ((DockContext)object).setCurrentDockSide(n2);
            ((DockContext)object).setDockedWidth(dataInputStream.readInt());
            ((DockContext)object).setDockedHeight(dataInputStream.readInt());
            ((DockContext)object).setAutohideWidth(dataInputStream.readInt());
            ((DockContext)object).setAutohideHeight(dataInputStream.readInt());
            Rectangle rectangle = SaveUtils.readRectangle(dataInputStream);
            if (!rectangle.isEmpty()) {
                ((DockContext)object).setUndockedBounds(rectangle);
            }
            ((DockContext)object).setHiddenPreviousState(SaveUtils.readPreviousState(dataInputStream));
            ((DockContext)object).setClosePreviousState(SaveUtils.readPreviousState(dataInputStream));
            ((DockContext)object).setDockPreviousState(SaveUtils.readPreviousState(dataInputStream));
            ((DockContext)object).setFloatPreviousState(SaveUtils.readPreviousState(dataInputStream));
            ((DockContext)object).setAutohidePreviousState(SaveUtils.readPreviousState(dataInputStream));
            DockContext dockContext = (DockContext)hashMap.remove(string);
            if (dockContext != null) {
                ((DockContext)object).setInitAutohideHeight(dockContext.getInitAutohideHeight());
                ((DockContext)object).setInitAutohideWidth(dockContext.getInitAutohideWidth());
                ((DockContext)object).setInitIndex(dockContext.getInitIndex());
                ((DockContext)object).setInitMode(dockContext.getInitMode());
                ((DockContext)object).setInitSide(dockContext.getInitSide());
                ((DockContext)object).setInitUndockedBounds(dockContext.getInitUndockedBounds());
            }
            map.put(string, (DockContext)object);
        }
        HiddenFrames hiddenFrames = new HiddenFrames();
        for (Object object : hashMap.keySet()) {
            hiddenFrames.add((String)object);
        }
        return hiddenFrames;
    }

    static void writeContext(DataOutputStream dataOutputStream, Map<String, DockContext> map) throws IOException {
        dataOutputStream.writeInt(map.size());
        Set<String> set = map.keySet();
        for (String string : set) {
            DockContext dockContext = map.get(string);
            SaveUtils.writeString(dataOutputStream, string);
            dataOutputStream.writeInt(dockContext.getDockID());
            dataOutputStream.writeInt(dockContext.getInitSide());
            dataOutputStream.writeInt(dockContext.getInitIndex());
            dataOutputStream.writeInt(dockContext.isInitPosition() ? 1 : 0);
            dataOutputStream.writeInt(dockContext.getCanMode());
            dataOutputStream.writeInt(dockContext.getInitMode());
            if (dockContext.isAutohideShowing()) {
                dataOutputStream.writeInt(2);
            } else {
                dataOutputStream.writeInt(dockContext.getCurrentMode());
            }
            int n = dockContext.getCurrentDockSide();
            if (!dockContext.isAvailable()) {
                n |= Integer.MIN_VALUE;
            }
            dataOutputStream.writeInt(n);
            dataOutputStream.writeInt(dockContext.getDockedWidth());
            dataOutputStream.writeInt(dockContext.getDockedHeight());
            dataOutputStream.writeInt(dockContext.getAutohideWidth());
            dataOutputStream.writeInt(dockContext.getAutohideHeight());
            if (dockContext.getUndockedBounds() != null) {
                SaveUtils.writeRectangle(dataOutputStream, dockContext.getUndockedBounds());
            } else {
                SaveUtils.writeRectangle(dataOutputStream, new Rectangle(0, 0, 0, 0));
            }
            SaveUtils.writePreviousState(dataOutputStream, dockContext.getHiddenPreviousState());
            SaveUtils.writePreviousState(dataOutputStream, dockContext.getClosePreviousState());
            SaveUtils.writePreviousState(dataOutputStream, dockContext.getDockPreviousState());
            SaveUtils.writePreviousState(dataOutputStream, dockContext.getFloatPreviousState());
            SaveUtils.writePreviousState(dataOutputStream, dockContext.getAutohidePreviousState());
        }
    }

    static void writeComponent(DataOutputStream dataOutputStream, int n, Component component) throws IOException {
        if (component instanceof ContainerContainer) {
            SaveUtils.writeContainerContainer(dataOutputStream, n, (ContainerContainer)component);
        } else if (component instanceof FrameContainer) {
            SaveUtils.writeFrameContainer(dataOutputStream, n, (FrameContainer)component);
        } else if (component instanceof DockableFrame) {
            SaveUtils.writeDockableFrame(dataOutputStream, n, (DockableFrame)component);
        } else if (component instanceof Workspace) {
            SaveUtils.writeWorkspace(dataOutputStream, n, (Workspace)component);
        } else if (component instanceof FloatingContainer) {
            SaveUtils.writeFloatingContainer(dataOutputStream, n, (FloatingContainer)((Object)component));
        } else {
            SaveUtils.writeInt(dataOutputStream, 65535);
        }
    }

    static Component readComponent(DockingManager dockingManager, int n, DataInputStream dataInputStream) throws IOException {
        int n2 = dataInputStream.readInt();
        boolean bl = false;
        if ((n2 & Integer.MIN_VALUE) != 0 && (n2 &= Integer.MAX_VALUE) == 1125) {
            bl = true;
        }
        switch (n2) {
            case 1123: {
                return SaveUtils.readContainerContainer(dockingManager, n, dataInputStream);
            }
            case 1124: {
                return SaveUtils.readFrameContainer(dockingManager, n, dataInputStream);
            }
            case 1125: {
                return SaveUtils.readDockableFrame(dockingManager, n, dataInputStream, bl);
            }
            case 1126: {
                return SaveUtils.readWorkspace(dockingManager, n, dataInputStream);
            }
            case 1127: {
                return SaveUtils.readFloatingContainer(dockingManager, n, dataInputStream);
            }
        }
        return null;
    }

    private static ContainerContainer readContainerContainer(DockingManager dockingManager, int n, DataInputStream dataInputStream) throws IOException {
        int n2;
        ContainerContainer containerContainer = dockingManager.createContainerContainer();
        containerContainer.setOrientation(dataInputStream.readInt());
        containerContainer.setDockID(dataInputStream.readInt());
        boolean bl = false;
        if (n >= 20) {
            containerContainer.setProportionalLayout(dataInputStream.readBoolean());
            if (containerContainer.isProportionalLayout()) {
                containerContainer.setInitiallyEven(dataInputStream.readBoolean());
                n2 = dataInputStream.readInt();
                if (n2 > 0) {
                    double[] dArray = new double[n2];
                    for (int i = 0; i < dArray.length; ++i) {
                        dArray[i] = dataInputStream.readDouble();
                    }
                    containerContainer.setEventualProportions(dArray);
                    bl = true;
                }
            }
        } else {
            containerContainer.setInitiallyEven(false);
        }
        n2 = dataInputStream.readInt();
        for (int i = 0; i < n2; ++i) {
            Component component = SaveUtils.readComponent(dockingManager, n, dataInputStream);
            if (component == null) continue;
            containerContainer.add(component);
        }
        Dimension dimension = SaveUtils.readSize(dataInputStream);
        if (dimension != null && (dimension.height != 0 || dimension.width != 0)) {
            containerContainer.setPreferredSize(dimension);
        }
        if (containerContainer.getComponentCount() == 0 && !bl) {
            return null;
        }
        return containerContainer;
    }

    private static void writeContainerContainer(DataOutputStream dataOutputStream, int n, ContainerContainer containerContainer) throws IOException {
        dataOutputStream.writeInt(1123);
        dataOutputStream.writeInt(containerContainer.getOrientation());
        dataOutputStream.writeInt(containerContainer.getDockID());
        if (n >= 20) {
            dataOutputStream.writeBoolean(containerContainer.isProportionalLayout());
            if (containerContainer.isProportionalLayout()) {
                dataOutputStream.writeBoolean(containerContainer.isInitiallyEven());
                double[] dArray = containerContainer.getProportions();
                dataOutputStream.writeInt(dArray == null ? -1 : dArray.length);
                if (dArray != null) {
                    for (double d : dArray) {
                        dataOutputStream.writeDouble(d);
                    }
                }
            }
        }
        dataOutputStream.writeInt(containerContainer.getPaneCount());
        for (int i = 0; i < containerContainer.getPaneCount(); ++i) {
            SaveUtils.writeComponent(dataOutputStream, n, containerContainer.getPaneAt(i));
        }
        SaveUtils.writeSize(dataOutputStream, containerContainer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FrameContainer readFrameContainer(DockingManager dockingManager, int n, DataInputStream dataInputStream) throws IOException {
        int n2;
        FrameContainer frameContainer = dockingManager.createFrameContainer();
        frameContainer.setDockID(dataInputStream.readInt());
        int n3 = dataInputStream.readInt();
        frameContainer.setSuppressSetSelectedIndex(true);
        frameContainer.setSuppressStateChangedEvents(true);
        try {
            DockableFrame dockableFrame;
            for (int i = 0; i < n3; ++i) {
                dockableFrame = (DockableFrame)SaveUtils.readComponent(dockingManager, n, dataInputStream);
                if (dockableFrame == null || dockableFrame.getContext() == null || !dockableFrame.isAvailable() || dockableFrame.shouldVetoShowing()) continue;
                frameContainer.addTab(dockableFrame);
            }
            Dimension dimension = SaveUtils.readSize(dataInputStream);
            if (dimension != null) {
                frameContainer.setPreferredSize(dimension);
            }
            n2 = dataInputStream.readInt();
            if (frameContainer.getTabCount() == 0) {
                dockableFrame = null;
                return dockableFrame;
            }
        }
        finally {
            frameContainer.setSuppressSetSelectedIndex(false);
            frameContainer.setSuppressStateChangedEvents(false);
        }
        if (n2 >= 0 && n2 < frameContainer.getTabCount()) {
            frameContainer.setSelectedIndex(n2);
        } else if (frameContainer.getTabCount() > 0) {
            frameContainer.setSelectedIndex(0);
        }
        frameContainer.setPreviousSelectedFrame(frameContainer.getSelectedFrame());
        return frameContainer;
    }

    private static void writeFrameContainer(DataOutputStream dataOutputStream, int n, FrameContainer frameContainer) throws IOException {
        DockableFrame dockableFrame;
        int n2;
        dataOutputStream.writeInt(1124);
        dataOutputStream.writeInt(frameContainer.getDockID());
        int n3 = 0;
        for (n2 = 0; n2 < frameContainer.getTabCount(); ++n2) {
            dockableFrame = (DockableFrame)frameContainer.getComponentAt(n2);
            if (dockableFrame.isTransient()) continue;
            ++n3;
        }
        dataOutputStream.writeInt(n3);
        if (n3 != 0) {
            for (n2 = 0; n2 < frameContainer.getTabCount(); ++n2) {
                dockableFrame = (DockableFrame)frameContainer.getComponentAt(n2);
                if (dockableFrame.isTransient()) continue;
                SaveUtils.writeDockableFrame(dataOutputStream, n, dockableFrame);
            }
        }
        SaveUtils.writeSize(dataOutputStream, frameContainer);
        dataOutputStream.writeInt(frameContainer.getSelectedIndex());
    }

    private static DockableFrame readDockableFrame(DockingManager dockingManager, int n, DataInputStream dataInputStream, boolean bl) throws IOException {
        String string = SaveUtils.readString(dataInputStream);
        DockableFrame dockableFrame = dockingManager.getFrame(string);
        if (dockableFrame != null) {
            DockContext dockContext = null;
            if (!dockableFrame.isTransient()) {
                dockContext = dockingManager.getContextOf(string);
            }
            if (dockContext != null) {
                dockableFrame.setContext(dockContext);
            }
            if (!dockableFrame.isHidden()) {
                dockingManager.removeFromHiddenFrames(string);
            }
            dockableFrame.setAvailable(true);
            if (bl && dockingManager instanceof DefaultDockingManager) {
                ((DefaultDockingManager)dockingManager).setFrameToActivate(string);
            }
        }
        return dockableFrame;
    }

    private static void writeDockableFrame(DataOutputStream dataOutputStream, int n, DockableFrame dockableFrame) throws IOException {
        int n2 = 1125;
        if (dockableFrame.getDockingManager() != null && dockableFrame.getKey().equals(dockableFrame.getDockingManager().getActiveFrameKey())) {
            n2 |= Integer.MIN_VALUE;
        }
        dataOutputStream.writeInt(n2);
        SaveUtils.writeString(dataOutputStream, dockableFrame.getKey());
    }

    private static Workspace readWorkspace(DockingManager dockingManager, int n, DataInputStream dataInputStream) throws IOException {
        SaveUtils.readSize(dataInputStream);
        Workspace workspace = dockingManager.getWorkspace();
        int n2 = SaveUtils.readInt(dataInputStream);
        workspace.setAcceptDockableFrame(n2 == 1);
        if (n2 == 1) {
            workspace.removeAll();
            int n3 = SaveUtils.readInt(dataInputStream);
            for (int i = 0; i < n3; ++i) {
                Component component = SaveUtils.readComponent(dockingManager, n, dataInputStream);
                if (component == null || !workspace.isAcceptDockableFrame()) continue;
                workspace.add(component);
            }
        }
        return workspace;
    }

    private static void writeWorkspace(DataOutputStream dataOutputStream, int n, Workspace workspace) throws IOException {
        dataOutputStream.writeInt(1126);
        SaveUtils.writeSize(dataOutputStream, workspace);
        if (workspace.isAcceptDockableFrame()) {
            SaveUtils.writeInt(dataOutputStream, 1);
            SaveUtils.writeInt(dataOutputStream, workspace.getComponentCount());
            for (int i = 0; i < workspace.getComponentCount(); ++i) {
                SaveUtils.writeComponent(dataOutputStream, n, workspace.getComponent(i));
            }
        } else {
            SaveUtils.writeInt(dataOutputStream, 0);
        }
    }

    private static Container readFloatingContainer(DockingManager dockingManager, int n, DataInputStream dataInputStream) throws IOException {
        Rectangle rectangle = SaveUtils.readRectangle(dataInputStream);
        int n2 = dataInputStream.readInt();
        if (n2 == 0) {
            return null;
        }
        RootPaneContainer rootPaneContainer = dockingManager.getRootPaneContainer();
        if (rootPaneContainer == null) {
            throw new IllegalStateException("Failed to create floating frame because the top level window is not available. Please make sure you load the layout after the contentContainer is added to Swing component tree hierarchy or make sure you pass in a valid rootPaneContainer in the constructor of DefaultDockingManager.");
        }
        FloatingContainer floatingContainer = dockingManager.createFloatingContainer(SwingUtilities.getWindowAncestor(rootPaneContainer.getRootPane()));
        DockingManager.FloatingContainerCustomizer floatingContainerCustomizer = dockingManager.getFloatingContainerCustomizer();
        if (floatingContainerCustomizer != null) {
            floatingContainerCustomizer.customize(floatingContainer);
        }
        Rectangle rectangle2 = PortingUtils.overlapWithScreenBounds((Component)((Object)floatingContainer), rectangle);
        if (dockingManager instanceof DefaultDockingManager) {
            ((DefaultDockingManager)dockingManager).adjustBoundsForSnap(new Rectangle(), rectangle2);
        }
        floatingContainer.setBounds(rectangle2);
        for (int i = 0; i < n2; ++i) {
            Component component = SaveUtils.readComponent(dockingManager, n, dataInputStream);
            if (component == null) continue;
            floatingContainer.getContentPane().add(component);
        }
        if (floatingContainer.getContentPane().getComponentCount() == 0) {
            floatingContainer.dispose();
            return null;
        }
        final int[] nArray = new int[]{0};
        JideSwingUtilities.setRecursively(floatingContainer.getContentPane(), new JideSwingUtilities.Handler(){

            @Override
            public boolean condition(Component component) {
                return component instanceof DockableFrame;
            }

            @Override
            public void action(Component component) {
                nArray[0] = nArray[0] + 1;
            }

            @Override
            public void postAction(Component component) {
            }
        });
        if (nArray[0] <= 0) {
            floatingContainer.dispose();
            return null;
        }
        floatingContainer.updateUndecorated();
        return (Container)((Object)floatingContainer);
    }

    private static void writeFloatingContainer(DataOutputStream dataOutputStream, int n, FloatingContainer floatingContainer) throws IOException {
        boolean bl;
        dataOutputStream.writeInt(1127);
        Rectangle rectangle = floatingContainer.getBounds();
        int n2 = rectangle.y;
        boolean bl2 = bl = n2 >= -5000;
        if (!bl) {
            rectangle.y += 10000;
        }
        SaveUtils.writeRectangle(dataOutputStream, rectangle);
        dataOutputStream.writeInt(floatingContainer.getContentPane().getComponentCount());
        for (int i = 0; i < floatingContainer.getContentPane().getComponentCount(); ++i) {
            SaveUtils.writeComponent(dataOutputStream, n, floatingContainer.getContentPane().getComponent(i));
        }
    }

    static FloatingFrames readFloatingFrames(DockingManager dockingManager, int n, DataInputStream dataInputStream) throws IOException {
        FloatingFrames floatingFrames = new FloatingFrames();
        int n2 = dataInputStream.readInt();
        for (int i = 0; i < n2; ++i) {
            Component component = SaveUtils.readComponent(dockingManager, n, dataInputStream);
            if (component == null || !(component instanceof FloatingContainer)) continue;
            floatingFrames.add((FloatingContainer)((Object)component));
        }
        return floatingFrames;
    }

    static void writeFloatingFrames(DataOutputStream dataOutputStream, int n, FloatingFrames floatingFrames) throws IOException {
        int n2 = floatingFrames != null ? floatingFrames.size() : 0;
        dataOutputStream.writeInt(n2);
        if (floatingFrames != null) {
            for (int i = 0; i < n2; ++i) {
                SaveUtils.writeComponent(dataOutputStream, n, (Container)floatingFrames.get(i));
            }
        }
    }

    static HiddenFrames readHiddenFrames(DataInputStream dataInputStream) throws IOException {
        HiddenFrames hiddenFrames = new HiddenFrames();
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            String string = SaveUtils.readString(dataInputStream);
            hiddenFrames.add(string);
        }
        return hiddenFrames;
    }

    static void writeHiddenFrames(DataOutputStream dataOutputStream, HiddenFrames hiddenFrames) throws IOException {
        dataOutputStream.writeInt(hiddenFrames.size());
        for (String string : hiddenFrames) {
            SaveUtils.writeString(dataOutputStream, string);
        }
    }

    private static SidePaneGroup readSideGroup(DockingManager dockingManager, AutoHideContainer.MouseInputCreator mouseInputCreator, int n, DataInputStream dataInputStream, int n2) throws IOException {
        int n3;
        SidePaneGroup sidePaneGroup = new SidePaneGroup();
        int n4 = dataInputStream.readInt();
        for (n3 = 0; n3 < n4; ++n3) {
            SidePaneItem sidePaneItem = SaveUtils.readSideItem(dockingManager, mouseInputCreator, n, dataInputStream, n2);
            if (sidePaneItem == null) continue;
            sidePaneGroup.add(sidePaneItem);
        }
        n3 = dataInputStream.readInt();
        if (n3 >= 0 && n3 < sidePaneGroup.size()) {
            sidePaneGroup.setSelectedIndex(n3);
        }
        if (sidePaneGroup.size() > 0) {
            return sidePaneGroup;
        }
        return null;
    }

    private static void writeSideGroup(DataOutputStream dataOutputStream, int n, SidePaneGroup sidePaneGroup) throws IOException {
        dataOutputStream.writeInt(sidePaneGroup.size());
        for (SidePaneItem sidePaneItem : sidePaneGroup) {
            SaveUtils.writeSideItem(dataOutputStream, n, sidePaneItem);
        }
        dataOutputStream.writeInt(sidePaneGroup.getSelectedIndex());
    }

    private static SidePaneItem readSideItem(DockingManager dockingManager, AutoHideContainer.MouseInputCreator mouseInputCreator, int n, DataInputStream dataInputStream, int n2) throws IOException {
        SaveUtils.readString(dataInputStream);
        DockableFrame dockableFrame = (DockableFrame)SaveUtils.readComponent(dockingManager, n, dataInputStream);
        if (dockableFrame != null && dockableFrame.getContext() != null && dockableFrame.isAvailable() && !dockableFrame.shouldVetoShowing()) {
            SidePaneItem sidePaneItem = new SidePaneItem(dockableFrame.getSideTitle(), dockableFrame.getFrameIcon(), dockableFrame, mouseInputCreator.createAutoHideMouseInputListener(dockableFrame, n2));
            sidePaneItem.setSelected(false);
            return sidePaneItem;
        }
        return null;
    }

    private static void writeSideItem(DataOutputStream dataOutputStream, int n, SidePaneItem sidePaneItem) throws IOException {
        SaveUtils.writeString(dataOutputStream, sidePaneItem.getTitle());
        SaveUtils.writeComponent(dataOutputStream, n, sidePaneItem.getComponent());
    }

    static AutoHideContainer readAutohideContainer(DockingManager dockingManager, AutoHideContainer.MouseInputCreator mouseInputCreator, int n, DataInputStream dataInputStream) throws IOException {
        AutoHideContainer autoHideContainer = dockingManager.createAutoHideContainer(dataInputStream.readInt());
        int n2 = dataInputStream.readInt();
        for (int i = 0; i < n2; ++i) {
            SidePaneGroup sidePaneGroup = SaveUtils.readSideGroup(dockingManager, mouseInputCreator, n, dataInputStream, DockingUtils.convertToDockSide(autoHideContainer.getAttachedSide()));
            if (sidePaneGroup == null) continue;
            autoHideContainer.addGroup(sidePaneGroup);
        }
        return autoHideContainer;
    }

    static void writeAutohideContainer(DataOutputStream dataOutputStream, int n, AutoHideContainer autoHideContainer) throws IOException {
        dataOutputStream.writeInt(autoHideContainer.getAttachedSide());
        dataOutputStream.writeInt(autoHideContainer.getGroups().size());
        for (int i = 0; i < autoHideContainer.getGroups().size(); ++i) {
            SaveUtils.writeSideGroup(dataOutputStream, n, autoHideContainer.getGroups().get(i));
        }
    }

    private static PreviousState readPreviousState(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        if (n == 1) {
            int n2;
            PreviousState previousState = new PreviousState();
            previousState.mode = dataInputStream.readInt();
            previousState.dockID = dataInputStream.readInt();
            previousState.rootID = dataInputStream.readInt();
            previousState.rcBounds = SaveUtils.readRectangle(dataInputStream);
            previousState.side = dataInputStream.readInt();
            previousState.index = dataInputStream.readInt();
            previousState.fcID = dataInputStream.readInt();
            int n3 = dataInputStream.readInt();
            if (n3 != 0) {
                previousState.fcChildren = new ArrayList();
                for (n2 = 0; n2 < n3; ++n2) {
                    previousState.fcChildren.add(dataInputStream.readInt());
                }
            }
            if ((n3 = dataInputStream.readInt()) != 0) {
                previousState.parentStates = new ArrayList();
                for (n2 = 0; n2 < n3; ++n2) {
                    PreviousState.ParentState parentState = new PreviousState.ParentState();
                    parentState.ccID = dataInputStream.readInt();
                    parentState.myID = dataInputStream.readInt();
                    parentState.orientation = dataInputStream.readInt();
                    int n4 = dataInputStream.readInt();
                    if (n4 != 0) {
                        parentState.ccChildren = new ArrayList();
                        for (int i = 0; i < n4; ++i) {
                            parentState.ccChildren.add(dataInputStream.readInt());
                        }
                    }
                    previousState.parentStates.add(parentState);
                }
            }
            return previousState;
        }
        return null;
    }

    private static void writePreviousState(DataOutputStream dataOutputStream, PreviousState previousState) throws IOException {
        if (previousState != null) {
            dataOutputStream.writeInt(1);
            dataOutputStream.writeInt(previousState.mode);
            dataOutputStream.writeInt(previousState.dockID);
            dataOutputStream.writeInt(previousState.rootID);
            SaveUtils.writeRectangle(dataOutputStream, previousState.rcBounds);
            dataOutputStream.writeInt(previousState.side);
            dataOutputStream.writeInt(previousState.index);
            dataOutputStream.writeInt(previousState.fcID);
            if (previousState.fcChildren != null) {
                dataOutputStream.writeInt(previousState.fcChildren.size());
                for (Integer serializable : previousState.fcChildren) {
                    dataOutputStream.writeInt(serializable);
                }
            } else {
                dataOutputStream.writeInt(0);
            }
            if (previousState.parentStates != null) {
                dataOutputStream.writeInt(previousState.parentStates.size());
                for (PreviousState.ParentState parentState : previousState.parentStates) {
                    dataOutputStream.writeInt(parentState.ccID);
                    dataOutputStream.writeInt(parentState.myID);
                    dataOutputStream.writeInt(parentState.orientation);
                    if (parentState.ccChildren != null) {
                        dataOutputStream.writeInt(parentState.ccChildren.size());
                        for (Integer n : parentState.ccChildren) {
                            dataOutputStream.writeInt(n);
                        }
                        continue;
                    }
                    dataOutputStream.writeInt(0);
                }
            } else {
                dataOutputStream.writeInt(0);
            }
        } else {
            dataOutputStream.writeInt(0);
        }
    }

    private static Dimension detectWrongSize(Dimension dimension) {
        if (dimension.width == -1 && dimension.height == -1) {
            return null;
        }
        return dimension;
    }
}

