/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.AutoHideContainer;
import com.jidesoft.docking.ContainerContainer;
import com.jidesoft.docking.ContainerContainerDivider;
import com.jidesoft.docking.Dockable;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockableHolder;
import com.jidesoft.docking.DockedFrameContainer;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.docking.FloatingContainer;
import com.jidesoft.docking.FrameContainer;
import com.jidesoft.docking.PreviousState;
import com.jidesoft.docking.SlidingOverFrameContainer;
import com.jidesoft.docking.Workspace;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicDockableFrameTitlePane;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideSplitPaneDivider;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.JideTabbedPane;
import com.jidesoft.swing.SidePaneItem;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.SystemInfo;
import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JWindow;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;

public class DockingUtils {
    static int sideOfComponent(Component component, int n, int n2, int n3, boolean bl) {
        int n4 = Math.min(n3, component.getWidth() / 3);
        int n5 = Math.min(n3, component.getHeight() / 3);
        if (n >= 0 && n < n4 && n2 >= 0 && n2 < component.getHeight()) {
            return 8;
        }
        if (n >= component.getWidth() - n4 && n < component.getWidth() && n2 >= 0 && n2 <= component.getHeight()) {
            return 4;
        }
        if (n2 >= 0 && n2 < n5 + (component instanceof FrameContainer && bl ? DockingUtils.getTitleBarHeight((FrameContainer)component) : 0) && n >= 0 && n < component.getWidth()) {
            return 1;
        }
        if (n2 >= component.getHeight() - n5 - (component instanceof FrameContainer && ((FrameContainer)component).isTabShown() ? 22 : 0) && n2 < component.getHeight() && n >= 0 && n <= component.getWidth()) {
            return 2;
        }
        if (n > n4 && n < component.getWidth() - n4 && n2 > n5 && n2 < component.getHeight() - n5) {
            return 16;
        }
        return 32;
    }

    static int getTitleBarHeight(FrameContainer frameContainer) {
        DockableFrame dockableFrame = frameContainer.getSelectedFrame();
        if (dockableFrame != null && dockableFrame.getUI() != null && dockableFrame.getUI().getTitlePane() != null) {
            return dockableFrame.getUI().getTitlePane().getHeight();
        }
        return 0;
    }

    static int outsideOfComponent(Component component, int n, int n2, int n3) {
        int n4 = Math.min(n3, component.getWidth() / 3);
        int n5 = Math.min(n3, component.getHeight() / 3);
        if (n < 0 && n >= -n4 && n2 >= 0 && n2 < component.getHeight()) {
            return 8;
        }
        if (n < component.getWidth() + n4 && n >= component.getWidth() && n2 >= 0 && n2 <= component.getHeight()) {
            return 4;
        }
        if (n2 < 0 && n2 >= -n5 && n >= 0 && n < component.getWidth()) {
            return 1;
        }
        if (n2 < component.getHeight() + n5 && n2 >= component.getHeight() && n >= 0 && n <= component.getWidth()) {
            return 2;
        }
        return 32;
    }

    static void dequeueMouseEvents(Map<Component, List<MouseEvent>> map, Component component) {
        List<MouseEvent> list = map.remove(component);
        if (list != null) {
            for (MouseEvent mouseEvent : list) {
                MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(mouseEvent.getComponent(), mouseEvent, mouseEvent.getComponent());
                mouseEvent.getComponent().dispatchEvent(mouseEvent2);
            }
        }
    }

    public static Window getWindowFor(Component component) {
        if (component instanceof Window) {
            return (Window)component;
        }
        return SwingUtilities.getWindowAncestor(component);
    }

    private static boolean isDescendantOfFloatingContainer(Component component) {
        while (component != null) {
            if (component instanceof FloatingContainer) {
                return true;
            }
            component = component.getParent();
        }
        return false;
    }

    static Component getValidParentOf(Component component, DockableFrame dockableFrame, boolean bl) {
        if (component == null) {
            return null;
        }
        if (!dockableFrame.isFloatable() && DockingUtils.isDescendantOfFloatingContainer(component)) {
            return null;
        }
        if (component instanceof FrameContainer && ((FrameContainer)component).getTabCount() == 1 && ((FrameContainer)component).isAncestorOf(dockableFrame)) {
            return null;
        }
        if (component instanceof FrameContainer && !bl && component.equals(dockableFrame.getParent())) {
            return null;
        }
        if (DockingUtils.isValidComponent(component, dockableFrame, bl)) {
            return component;
        }
        do {
            if (dockableFrame.equals(component) && ((FrameContainer)component.getParent()).getTabCount() == 1) {
                return null;
            }
            if (component instanceof BasicDockableFrameTitlePane && component.getParent().equals(dockableFrame) && ((FrameContainer)component.getParent().getParent()).getTabCount() == 1) {
                return null;
            }
            if (component.getParent() == null) {
                return null;
            }
            if (!bl && component.getParent().equals(dockableFrame.getParent())) {
                return null;
            }
            if ((component = component.getParent()) == null) {
                return null;
            }
            if (!(component instanceof FrameContainer) || ((FrameContainer)component).getTabCount() != 1 || !((FrameContainer)component).isAncestorOf(dockableFrame)) continue;
            return null;
        } while (!DockingUtils.isValidComponent(component, dockableFrame, bl));
        return component;
    }

    static Component getManagedDockableHolder(DockingManager dockingManager, Class<? extends DockableHolder> clazz, Component component) {
        if (component == null) {
            return null;
        }
        if (clazz.isInstance(component) && component instanceof DockableHolder && ((DockableHolder)((Object)component)).getDockingManager() == dockingManager) {
            return component;
        }
        do {
            if ((component = component.getParent()) != null) continue;
            return null;
        } while (!clazz.isInstance(component) || !(component instanceof DockableHolder) || ((DockableHolder)((Object)component)).getDockingManager() != dockingManager);
        if (!clazz.isInstance(component)) {
            return null;
        }
        return component;
    }

    static List<DockingManager> getDockingManagers(Component component) {
        ArrayList<DockingManager> arrayList = new ArrayList<DockingManager>();
        while (component != null) {
            DockingManager dockingManager = null;
            if (component instanceof DockableFrame) {
                dockingManager = ((DockableFrame)component).getDockingManager();
            } else if (component instanceof Workspace) {
                dockingManager = ((Workspace)component).getDockingManager();
            }
            if (dockingManager != null && !arrayList.contains(dockingManager)) {
                arrayList.add(0, dockingManager);
            }
            component = component.getParent();
        }
        return arrayList;
    }

    static boolean isDockingManagerAncestor(Component component, DockingManager dockingManager) {
        while (component != null) {
            DockingManager dockingManager2 = null;
            if (component instanceof DockableFrame) {
                dockingManager2 = ((DockableFrame)component).getDockingManager();
            } else if (component instanceof Workspace) {
                dockingManager2 = ((Workspace)component).getDockingManager();
            }
            if (dockingManager2 == dockingManager) {
                return true;
            }
            component = component.getParent();
        }
        return false;
    }

    static boolean hasDockingManagerAncestor(Component component) {
        while (component != null) {
            DockingManager dockingManager = null;
            if (component instanceof DockableFrame) {
                dockingManager = ((DockableFrame)component).getDockingManager();
            } else if (component instanceof Workspace) {
                dockingManager = ((Workspace)component).getDockingManager();
            }
            if (dockingManager != null) {
                return true;
            }
            component = component.getParent();
        }
        return false;
    }

    static Component getDockableFrameOrWorkspace(DockingManager dockingManager, Component component) {
        return DockingUtils.getDockableFrameOrWorkspace(dockingManager, component, false);
    }

    static Component getDockableFrameOrWorkspace(DockingManager dockingManager, Component component, boolean bl) {
        if (component == null) {
            return null;
        }
        if (DockingUtils.isDockableFrameOrWorkspace(dockingManager, component)) {
            return component;
        }
        if (bl) {
            do {
                if ((component = component.getParent()) != null) continue;
                return null;
            } while (!DockingUtils.isDockableFrameOrWorkspace(component));
            if (component instanceof Workspace && ((Workspace)component).getDockingManager() != dockingManager) {
                component = null;
            } else if (component instanceof DockableFrame && ((DockableFrame)component).getDockingManager() != dockingManager) {
                component = null;
            }
        } else {
            do {
                if ((component = component.getParent()) != null) continue;
                return null;
            } while (!DockingUtils.isDockableFrameOrWorkspace(dockingManager, component));
        }
        return component;
    }

    private static boolean isDockableFrameOrWorkspace(DockingManager dockingManager, Component component) {
        return component instanceof DockableFrame && ((DockableFrame)component).getDockingManager() == dockingManager || component instanceof Workspace && component == dockingManager.getWorkspace();
    }

    private static boolean isDockableFrameOrWorkspace(Component component) {
        return component instanceof DockableFrame || component instanceof Workspace;
    }

    private static boolean isValidComponent(Component component, DockableFrame dockableFrame, boolean bl) {
        return DockingUtils.isValidTargetComponent(component, dockableFrame, bl) && DockingUtils.isSameDockingManager(component, dockableFrame);
    }

    public static DockingManager getDockingManager(Component component) {
        if (component instanceof BasicDockableFrameTitlePane && component.getParent() instanceof DockableFrame) {
            return ((DockableFrame)component.getParent()).getDockingManager();
        }
        if (component instanceof ContainerContainerDivider && component.getParent() instanceof ContainerContainer) {
            return ((ContainerContainer)component.getParent()).getDockingManager();
        }
        if (component instanceof DockableFrame) {
            return ((DockableFrame)component).getDockingManager();
        }
        if (component instanceof Workspace) {
            return ((Workspace)component).getDockingManager();
        }
        if (component instanceof ContainerContainer) {
            return ((ContainerContainer)component).getDockingManager();
        }
        if (component instanceof FrameContainer) {
            return ((FrameContainer)component).getDockingManager();
        }
        if (component instanceof FloatingContainer) {
            return ((FloatingContainer)((Object)component)).getDockingManager();
        }
        return null;
    }

    public static boolean isSameDockingManager(Component component, DockableFrame dockableFrame) {
        DockingManager dockingManager = dockableFrame.getDockingManager();
        DockingManager dockingManager2 = DockingUtils.getDockingManager(component);
        if (dockingManager2 != null && dockingManager != null && dockingManager2 != dockingManager) {
            return dockingManager.isCrossDraggingAllowed() && dockingManager2.isCrossDroppingAllowed();
        }
        return dockingManager2 != null && dockingManager != null;
    }

    private static boolean isValidTargetComponent(Component component, DockableFrame dockableFrame, boolean bl) {
        return component instanceof BasicDockableFrameTitlePane && component.getParent() instanceof DockableFrame && ((DockableFrame)component.getParent()).isTabDockAllowed() && !((DockableFrame)component.getParent()).isMaximized() && component.getParent().getParent() != dockableFrame.getParent() || component instanceof ContainerContainerDivider && component.getParent() instanceof ContainerContainer && (bl && dockableFrame.getParent() != null && ((FrameContainer)dockableFrame.getParent()).getTabCount() > 1 || !((ContainerContainer)component.getParent()).isComponentNextToDivider((ContainerContainerDivider)component, dockableFrame.getParent())) || component instanceof DockableFrame && ((DockableFrame)component).isMaximized() || component instanceof DockableFrame && ((DockableFrame)component).isAutohideShowing() || component instanceof Workspace || component instanceof ContainerContainer || component instanceof FrameContainer || component instanceof FloatingContainer;
    }

    static void floatizeChildrenOf(Container container, DockingManager dockingManager) throws PropertyVetoException {
        for (Component component : container.getComponents()) {
            if (component instanceof Container) {
                DockingUtils.floatizeChildrenOf((Container)component, dockingManager);
            }
            if (!(component instanceof DockableFrame) || ((DockableFrame)component).getDockingManager() != dockingManager) continue;
            ((DockableFrame)component).setFloated(true);
        }
    }

    protected static void dockizeChildrenOf(Container container, DockingManager dockingManager) throws PropertyVetoException {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            if (container.getComponent(i) instanceof Container) {
                DockingUtils.floatizeChildrenOf((Container)container.getComponent(i), dockingManager);
            }
            if (!(container.getComponent(i) instanceof DockableFrame) || ((DockableFrame)container.getComponent(i)).getDockingManager() != dockingManager) continue;
            ((DockableFrame)container.getComponent(i)).setDocked(true);
        }
    }

    protected static Container getValidFloatableParent(DockableFrame dockableFrame) {
        Container container = dockableFrame;
        while (!DockingUtils.isValidFloatableComponent(container)) {
            if ((container = container.getParent()) != null) continue;
            return null;
        }
        return container;
    }

    private static boolean isValidFloatableComponent(Component component) {
        return component instanceof ContainerContainer || component instanceof FrameContainer;
    }

    private static void printTabs(int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print("\t");
        }
    }

    static void printLayout(DockedFrameContainer dockedFrameContainer, int n) {
        DockingUtils.printLayout((ContainerContainer)dockedFrameContainer.getNormalContainer().getComponent(0), n);
    }

    static void printLayout(ContainerContainer containerContainer, int n) {
        DockingUtils.printTabs(++n);
        Map<Component, Object> map = ((JideBoxLayout)containerContainer.getLayout()).getConstraintMap();
        System.out.println("ContainerContainer " + (containerContainer.getOrientation() == 1 ? "(Horizontal) " : "(Vertical) ") + " Count = " + containerContainer.getPaneCount());
        for (int i = 0; i < containerContainer.getComponentCount(); ++i) {
            Component component = containerContainer.getComponent(i);
            DockingUtils.printTabs(n);
            System.out.println("Constraint: " + map.get(component));
            if (component instanceof ContainerContainerDivider) {
                DockingUtils.printTabs(n);
                System.out.println("Divider Size = " + (containerContainer.getOrientation() == 1 ? component.getWidth() : component.getHeight()));
                continue;
            }
            if (component instanceof ContainerContainer) {
                DockingUtils.printLayout((ContainerContainer)component, n);
                continue;
            }
            if (component instanceof FrameContainer) {
                DockingUtils.printLayout((FrameContainer)component, n);
                continue;
            }
            if (component instanceof DockableFrame) {
                DockingUtils.printLayout((DockableFrame)component, n);
                continue;
            }
            if (component instanceof Workspace) {
                DockingUtils.printLayout((Workspace)component, n);
                continue;
            }
            DockingUtils.printLayout(component, n);
        }
    }

    private static void printLayout(FrameContainer frameContainer, int n) {
        DockingUtils.printTabs(++n);
        System.out.println("FrameContainer  Count = " + frameContainer.getTabCount() + " DockedWidth = " + frameContainer.getDockedWidth() + " DockedHeight = " + frameContainer.getDockedHeight() + " AutohideWidth = " + frameContainer.getAutohideWidth() + " AutohideHeight = " + frameContainer.getAutohideWidth() + " UndockedBounds = " + frameContainer.getUndockedBounds());
        for (int i = 0; i < frameContainer.getTabCount(); ++i) {
            Component component = frameContainer.getComponentAt(i);
            if (component instanceof DockableFrame) {
                DockingUtils.printLayout((DockableFrame)component, n);
                continue;
            }
            DockingUtils.printLayout(component, n);
        }
    }

    private static void printLayout(Workspace workspace, int n) {
        DockingUtils.printTabs(++n);
        System.out.println("Workspace");
    }

    private static void printLayout(DockableFrame dockableFrame, int n) {
        DockingUtils.printTabs(++n);
        System.out.println("TitledFrame \"" + dockableFrame.getTitle() + "\" Mode = " + dockableFrame.getContext().getCurrentMode() + " Side = " + dockableFrame.getContext().getCurrentDockSide() + " DockedWidth = " + dockableFrame.getDockedWidth() + " DockedHeight = " + dockableFrame.getDockedHeight() + " AutohideWidth = " + dockableFrame.getAutohideWidth() + " AutohideHeight = " + dockableFrame.getAutohideWidth() + " UndockedBounds = " + dockableFrame.getUndockedBounds());
    }

    private static void printLayout(Component component, int n) {
        DockingUtils.printTabs(++n);
    }

    static Container getRootContainer(Component component) {
        if (component instanceof DockedFrameContainer) {
            return (DockedFrameContainer)component;
        }
        if (component instanceof FloatingContainer) {
            return (Container)component;
        }
        Container container = component.getParent();
        do {
            if (container == null) {
                return null;
            }
            if (container instanceof DockedFrameContainer) {
                return container;
            }
            if (!(container instanceof FloatingContainer)) continue;
            return container;
        } while ((container = container.getParent()) != null);
        return null;
    }

    static ContainerContainer getContainContainer(Component component) {
        if (component == null) {
            return null;
        }
        Container container = component.getParent();
        do {
            if (container != null && container instanceof ContainerContainer) {
                return (ContainerContainer)container;
            }
            if (container != null) continue;
            return null;
        } while ((container = container.getParent()) != null);
        return null;
    }

    static boolean containsInMainContainer(DockedFrameContainer dockedFrameContainer, Component component) {
        return component == dockedFrameContainer || dockedFrameContainer.isAncestorOf(component);
    }

    static int sideOf(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle.x >= rectangle2.x + rectangle2.width) {
            return 8;
        }
        if (rectangle.x + rectangle.width <= rectangle2.x) {
            return 4;
        }
        if (rectangle.y >= rectangle2.y + rectangle.height) {
            return 1;
        }
        if (rectangle.y + rectangle.height <= rectangle2.y) {
            return 2;
        }
        return 32;
    }

    static Container getContainerContainerOnSide(int n, Container container, Workspace workspace) {
        if (container == null || !(container.getComponent(0) instanceof ContainerContainer)) {
            return null;
        }
        Rectangle rectangle = DockingUtils.getBounds(workspace);
        Container container2 = (Container)container.getComponent(0);
        return DockingUtils.getContainerSideOf(container2, rectangle, n);
    }

    private static Container getContainerSideOf(Container container, Rectangle rectangle, int n) {
        Rectangle rectangle2 = DockingUtils.getBounds(container);
        if ((container instanceof ContainerContainer || container instanceof FrameContainer) && DockingUtils.sideOf(rectangle, rectangle2) == n) {
            return container;
        }
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Container container2;
            Component component = container.getComponent(i);
            if (component instanceof Workspace || component instanceof JideSplitPaneDivider || !(container instanceof Container) || (container2 = DockingUtils.getContainerSideOf((Container)component, rectangle, n)) == null) continue;
            return container2;
        }
        return null;
    }

    private static Rectangle getBounds(Component component) {
        Rectangle rectangle = component.getBounds();
        Point point = rectangle.getLocation();
        SwingUtilities.convertPointToScreen(point, component);
        rectangle.setLocation(point);
        return rectangle;
    }

    static int getFrameContainerCount(DockingManager dockingManager, Container container) {
        int n = 0;
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (component instanceof ContainerContainerDivider) continue;
            if (component instanceof ContainerContainer) {
                n += DockingUtils.getFrameContainerCount(dockingManager, (ContainerContainer)component);
                continue;
            }
            if (component instanceof FrameContainer) {
                if (((FrameContainer)component).getDockingManager() != dockingManager) continue;
                ++n;
                continue;
            }
            if (!(component instanceof DockableFrame) || ((DockableFrame)component).getDockingManager() != dockingManager) continue;
            ++n;
        }
        return n;
    }

    static int getDockableFrameCount(DockingManager dockingManager, Container container) {
        int n = 0;
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (component instanceof ContainerContainerDivider) continue;
            if (component instanceof ContainerContainer) {
                n += DockingUtils.getDockableFrameCount(dockingManager, (ContainerContainer)component);
                continue;
            }
            if (component instanceof FrameContainer) {
                n += DockingUtils.getDockableFrameCount(dockingManager, (FrameContainer)component);
                continue;
            }
            if (!(component instanceof DockableFrame) || ((DockableFrame)component).getDockingManager() != dockingManager) continue;
            ++n;
        }
        return n;
    }

    static boolean isTabVisible(Container container) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (component instanceof ContainerContainerDivider) continue;
            if (component instanceof ContainerContainer) {
                return DockingUtils.isTabVisible((ContainerContainer)component);
            }
            if (!(component instanceof FrameContainer)) continue;
            return ((FrameContainer)component).getTabCount() > 1 || !((FrameContainer)component).isHideOneTab();
        }
        return false;
    }

    static void setFrameContainerBorder(Container container, Border border) {
        if (container instanceof FrameContainer) {
            FrameContainer frameContainer = (FrameContainer)container;
            Border border2 = frameContainer.getBorder();
            if (border2 == null || border2 instanceof UIResource) {
                frameContainer.setBorder(border);
            }
            return;
        }
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (component instanceof ContainerContainer) {
                DockingUtils.setFrameContainerBorder((ContainerContainer)component, border);
                continue;
            }
            if (!(component instanceof FrameContainer)) continue;
            ((FrameContainer)component).setBorder(border);
        }
    }

    static void setDockableFrameBorder(Container container, Border border) {
        if (container instanceof DockableFrame) {
            DockableFrame dockableFrame = (DockableFrame)container;
            Border border2 = dockableFrame.getBorder();
            if (border2 == null || border2 instanceof UIResource) {
                dockableFrame.setBorder(border);
            }
            return;
        }
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (component instanceof ContainerContainer) {
                DockingUtils.setDockableFrameBorder((ContainerContainer)component, border);
                continue;
            }
            if (component instanceof FrameContainer) {
                DockingUtils.setDockableFrameBorder((FrameContainer)component, border);
                continue;
            }
            if (!(component instanceof DockableFrame)) continue;
            ((DockableFrame)component).setBorder(border);
        }
    }

    static List<Component> getAllChildrenOf(ContainerContainer containerContainer) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (int i = 0; i < containerContainer.getComponentCount(); ++i) {
            Component component = containerContainer.getComponent(i);
            if (component instanceof ContainerContainerDivider) continue;
            if (component instanceof Workspace) {
                arrayList.add(component);
            }
            if (component instanceof ContainerContainer) {
                arrayList.addAll(DockingUtils.getAllChildrenOf((ContainerContainer)component));
                continue;
            }
            if (component instanceof FrameContainer) {
                arrayList.addAll(DockingUtils.getAllChildrenOf((FrameContainer)component));
                continue;
            }
            if (!(component instanceof DockableFrame)) continue;
            arrayList.add(component);
        }
        return arrayList;
    }

    static List<Component> getAllChildrenOf(FrameContainer frameContainer) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (int i = 0; i < frameContainer.getTabCount(); ++i) {
            arrayList.add(frameContainer.getComponentAt(i));
        }
        return arrayList;
    }

    static ArrayList<Integer> getAllChildrenIDOf(ContainerContainer containerContainer) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < containerContainer.getComponentCount(); ++i) {
            Component component = containerContainer.getComponent(i);
            if (component instanceof Workspace) {
                arrayList.add(-1);
                continue;
            }
            if (!(component instanceof Dockable)) continue;
            arrayList.add(((Dockable)((Object)component)).getDockID());
        }
        return arrayList;
    }

    static ArrayList<Integer> getAllChildrenIDOf(FrameContainer frameContainer) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < frameContainer.getTabCount(); ++i) {
            Component component = frameContainer.getComponentAt(i);
            if (!(component instanceof DockableFrame)) continue;
            arrayList.add(((DockableFrame)component).getDockID());
        }
        return arrayList;
    }

    static List<DockableFrame> getAllDockableFrameOf(FrameContainer frameContainer) {
        ArrayList<DockableFrame> arrayList = new ArrayList<DockableFrame>();
        for (int i = 0; i < frameContainer.getTabCount(); ++i) {
            Component component = frameContainer.getComponentAt(i);
            if (!(component instanceof DockableFrame)) continue;
            arrayList.add((DockableFrame)component);
        }
        return arrayList;
    }

    static List<DockableFrame> getAllDockableFrameOf(Container container) {
        if (container instanceof ContainerContainer) {
            return DockingUtils.getAllDockableFrameOf((ContainerContainer)container);
        }
        if (container instanceof FrameContainer) {
            return DockingUtils.getAllDockableFrameOf((FrameContainer)container);
        }
        final ArrayList<DockableFrame> arrayList = new ArrayList<DockableFrame>();
        JideSwingUtilities.setRecursively(container, new JideSwingUtilities.Handler(){

            @Override
            public boolean condition(Component component) {
                return component instanceof DockableFrame;
            }

            @Override
            public void action(Component component) {
                arrayList.add((DockableFrame)component);
            }

            @Override
            public void postAction(Component component) {
            }
        });
        return arrayList;
    }

    static List<DockableFrame> getAllDockableFrameOf(ContainerContainer containerContainer) {
        ArrayList<DockableFrame> arrayList = new ArrayList<DockableFrame>();
        for (int i = 0; i < containerContainer.getPaneCount(); ++i) {
            Component component = containerContainer.getPaneAt(i);
            if (component instanceof DockableFrame) {
                arrayList.add((DockableFrame)component);
            }
            if (component instanceof FrameContainer) {
                arrayList.addAll(DockingUtils.getAllDockableFrameOf((FrameContainer)component));
                continue;
            }
            if (!(component instanceof ContainerContainer)) continue;
            arrayList.addAll(DockingUtils.getAllDockableFrameOf((ContainerContainer)component));
        }
        return arrayList;
    }

    static int convertToDockSide(int n) {
        int n2 = 32;
        switch (n) {
            case 3: {
                n2 = 4;
                break;
            }
            case 7: {
                n2 = 8;
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 5: {
                n2 = 2;
            }
        }
        return n2;
    }

    static int[] reorderIndex(int n, int n2, int n3, int n4) {
        if (n4 == -1) {
            return DockingUtils.reorderIndex(n, n2, n3);
        }
        if (n4 > n3) {
            return DockingUtils.reorderIndex(n, n4, n3);
        }
        if (n4 < n3) {
            return DockingUtils.reorderIndex(n4, n2, n3);
        }
        return new int[0];
    }

    static int[] reorderIndex(int n, int n2, int n3) {
        int n4;
        int n5 = n2 - n + 1;
        if (n5 <= 0) {
            return new int[0];
        }
        int[] nArray = new int[n5 - 1];
        int n6 = Math.max(n3 - n, n2 - n3);
        int[] nArray2 = new int[n6 * 2];
        for (n4 = 0; n4 < n6; ++n4) {
            nArray2[2 * n4] = n3 + (n4 + 1);
            nArray2[2 * n4 + 1] = n3 - (n4 + 1);
        }
        n4 = 0;
        for (int i = 0; i < n6 * 2; ++i) {
            if (nArray2[i] < n || nArray2[i] > n2) continue;
            nArray[n4] = nArray2[i];
            ++n4;
        }
        return nArray;
    }

    public static void main(String[] stringArray) {
        int[] nArray;
        System.out.println("[0,2] --- 0, 2");
        for (int n : nArray = DockingUtils.reorderIndex(0, 2, 0, 1)) {
            System.out.print(n + " ");
        }
        System.out.println();
        System.out.println("[0,1] --- 0");
        for (int n : nArray = DockingUtils.reorderIndex(0, 1, 0)) {
            System.out.print(n + " ");
        }
        System.out.println();
        System.out.println("[0, 3] --- 0");
        for (int n : nArray = DockingUtils.reorderIndex(0, 3, 0)) {
            System.out.print(n + " ");
        }
        System.out.println();
        System.out.println("[0, 7] --- 4");
        for (int n : nArray = DockingUtils.reorderIndex(0, 7, 4)) {
            System.out.print(n + " ");
        }
        System.out.println();
        System.out.println("[3, 8] --- 6");
        for (int n : nArray = DockingUtils.reorderIndex(3, 8, 6)) {
            System.out.print(n + " ");
        }
        System.out.println();
    }

    static void validateLocations(DockedFrameContainer dockedFrameContainer, Workspace workspace) {
        if (dockedFrameContainer != null && dockedFrameContainer.getNormalContainer().getComponentCount() > 0) {
            DockingUtils.validateLocations(workspace.getDockingManager(), (ContainerContainer)dockedFrameContainer.getNormalContainer().getComponent(0), workspace);
        }
    }

    static void validateLocations(DockingManager dockingManager, Container container, Workspace workspace) {
        if (container instanceof ContainerContainer) {
            DockingUtils.validateLocations(dockingManager, (ContainerContainer)container, workspace);
        } else {
            DockingUtils.validateLocations(dockingManager, workspace);
        }
    }

    static void validateLocations(DockingManager dockingManager, Workspace workspace) {
        for (int i = 0; i < workspace.getComponentCount(); ++i) {
            Component component = workspace.getComponent(i);
            if (!(component instanceof Container)) continue;
            DockingUtils.setLocation(dockingManager, (Container)component, 16);
        }
    }

    static void validateLocations(DockingManager dockingManager, ContainerContainer containerContainer, Workspace workspace) {
        boolean bl = false;
        int n = containerContainer.getOrientation();
        for (int i = 0; i < containerContainer.getComponentCount(); ++i) {
            Component component = containerContainer.getComponent(i);
            if (!(component instanceof Container)) continue;
            if (!bl && (((Container)component).isAncestorOf(workspace) || component.equals(workspace))) {
                bl = true;
                DockingUtils.validateLocations(dockingManager, (Container)component, workspace);
                continue;
            }
            if (bl) {
                DockingUtils.setLocation(dockingManager, (Container)component, n == 1 ? 4 : 2);
                continue;
            }
            DockingUtils.setLocation(dockingManager, (Container)component, n == 1 ? 8 : 1);
        }
    }

    static void setLocation(DockingManager dockingManager, Container container, int n) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            DockableFrame dockableFrame;
            Component component = container.getComponent(i);
            if (component instanceof Container) {
                DockingUtils.setLocation(dockingManager, (Container)component, n);
            }
            if (!(component instanceof DockableFrame) || (dockableFrame = (DockableFrame)component).getDockingManager() != dockingManager || dockableFrame.getContext().getCurrentDockSide() == n) continue;
            dockableFrame.getContext().setCurrentDockSide(n);
        }
    }

    static DockingManager getDockingManager(AWTEvent aWTEvent, boolean bl) {
        Serializable serializable;
        Component component = null;
        if (aWTEvent instanceof MouseEvent) {
            serializable = (MouseEvent)aWTEvent;
            Component component2 = ((ComponentEvent)serializable).getComponent();
            if (component2 == null) {
                return null;
            }
            component = SwingUtilities.getDeepestComponentAt(component2, ((MouseEvent)serializable).getX(), ((MouseEvent)serializable).getY());
        } else if (aWTEvent instanceof KeyEvent && aWTEvent.getSource() instanceof Component) {
            component = PortingUtils.getCurrentFocusComponent(aWTEvent);
        } else if (aWTEvent instanceof FocusEvent) {
            component = PortingUtils.getCurrentFocusComponent(aWTEvent);
        }
        if (!bl && component instanceof JComponent && ((JComponent)component).getClientProperty("ignoreClickToActivate") instanceof Boolean && ((Boolean)((JComponent)component).getClientProperty("ignoreClickToActivate")).booleanValue()) {
            return null;
        }
        if (component instanceof AutoHideContainer && aWTEvent instanceof MouseEvent) {
            serializable = (AutoHideContainer)component;
            int n = ((AutoHideContainer)serializable).getSelectedItemIndex(((MouseEvent)aWTEvent).getPoint());
            SidePaneItem sidePaneItem = null;
            if (n != -1) {
                sidePaneItem = ((AutoHideContainer)serializable).getItemForIndex(n);
            }
            if (sidePaneItem != null && sidePaneItem.getComponent() instanceof DockableFrame) {
                component = sidePaneItem.getComponent();
            }
        }
        if (!(component instanceof Workspace) && SwingUtilities.getAncestorOfClass(FrameContainer.class, component) != null && SwingUtilities.getAncestorOfClass(SlidingOverFrameContainer.class, component) == null || component instanceof FrameContainer) {
            if (!(component instanceof FrameContainer)) {
                component = SwingUtilities.getAncestorOfClass(FrameContainer.class, component);
            }
            component = ((FrameContainer)(serializable = (FrameContainer)component)).getSelectedFrame() != null ? ((FrameContainer)serializable).getSelectedFrame().getComponent(0) : null;
        }
        if ((serializable = DockingUtils.getDockableFrameOrWorkspace(component)) instanceof DockableFrame) {
            return ((DockableFrame)serializable).getDockingManager();
        }
        if (serializable instanceof Workspace) {
            return ((Workspace)serializable).getDockingManager();
        }
        return null;
    }

    static Component getDockableFrameOrWorkspace(Component component) {
        if (component == null) {
            return null;
        }
        if (DockingUtils.isDockableFrameOrWorkspace(component)) {
            return component;
        }
        do {
            if ((component = component.getParent()) != null) continue;
            return null;
        } while (!DockingUtils.isDockableFrameOrWorkspace(component));
        return component;
    }

    public static Container getAncestorOfClassButNot(Class<?> clazz, Component component, Class<?> clazz2) {
        Container container;
        if (component == null || clazz == null) {
            return null;
        }
        for (container = component.getParent(); container != null && !clazz.isInstance(container); container = container.getParent()) {
            if (!clazz2.isInstance(container)) continue;
            return null;
        }
        return container;
    }

    static Component getSource(DockingManager dockingManager, AWTEvent aWTEvent, boolean bl, boolean bl2) {
        boolean bl3;
        Object object;
        Component component;
        Serializable serializable;
        Component component2 = null;
        if (aWTEvent instanceof MouseEvent) {
            serializable = (MouseEvent)aWTEvent;
            component = ((ComponentEvent)serializable).getComponent();
            if (component == null) {
                return null;
            }
            component2 = SwingUtilities.getDeepestComponentAt(component, ((MouseEvent)serializable).getX(), ((MouseEvent)serializable).getY());
        } else if (aWTEvent instanceof KeyEvent && aWTEvent.getSource() instanceof Component) {
            component2 = PortingUtils.getCurrentFocusComponent(aWTEvent);
        } else if (aWTEvent instanceof FocusEvent) {
            component2 = PortingUtils.getCurrentFocusComponent(aWTEvent);
        }
        if (!bl && component2 instanceof JComponent && ((JComponent)component2).getClientProperty("ignoreClickToActivate") instanceof Boolean && ((Boolean)((JComponent)component2).getClientProperty("ignoreClickToActivate")).booleanValue()) {
            return null;
        }
        if (component2 instanceof AutoHideContainer && aWTEvent instanceof MouseEvent) {
            serializable = (AutoHideContainer)component2;
            int n = ((AutoHideContainer)serializable).getSelectedItemIndex(((MouseEvent)aWTEvent).getPoint());
            object = null;
            if (n != -1) {
                object = ((AutoHideContainer)serializable).getItemForIndex(n);
            }
            if (object != null && ((SidePaneItem)object).getComponent() instanceof DockableFrame) {
                component2 = ((SidePaneItem)object).getComponent();
            }
        }
        boolean bl4 = bl3 = component2 instanceof Workspace || DockingUtils.getAncestorOfClassButNot(Workspace.class, component2, FrameContainer.class) != null;
        if (!bl3 && SwingUtilities.getAncestorOfClass(FrameContainer.class, component2) != null && SwingUtilities.getAncestorOfClass(SlidingOverFrameContainer.class, component2) == null || component2 instanceof FrameContainer) {
            component = component2;
            if (!(component2 instanceof FrameContainer)) {
                component2 = SwingUtilities.getAncestorOfClass(FrameContainer.class, component2);
            }
            component2 = ((FrameContainer)(object = (FrameContainer)component2)).getSelectedFrame() != null ? ((FrameContainer)object).getSelectedFrame().getComponent(0) : null;
            if (aWTEvent instanceof MouseEvent && aWTEvent.getSource() instanceof Component && !(component instanceof JideTabbedPane.NoFocusButton)) {
                Point point = SwingUtilities.convertPoint((Component)aWTEvent.getSource(), ((MouseEvent)aWTEvent).getPoint(), (Component)object);
                int n = ((JideTabbedPane)object).getUI().tabForCoordinate((JTabbedPane)object, point.x, point.y);
                if (n >= 0 && n != ((JTabbedPane)object).getSelectedIndex() && n < ((JTabbedPane)object).getTabCount() && ((FrameContainer)object).getFrame(n) != null) {
                    component2 = ((FrameContainer)object).getFrame(n).getComponent(0);
                }
            }
        }
        return DockingUtils.getDockableFrameOrWorkspace(dockingManager, component2, bl2);
    }

    static void saveClosePreviousState(DockableFrame dockableFrame) {
        if (dockableFrame.isMaximized()) {
            PreviousState.disposePreviousState(dockableFrame.getClosePreviousState());
            dockableFrame.setClosePreviousState(dockableFrame.getMaximizedPreviousState());
        } else {
            PreviousState.disposePreviousState(dockableFrame.getClosePreviousState());
            dockableFrame.setClosePreviousState(PreviousState.createPreviousState(dockableFrame));
        }
    }

    static void saveHiddenPreviousState(DockableFrame dockableFrame) {
        if (dockableFrame.isMaximized()) {
            PreviousState.disposePreviousState(dockableFrame.getHiddenPreviousState());
            dockableFrame.setHiddenPreviousState(dockableFrame.getMaximizedPreviousState());
        } else {
            PreviousState.disposePreviousState(dockableFrame.getHiddenPreviousState());
            dockableFrame.setHiddenPreviousState(PreviousState.createPreviousState(dockableFrame));
        }
    }

    static void saveAvailablePreviousState(DockableFrame dockableFrame) {
        PreviousState.disposePreviousState(dockableFrame.getAvailablePreviousState());
        dockableFrame.setAvailablePreviousState(PreviousState.createPreviousState(dockableFrame));
    }

    static void saveMaximizedPreviousState(DockableFrame dockableFrame) {
        PreviousState.disposePreviousState(dockableFrame.getMaximizedPreviousState());
        dockableFrame.setMaximizedPreviousState(PreviousState.createPreviousState(dockableFrame));
    }

    static void saveDockPreviousState(DockableFrame dockableFrame, boolean bl) {
        if (bl) {
            PreviousState.disposePreviousState(dockableFrame.getDockPreviousState());
            dockableFrame.setDockPreviousState(PreviousState.createPreviousState(dockableFrame));
        } else {
            FrameContainer frameContainer = (FrameContainer)dockableFrame.getParent();
            for (int i = frameContainer.getTabCount() - 1; i >= 0; --i) {
                DockableFrame dockableFrame2 = (DockableFrame)frameContainer.getComponentAt(i);
                PreviousState previousState = PreviousState.createPreviousState(dockableFrame2);
                PreviousState.disposePreviousState(dockableFrame2.getDockPreviousState());
                dockableFrame2.setDockPreviousState(previousState);
            }
        }
    }

    static void saveFloatPreviousState(DockableFrame dockableFrame, boolean bl) {
        if (bl) {
            PreviousState.disposePreviousState(dockableFrame.getFloatPreviousState());
            dockableFrame.setFloatPreviousState(PreviousState.createPreviousState(dockableFrame));
        } else {
            FrameContainer frameContainer = (FrameContainer)dockableFrame.getParent();
            for (int i = frameContainer.getTabCount() - 1; i >= 0; --i) {
                DockableFrame dockableFrame2 = (DockableFrame)frameContainer.getComponentAt(i);
                PreviousState previousState = PreviousState.createPreviousState(dockableFrame2);
                PreviousState.disposePreviousState(dockableFrame2.getFloatPreviousState());
                dockableFrame2.setFloatPreviousState(previousState);
            }
        }
    }

    static void saveAutohidePreviousState(DockableFrame dockableFrame) {
        PreviousState.disposePreviousState(dockableFrame.getAutohidePreviousState());
        dockableFrame.setAutohidePreviousState(PreviousState.createPreviousState(dockableFrame));
    }

    static boolean attachToContainerContainer(DockingManager dockingManager, Container container, PreviousState.ParentState parentState, JComponent jComponent, boolean bl) {
        int n = parentState.ccChildren.indexOf(new Integer(parentState.myID));
        int n2 = parentState.ccChildren.indexOf(new Integer(-1));
        Component component = PreviousState.findComponentByDockID(dockingManager, container, parentState.ccID);
        JideSwingUtilities.removeFromParentWithFocusTransfer(jComponent);
        if (component != null && component instanceof ContainerContainer) {
            ContainerContainer containerContainer = (ContainerContainer)component;
            if (!bl) {
                int[] nArray;
                for (int n3 : nArray = DockingUtils.reorderIndex(0, parentState.ccChildren.size() - 1, n, n2)) {
                    Component component2;
                    Component component3 = PreviousState.findComponentByDockID(dockingManager, containerContainer, parentState.ccChildren.get(n3));
                    if (component3 == null || (component2 = PreviousState.findComponentByDockID(dockingManager, container, parentState.ccID)) == null || !(component2 instanceof ContainerContainer)) continue;
                    ContainerContainer containerContainer2 = (ContainerContainer)component2;
                    int n4 = containerContainer.indexOfPane(component3);
                    if (n4 == -1) continue;
                    containerContainer2.insertPane(jComponent, n4 + (n3 > n ? 0 : 1));
                    bl = true;
                    break;
                }
            }
            if (!bl) {
                if (n < n2) {
                    containerContainer.insertPane(jComponent, 0);
                } else {
                    containerContainer.add(jComponent);
                }
                bl = true;
            }
        }
        return bl;
    }

    static boolean attachToFrameContainer(DockingManager dockingManager, Container container, PreviousState previousState, DockableFrame dockableFrame) {
        Component component = PreviousState.findComponentByDockID(dockingManager, container, previousState.fcID);
        ArrayList<Integer> arrayList = previousState.fcChildren;
        if (arrayList == null) {
            return false;
        }
        int n = arrayList.indexOf(new Integer(previousState.dockID));
        boolean bl = false;
        if (component != null && component instanceof FrameContainer) {
            FrameContainer frameContainer = (FrameContainer)component;
            if (n != -1) {
                int[] nArray;
                for (int n2 : nArray = DockingUtils.reorderIndex(0, previousState.fcChildren.size() - 1, n)) {
                    Component component2 = PreviousState.findComponentByDockID(dockingManager, frameContainer, previousState.fcChildren.get(n2));
                    if (component2 == null) continue;
                    int n3 = frameContainer.indexOfComponent(component2);
                    int n4 = n3 + (n2 > n ? 0 : 1);
                    JideSwingUtilities.removeFromParentWithFocusTransfer(dockableFrame);
                    frameContainer.insertTab(dockableFrame, n4, true);
                    bl = true;
                    break;
                }
            }
            if (!bl) {
                frameContainer.addTab(dockableFrame, true);
                return true;
            }
        }
        return bl;
    }

    static boolean isFloatingContainerNotDockable(FloatingContainer floatingContainer) {
        DockableFrame dockableFrame;
        List<DockableFrame> list;
        return floatingContainer != null && floatingContainer.getContentPane().getComponentCount() == 1 && (list = DockingUtils.getAllDockableFrameOf((Container)floatingContainer.getContentPane().getComponent(0))) != null && list.size() == 1 && !(dockableFrame = list.get(0)).isDockable();
    }

    static int getDockableFrameCount(FloatingContainer floatingContainer) {
        List<DockableFrame> list;
        if (floatingContainer != null && floatingContainer.getContentPane().getComponentCount() == 1 && (list = DockingUtils.getAllDockableFrameOf((Container)floatingContainer.getContentPane().getComponent(0))) != null) {
            return list.size();
        }
        return 0;
    }

    public static Insets getFloatingContainerInsets(DockingManager dockingManager) {
        Insets insets;
        if (dockingManager.isUseDecoratedFloatingContainer()) {
            switch (dockingManager.getFloatingContainerType()) {
                case 1: {
                    JFrame jFrame = new JFrame();
                    insets = jFrame.getInsets();
                    break;
                }
                case 2: {
                    JWindow jWindow = new JWindow();
                    insets = jWindow.getInsets();
                    break;
                }
                default: {
                    JDialog jDialog = new JDialog();
                    insets = jDialog.getInsets();
                    break;
                }
            }
        } else {
            Border border = UIDefaultsLookup.getBorder("Resizable.resizeBorder");
            insets = border.getBorderInsets(new JPanel());
            if (!SystemInfo.isJdk14Above()) {
                insets.top = 22;
            }
        }
        return insets;
    }

    public static boolean isFloatingContainerDecorated(FloatingContainer floatingContainer) {
        return !floatingContainer.isUndecorated() || floatingContainer instanceof RootPaneContainer && ((RootPaneContainer)((Object)floatingContainer)).getRootPane().getWindowDecorationStyle() != 0;
    }

    public static boolean shouldUseDecoratedFloatingContainer(DockingManager dockingManager, Container container) {
        return dockingManager.isUseDecoratedFloatingContainer() || DockingUtils.getFrameContainerCount(dockingManager, container) > 1 || DockingUtils.getFrameContainerCount(dockingManager, container) == 1 && DockingUtils.getDockableFrameCount(dockingManager, container) > 1 && !dockingManager.isDragAllTabs();
    }

    public static boolean isInPopup(Component component) {
        for (Component component2 = component; component2 != null && !(component2 instanceof Applet) && !(component2 instanceof Window); component2 = component2.getParent()) {
            if (!(component2 instanceof JPopupMenu)) continue;
            return true;
        }
        return false;
    }

    static void setGlassPaneVisible(DockingManager dockingManager, boolean bl) {
        List<FloatingContainer> list;
        if (dockingManager == null) {
            return;
        }
        if (dockingManager.getRootPaneContainer().getGlassPane() != null) {
            dockingManager.getRootPaneContainer().getGlassPane().setVisible(bl);
        }
        if ((list = dockingManager.getFloatingFrames()) != null) {
            for (FloatingContainer floatingContainer : list) {
                Container container;
                if (!(floatingContainer.getContentPane() instanceof JComponent) || !((container = ((JComponent)floatingContainer.getContentPane()).getTopLevelAncestor()) instanceof RootPaneContainer) || ((RootPaneContainer)((Object)container)).getGlassPane() == null) continue;
                ((RootPaneContainer)((Object)container)).getGlassPane().setVisible(bl);
            }
        }
    }

    static void updateGlassPaneCursor(DockingManager dockingManager, Cursor cursor) {
        List<FloatingContainer> list;
        if (dockingManager == null) {
            return;
        }
        if (cursor == Cursor.getDefaultCursor()) {
            DockingUtils.clearGlassPaneCursor(dockingManager);
            return;
        }
        if (dockingManager.getRootPaneContainer().getGlassPane() != null) {
            dockingManager.getRootPaneContainer().getGlassPane().setCursor(cursor);
        }
        if ((list = dockingManager.getFloatingFrames()) != null) {
            for (FloatingContainer floatingContainer : list) {
                Container container;
                if (!(floatingContainer.getContentPane() instanceof JComponent) || !((container = ((JComponent)floatingContainer.getContentPane()).getTopLevelAncestor()) instanceof RootPaneContainer) || ((RootPaneContainer)((Object)container)).getGlassPane() == null) continue;
                ((RootPaneContainer)((Object)container)).getGlassPane().setCursor(cursor);
            }
        }
    }

    static void clearGlassPaneCursor(DockingManager dockingManager) {
        List<FloatingContainer> list;
        if (dockingManager == null) {
            return;
        }
        if (dockingManager.getRootPaneContainer().getGlassPane() != null) {
            dockingManager.getRootPaneContainer().getGlassPane().setCursor(Cursor.getDefaultCursor());
        }
        if ((list = dockingManager.getFloatingFrames()) != null) {
            for (FloatingContainer floatingContainer : list) {
                Container container;
                if (!(floatingContainer.getContentPane() instanceof JComponent) || !((container = ((JComponent)floatingContainer.getContentPane()).getTopLevelAncestor()) instanceof RootPaneContainer) || ((RootPaneContainer)((Object)container)).getGlassPane() == null) continue;
                ((RootPaneContainer)((Object)container)).getGlassPane().setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    public static void closeFloatingContainer(DockingManager dockingManager, FloatingContainer floatingContainer) {
        DockableFrame dockableFrame;
        if (dockingManager == null) {
            return;
        }
        switch (dockingManager.getFloatingContainerCloseBehavior()) {
            case 0: {
                if (dockingManager.isHidable()) break;
                return;
            }
            case 1: {
                if (dockingManager.isFloatable()) break;
                return;
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        DockableFrame dockableFrame2 = dockingManager.getFrame(dockingManager.getActiveFrameKey());
        if (dockableFrame2 != null && SwingUtilities.isDescendingFrom(dockableFrame2, (Component)((Object)floatingContainer)) && !dockableFrame2.isHidden() && dockableFrame2.isHidable() && !dockableFrame2.shouldVetoHiding() && !arrayList.contains(dockableFrame2.getKey())) {
            arrayList.add(dockableFrame2.getKey());
        }
        List<String> list = dockingManager.getAllFrameNames();
        for (String string : list) {
            dockableFrame = dockingManager.getFrame(string);
            if (dockableFrame == null || !SwingUtilities.isDescendingFrom(dockableFrame, (Component)((Object)floatingContainer)) || dockableFrame.isHidden() || !dockableFrame.isHidable() || dockableFrame.shouldVetoHiding() || arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        if (arrayList.size() > 0) {
            switch (dockingManager.getFloatingContainerCloseBehavior()) {
                case 0: {
                    dockingManager.addUndo(dockingManager.getResourceString("Undo.hide"));
                    for (String string : arrayList) {
                        Action action;
                        dockableFrame = dockingManager.getFrame(string);
                        if (dockableFrame == null || (action = dockableFrame.getCloseAction()) == null || !action.isEnabled()) continue;
                        ActionEvent actionEvent = new ActionEvent(floatingContainer, 1001, "hiddenByParentContainer");
                        action.actionPerformed(actionEvent);
                    }
                    break;
                }
                case 1: {
                    dockingManager.addUndo(dockingManager.getResourceString("Undo.toggle"));
                    for (String string : arrayList) {
                        Action action;
                        dockableFrame = dockingManager.getFrame(string);
                        if (dockableFrame == null || (action = dockableFrame.getFloatingAction(true)) == null || !action.isEnabled()) continue;
                        ActionEvent actionEvent = new ActionEvent(floatingContainer, 1001, "hiddenByParentContainer");
                        action.actionPerformed(actionEvent);
                    }
                    break;
                }
            }
        }
    }
}

