/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.AutoHideContainer;
import com.jidesoft.docking.ContainerContainer;
import com.jidesoft.docking.DefaultDockingManager;
import com.jidesoft.docking.DockContext;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.docking.DockingUtils;
import com.jidesoft.docking.FloatingContainer;
import com.jidesoft.docking.FloatingFrames;
import com.jidesoft.docking.FrameContainer;
import com.jidesoft.docking.FrameFloatingContainer;
import com.jidesoft.docking.HiddenFrames;
import com.jidesoft.docking.PreviousState;
import com.jidesoft.docking.Workspace;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.PersistenceUtils;
import com.jidesoft.swing.SidePane;
import com.jidesoft.swing.SidePaneGroup;
import com.jidesoft.swing.SidePaneItem;
import com.jidesoft.utils.PersistenceUtilsCallback;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DockingPersistenceUtils {
    private static final String NODE_CONTEXT = "DockContext";
    private static final String NODE_PREVIOUS_STATE = "DockPreviousState";
    private static final String NODE_CHILD = "DockChild";
    private static final String NODE_PARENT_STATE = "DockParentState";
    private static final String NODE_AUTO_HIDE_CONTAINER = "AutoHideContainer";
    private static final String NODE_SIDE_PANE_GROUP = "SidePaneGroup";
    private static final String NODE_SIDE_PANE_ITEM = "SidePaneItem";
    private static final String NODE_HIDDEN_FRAME = "HiddenFrame";
    private static final String NODE_UNDOCKED_BOUNDS = "UndockedBounds";
    private static final String NODE_INIT_UNDOCKED_BOUNDS = "InitUndockedBounds";
    private static final String NODE_BOUNDS = "Bounds";
    private static final String NODE_CONTAINER_CONTAINER = "ContainerContainer";
    private static final String NODE_FRAME_CONTAINER = "FrameContainer";
    private static final String NODE_DOCKABLE_FRAME = "DockableFrame";
    private static final String NODE_WORKSPACE = "Workspace";
    private static final String NODE_FLOATING_CONTAINER = "FloatingContainer";
    private static final String ATTRIBUTE_FRAME_STATE = "frameState";
    private static final String ATTRIBUTE_MAXIMIZED_FRAME = "maximizedFrame";
    private static final String ATTRIBUTE_KEY = "key";
    private static final String ATTRIBUTE_DOCK_ID = "dockId";
    private static final String ATTRIBUTE_INIT_SIDE = "initSide";
    private static final String ATTRIBUTE_INIT_INDEX = "initIndex";
    private static final String ATTRIBUTE_INIT_POSITION = "initPosition";
    private static final String ATTRIBUTE_INIT_MODE = "initMode";
    private static final String ATTRIBUTE_CAN_MODE = "canMode";
    private static final String ATTRIBUTE_CURRENT_MODE = "currentMode";
    private static final String ATTRIBUTE_AVAILABLE = "available";
    private static final String ATTRIBUTE_CURRENT_DOCK_SIDE = "currentDockSide";
    private static final String ATTRIBUTE_DOCKED_WIDTH = "dockedWidth";
    private static final String ATTRIBUTE_DOCKED_HEIGHT = "dockedHeight";
    private static final String ATTRIBUTE_AUTOHIDE_WIDTH = "autohideWidth";
    private static final String ATTRIBUTE_AUTOHIDE_HEIGHT = "autohideHeight";
    private static final String ATTRIBUTE_INIT_AUTOHIDE_WIDTH = "initAutohideWidth";
    private static final String ATTRIBUTE_INIT_AUTOHIDE_HEIGHT = "initAutohideHeight";
    private static final String ATTRIBUTE_TYPE = "type";
    private static final String ATTRIBUTE_MODE = "mode";
    private static final String ATTRIBUTE_ROOT_ID = "rootId";
    private static final String ATTRIBUTE_SIDE = "side";
    private static final String ATTRIBUTE_INDEX = "index";
    private static final String ATTRIBUTE_FC_ID = "fcId";
    private static final String ATTRIBUTE_CC_ID = "ccId";
    private static final String ATTRIBUTE_ORIENTATION = "orientation";
    private static final String ATTRIBUTE_PROPORTION_LAYOUT = "proportionLayout";
    private static final String ATTRIBUTE_INITIALLY_EVEN = "initiallyEven";
    private static final String ATTRIBUTE_PROPORTION = "proportion";
    private static final String ATTRIBUTE_PREFERRED_WIDTH = "preferredWidth";
    private static final String ATTRIBUTE_PREFERRED_HEIGHT = "preferredHeight";
    private static final String ATTRIBUTE_SELECTED_INDEX = "selectedIndex";
    private static final String ATTRIBUTE_ACTIVE_FRAME = "activeFrame";
    private static final String ATTRIBUTE_ACCEPT_DOCKABLE_FRAME = "acceptDockableFrame";
    private static final String ATTRIBUTE_X = "x";
    private static final String ATTRIBUTE_Y = "y";
    private static final String ATTRIBUTE_WIDTH = "width";
    private static final String ATTRIBUTE_HEIGHT = "height";
    private static final String PREVIOUS_STATE_HIDDEN = "hidden";
    private static final String PREVIOUS_STATE_DOCK = "dock";
    private static final String PREVIOUS_STATE_CLOSE = "close";
    private static final String PREVIOUS_STATE_FLOAT = "float";
    private static final String PREVIOUS_STATE_AUTOHIDE = "autohide";
    private static final String PREVIOUS_STATE_AVAILABLE = "available";
    private static final Logger LOGGER = Logger.getLogger(DefaultDockingManager.class.getName());
    private static final int HIDE_OFFSCREEN_OFFSET = 10000;

    public static void save(DefaultDockingManager defaultDockingManager, String string) throws ParserConfigurationException, IOException {
        DockingPersistenceUtils.save(defaultDockingManager, string, PersistenceUtils.getDefaultXmlEncoding());
    }

    public static void save(DefaultDockingManager defaultDockingManager, String string, String string2) throws ParserConfigurationException, IOException {
        DockingPersistenceUtils.save(defaultDockingManager, string, string2, null);
    }

    public static void save(final DefaultDockingManager defaultDockingManager, final String string, final String string2, final PersistenceUtilsCallback.Save save) throws ParserConfigurationException, IOException {
        if (SwingUtilities.isEventDispatchThread()) {
            Document document = DockingPersistenceUtils.save(defaultDockingManager, save);
            PersistenceUtils.saveXMLDocumentToFile(document, string, string2);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        Document document = DockingPersistenceUtils.save(defaultDockingManager, save);
                        PersistenceUtils.saveXMLDocumentToFile(document, string, string2);
                    }
                    catch (ParserConfigurationException parserConfigurationException) {
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            });
        }
    }

    public static void save(DefaultDockingManager defaultDockingManager, OutputStream outputStream) throws ParserConfigurationException, IOException {
        DockingPersistenceUtils.save(defaultDockingManager, outputStream, PersistenceUtils.getDefaultXmlEncoding());
    }

    public static void save(DefaultDockingManager defaultDockingManager, OutputStream outputStream, String string) throws ParserConfigurationException, IOException {
        DockingPersistenceUtils.save(defaultDockingManager, outputStream, string, null);
    }

    public static void save(final DefaultDockingManager defaultDockingManager, final OutputStream outputStream, final String string, final PersistenceUtilsCallback.Save save) throws ParserConfigurationException, IOException {
        if (SwingUtilities.isEventDispatchThread()) {
            Document document = DockingPersistenceUtils.save(defaultDockingManager, save);
            PersistenceUtils.saveXMLDocumentToStream(document, outputStream, string);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Document document = DockingPersistenceUtils.save(defaultDockingManager, save);
                            PersistenceUtils.saveXMLDocumentToStream(document, outputStream, string);
                        }
                        catch (ParserConfigurationException parserConfigurationException) {
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Document save(DefaultDockingManager defaultDockingManager, PersistenceUtilsCallback.Save save) throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        DockingPersistenceUtils.saveToDocument(defaultDockingManager, document, save);
        return document;
    }

    static void saveToDocument(DefaultDockingManager defaultDockingManager, Document document, PersistenceUtilsCallback.Save save) {
        Object object;
        Object object2;
        Object object3;
        Rectangle rectangle;
        if (defaultDockingManager == null || defaultDockingManager.isLoadingLayoutData()) {
            return;
        }
        if (defaultDockingManager.getDockedFrameContainer() != null && defaultDockingManager.getDockedFrameContainer().getNormalContainer().getComponentCount() <= 0) {
            throw new IllegalStateException("There is no component in getDockedFrameContainer().getNormalContainer(). Did you remove all the components before saving the layout? If so, please don't do it until the layout is saved.");
        }
        String string = defaultDockingManager.getMaximizedFrameKey();
        if (string != null) {
            defaultDockingManager.internalRestoreFrame(false);
        }
        if (defaultDockingManager.getDockedFrameContainer() == null) {
            return;
        }
        DockingUtils.validateLocations(defaultDockingManager.getDockedFrameContainer(), defaultDockingManager.getWorkspace());
        defaultDockingManager.removeExtraContainerContainer();
        defaultDockingManager.saveCurrentContext();
        Node node = document.getElementsByTagName("LayoutPersistence").item(0);
        if (node == null) {
            node = document.createElement("LayoutPersistence");
            document.appendChild(node);
        }
        Element element = document.createElement("DockingManager");
        node.appendChild(element);
        element.setAttribute("version", "" + defaultDockingManager.getVersion());
        if (defaultDockingManager.getLayoutPersistenceName() != null) {
            element.setAttribute("persistenceName", defaultDockingManager.getLayoutPersistenceName());
        }
        if ((rectangle = defaultDockingManager._unmaximizedBounds) != null) {
            object3 = document.createElement(NODE_BOUNDS);
            element.appendChild((Node)object3);
            object3.setAttribute(ATTRIBUTE_X, "" + rectangle.x);
            object3.setAttribute(ATTRIBUTE_Y, "" + rectangle.y);
            object3.setAttribute(ATTRIBUTE_WIDTH, "" + rectangle.width);
            object3.setAttribute(ATTRIBUTE_HEIGHT, "" + rectangle.height);
        }
        if (defaultDockingManager.getActiveFrameKey() != null) {
            element.setAttribute(ATTRIBUTE_ACTIVE_FRAME, defaultDockingManager.getActiveFrameKey());
        }
        if (defaultDockingManager.getRootPaneContainer() instanceof Frame) {
            element.setAttribute(ATTRIBUTE_FRAME_STATE, "" + PortingUtils.getFrameState((Frame)((Object)defaultDockingManager.getRootPaneContainer())));
        }
        if (string != null) {
            element.setAttribute(ATTRIBUTE_MAXIMIZED_FRAME, string);
        }
        DockingPersistenceUtils.writeAllContexts(document, element, defaultDockingManager, save);
        DockingPersistenceUtils.writeComponent(document, element, defaultDockingManager, defaultDockingManager.getDockedFrameContainer().getNormalContainer().getComponent(0), save);
        DockingPersistenceUtils.writeAutohideContainer(document, element, defaultDockingManager, 4, save);
        DockingPersistenceUtils.writeAutohideContainer(document, element, defaultDockingManager, 8, save);
        DockingPersistenceUtils.writeAutohideContainer(document, element, defaultDockingManager, 2, save);
        DockingPersistenceUtils.writeAutohideContainer(document, element, defaultDockingManager, 1, save);
        object3 = defaultDockingManager.getFloatingFrames();
        if (object3 != null && object3.size() > 0) {
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (FloatingContainer)object2.next();
                if (!(object instanceof Component)) continue;
                DockingPersistenceUtils.writeComponent(document, element, defaultDockingManager, (Component)object, save);
            }
        }
        if ((object2 = defaultDockingManager.getHiddenFrames()) != null) {
            object = ((Vector)object2).iterator();
            while (object.hasNext()) {
                String string2 = (String)object.next();
                Element element2 = document.createElement(NODE_HIDDEN_FRAME);
                element.appendChild(element2);
                element2.setAttribute(ATTRIBUTE_KEY, string2);
            }
        }
        if (string != null) {
            defaultDockingManager.internalMaximizeFrame(defaultDockingManager.getFrame(string), false);
        }
        if (save != null) {
            save.save(document, element, defaultDockingManager);
        }
    }

    private static void writeAutohideContainer(Document document, Element element, DefaultDockingManager defaultDockingManager, int n, PersistenceUtilsCallback.Save save) {
        AutoHideContainer autoHideContainer = defaultDockingManager.getAutoHideContainer(n);
        if (autoHideContainer == null) {
            return;
        }
        Element element2 = document.createElement(NODE_AUTO_HIDE_CONTAINER);
        element.appendChild(element2);
        element2.setAttribute(ATTRIBUTE_SIDE, "" + autoHideContainer.getAttachedSide());
        for (int i = 0; i < autoHideContainer.getGroups().size(); ++i) {
            DockingPersistenceUtils.writeSideGroup(document, element2, autoHideContainer.getGroups().get(i), defaultDockingManager, save);
        }
        if (save != null) {
            save.save(document, element2, autoHideContainer);
        }
    }

    private static void writeSideGroup(Document document, Element element, SidePaneGroup sidePaneGroup, DefaultDockingManager defaultDockingManager, PersistenceUtilsCallback.Save save) {
        if (sidePaneGroup.size() <= 0) {
            return;
        }
        Element element2 = document.createElement(NODE_SIDE_PANE_GROUP);
        element.appendChild(element2);
        element2.setAttribute(ATTRIBUTE_SELECTED_INDEX, "" + sidePaneGroup.getSelectedIndex());
        for (SidePaneItem sidePaneItem : sidePaneGroup) {
            DockingPersistenceUtils.writeSideItem(document, element2, sidePaneItem, defaultDockingManager, save);
        }
        if (save != null) {
            save.save(document, element2, sidePaneGroup);
        }
    }

    private static void writeSideItem(Document document, Element element, SidePaneItem sidePaneItem, DefaultDockingManager defaultDockingManager, PersistenceUtilsCallback.Save save) {
        Element element2 = document.createElement(NODE_SIDE_PANE_ITEM);
        element.appendChild(element2);
        DockingPersistenceUtils.writeComponent(document, element2, defaultDockingManager, sidePaneItem.getComponent(), save);
    }

    private static void writeComponent(Document document, Element element, DefaultDockingManager defaultDockingManager, Component component, PersistenceUtilsCallback.Save save) {
        if (component instanceof ContainerContainer) {
            DockingPersistenceUtils.writeContainerContainer(document, element, defaultDockingManager, (ContainerContainer)component, save);
        } else if (component instanceof FrameContainer) {
            DockingPersistenceUtils.writeFrameContainer(document, element, (FrameContainer)component, save);
        } else if (component instanceof DockableFrame) {
            DockingPersistenceUtils.writeDockableFrame(document, element, (DockableFrame)component, save);
        } else if (component instanceof Workspace) {
            DockingPersistenceUtils.writeWorkspace(document, element, defaultDockingManager, (Workspace)component, save);
        } else if (component instanceof FloatingContainer) {
            DockingPersistenceUtils.writeFloatingContainer(document, element, defaultDockingManager, (FloatingContainer)((Object)component), save);
        }
    }

    private static void writeContainerContainer(Document document, Element element, DefaultDockingManager defaultDockingManager, ContainerContainer containerContainer, PersistenceUtilsCallback.Save save) {
        Element element2 = document.createElement(NODE_CONTAINER_CONTAINER);
        element.appendChild(element2);
        element2.setAttribute(ATTRIBUTE_ORIENTATION, "" + containerContainer.getOrientation());
        element2.setAttribute(ATTRIBUTE_DOCK_ID, "" + containerContainer.getDockID());
        element2.setAttribute(ATTRIBUTE_PROPORTION_LAYOUT, containerContainer.isProportionalLayout() ? "1" : "0");
        element2.setAttribute(ATTRIBUTE_INITIALLY_EVEN, containerContainer.isInitiallyEven() ? "1" : "0");
        if (containerContainer.isProportionalLayout() && containerContainer.getProportions() != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (double d : containerContainer.getProportions()) {
                stringBuffer.append(d).append(';');
            }
            element2.setAttribute(ATTRIBUTE_PROPORTION, "" + stringBuffer.substring(0, stringBuffer.length() - 1));
        }
        if (containerContainer.getPreferredSize() != null && (!SystemInfo.isJdk15Above() || containerContainer.isPreferredSizeSet())) {
            element2.setAttribute(ATTRIBUTE_PREFERRED_WIDTH, "" + containerContainer.getPreferredSize().width);
            element2.setAttribute(ATTRIBUTE_PREFERRED_HEIGHT, "" + containerContainer.getPreferredSize().height);
        }
        for (int i = 0; i < containerContainer.getPaneCount(); ++i) {
            DockingPersistenceUtils.writeComponent(document, element2, defaultDockingManager, containerContainer.getPaneAt(i), save);
        }
        if (save != null) {
            save.save(document, element2, containerContainer);
        }
    }

    private static void writeFrameContainer(Document document, Element element, FrameContainer frameContainer, PersistenceUtilsCallback.Save save) {
        Element element2 = document.createElement(NODE_FRAME_CONTAINER);
        element.appendChild(element2);
        element2.setAttribute(ATTRIBUTE_DOCK_ID, "" + frameContainer.getDockID());
        if (frameContainer.getPreferredSize() != null && (!SystemInfo.isJdk15Above() || frameContainer.isPreferredSizeSet())) {
            element2.setAttribute(ATTRIBUTE_PREFERRED_WIDTH, "" + frameContainer.getPreferredSize().width);
            element2.setAttribute(ATTRIBUTE_PREFERRED_HEIGHT, "" + frameContainer.getPreferredSize().height);
        }
        element2.setAttribute(ATTRIBUTE_SELECTED_INDEX, "" + frameContainer.getSelectedIndex());
        for (int i = 0; i < frameContainer.getTabCount(); ++i) {
            DockableFrame dockableFrame;
            Component component = frameContainer.getComponentAt(i);
            if (!(component instanceof DockableFrame) || (dockableFrame = (DockableFrame)component).isTransient()) continue;
            DockingPersistenceUtils.writeDockableFrame(document, element2, dockableFrame, save);
        }
        if (save != null) {
            save.save(document, element2, frameContainer);
        }
    }

    private static void writeDockableFrame(Document document, Element element, DockableFrame dockableFrame, PersistenceUtilsCallback.Save save) {
        Element element2 = document.createElement(NODE_DOCKABLE_FRAME);
        element.appendChild(element2);
        element2.setAttribute(ATTRIBUTE_KEY, "" + dockableFrame.getKey());
        if (save != null) {
            save.save(document, element2, dockableFrame);
        }
    }

    private static void writeWorkspace(Document document, Element element, DefaultDockingManager defaultDockingManager, Workspace workspace, PersistenceUtilsCallback.Save save) {
        Element element2 = document.createElement(NODE_WORKSPACE);
        element.appendChild(element2);
        element2.setAttribute(ATTRIBUTE_ACCEPT_DOCKABLE_FRAME, workspace.isAcceptDockableFrame() ? "1" : "0");
        if (workspace.isAcceptDockableFrame()) {
            for (int i = 0; i < workspace.getComponentCount(); ++i) {
                DockingPersistenceUtils.writeComponent(document, element2, defaultDockingManager, workspace.getComponent(i), save);
            }
        }
        if (save != null) {
            save.save(document, element2, workspace);
        }
    }

    private static void writeFloatingContainer(Document document, Element element, DefaultDockingManager defaultDockingManager, FloatingContainer floatingContainer, PersistenceUtilsCallback.Save save) {
        int n;
        Element element2 = document.createElement(NODE_FLOATING_CONTAINER);
        element.appendChild(element2);
        Rectangle rectangle = floatingContainer.getBounds();
        if (rectangle != null) {
            boolean bl;
            n = rectangle.y;
            boolean bl2 = bl = n >= -5000;
            if (!bl) {
                rectangle.y += 10000;
            }
            Element element3 = document.createElement(NODE_BOUNDS);
            element2.appendChild(element3);
            element3.setAttribute(ATTRIBUTE_X, "" + rectangle.x);
            element3.setAttribute(ATTRIBUTE_Y, "" + rectangle.y);
            element3.setAttribute(ATTRIBUTE_WIDTH, "" + rectangle.width);
            element3.setAttribute(ATTRIBUTE_HEIGHT, "" + rectangle.height);
        }
        for (n = 0; n < floatingContainer.getContentPane().getComponentCount(); ++n) {
            DockingPersistenceUtils.writeComponent(document, element2, defaultDockingManager, floatingContainer.getContentPane().getComponent(n), save);
        }
    }

    private static void writeAllContexts(Document document, Element element, DefaultDockingManager defaultDockingManager, PersistenceUtilsCallback.Save save) {
        Map<String, DockContext> map = defaultDockingManager.getAllContexts();
        Set<String> set = map.keySet();
        for (String string : set) {
            Element element2;
            Object object;
            Element element3 = document.createElement(NODE_CONTEXT);
            element.appendChild(element3);
            element3.setAttribute(ATTRIBUTE_KEY, string);
            DockContext dockContext = map.get(string);
            element3.setAttribute(ATTRIBUTE_DOCK_ID, "" + dockContext.getDockID());
            element3.setAttribute(ATTRIBUTE_INIT_SIDE, "" + dockContext.getInitSide());
            element3.setAttribute(ATTRIBUTE_INIT_INDEX, "" + dockContext.getInitIndex());
            element3.setAttribute(ATTRIBUTE_INIT_POSITION, dockContext.isInitPosition() ? "1" : "0");
            element3.setAttribute(ATTRIBUTE_INIT_MODE, "" + dockContext.getInitMode());
            element3.setAttribute(ATTRIBUTE_CAN_MODE, "" + dockContext.getCanMode());
            element3.setAttribute(ATTRIBUTE_CURRENT_MODE, "" + dockContext.getCurrentMode());
            element3.setAttribute(ATTRIBUTE_CURRENT_DOCK_SIDE, "" + dockContext.getCurrentDockSide());
            element3.setAttribute("available", dockContext.isAvailable() ? "1" : "0");
            element3.setAttribute(ATTRIBUTE_DOCKED_WIDTH, "" + dockContext.getDockedWidth());
            element3.setAttribute(ATTRIBUTE_DOCKED_HEIGHT, "" + dockContext.getDockedHeight());
            element3.setAttribute(ATTRIBUTE_AUTOHIDE_WIDTH, "" + dockContext.getAutohideWidth());
            element3.setAttribute(ATTRIBUTE_AUTOHIDE_HEIGHT, "" + dockContext.getAutohideHeight());
            element3.setAttribute(ATTRIBUTE_INIT_AUTOHIDE_WIDTH, "" + dockContext.getInitAutohideWidth());
            element3.setAttribute(ATTRIBUTE_INIT_AUTOHIDE_HEIGHT, "" + dockContext.getInitAutohideHeight());
            Rectangle rectangle = dockContext.getUndockedBounds();
            if (rectangle != null) {
                object = document.createElement(NODE_UNDOCKED_BOUNDS);
                element3.appendChild((Node)object);
                object.setAttribute(ATTRIBUTE_X, "" + rectangle.x);
                object.setAttribute(ATTRIBUTE_Y, "" + rectangle.y);
                object.setAttribute(ATTRIBUTE_WIDTH, "" + rectangle.width);
                object.setAttribute(ATTRIBUTE_HEIGHT, "" + rectangle.height);
            }
            if ((object = dockContext.getInitUndockedBounds()) != null) {
                element2 = document.createElement(NODE_INIT_UNDOCKED_BOUNDS);
                element3.appendChild(element2);
                element2.setAttribute(ATTRIBUTE_X, "" + ((Rectangle)object).x);
                element2.setAttribute(ATTRIBUTE_Y, "" + ((Rectangle)object).y);
                element2.setAttribute(ATTRIBUTE_WIDTH, "" + ((Rectangle)object).width);
                element2.setAttribute(ATTRIBUTE_HEIGHT, "" + ((Rectangle)object).height);
            }
            if (dockContext.getHiddenPreviousState() != null) {
                element2 = document.createElement(NODE_PREVIOUS_STATE);
                element3.appendChild(element2);
                element2.setAttribute(ATTRIBUTE_TYPE, PREVIOUS_STATE_HIDDEN);
                DockingPersistenceUtils.writePreviousState(document, element2, dockContext.getHiddenPreviousState(), save);
            }
            if (dockContext.getDockPreviousState() != null) {
                element2 = document.createElement(NODE_PREVIOUS_STATE);
                element3.appendChild(element2);
                element2.setAttribute(ATTRIBUTE_TYPE, PREVIOUS_STATE_DOCK);
                DockingPersistenceUtils.writePreviousState(document, element2, dockContext.getDockPreviousState(), save);
            }
            if (dockContext.getClosePreviousState() != null) {
                element2 = document.createElement(NODE_PREVIOUS_STATE);
                element3.appendChild(element2);
                element2.setAttribute(ATTRIBUTE_TYPE, PREVIOUS_STATE_CLOSE);
                DockingPersistenceUtils.writePreviousState(document, element2, dockContext.getClosePreviousState(), save);
            }
            if (dockContext.getFloatPreviousState() != null) {
                element2 = document.createElement(NODE_PREVIOUS_STATE);
                element3.appendChild(element2);
                element2.setAttribute(ATTRIBUTE_TYPE, PREVIOUS_STATE_FLOAT);
                DockingPersistenceUtils.writePreviousState(document, element2, dockContext.getFloatPreviousState(), save);
            }
            if (dockContext.getAutohidePreviousState() != null) {
                element2 = document.createElement(NODE_PREVIOUS_STATE);
                element3.appendChild(element2);
                element2.setAttribute(ATTRIBUTE_TYPE, PREVIOUS_STATE_AUTOHIDE);
                DockingPersistenceUtils.writePreviousState(document, element2, dockContext.getAutohidePreviousState(), save);
            }
            if (dockContext.getAvailablePreviousState() != null) {
                element2 = document.createElement(NODE_PREVIOUS_STATE);
                element3.appendChild(element2);
                element2.setAttribute(ATTRIBUTE_TYPE, "available");
                DockingPersistenceUtils.writePreviousState(document, element2, dockContext.getAvailablePreviousState(), save);
            }
            if (save == null) continue;
            save.save(document, element3, dockContext);
        }
    }

    private static void writePreviousState(Document document, Element element, PreviousState previousState, PersistenceUtilsCallback.Save save) {
        Element element2;
        element.setAttribute(ATTRIBUTE_MODE, "" + previousState.mode);
        element.setAttribute(ATTRIBUTE_DOCK_ID, "" + previousState.dockID);
        element.setAttribute(ATTRIBUTE_ROOT_ID, "" + previousState.rootID);
        element.setAttribute(ATTRIBUTE_SIDE, "" + previousState.side);
        element.setAttribute(ATTRIBUTE_INDEX, "" + previousState.index);
        element.setAttribute(ATTRIBUTE_FC_ID, "" + previousState.fcID);
        Rectangle rectangle = previousState.rcBounds;
        if (rectangle != null) {
            Iterator<PreviousState.ParentState> iterator = document.createElement(NODE_BOUNDS);
            element.appendChild((Node)((Object)iterator));
            iterator.setAttribute(ATTRIBUTE_X, "" + rectangle.x);
            iterator.setAttribute(ATTRIBUTE_Y, "" + rectangle.y);
            iterator.setAttribute(ATTRIBUTE_WIDTH, "" + rectangle.width);
            iterator.setAttribute(ATTRIBUTE_HEIGHT, "" + rectangle.height);
        }
        if (previousState.fcChildren != null) {
            for (Integer serializable : previousState.fcChildren) {
                element2 = document.createElement(NODE_CHILD);
                element.appendChild(element2);
                element2.setAttribute(ATTRIBUTE_DOCK_ID, "" + serializable);
            }
        }
        if (previousState.parentStates != null) {
            for (PreviousState.ParentState parentState : previousState.parentStates) {
                element2 = document.createElement(NODE_PARENT_STATE);
                element.appendChild(element2);
                element2.setAttribute(ATTRIBUTE_CC_ID, "" + parentState.ccID);
                element2.setAttribute(ATTRIBUTE_DOCK_ID, "" + parentState.myID);
                element2.setAttribute(ATTRIBUTE_ORIENTATION, "" + parentState.orientation);
                if (parentState.ccChildren == null) continue;
                for (Integer n : parentState.ccChildren) {
                    Element element3 = document.createElement(NODE_CHILD);
                    element2.appendChild(element3);
                    element3.setAttribute(ATTRIBUTE_DOCK_ID, "" + n);
                }
            }
        }
        if (save != null) {
            save.save(document, element, previousState);
        }
    }

    public static boolean load(DefaultDockingManager defaultDockingManager, InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        return DockingPersistenceUtils.load(defaultDockingManager, inputStream, null);
    }

    public static boolean load(DefaultDockingManager defaultDockingManager, InputStream inputStream, PersistenceUtilsCallback.Load load) throws ParserConfigurationException, SAXException, IOException {
        return DockingPersistenceUtils.load(defaultDockingManager, PersistenceUtils.getDocument(inputStream), load);
    }

    public static boolean load(DefaultDockingManager defaultDockingManager, String string) throws ParserConfigurationException, SAXException, IOException {
        return DockingPersistenceUtils.load(defaultDockingManager, string, null);
    }

    public static boolean load(DefaultDockingManager defaultDockingManager, String string, PersistenceUtilsCallback.Load load) throws ParserConfigurationException, SAXException, IOException {
        return DockingPersistenceUtils.load(defaultDockingManager, PersistenceUtils.getDocument(string), load);
    }

    public static boolean load(final DefaultDockingManager defaultDockingManager, final Document document, final PersistenceUtilsCallback.Load load) {
        if (SwingUtilities.isEventDispatchThread()) {
            return DockingPersistenceUtils.internalLoad(defaultDockingManager, document, load);
        }
        final boolean[] blArray = new boolean[]{false};
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    blArray[0] = DockingPersistenceUtils.internalLoad(defaultDockingManager, document, load);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        return blArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean internalLoad(DefaultDockingManager defaultDockingManager, Document document, PersistenceUtilsCallback.Load load) {
        boolean bl = false;
        boolean bl2 = defaultDockingManager.isLoadingLayoutData();
        defaultDockingManager.setLoadingLayoutData(true);
        try {
            RuntimeException runtimeException = null;
            if (document == null) {
                defaultDockingManager.loadDataErrorHandler();
                boolean bl3 = false;
                return bl3;
            }
            defaultDockingManager.setRealized(false);
            try {
                int n;
                Object object;
                Serializable serializable;
                Object object3;
                Object object4;
                Object object5;
                int n2;
                Object object6;
                if (defaultDockingManager.getMaximizedFrameKey() != null) {
                    defaultDockingManager.internalRestoreFrame(false);
                }
                if (defaultDockingManager.getAutohideShowingFrame() != null) {
                    defaultDockingManager.stopShowingAutohideFrameImmediately();
                }
                defaultDockingManager.clearLayout();
                String string = null;
                String string2 = null;
                String string3 = null;
                String string4 = null;
                HiddenFrames hiddenFrames = new HiddenFrames();
                HiddenFrames hiddenFrames2 = new HiddenFrames();
                defaultDockingManager._floatingFrames = new FloatingFrames();
                Node node = document.getElementsByTagName("LayoutPersistence").item(0);
                Object object7 = null;
                if (node != null) {
                    object6 = node.getChildNodes();
                    for (n2 = 0; n2 < object6.getLength(); ++n2) {
                        object5 = object6.item(n2);
                        if (!"DockingManager".equals(object5.getNodeName())) continue;
                        String string5 = null;
                        object4 = object5.getAttributes();
                        for (int i = 0; i < object4.getLength(); ++i) {
                            object3 = object4.item(i);
                            if (!"persistenceName".equals(object3.getNodeName())) continue;
                            string5 = object3.getNodeValue();
                            break;
                        }
                        if (!JideSwingUtilities.equals(string5, defaultDockingManager.getLayoutPersistenceName())) continue;
                        object7 = object5;
                        break;
                    }
                }
                if (object7 == null) {
                    defaultDockingManager.loadDataErrorHandler();
                    boolean bl4 = false;
                    return bl4;
                }
                object6 = object7.getAttributes();
                for (n2 = 0; n2 < object6.getLength(); ++n2) {
                    object5 = object6.item(n2);
                    if ("version".equals(object5.getNodeName())) {
                        string2 = object5.getNodeValue();
                        continue;
                    }
                    if (ATTRIBUTE_ACTIVE_FRAME.equals(object5.getNodeName())) {
                        string3 = object5.getNodeValue();
                        continue;
                    }
                    if (ATTRIBUTE_FRAME_STATE.equals(object5.getNodeName())) {
                        string4 = object5.getNodeValue();
                        continue;
                    }
                    if (!ATTRIBUTE_MAXIMIZED_FRAME.equals(object5.getNodeName())) continue;
                    string = object5.getNodeValue();
                }
                if (string2 != null) {
                    defaultDockingManager.setVersion(Short.valueOf(string2));
                }
                HashMap<String, DockContext> hashMap = new HashMap<String, DockContext>(defaultDockingManager.getAllContexts());
                defaultDockingManager.getAllContexts().clear();
                object5 = object7.getChildNodes();
                for (int i = 0; i < object5.getLength(); ++i) {
                    object4 = object5.item(i);
                    if (!NODE_CONTEXT.equals(object4.getNodeName())) continue;
                    String string6 = DockingPersistenceUtils.readContext(document, defaultDockingManager, object4, defaultDockingManager.getAllContexts(), load);
                    object3 = defaultDockingManager.getAllContexts().get(string6);
                    DockContext dockContext = (DockContext)hashMap.remove(string6);
                    if (object3 == null || dockContext == null) continue;
                    ((DockContext)object3).setInitAutohideHeight(dockContext.getInitAutohideHeight());
                    ((DockContext)object3).setInitAutohideWidth(dockContext.getInitAutohideWidth());
                    ((DockContext)object3).setInitIndex(dockContext.getInitIndex());
                    ((DockContext)object3).setInitMode(dockContext.getInitMode());
                    ((DockContext)object3).setInitSide(dockContext.getInitSide());
                    ((DockContext)object3).setInitUndockedBounds(dockContext.getInitUndockedBounds());
                }
                HiddenFrames hiddenFrames3 = new HiddenFrames();
                defaultDockingManager.setHiddenFrames(hiddenFrames3);
                object4 = defaultDockingManager.getAllContexts();
                object4.putAll(hashMap);
                if (object4 != null) {
                    String[] stringArray = object4.keySet().toArray(new String[object4.size()]);
                    for (String object22 : stringArray) {
                        if (runtimeException != null) continue;
                        serializable = defaultDockingManager.getFrame(object22);
                        if (serializable == null && (object = defaultDockingManager.getDockableFrameFactory()) != null) {
                            try {
                                serializable = object.create(object22);
                            }
                            catch (Throwable throwable) {
                                runtimeException = new RuntimeException("DockableFrameFactory threw an unexpected exception while creating '" + (String)object22 + "'.", throwable);
                            }
                            if (serializable != null) {
                                boolean bl3 = defaultDockingManager.isRealized();
                                defaultDockingManager.setRealized(false);
                                defaultDockingManager.addFrame((DockableFrame)serializable);
                                defaultDockingManager.setRealized(bl3);
                            }
                        }
                        if (serializable != null) {
                            ((DockableFrame)serializable).setContext(object4.get(object22));
                            if (((DockableFrame)serializable).getContext().getDockedWidth() > 0 || ((DockableFrame)serializable).getContext().getDockedHeight() > 0) {
                                ((DockableFrame)serializable).internalSetPreferredSize();
                            }
                            if (!object4.get(object22).isAvailable()) continue;
                            hiddenFrames3.add(object22);
                            continue;
                        }
                        object4.remove(object22);
                    }
                }
                for (int i = 0; i < object5.getLength(); ++i) {
                    String string7;
                    object3 = object5.item(i);
                    if (NODE_BOUNDS.equals(object3.getNodeName()) && defaultDockingManager.isUseFrameBounds()) {
                        defaultDockingManager._unmaximizedBounds = DockingPersistenceUtils.readBounds((Node)object3);
                        continue;
                    }
                    if (NODE_CONTAINER_CONTAINER.equals(object3.getNodeName()) || NODE_FRAME_CONTAINER.equals(object3.getNodeName()) || NODE_WORKSPACE.equals(object3.getNodeName()) || NODE_DOCKABLE_FRAME.equals(object3.getNodeName())) {
                        Component component = DockingPersistenceUtils.readComponent(document, defaultDockingManager, (Node)object3, hiddenFrames2, load);
                        if (component == null) continue;
                        defaultDockingManager.getDockedFrameContainer().getNormalContainer().add(component, "Center");
                        continue;
                    }
                    if (NODE_FLOATING_CONTAINER.equals(object3.getNodeName())) {
                        FloatingContainer floatingContainer = DockingPersistenceUtils.readFloatingContainer(document, defaultDockingManager, (Node)object3, hiddenFrames2, load);
                        if (floatingContainer == null) continue;
                        defaultDockingManager.getFloatingFrames().add(floatingContainer);
                        continue;
                    }
                    if (NODE_AUTO_HIDE_CONTAINER.equals(object3.getNodeName())) {
                        AutoHideContainer autoHideContainer = DockingPersistenceUtils.readAutohideContainer(document, defaultDockingManager, (Node)object3, hiddenFrames2, load);
                        switch (autoHideContainer.getAttachedSide()) {
                            case 3: {
                                defaultDockingManager._eastContainer = autoHideContainer;
                                break;
                            }
                            case 7: {
                                defaultDockingManager._westContainer = autoHideContainer;
                                break;
                            }
                            case 5: {
                                defaultDockingManager._southContainer = autoHideContainer;
                                break;
                            }
                            case 1: {
                                defaultDockingManager._northContainer = autoHideContainer;
                            }
                        }
                        continue;
                    }
                    if (!NODE_HIDDEN_FRAME.equals(object3.getNodeName()) || (string7 = DockingPersistenceUtils.readHiddenFrame((Node)object3)) == null) continue;
                    hiddenFrames.add(string7);
                }
                if (load != null && object7 instanceof Element) {
                    load.load(document, (Element)object7, defaultDockingManager);
                }
                HiddenFrames hiddenFrames4 = new HiddenFrames();
                for (String string8 : hashMap.keySet()) {
                    hiddenFrames4.add(string8);
                }
                if (defaultDockingManager.isHideNewlyAddedFrames()) {
                    for (String string9 : hiddenFrames4) {
                        DockableFrame dockableFrame = defaultDockingManager.getFrame(string9);
                        if (dockableFrame == null || !dockableFrame.isHidable()) continue;
                        hiddenFrames.add(string9);
                    }
                } else if (hiddenFrames4 != null && defaultDockingManager instanceof DefaultDockingManager) {
                    defaultDockingManager.handleNewlyAddedFrames(hiddenFrames4.toArray(new String[hiddenFrames4.size()]));
                }
                if (string4 != null) {
                    defaultDockingManager._state = Integer.valueOf(string4);
                }
                hiddenFrames3.removeAll(hiddenFrames2);
                if (defaultDockingManager._eastContainer == null) {
                    defaultDockingManager._eastContainer = defaultDockingManager.createAutoHideContainer(3);
                }
                defaultDockingManager._eastContainer.setRollover(defaultDockingManager.isSidebarRollover());
                if (defaultDockingManager._westContainer == null) {
                    defaultDockingManager._westContainer = defaultDockingManager.createAutoHideContainer(7);
                }
                defaultDockingManager._westContainer.setRollover(defaultDockingManager.isSidebarRollover());
                if (defaultDockingManager._southContainer == null) {
                    defaultDockingManager._southContainer = defaultDockingManager.createAutoHideContainer(5);
                }
                defaultDockingManager._southContainer.setRollover(defaultDockingManager.isSidebarRollover());
                if (defaultDockingManager._northContainer == null) {
                    defaultDockingManager._northContainer = defaultDockingManager.createAutoHideContainer(1);
                }
                defaultDockingManager._northContainer.setRollover(defaultDockingManager.isSidebarRollover());
                defaultDockingManager.listenToAutohideContainers();
                defaultDockingManager._dockedHiddenContainer.add((Component)defaultDockingManager.createScrollPaneForAutoHideContainer(defaultDockingManager._westContainer), "Before");
                defaultDockingManager._dockedHiddenContainer.add((Component)defaultDockingManager.createScrollPaneForAutoHideContainer(defaultDockingManager._eastContainer), "After");
                defaultDockingManager._dockedHiddenContainer.add((Component)defaultDockingManager.createScrollPaneForAutoHideContainer(defaultDockingManager._northContainer), "First");
                defaultDockingManager._dockedHiddenContainer.add((Component)defaultDockingManager.createScrollPaneForAutoHideContainer(defaultDockingManager._southContainer), "Last");
                defaultDockingManager._orderedFloatingFrames = new Vector<Component>();
                for (FloatingContainer floatingContainer : defaultDockingManager.getFloatingFrames()) {
                    floatingContainer.addWindowListener(defaultDockingManager.getFloatingContainerWindowListener());
                    if (!(floatingContainer instanceof Component)) continue;
                    defaultDockingManager._orderedFloatingFrames.add((Component)((Object)floatingContainer));
                }
                if (defaultDockingManager.getRootPaneContainer() instanceof Window) {
                    defaultDockingManager._orderedFloatingFrames.add((Window)((Object)defaultDockingManager.getRootPaneContainer()));
                    ((Window)((Object)defaultDockingManager.getRootPaneContainer())).addWindowListener(defaultDockingManager.getFloatingContainerWindowListener());
                }
                object3 = new ArrayList();
                List<String> list = defaultDockingManager.getAllFrameNames();
                for (n = list.size() - 1; n >= 0; --n) {
                    String string5 = list.get(n);
                    if (hiddenFrames3.contains(string5)) continue;
                    serializable = defaultDockingManager.getFrame(list.get(n));
                    defaultDockingManager.addToZOrder(serializable);
                }
                for (n = list.size() - 1; n >= 0; --n) {
                    String string6 = list.get(n);
                    if (hiddenFrames3.contains(string6) || !(((Component)(serializable = defaultDockingManager.getFrame(list.get(n)))).getParent() instanceof FrameContainer) || ((FrameContainer)(object = (FrameContainer)((Component)serializable).getParent())).getSelectedFrame() != serializable) continue;
                    defaultDockingManager.adjustZorderWhileLoadingLayout(serializable);
                }
                for (n = hiddenFrames3.size() - 1; n >= 0; --n) {
                    int n3;
                    String string7 = (String)hiddenFrames3.get(n);
                    if (hiddenFrames.contains(string7)) {
                        serializable = defaultDockingManager.getFrame(string7);
                        if (serializable == null || (n3 = ((DockableFrame)serializable).getContext().getInitSide()) != 0) continue;
                        ((DockableFrame)serializable).getContext().setCurrentDockSide(n3);
                        continue;
                    }
                    serializable = defaultDockingManager.getFrame(string7);
                    if (serializable == null || ((DockableFrame)serializable).isHidden() || !((DockableFrame)serializable).isAvailable()) continue;
                    JideSwingUtilities.removeFromParentWithFocusTransfer((Component)serializable);
                    ((DockableFrame)serializable).setVisible(false);
                    if (defaultDockingManager.getUnknownFrameBehaviorOnLoading() == 1) {
                        ((DockableFrame)serializable).setHidden(true);
                        continue;
                    }
                    n3 = ((DockableFrame)serializable).getContext().getInitSide();
                    ((DockableFrame)serializable).getContext().setCurrentDockSide(n3);
                    switch (((DockableFrame)serializable).getInitMode()) {
                        case 2: 
                        case 3: {
                            AutoHideContainer autoHideContainer = defaultDockingManager.getAutoHideContainer(n3);
                            if (defaultDockingManager.isGroupAllowedOnSidePane()) {
                                autoHideContainer.addFrame((DockableFrame)serializable);
                            } else {
                                autoHideContainer.addFrame((DockableFrame)serializable, autoHideContainer.getGroups().size());
                            }
                            hiddenFrames3.remove(n);
                            break;
                        }
                        case 1: {
                            defaultDockingManager.internalFloatFrame((DockableFrame)serializable, ((DockableFrame)serializable).getContext().getUndockedBounds(), true, true);
                            hiddenFrames3.remove(n);
                            break;
                        }
                        case 4: {
                            if (((Component)serializable).getParent() == null || !(((Component)serializable).getParent() instanceof FrameContainer)) {
                                if (!DefaultDockingManager.checkForInitPosition() || ((DockableFrame)serializable).getContext().isInitPosition()) {
                                    defaultDockingManager.dockFrame(((DockableFrame)serializable).getKey(), ((DockableFrame)serializable).getContext().getInitSide(), ((DockableFrame)serializable).getContext().getInitIndex());
                                    ((DockableFrame)serializable).getContext().setInitPosition(true);
                                    object3.add(serializable);
                                } else {
                                    defaultDockingManager.internalDockFrame((JComponent)serializable, (Component)defaultDockingManager.getDockedFrameContainer(), n3);
                                }
                            }
                            hiddenFrames3.remove(n);
                            break;
                        }
                    }
                    defaultDockingManager.addToZOrder(serializable);
                }
                Iterator<Object> iterator = object3.iterator();
                while (iterator.hasNext()) {
                    DockableFrame dockableFrame = (DockableFrame)iterator.next();
                    dockableFrame.getContext().setInitPosition(false);
                }
                for (FloatingContainer floatingContainer : defaultDockingManager.getFloatingFrames()) {
                    if (floatingContainer == null) continue;
                    serializable = floatingContainer.getInitialBounds(floatingContainer.getBounds());
                    floatingContainer.pack();
                    floatingContainer.setBounds((Rectangle)serializable);
                    floatingContainer.setVisible(true);
                }
                defaultDockingManager.resetLayout();
                defaultDockingManager.setRealized(true);
                defaultDockingManager.fireFrameEvents();
                defaultDockingManager.setBoundsState();
                if (string != null && string.trim().length() > 0) {
                    defaultDockingManager.internalMaximizeFrame(defaultDockingManager.getFrame(string), false);
                }
                if (string3 != null && string3.trim().length() > 0) {
                    defaultDockingManager.activateFrame(string3);
                }
                bl = true;
            }
            catch (Exception exception) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "Error loading layout - " + exception.getLocalizedMessage(), exception);
                }
                defaultDockingManager.loadDataErrorHandler();
            }
            finally {
                defaultDockingManager.setRealized(true);
            }
            if (runtimeException != null) {
                throw runtimeException;
            }
        }
        catch (Exception exception) {
            bl = false;
            defaultDockingManager.loadDataErrorHandler();
        }
        finally {
            defaultDockingManager.setLoadingLayoutData(bl2);
        }
        return bl;
    }

    private static String readContext(Document document, DockingManager dockingManager, Node node, Map<String, DockContext> map, PersistenceUtilsCallback.Load load) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        String string12 = null;
        String string13 = null;
        String string14 = null;
        String string15 = null;
        String string16 = null;
        DockContext dockContext = new DockContext();
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            if (ATTRIBUTE_KEY.equals(node2.getNodeName())) {
                string = node2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_DOCK_ID.equals(node2.getNodeName())) {
                string2 = node2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_INIT_SIDE.equals(node2.getNodeName())) {
                string3 = node2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_INIT_INDEX.equals(node2.getNodeName())) {
                string4 = node2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_INIT_POSITION.equals(node2.getNodeName())) {
                string5 = node2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_INIT_MODE.equals(node2.getNodeName())) {
                string6 = node2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_CAN_MODE.equals(node2.getNodeName())) {
                string7 = node2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_CURRENT_MODE.equals(node2.getNodeName())) {
                string8 = node2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_CURRENT_DOCK_SIDE.equals(node2.getNodeName())) {
                string9 = node2.getNodeValue();
                continue;
            }
            if ("available".equals(node2.getNodeName())) {
                string10 = node2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_DOCKED_WIDTH.equals(node2.getNodeName())) {
                string11 = node2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_DOCKED_HEIGHT.equals(node2.getNodeName())) {
                string12 = node2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_AUTOHIDE_WIDTH.equals(node2.getNodeName())) {
                string13 = node2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_AUTOHIDE_HEIGHT.equals(node2.getNodeName())) {
                string14 = node2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_INIT_AUTOHIDE_WIDTH.equals(node2.getNodeName())) {
                string15 = node2.getNodeValue();
                continue;
            }
            if (!ATTRIBUTE_INIT_AUTOHIDE_HEIGHT.equals(node2.getNodeName())) continue;
            string16 = node2.getNodeValue();
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node3 = nodeList.item(i);
            if (NODE_UNDOCKED_BOUNDS.equals(node3.getNodeName())) {
                dockContext.setUndockedBounds(DockingPersistenceUtils.readBounds(node3));
            }
            if (NODE_INIT_UNDOCKED_BOUNDS.equals(node3.getNodeName())) {
                dockContext.setInitUndockedBounds(DockingPersistenceUtils.readBounds(node3));
                continue;
            }
            if (!NODE_PREVIOUS_STATE.equals(node3.getNodeName())) continue;
            NamedNodeMap namedNodeMap2 = node3.getAttributes();
            for (int j = 0; j < namedNodeMap2.getLength(); ++j) {
                Node node4 = namedNodeMap2.item(j);
                if (!ATTRIBUTE_TYPE.equals(node4.getNodeName())) continue;
                String string17 = node4.getNodeValue();
                if (PREVIOUS_STATE_HIDDEN.equals(string17)) {
                    dockContext.setHiddenPreviousState(DockingPersistenceUtils.readPreviousState(document, node3, load));
                    continue;
                }
                if (PREVIOUS_STATE_DOCK.equals(string17)) {
                    dockContext.setDockPreviousState(DockingPersistenceUtils.readPreviousState(document, node3, load));
                    continue;
                }
                if (PREVIOUS_STATE_CLOSE.equals(string17)) {
                    dockContext.setClosePreviousState(DockingPersistenceUtils.readPreviousState(document, node3, load));
                    continue;
                }
                if (PREVIOUS_STATE_FLOAT.equals(string17)) {
                    dockContext.setFloatPreviousState(DockingPersistenceUtils.readPreviousState(document, node3, load));
                    continue;
                }
                if (PREVIOUS_STATE_AUTOHIDE.equals(string17)) {
                    dockContext.setAutohidePreviousState(DockingPersistenceUtils.readPreviousState(document, node3, load));
                    continue;
                }
                if (!"available".equals(string17)) continue;
                dockContext.setAvailablePreviousState(DockingPersistenceUtils.readPreviousState(document, node3, load));
            }
        }
        if (string2 != null) {
            dockContext.setDockID(dockingManager, Integer.valueOf(string2));
        }
        if (string3 != null) {
            dockContext.setInitSide(Integer.valueOf(string3));
        }
        if (string4 != null) {
            dockContext.setInitIndex(Integer.valueOf(string4));
        }
        dockContext.setInitPosition("1".equals(string5));
        if (string6 != null) {
            dockContext.setInitMode(Integer.valueOf(string6));
        }
        if (string7 != null) {
            dockContext.setCanMode(Integer.valueOf(string7));
        }
        if (string8 != null) {
            dockContext.setCurrentMode(Integer.valueOf(string8));
        }
        if (dockContext.isAutohideShowing()) {
            dockContext.setCurrentMode(2);
        }
        if (string9 != null) {
            dockContext.setCurrentDockSide(Integer.valueOf(string9));
        }
        dockContext.setAvailable("1".equals(string10));
        if (string11 != null) {
            dockContext.setDockedWidth(Integer.valueOf(string11));
        }
        if (string12 != null) {
            dockContext.setDockedHeight(Integer.valueOf(string12));
        }
        if (string13 != null) {
            dockContext.setAutohideWidth(Integer.valueOf(string13));
        }
        if (string14 != null) {
            dockContext.setAutohideHeight(Integer.valueOf(string14));
        }
        if (string15 != null) {
            dockContext.setInitAutohideWidth(Integer.valueOf(string15));
        }
        if (string16 != null) {
            dockContext.setInitAutohideHeight(Integer.valueOf(string16));
        }
        if (map != null) {
            map.put(string, dockContext);
        }
        if (load != null && node instanceof Element) {
            load.load(document, (Element)node, dockContext);
        }
        return string;
    }

    private static Rectangle readBounds(Node node) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            if (ATTRIBUTE_X.equals(node2.getNodeName())) {
                string = node2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_Y.equals(node2.getNodeName())) {
                string2 = node2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_WIDTH.equals(node2.getNodeName())) {
                string3 = node2.getNodeValue();
                continue;
            }
            if (!ATTRIBUTE_HEIGHT.equals(node2.getNodeName())) continue;
            string4 = node2.getNodeValue();
        }
        Rectangle rectangle = new Rectangle();
        if (string != null) {
            rectangle.x = Integer.valueOf(string);
        }
        if (string2 != null) {
            rectangle.y = Integer.valueOf(string2);
        }
        if (string3 != null) {
            rectangle.width = Integer.valueOf(string3);
        }
        if (string4 != null) {
            rectangle.height = Integer.valueOf(string4);
        }
        return rectangle;
    }

    private static PreviousState readPreviousState(Document document, Node node, PersistenceUtilsCallback.Load load) {
        PreviousState previousState = new PreviousState();
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            if (ATTRIBUTE_MODE.equals(node2.getNodeName())) {
                previousState.mode = Integer.valueOf(node2.getNodeValue());
                continue;
            }
            if (ATTRIBUTE_DOCK_ID.equals(node2.getNodeName())) {
                previousState.dockID = Integer.valueOf(node2.getNodeValue());
                continue;
            }
            if (ATTRIBUTE_ROOT_ID.equals(node2.getNodeName())) {
                previousState.rootID = Integer.valueOf(node2.getNodeValue());
                continue;
            }
            if (ATTRIBUTE_SIDE.equals(node2.getNodeName())) {
                previousState.side = Integer.valueOf(node2.getNodeValue());
                continue;
            }
            if (ATTRIBUTE_INDEX.equals(node2.getNodeName())) {
                previousState.index = Integer.valueOf(node2.getNodeValue());
                continue;
            }
            if (!ATTRIBUTE_FC_ID.equals(node2.getNodeName())) continue;
            previousState.fcID = Integer.valueOf(node2.getNodeValue());
        }
        previousState.fcChildren = new ArrayList();
        previousState.parentStates = new ArrayList();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node3 = nodeList.item(i);
            if (NODE_BOUNDS.equals(node3.getNodeName())) {
                previousState.rcBounds = DockingPersistenceUtils.readBounds(node3);
                continue;
            }
            if (NODE_CHILD.equals(node3.getNodeName())) {
                NamedNodeMap namedNodeMap2 = node3.getAttributes();
                for (int j = 0; j < namedNodeMap2.getLength(); ++j) {
                    Node node4 = namedNodeMap2.item(j);
                    if (!ATTRIBUTE_DOCK_ID.equals(node4.getNodeName())) continue;
                    previousState.fcChildren.add(Integer.valueOf(node4.getNodeValue()));
                }
                continue;
            }
            if (!NODE_PARENT_STATE.equals(node3.getNodeName())) continue;
            previousState.parentStates.add(DockingPersistenceUtils.readParentState(node3));
        }
        if (load != null && node instanceof Element) {
            load.load(document, (Element)node, previousState);
        }
        return previousState;
    }

    private static PreviousState.ParentState readParentState(Node node) {
        PreviousState.ParentState parentState = new PreviousState.ParentState();
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            if (ATTRIBUTE_CC_ID.equals(node2.getNodeName())) {
                parentState.ccID = Integer.valueOf(node2.getNodeValue());
                continue;
            }
            if (ATTRIBUTE_DOCK_ID.equals(node2.getNodeName())) {
                parentState.myID = Integer.valueOf(node2.getNodeValue());
                continue;
            }
            if (!ATTRIBUTE_ORIENTATION.equals(node2.getNodeName())) continue;
            parentState.orientation = Integer.valueOf(node2.getNodeValue());
        }
        parentState.ccChildren = new ArrayList();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node3 = nodeList.item(i);
            if (!NODE_CHILD.equals(node3.getNodeName())) continue;
            NamedNodeMap namedNodeMap2 = node3.getAttributes();
            for (int j = 0; j < namedNodeMap2.getLength(); ++j) {
                Node node4 = namedNodeMap2.item(j);
                if (!ATTRIBUTE_DOCK_ID.equals(node4.getNodeName())) continue;
                parentState.ccChildren.add(Integer.valueOf(node4.getNodeValue()));
            }
        }
        return parentState;
    }

    private static Component readComponent(Document document, DockingManager dockingManager, Node node, HiddenFrames hiddenFrames, PersistenceUtilsCallback.Load load) {
        if (NODE_CONTAINER_CONTAINER.equals(node.getNodeName())) {
            return DockingPersistenceUtils.readContainerContainer(document, dockingManager, node, hiddenFrames, load);
        }
        if (NODE_FRAME_CONTAINER.equals(node.getNodeName())) {
            return DockingPersistenceUtils.readFrameContainer(document, dockingManager, node, hiddenFrames, load);
        }
        if (NODE_DOCKABLE_FRAME.equals(node.getNodeName())) {
            return DockingPersistenceUtils.readDockableFrame(document, dockingManager, node, hiddenFrames, load);
        }
        if (NODE_FLOATING_CONTAINER.equals(node.getNodeName())) {
            return (Component)((Object)DockingPersistenceUtils.readFloatingContainer(document, dockingManager, node, hiddenFrames, load));
        }
        if (NODE_WORKSPACE.equals(node.getNodeName())) {
            return DockingPersistenceUtils.readWorkspace(document, dockingManager, node, hiddenFrames, load);
        }
        return null;
    }

    private static ContainerContainer readContainerContainer(Document document, DockingManager dockingManager, Node node, HiddenFrames hiddenFrames, PersistenceUtilsCallback.Load load) {
        Object object;
        String[] stringArray;
        int n;
        ContainerContainer containerContainer = dockingManager != null ? dockingManager.createContainerContainer() : new ContainerContainer();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            if (ATTRIBUTE_ORIENTATION.equals(node2.getNodeName())) {
                string = node2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_DOCK_ID.equals(node2.getNodeName())) {
                string2 = node2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_PROPORTION_LAYOUT.equals(node2.getNodeName())) {
                string3 = node2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_INITIALLY_EVEN.equals(node2.getNodeName())) {
                string4 = node2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_PROPORTION.equals(node2.getNodeName())) {
                string5 = node2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_PREFERRED_WIDTH.equals(node2.getNodeName())) {
                string6 = node2.getNodeValue();
                continue;
            }
            if (!ATTRIBUTE_PREFERRED_HEIGHT.equals(node2.getNodeName())) continue;
            string7 = node2.getNodeValue();
        }
        NodeList nodeList = node.getChildNodes();
        for (n = 0; n < nodeList.getLength(); ++n) {
            stringArray = nodeList.item(n);
            if (!NODE_CONTAINER_CONTAINER.equals(stringArray.getNodeName()) && !NODE_FRAME_CONTAINER.equals(stringArray.getNodeName()) && !NODE_DOCKABLE_FRAME.equals(stringArray.getNodeName()) && !NODE_WORKSPACE.equals(stringArray.getNodeName()) || (object = DockingPersistenceUtils.readComponent(document, dockingManager, (Node)stringArray, hiddenFrames, load)) == null) continue;
            containerContainer.add((Component)object);
        }
        if (string != null) {
            containerContainer.setOrientation(Integer.valueOf(string));
        }
        if (string2 != null) {
            containerContainer.setDockID(Integer.valueOf(string2));
        }
        containerContainer.setProportionalLayout("1".equals(string3));
        n = 0;
        if (containerContainer.isProportionalLayout()) {
            containerContainer.setInitiallyEven("1".equals(string4));
            if (string5 != null) {
                stringArray = string5.split(";");
                object = new double[stringArray.length];
                for (int i = 0; i < ((Object)object).length; ++i) {
                    object[i] = Double.valueOf(stringArray[i]);
                }
                containerContainer.setEventualProportions((double[])object);
                n = 1;
            }
        }
        if (string6 != null && string7 != null && (Integer.valueOf(string6) != 0 || Integer.valueOf(string7) != 0)) {
            containerContainer.setPreferredSize(new Dimension(Integer.valueOf(string6), Integer.valueOf(string7)));
        }
        if (containerContainer.getComponentCount() == 0 && n == 0) {
            return null;
        }
        if (load != null && node instanceof Element) {
            load.load(document, (Element)node, containerContainer);
        }
        return containerContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FrameContainer readFrameContainer(Document document, DockingManager dockingManager, Node node, HiddenFrames hiddenFrames, PersistenceUtilsCallback.Load load) {
        int n;
        FrameContainer frameContainer = dockingManager != null ? dockingManager.createFrameContainer() : new FrameContainer();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            if (ATTRIBUTE_DOCK_ID.equals(node2.getNodeName())) {
                string = node2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_PREFERRED_WIDTH.equals(node2.getNodeName())) {
                string2 = node2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_PREFERRED_HEIGHT.equals(node2.getNodeName())) {
                string3 = node2.getNodeValue();
                continue;
            }
            if (!ATTRIBUTE_SELECTED_INDEX.equals(node2.getNodeName())) continue;
            string4 = node2.getNodeValue();
        }
        NodeList nodeList = node.getChildNodes();
        frameContainer.setSuppressSetSelectedIndex(true);
        frameContainer.setSuppressStateChangedEvents(true);
        try {
            for (n = 0; n < nodeList.getLength(); ++n) {
                DockableFrame dockableFrame;
                Node node3 = nodeList.item(n);
                if (!NODE_DOCKABLE_FRAME.equals(node3.getNodeName()) || (dockableFrame = DockingPersistenceUtils.readDockableFrame(document, dockingManager, node3, hiddenFrames, load)) == null || dockableFrame.getContext() == null || !dockableFrame.isAvailable() || dockableFrame.shouldVetoShowing()) continue;
                frameContainer.addTab(dockableFrame);
            }
        }
        finally {
            frameContainer.setSuppressSetSelectedIndex(false);
            frameContainer.setSuppressStateChangedEvents(false);
        }
        if (frameContainer.getTabCount() == 0) {
            return null;
        }
        if (string != null) {
            frameContainer.setDockID(Integer.valueOf(string));
        }
        if (string2 != null && string3 != null) {
            frameContainer.setPreferredSize(new Dimension(Integer.valueOf(string2), Integer.valueOf(string3)));
        }
        n = -1;
        if (string4 != null) {
            n = Integer.valueOf(string4);
        }
        if (n >= 0 && n < frameContainer.getTabCount()) {
            frameContainer.setSelectedIndex(n);
        } else if (frameContainer.getTabCount() > 0) {
            frameContainer.setSelectedIndex(0);
        }
        frameContainer.setPreviousSelectedFrame(frameContainer.getSelectedFrame());
        if (load != null && node instanceof Element) {
            load.load(document, (Element)node, frameContainer);
        }
        return frameContainer;
    }

    private static DockableFrame readDockableFrame(Document document, DockingManager dockingManager, Node node, HiddenFrames hiddenFrames, PersistenceUtilsCallback.Load load) {
        DockableFrame dockableFrame;
        Object object;
        String string = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            object = namedNodeMap.item(i);
            if (!ATTRIBUTE_KEY.equals(object.getNodeName())) continue;
            string = object.getNodeValue();
        }
        if (dockingManager != null) {
            dockableFrame = dockingManager.getFrame(string);
        } else {
            dockableFrame = new DockableFrame();
            dockableFrame.setKey(string);
        }
        if (dockableFrame != null) {
            object = null;
            if (!dockableFrame.isTransient() && dockingManager != null) {
                object = dockingManager.getContextOf(string);
            }
            if (object != null) {
                dockableFrame.setContext((DockContext)object);
            }
            if (!dockableFrame.isHidden()) {
                hiddenFrames.add(string);
            }
            dockableFrame.setAvailable(true);
        }
        if (load != null && node instanceof Element) {
            load.load(document, (Element)node, dockableFrame);
        }
        return dockableFrame;
    }

    private static FloatingContainer readFloatingContainer(Document document, DockingManager dockingManager, Node node, HiddenFrames hiddenFrames, PersistenceUtilsCallback.Load load) {
        Object object;
        Object object2;
        FloatingContainer floatingContainer;
        Object object3;
        if (dockingManager != null) {
            object3 = dockingManager.getRootPaneContainer();
            if (object3 == null) {
                throw new IllegalStateException("Failed to create floating frame because the top level window is not available. Please make sure you load the layout after the contentContainer is added to Swing component tree hierarchy or make sure you pass in a valid rootPaneContainer in the constructor of DefaultDockingManager.");
            }
            floatingContainer = dockingManager.createFloatingContainer(SwingUtilities.getWindowAncestor(object3.getRootPane()));
            object2 = dockingManager.getFloatingContainerCustomizer();
            if (object2 != null) {
                object2.customize(floatingContainer);
            }
        } else {
            floatingContainer = new FrameFloatingContainer();
        }
        object3 = null;
        object2 = node.getChildNodes();
        for (int i = 0; i < object2.getLength(); ++i) {
            Component component;
            object = object2.item(i);
            if (NODE_BOUNDS.equals(object.getNodeName())) {
                object3 = DockingPersistenceUtils.readBounds((Node)object);
                continue;
            }
            if (!NODE_CONTAINER_CONTAINER.equals(object.getNodeName()) && !NODE_FRAME_CONTAINER.equals(object.getNodeName()) && !NODE_DOCKABLE_FRAME.equals(object.getNodeName()) && !NODE_WORKSPACE.equals(object.getNodeName()) || (component = DockingPersistenceUtils.readComponent(document, dockingManager, (Node)object, hiddenFrames, load)) == null) continue;
            floatingContainer.getContentPane().add(component);
        }
        if (floatingContainer.getContentPane().getComponentCount() == 0 || object3 == null || ((Rectangle)object3).isEmpty()) {
            floatingContainer.dispose();
            return null;
        }
        final int[] nArray = new int[]{0};
        JideSwingUtilities.setRecursively(floatingContainer.getContentPane(), new JideSwingUtilities.Handler(){

            @Override
            public boolean condition(Component component) {
                return component instanceof DockableFrame;
            }

            @Override
            public void action(Component component) {
                nArray[0] = nArray[0] + 1;
            }

            @Override
            public void postAction(Component component) {
            }
        });
        if (nArray[0] <= 0) {
            floatingContainer.dispose();
            return null;
        }
        object = PortingUtils.overlapWithScreenBounds((Component)((Object)floatingContainer), (Rectangle)object3);
        if (dockingManager instanceof DefaultDockingManager) {
            ((DefaultDockingManager)dockingManager).adjustBoundsForSnap(new Rectangle(), (Rectangle)object);
        }
        floatingContainer.setBounds((Rectangle)object);
        if (dockingManager != null) {
            floatingContainer.updateUndecorated();
        }
        if (load != null && node instanceof Element) {
            load.load(document, (Element)node, floatingContainer);
        }
        return floatingContainer;
    }

    private static Workspace readWorkspace(Document document, DockingManager dockingManager, Node node, HiddenFrames hiddenFrames, PersistenceUtilsCallback.Load load) {
        Workspace workspace = dockingManager != null ? dockingManager.getWorkspace() : new Workspace();
        String string = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            if (!ATTRIBUTE_ACCEPT_DOCKABLE_FRAME.equals(node2.getNodeName())) continue;
            string = node2.getNodeValue();
        }
        if (string != null) {
            workspace.setAcceptDockableFrame("1".equals(string));
        }
        if (workspace.isAcceptDockableFrame()) {
            workspace.removeAll();
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Component component;
                Node node3 = nodeList.item(i);
                if (!NODE_CONTAINER_CONTAINER.equals(node3.getNodeName()) && !NODE_FRAME_CONTAINER.equals(node3.getNodeName()) && !NODE_DOCKABLE_FRAME.equals(node3.getNodeName()) && !NODE_WORKSPACE.equals(node3.getNodeName()) || (component = DockingPersistenceUtils.readComponent(document, dockingManager, node3, hiddenFrames, load)) == null) continue;
                workspace.add(component);
            }
        }
        if (load != null && node instanceof Element) {
            load.load(document, (Element)node, workspace);
        }
        return workspace;
    }

    private static AutoHideContainer readAutohideContainer(Document document, DefaultDockingManager defaultDockingManager, Node node, HiddenFrames hiddenFrames, PersistenceUtilsCallback.Load load) {
        Object object;
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = null;
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            object = namedNodeMap.item(i);
            if (!ATTRIBUTE_SIDE.equals(object.getNodeName())) continue;
            string = object.getNodeValue();
        }
        if (string == null) {
            return null;
        }
        AutoHideContainer autoHideContainer = defaultDockingManager != null ? defaultDockingManager.createAutoHideContainer(Integer.valueOf(string)) : new AutoHideContainer(Integer.valueOf(string));
        object = node.getChildNodes();
        for (int i = 0; i < object.getLength(); ++i) {
            SidePaneGroup sidePaneGroup;
            Node node2 = object.item(i);
            if (!NODE_SIDE_PANE_GROUP.equals(node2.getNodeName()) || (sidePaneGroup = DockingPersistenceUtils.readSideGroup(document, defaultDockingManager, node2, DockingUtils.convertToDockSide(autoHideContainer.getAttachedSide()), hiddenFrames, load)) == null) continue;
            autoHideContainer.addGroup(sidePaneGroup);
        }
        if (load != null && node instanceof Element) {
            load.load(document, (Element)node, autoHideContainer);
        }
        return autoHideContainer;
    }

    private static SidePaneGroup readSideGroup(Document document, DefaultDockingManager defaultDockingManager, Node node, int n, HiddenFrames hiddenFrames, PersistenceUtilsCallback.Load load) {
        int n2;
        SidePaneGroup sidePaneGroup = new SidePaneGroup();
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = null;
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            if (!ATTRIBUTE_SELECTED_INDEX.equals(node2.getNodeName())) continue;
            string = node2.getNodeValue();
        }
        NodeList nodeList = node.getChildNodes();
        for (n2 = 0; n2 < nodeList.getLength(); ++n2) {
            SidePaneItem sidePaneItem;
            Node node3 = nodeList.item(n2);
            if (!NODE_SIDE_PANE_ITEM.equals(node3.getNodeName()) || (sidePaneItem = DockingPersistenceUtils.readSideItem(document, defaultDockingManager, node3, n, hiddenFrames, load)) == null) continue;
            sidePaneGroup.add(sidePaneItem);
        }
        n2 = -1;
        if (string != null) {
            n2 = Integer.valueOf(string);
        }
        if (n2 >= 0 && n2 < sidePaneGroup.size()) {
            sidePaneGroup.setSelectedIndex(n2);
        }
        if (sidePaneGroup.size() > 0) {
            if (load != null && node instanceof Element) {
                load.load(document, (Element)node, sidePaneGroup);
            }
            return sidePaneGroup;
        }
        return null;
    }

    private static SidePaneItem readSideItem(Document document, DefaultDockingManager defaultDockingManager, Node node, int n, HiddenFrames hiddenFrames, PersistenceUtilsCallback.Load load) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            DockableFrame dockableFrame;
            Node node2 = nodeList.item(i);
            if (!NODE_DOCKABLE_FRAME.equals(node2.getNodeName()) || (dockableFrame = DockingPersistenceUtils.readDockableFrame(document, defaultDockingManager, node2, hiddenFrames, load)) == null || dockableFrame.getContext() == null || !dockableFrame.isAvailable() || dockableFrame.shouldVetoShowing()) continue;
            SidePaneItem sidePaneItem = new SidePaneItem(dockableFrame.getSideTitle(), dockableFrame.getFrameIcon(), dockableFrame, defaultDockingManager != null ? defaultDockingManager.getInternalEventManager().createAutoHideMouseInputListener(dockableFrame, n) : null);
            sidePaneItem.setSelected(false);
            if (load != null && node instanceof Element) {
                load.load(document, (Element)node, sidePaneItem);
            }
            return sidePaneItem;
        }
        return null;
    }

    private static String readHiddenFrame(Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            if (!ATTRIBUTE_KEY.equals(node2.getNodeName())) continue;
            return node2.getNodeValue();
        }
        return null;
    }

    public static boolean compare(Document document, Document document2) {
        return DockingPersistenceUtils.compare(document, null, document2, null);
    }

    public static boolean compare(Document document, String string, Document document2, String string2) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        Object object9;
        Node node = document.getElementsByTagName("LayoutPersistence").item(0);
        Object object10 = null;
        if (node != null) {
            object9 = node.getChildNodes();
            for (int i = 0; i < object9.getLength(); ++i) {
                object8 = object9.item(i);
                if (!"DockingManager".equals(object8.getNodeName())) continue;
                String string3 = null;
                object7 = object8.getAttributes();
                for (int j = 0; j < object7.getLength(); ++j) {
                    object6 = object7.item(j);
                    if (!"persistenceName".equals(object6.getNodeName())) continue;
                    string3 = object6.getNodeValue();
                    break;
                }
                if (object10 == null) {
                    object10 = object8;
                }
                if (!JideSwingUtilities.equals(string3, string)) continue;
                object10 = object8;
                break;
            }
        }
        object9 = document2.getElementsByTagName("LayoutPersistence").item(0);
        Object object11 = null;
        if (object9 != null) {
            object8 = object9.getChildNodes();
            for (int i = 0; i < object8.getLength(); ++i) {
                object7 = object8.item(i);
                if (!"DockingManager".equals(object7.getNodeName())) continue;
                String string4 = null;
                object6 = object7.getAttributes();
                for (int j = 0; j < object6.getLength(); ++j) {
                    object5 = object6.item(j);
                    if (!"persistenceName".equals(object5.getNodeName())) continue;
                    string4 = object5.getNodeValue();
                    break;
                }
                if (object11 == null) {
                    object11 = object7;
                }
                if (!JideSwingUtilities.equals(string4, string2)) continue;
                object11 = object7;
                break;
            }
        }
        if (object10 == null || object11 == null) {
            return false;
        }
        object8 = null;
        String string5 = null;
        object7 = null;
        NamedNodeMap namedNodeMap = object10.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            if (ATTRIBUTE_ACTIVE_FRAME.equals(node2.getNodeName())) {
                object8 = node2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_FRAME_STATE.equals(node2.getNodeName())) {
                string5 = node2.getNodeValue();
                continue;
            }
            if (!ATTRIBUTE_MAXIMIZED_FRAME.equals(node2.getNodeName())) continue;
            object7 = node2.getNodeValue();
        }
        String string6 = null;
        String string7 = null;
        object5 = null;
        NamedNodeMap namedNodeMap2 = object11.getAttributes();
        for (int i = 0; i < namedNodeMap2.getLength(); ++i) {
            object4 = namedNodeMap2.item(i);
            if (ATTRIBUTE_ACTIVE_FRAME.equals(object4.getNodeName())) {
                string6 = object4.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_FRAME_STATE.equals(object4.getNodeName())) {
                string7 = object4.getNodeValue();
                continue;
            }
            if (!ATTRIBUTE_MAXIMIZED_FRAME.equals(object4.getNodeName())) continue;
            object5 = object4.getNodeValue();
        }
        if (!(JideSwingUtilities.equals(object8, string6) && JideSwingUtilities.equals(string5, string7) && JideSwingUtilities.equals(object7, object5))) {
            return false;
        }
        HashMap<String, DockContext> hashMap = new HashMap<String, DockContext>();
        object4 = null;
        Component component = null;
        FloatingFrames floatingFrames = new FloatingFrames();
        Object object12 = null;
        Object object13 = null;
        Object object14 = null;
        Object object15 = null;
        HiddenFrames hiddenFrames = new HiddenFrames();
        HiddenFrames hiddenFrames2 = new HiddenFrames();
        NodeList nodeList = object10.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            object3 = nodeList.item(i);
            if (NODE_CONTEXT.equals(object3.getNodeName())) {
                DockingPersistenceUtils.readContext(document, null, (Node)object3, hashMap, null);
                continue;
            }
            if (NODE_BOUNDS.equals(object3.getNodeName())) {
                object4 = DockingPersistenceUtils.readBounds((Node)object3);
                continue;
            }
            if (NODE_CONTAINER_CONTAINER.equals(object3.getNodeName()) || NODE_FRAME_CONTAINER.equals(object3.getNodeName()) || NODE_WORKSPACE.equals(object3.getNodeName()) || NODE_DOCKABLE_FRAME.equals(object3.getNodeName())) {
                component = DockingPersistenceUtils.readComponent(document, null, (Node)object3, hiddenFrames2, null);
                continue;
            }
            if (NODE_FLOATING_CONTAINER.equals(object3.getNodeName())) {
                object2 = DockingPersistenceUtils.readFloatingContainer(document, null, (Node)object3, hiddenFrames2, null);
                if (object2 == null) continue;
                floatingFrames.add(object2);
                continue;
            }
            if (NODE_AUTO_HIDE_CONTAINER.equals(object3.getNodeName())) {
                object2 = DockingPersistenceUtils.readAutohideContainer(document, null, (Node)object3, hiddenFrames2, null);
                switch (((SidePane)object2).getAttachedSide()) {
                    case 3: {
                        object12 = object2;
                        break;
                    }
                    case 7: {
                        object13 = object2;
                        break;
                    }
                    case 5: {
                        object14 = object2;
                        break;
                    }
                    case 1: {
                        object15 = object2;
                    }
                }
                continue;
            }
            if (!NODE_HIDDEN_FRAME.equals(object3.getNodeName()) || (object2 = DockingPersistenceUtils.readHiddenFrame((Node)object3)) == null) continue;
            hiddenFrames.add((String)object2);
        }
        HashMap<String, DockContext> hashMap2 = new HashMap<String, DockContext>();
        object3 = null;
        object2 = null;
        FloatingFrames floatingFrames2 = new FloatingFrames();
        Iterator iterator = null;
        Iterator iterator2 = null;
        Iterator iterator3 = null;
        Iterator iterator4 = null;
        HiddenFrames hiddenFrames3 = new HiddenFrames();
        HiddenFrames hiddenFrames4 = new HiddenFrames();
        NodeList nodeList2 = object11.getChildNodes();
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            Object object16;
            object = nodeList2.item(i);
            if (NODE_CONTEXT.equals(object.getNodeName())) {
                DockingPersistenceUtils.readContext(document2, null, (Node)object, hashMap2, null);
                continue;
            }
            if (NODE_BOUNDS.equals(object.getNodeName())) {
                object3 = DockingPersistenceUtils.readBounds((Node)object);
                continue;
            }
            if (NODE_CONTAINER_CONTAINER.equals(object.getNodeName()) || NODE_FRAME_CONTAINER.equals(object.getNodeName()) || NODE_WORKSPACE.equals(object.getNodeName()) || NODE_DOCKABLE_FRAME.equals(object.getNodeName())) {
                object2 = DockingPersistenceUtils.readComponent(document2, null, (Node)object, hiddenFrames4, null);
                continue;
            }
            if (NODE_FLOATING_CONTAINER.equals(object.getNodeName())) {
                object16 = DockingPersistenceUtils.readFloatingContainer(document2, null, (Node)object, hiddenFrames4, null);
                if (object16 == null) continue;
                floatingFrames2.add(object16);
                continue;
            }
            if (NODE_AUTO_HIDE_CONTAINER.equals(object.getNodeName())) {
                object16 = DockingPersistenceUtils.readAutohideContainer(document2, null, (Node)object, hiddenFrames4, null);
                switch (((SidePane)object16).getAttachedSide()) {
                    case 3: {
                        iterator = object16;
                        break;
                    }
                    case 7: {
                        iterator2 = object16;
                        break;
                    }
                    case 5: {
                        iterator3 = object16;
                        break;
                    }
                    case 1: {
                        iterator4 = object16;
                    }
                }
                continue;
            }
            if (!NODE_HIDDEN_FRAME.equals(object.getNodeName()) || (object16 = DockingPersistenceUtils.readHiddenFrame((Node)object)) == null) continue;
            hiddenFrames3.add((String)object16);
        }
        if (!JideSwingUtilities.equals(object4, object3) || hashMap.size() != hashMap2.size() || hiddenFrames.size() != hiddenFrames3.size() || hiddenFrames2.size() != hiddenFrames4.size() || floatingFrames.size() != floatingFrames2.size()) {
            return false;
        }
        HashMap<Integer, String> hashMap3 = new HashMap<Integer, String>();
        object = new HashMap();
        for (Object object17 : hashMap.keySet()) {
            DockContext dockContext = (DockContext)hashMap.get(object17);
            DockContext dockContext2 = (DockContext)hashMap2.get(object17);
            if (dockContext == null || dockContext2 == null) {
                if (dockContext == dockContext2) continue;
                return false;
            }
            if (!JideSwingUtilities.equals(dockContext.getUndockedBounds(), dockContext2.getUndockedBounds()) || !JideSwingUtilities.equals(dockContext.getInitUndockedBounds(), dockContext2.getInitUndockedBounds()) || dockContext.getInitSide() != dockContext2.getInitSide() || dockContext.getInitIndex() != dockContext2.getInitIndex() || dockContext.isInitPosition() != dockContext2.isInitPosition() || dockContext.getInitMode() != dockContext2.getInitMode() || dockContext.getCanMode() != dockContext2.getCanMode() || dockContext.getCurrentMode() != dockContext2.getCurrentMode() || dockContext.getCurrentDockSide() != dockContext2.getCurrentDockSide() || dockContext.isAvailable() != dockContext2.isAvailable() || dockContext.getDockedWidth() != dockContext2.getDockedWidth() || dockContext.getDockedHeight() != dockContext2.getDockedHeight() || dockContext.getAutohideWidth() != dockContext2.getAutohideWidth() || dockContext.getAutohideHeight() != dockContext2.getAutohideHeight() || dockContext.getInitAutohideWidth() != dockContext2.getInitAutohideWidth() || dockContext.getInitAutohideHeight() != dockContext2.getInitAutohideHeight()) {
                return false;
            }
            hashMap3.put(dockContext.getDockID(), (String)object17);
            object.put(dockContext2.getDockID(), object17);
        }
        if (!DockingPersistenceUtils.compareComponent(component, (Component)object2, hashMap3, (Map<Integer, String>)object)) {
            return false;
        }
        for (Object object17 : floatingFrames) {
            boolean bl = false;
            for (int i = 0; i < floatingFrames2.size(); ++i) {
                if (!DockingPersistenceUtils.compareComponent((Component)object17, (Component)floatingFrames2.get(i), hashMap3, (Map<Integer, String>)object)) continue;
                bl = true;
                floatingFrames2.remove(i);
                break;
            }
            if (bl) continue;
            return false;
        }
        if (!(object12 == null && iterator == null || DockingPersistenceUtils.compareComponent((Component)object12, (Component)((Object)iterator), hashMap3, (Map<Integer, String>)object))) {
            return false;
        }
        if (!(object13 == null && iterator2 == null || DockingPersistenceUtils.compareComponent((Component)object13, (Component)((Object)iterator2), hashMap3, (Map<Integer, String>)object))) {
            return false;
        }
        if (!(object14 == null && iterator3 == null || DockingPersistenceUtils.compareComponent((Component)object14, (Component)((Object)iterator3), hashMap3, (Map<Integer, String>)object))) {
            return false;
        }
        if (!(object15 == null && iterator4 == null || DockingPersistenceUtils.compareComponent((Component)object15, iterator4, hashMap3, (Map<Integer, String>)object))) {
            return false;
        }
        for (Object object17 : hiddenFrames) {
            if (hiddenFrames3.contains(object17)) continue;
            return false;
        }
        for (Object object17 : hiddenFrames2) {
            if (hiddenFrames4.contains(object17)) continue;
            return false;
        }
        for (Object object17 : hashMap.keySet()) {
            DockContext dockContext = (DockContext)hashMap.get(object17);
            DockContext dockContext3 = (DockContext)hashMap2.get(object17);
            if (!DockingPersistenceUtils.comparePreviousState(dockContext.getHiddenPreviousState(), dockContext3.getHiddenPreviousState(), hashMap3, (Map<Integer, String>)object)) {
                return false;
            }
            if (!DockingPersistenceUtils.comparePreviousState(dockContext.getDockPreviousState(), dockContext3.getDockPreviousState(), hashMap3, (Map<Integer, String>)object)) {
                return false;
            }
            if (!DockingPersistenceUtils.comparePreviousState(dockContext.getClosePreviousState(), dockContext3.getClosePreviousState(), hashMap3, (Map<Integer, String>)object)) {
                return false;
            }
            if (!DockingPersistenceUtils.comparePreviousState(dockContext.getFloatPreviousState(), dockContext3.getFloatPreviousState(), hashMap3, (Map<Integer, String>)object)) {
                return false;
            }
            if (!DockingPersistenceUtils.comparePreviousState(dockContext.getAutohidePreviousState(), dockContext3.getAutohidePreviousState(), hashMap3, (Map<Integer, String>)object)) {
                return false;
            }
            if (DockingPersistenceUtils.comparePreviousState(dockContext.getAvailablePreviousState(), dockContext3.getAvailablePreviousState(), hashMap3, (Map<Integer, String>)object)) continue;
            return false;
        }
        return true;
    }

    private static boolean compareParentState(PreviousState.ParentState parentState, PreviousState.ParentState parentState2, Map<Integer, String> map, Map<Integer, String> map2) {
        if (parentState == null && parentState2 == null) {
            return true;
        }
        if (parentState == null || parentState2 == null) {
            return false;
        }
        if (parentState.orientation != parentState2.orientation || !JideSwingUtilities.equals(map.get(parentState.ccID), map2.get(parentState2.ccID)) || !JideSwingUtilities.equals(map.get(parentState.myID), map2.get(parentState2.myID)) || parentState.ccChildren.size() != parentState2.ccChildren.size()) {
            return false;
        }
        for (int n : parentState.ccChildren) {
            String string = map.get(n);
            boolean bl = false;
            for (int n2 : parentState2.ccChildren) {
                if (!JideSwingUtilities.equals(string, map2.get(n2))) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private static boolean comparePreviousState(PreviousState previousState, PreviousState previousState2, Map<Integer, String> map, Map<Integer, String> map2) {
        if (previousState == null && previousState2 == null) {
            return true;
        }
        if (previousState == null || previousState2 == null) {
            return false;
        }
        if (!(previousState.mode == previousState2.mode && previousState.side == previousState2.side && previousState.index == previousState2.index && JideSwingUtilities.equals(map.get(previousState.dockID), map2.get(previousState2.dockID)) && JideSwingUtilities.equals(map.get(previousState.rootID), map2.get(previousState2.rootID)) && JideSwingUtilities.equals(map.get(previousState.fcID), map2.get(previousState2.fcID)) && JideSwingUtilities.equals(previousState.rcBounds, previousState2.rcBounds) && previousState.fcChildren.size() == previousState2.fcChildren.size() && previousState.parentStates.size() == previousState2.parentStates.size())) {
            return false;
        }
        Iterator<Serializable> iterator = previousState.fcChildren.iterator();
        while (iterator.hasNext()) {
            int n = iterator.next();
            String string = map.get(n);
            boolean bl = false;
            for (int n2 : previousState2.fcChildren) {
                if (!JideSwingUtilities.equals(string, map2.get(n2))) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        for (PreviousState.ParentState parentState : previousState.parentStates) {
            boolean bl = false;
            for (PreviousState.ParentState parentState2 : previousState2.parentStates) {
                if (!DockingPersistenceUtils.compareParentState(parentState, parentState2, map, map2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private static boolean compareComponent(Component component, Component component2, Map<Integer, String> map, Map<Integer, String> map2) {
        block12: {
            block15: {
                block14: {
                    block13: {
                        block11: {
                            if (component == null && component2 == null) {
                                return true;
                            }
                            if (component == null || component2 == null || component.getClass() != component2.getClass()) {
                                return false;
                            }
                            if (!(component instanceof ContainerContainer) || !(component2 instanceof ContainerContainer)) break block11;
                            if (((ContainerContainer)component).getOrientation() != ((ContainerContainer)component2).getOrientation() || ((ContainerContainer)component).isProportionalLayout() != ((ContainerContainer)component2).isProportionalLayout() || ((ContainerContainer)component).isInitiallyEven() != ((ContainerContainer)component2).isInitiallyEven() || !JideSwingUtilities.equals(((ContainerContainer)component).getProportions(), ((ContainerContainer)component).getProportions(), true) || !JideSwingUtilities.equals(component.getPreferredSize(), component2.getPreferredSize()) || ((ContainerContainer)component).getPaneCount() != ((ContainerContainer)component2).getPaneCount()) {
                                return false;
                            }
                            for (int i = 0; i < ((ContainerContainer)component).getPaneCount(); ++i) {
                                if (DockingPersistenceUtils.compareComponent(((ContainerContainer)component).getPaneAt(i), ((ContainerContainer)component2).getPaneAt(i), map, map2)) continue;
                                return false;
                            }
                            String string = NODE_CONTAINER_CONTAINER + ((ContainerContainer)component).getDockID();
                            map.put(((ContainerContainer)component).getDockID(), string);
                            map2.put(((ContainerContainer)component2).getDockID(), string);
                            break block12;
                        }
                        if (!(component instanceof FrameContainer) || !(component2 instanceof FrameContainer)) break block13;
                        if (((FrameContainer)component).getSelectedIndex() != ((FrameContainer)component2).getSelectedIndex() || !JideSwingUtilities.equals(component.getPreferredSize(), component2.getPreferredSize()) || ((FrameContainer)component).getTabCount() != ((FrameContainer)component2).getTabCount()) {
                            return false;
                        }
                        for (int i = 0; i < ((FrameContainer)component).getTabCount(); ++i) {
                            if (DockingPersistenceUtils.compareComponent(((FrameContainer)component).getComponentAt(i), ((FrameContainer)component2).getComponentAt(i), map, map2)) continue;
                            return false;
                        }
                        String string = NODE_FRAME_CONTAINER + ((FrameContainer)component).getDockID();
                        map.put(((FrameContainer)component).getDockID(), string);
                        map2.put(((FrameContainer)component2).getDockID(), string);
                        break block12;
                    }
                    if (!(component instanceof DockableFrame) || !(component2 instanceof DockableFrame)) break block14;
                    if (!JideSwingUtilities.equals(((DockableFrame)component).getKey(), ((DockableFrame)component2).getKey())) {
                        return false;
                    }
                    break block12;
                }
                if (!(component instanceof Workspace) || !(component2 instanceof Workspace)) break block15;
                if (((Workspace)component).isAcceptDockableFrame() != ((Workspace)component2).isAcceptDockableFrame() || ((Workspace)component).getComponentCount() != ((Workspace)component2).getComponentCount()) {
                    return false;
                }
                for (int i = 0; i < ((Workspace)component).getComponentCount(); ++i) {
                    if (DockingPersistenceUtils.compareComponent(((Workspace)component).getComponent(i), ((Workspace)component2).getComponent(i), map, map2)) continue;
                    return false;
                }
                break block12;
            }
            if (!(component instanceof FloatingContainer) || !(component2 instanceof FloatingContainer)) break block12;
            if (!JideSwingUtilities.equals(component.getBounds(), component2.getBounds()) || ((FloatingContainer)((Object)component)).getContentPane().getComponentCount() != ((FloatingContainer)((Object)component2)).getContentPane().getComponentCount()) {
                return false;
            }
            for (int i = 0; i < ((FloatingContainer)((Object)component)).getContentPane().getComponentCount(); ++i) {
                if (DockingPersistenceUtils.compareComponent(((FloatingContainer)((Object)component)).getContentPane().getComponent(i), ((FloatingContainer)((Object)component2)).getContentPane().getComponent(i), map, map2)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean containsFrameKey(DockingManager dockingManager, byte[] byArray, String string) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            String string2;
            Node node;
            int n;
            NodeList nodeList;
            Document document = PersistenceUtils.getDocument(byteArrayInputStream);
            Node node2 = document.getElementsByTagName("LayoutPersistence").item(0);
            Node node3 = null;
            if (node2 != null) {
                nodeList = node2.getChildNodes();
                for (n = 0; n < nodeList.getLength(); ++n) {
                    node = nodeList.item(n);
                    if (!"DockingManager".equals(node.getNodeName())) continue;
                    string2 = null;
                    NamedNodeMap namedNodeMap = node.getAttributes();
                    for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                        Node node4 = namedNodeMap.item(i);
                        if (!"persistenceName".equals(node4.getNodeName())) continue;
                        string2 = node4.getNodeValue();
                        break;
                    }
                    if (!JideSwingUtilities.equals(string2, dockingManager.getLayoutPersistenceName())) continue;
                    node3 = node;
                    break;
                }
            }
            if (node3 == null) {
                boolean bl = false;
                return bl;
            }
            nodeList = node3.getChildNodes();
            n = 0;
            while (n < nodeList.getLength()) {
                node = nodeList.item(n);
                if (NODE_CONTEXT.equals(node.getNodeName()) && JideSwingUtilities.equals(string2 = DockingPersistenceUtils.readContext(document, dockingManager, node, null, null), string)) {
                    boolean bl = true;
                    return bl;
                }
                ++n;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
        finally {
            try {
                byteArrayInputStream.close();
            }
            catch (IOException iOException) {}
        }
    }
}

