/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.DockingManager;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class DockingManagerUndoableEdit
implements UndoableEdit {
    private String _name;
    private byte[] _undoLayout;
    private byte[] _redoLayout;
    private DockingManager _dockingManager;

    public DockingManagerUndoableEdit(String string, DockingManager dockingManager) {
        this._name = string;
        this._dockingManager = dockingManager;
        this._dockingManager.setPreserveAvailableProperty(true);
        this._undoLayout = this._dockingManager.getLayoutRawData();
        this._dockingManager.setPreserveAvailableProperty(false);
    }

    @Override
    public void undo() throws CannotUndoException {
        this._dockingManager.setPreserveAvailableProperty(true);
        this._redoLayout = this._dockingManager.getLayoutRawData();
        this._dockingManager.setPreserveAvailableProperty(false);
        this._dockingManager.setLayoutRawData(this._undoLayout);
    }

    @Override
    public boolean canUndo() {
        return this._undoLayout != null;
    }

    @Override
    public void redo() throws CannotRedoException {
        this._dockingManager.setLayoutRawData(this._redoLayout);
    }

    @Override
    public boolean canRedo() {
        return this._redoLayout != null;
    }

    @Override
    public void die() {
        this._undoLayout = null;
        this._redoLayout = null;
        this._dockingManager = null;
    }

    @Override
    public boolean addEdit(UndoableEdit undoableEdit) {
        return false;
    }

    @Override
    public boolean replaceEdit(UndoableEdit undoableEdit) {
        return false;
    }

    @Override
    public boolean isSignificant() {
        return true;
    }

    @Override
    public String getPresentationName() {
        return this._name;
    }

    @Override
    public String getUndoPresentationName() {
        return "Undo " + this._name;
    }

    @Override
    public String getRedoPresentationName() {
        return "Redo " + this._name;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    public byte[] getUndoLayout() {
        return this._undoLayout;
    }

    public void setUndoLayout(byte[] byArray) {
        this._undoLayout = byArray;
    }

    public byte[] getRedoLayout() {
        return this._redoLayout;
    }

    public void setRedoLayout(byte[] byArray) {
        this._redoLayout = byArray;
    }
}

