/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.DefaultDockingManager;
import com.jidesoft.docking.DockableHolder;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.swing.ContentContainer;
import java.awt.LayoutManager;
import javax.swing.RootPaneContainer;

public class DockableHolderPanel
extends ContentContainer
implements DockableHolder {
    private DockingManager _dockingManager;
    private boolean _outsideCallChecking = false;

    public DockableHolderPanel() {
        this((RootPaneContainer)null);
    }

    public DockableHolderPanel(RootPaneContainer rootPaneContainer) {
        try {
            this.setOutsideCallChecking(true);
            this._dockingManager = this.createDockingManager(rootPaneContainer);
        }
        finally {
            this.setOutsideCallChecking(false);
        }
    }

    private boolean isOutsideCallChecking() {
        return this._outsideCallChecking;
    }

    private void setOutsideCallChecking(boolean bl) {
        this._outsideCallChecking = bl;
    }

    protected DockingManager createDockingManager(RootPaneContainer rootPaneContainer) {
        return new DefaultDockingManager(rootPaneContainer, this);
    }

    @Override
    public DockingManager getDockingManager() {
        return this._dockingManager;
    }

    public void dispose() {
        if (this._dockingManager != null) {
            this._dockingManager.dispose();
            this._dockingManager = null;
        }
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
        if (this.isOutsideCallChecking()) {
            super.setLayout(layoutManager);
        }
    }
}

