/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.DockingManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class DockID {
    private final Set<Integer> _IDs = new HashSet<Integer>();
    private static Map<DockingManager, DockID> _instances;
    private static final int SCOPE = 65535;
    public static final int MAINCONTAINER_ID = 2;
    public static final int WORKSPACE_ID = 3;

    public static synchronized DockID getInstance(DockingManager dockingManager) {
        DockID dockID;
        if (dockingManager == null) {
            throw new IllegalArgumentException("The docking manager cannot be null.");
        }
        if (_instances == null) {
            _instances = new HashMap<DockingManager, DockID>();
        }
        if ((dockID = _instances.get(dockingManager)) != null) {
            return dockID;
        }
        DockID dockID2 = new DockID();
        _instances.put(dockingManager, dockID2);
        return dockID2;
    }

    public static synchronized void removeInstance(DockingManager dockingManager) {
        if (_instances != null) {
            _instances.remove(dockingManager);
        }
    }

    private DockID() {
    }

    private int getRandomNumber() {
        double d;
        int n;
        while (this.isNumberUsed(n = (int)((d = Math.random()) * 65535.0))) {
        }
        return n;
    }

    private boolean isNumberUsed(int n) {
        return n == 0 || n == 1 || n == 2 || n == 3 || this._IDs.contains(n);
    }

    public int getID() {
        return this.getRandomNumber();
    }

    public int getID(int n) {
        this.releaseID(n);
        return this.getRandomNumber();
    }

    public void releaseID(int n) {
        this._IDs.remove(n);
    }

    public void releaseAll() {
        this._IDs.clear();
    }

    public void reserveID(int n) {
        if (!this._IDs.contains(n)) {
            this._IDs.add(n);
        }
    }
}

