/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.ContainerContainer;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.swing.JideSplitPane;
import com.jidesoft.swing.JideSplitPaneDivider;
import com.jidesoft.utils.SystemInfo;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseEvent;

public class ContainerContainerDivider
extends JideSplitPaneDivider {
    public ContainerContainerDivider(JideSplitPane jideSplitPane) {
        super(jideSplitPane);
        if (!this.isResizable()) {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    protected JideSplitPaneDivider.MouseHandler createMouseHandler() {
        return new ContainerContainerMouseHandler();
    }

    private boolean isResizable() {
        if (this._jideSplitPane != null && ((ContainerContainer)this._jideSplitPane).getDockingManager() != null) {
            return this.getDockingManager().isResizable();
        }
        return true;
    }

    private DockingManager getDockingManager() {
        return ((ContainerContainer)this._jideSplitPane).getDockingManager();
    }

    private DockableFrame getAutohideShowingFrame() {
        int n = this._jideSplitPane.indexOfDivider(this);
        Component component = this._jideSplitPane.getPaneAt(n);
        if (component instanceof DockableFrame && ((DockableFrame)component).isAutohideShowing()) {
            return (DockableFrame)component;
        }
        component = this._jideSplitPane.getPaneAt(n + 1);
        if (component instanceof DockableFrame && ((DockableFrame)component).isAutohideShowing()) {
            return (DockableFrame)component;
        }
        return null;
    }

    class ContainerContainerMouseHandler
    extends JideSplitPaneDivider.MouseHandler {
        ContainerContainerMouseHandler() {
            super(ContainerContainerDivider.this);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (ContainerContainerDivider.this.isResizable()) {
                super.mousePressed(mouseEvent);
                DockableFrame dockableFrame = ContainerContainerDivider.this.getAutohideShowingFrame();
                if (dockableFrame != null) {
                    ContainerContainerDivider.this.getDockingManager().beginResizingFrame(dockableFrame, 0);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (ContainerContainerDivider.this.isResizable()) {
                super.mouseReleased(mouseEvent);
                if (ContainerContainerDivider.this._jideSplitPane == null) {
                    return;
                }
                DockableFrame dockableFrame = ContainerContainerDivider.this.getAutohideShowingFrame();
                if (dockableFrame != null) {
                    ContainerContainerDivider.this.getDockingManager().endResizingFrame(dockableFrame);
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (ContainerContainerDivider.this.isResizable()) {
                super.mouseDragged(mouseEvent);
                DockableFrame dockableFrame = ContainerContainerDivider.this.getAutohideShowingFrame();
                if (dockableFrame != null) {
                    ContainerContainerDivider.this.getDockingManager().endResizingFrame(dockableFrame);
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (ContainerContainerDivider.this.isResizable() && SystemInfo.isJdk6Above()) {
                super.mouseMoved(mouseEvent);
            }
        }
    }
}

