/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.diff;

public class Difference {
    public static final int NONE = -1;
    protected int _deletedStart = -1;
    protected int _deletedEnd = -1;
    protected int _addedStart = -1;
    protected int _addedEnd = -1;
    protected boolean _conflicting = false;

    public Difference(int n, int n2, int n3, int n4) {
        this._deletedStart = n;
        this._deletedEnd = n2;
        this._addedStart = n3;
        this._addedEnd = n4;
    }

    protected Difference(int n, int n2, int n3, int n4, boolean bl) {
        this(n, n2, n3, n4);
        this._conflicting = bl;
    }

    public int getDeletedStart() {
        return this._deletedStart;
    }

    public int getDeletedEnd() {
        return this._deletedEnd;
    }

    public int getAddedStart() {
        return this._addedStart;
    }

    public int getAddedEnd() {
        return this._addedEnd;
    }

    public void setDeleted(int n) {
        this._deletedStart = Math.min(n, this._deletedStart);
        this._deletedEnd = Math.max(n, this._deletedEnd);
    }

    public void adjustDeleted(int n) {
        this._deletedStart += n;
        this._deletedEnd = this._deletedEnd != -1 ? this._deletedEnd + n : -1;
    }

    public void adjustAdded(int n) {
        this._addedStart += n;
        this._addedEnd = this._addedEnd != -1 ? this._addedEnd + n : -1;
    }

    public void setAdded(int n) {
        this._addedStart = Math.min(n, this._addedStart);
        this._addedEnd = Math.max(n, this._addedEnd);
    }

    boolean isConflicting() {
        return this._conflicting;
    }

    public boolean equals(Object object) {
        if (object instanceof Difference) {
            Difference difference = (Difference)object;
            return this._deletedStart == difference._deletedStart && this._deletedEnd == difference._deletedEnd && this._addedStart == difference._addedStart && this._addedEnd == difference._addedEnd;
        }
        return false;
    }

    public boolean equal(int n) {
        return this.getDeletedStart() == n && this.getDeletedEnd() == n;
    }

    public boolean contains(int n) {
        return this.getDeletedStart() >= n && this.getDeletedEnd() != -1 && this.getDeletedEnd() >= n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("del: [").append(this._deletedStart).append(", ").append(this._deletedEnd).append("]");
        stringBuffer.append(" ");
        stringBuffer.append("add: [").append(this._addedStart).append(", ").append(this._addedEnd).append("]");
        return stringBuffer.toString();
    }
}

