/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.diff;

import com.jidesoft.diff.Difference;
import com.jidesoft.margin.RowMarginSupport;
import com.jidesoft.margin.RowNumberMargin;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Map;
import java.util.Set;

class DiffRowNumberMargin
extends RowNumberMargin {
    private Map<Integer, Difference> _changeStart;
    private Set<Integer> _changeEnd;
    private int _delta = 0;

    public DiffRowNumberMargin(RowMarginSupport rowMarginSupport) {
        super(rowMarginSupport);
    }

    public void setDifferences(Map<Integer, Difference> map, Set<Integer> set) {
        this._changeStart = map;
        this._changeEnd = set;
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    void setDelta(int n) {
        this._delta = n;
    }

    int getDelta() {
        return this._delta;
    }

    @Override
    public void paintRowMargin(Graphics graphics, Rectangle rectangle, int n) {
        super.paintRowMargin(graphics, rectangle, n);
        int n2 = ((RowMarginSupport)this.getMarginSupport()).actualRowToVisualRow(n);
        if (this._changeStart == null || this._changeEnd == null) {
            return;
        }
        rectangle = new Rectangle(rectangle);
        rectangle.y += this.getDelta();
        if (this._changeStart.get(n2) != null && rectangle.y >= 0) {
            graphics.setColor(Color.GRAY);
            graphics.drawLine(0, rectangle.y, this.getWidth(), rectangle.y);
        } else if (this._changeEnd.contains(n2) && rectangle.y >= 0) {
            graphics.setColor(Color.GRAY);
            graphics.drawLine(0, rectangle.y, this.getWidth(), rectangle.y);
        }
        if (n + 1 >= ((RowMarginSupport)this._marginSupport).getRowCount() && (this._changeStart.get(n2 + 1) != null || this._changeEnd.contains(n2 + 1))) {
            graphics.setColor(Color.GRAY);
            graphics.drawLine(0, rectangle.y + rectangle.height, this.getWidth(), rectangle.y + rectangle.height);
        }
    }
}

