/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.diff;

import com.jidesoft.diff.DiffResource;
import com.jidesoft.diff.Difference;
import com.jidesoft.icons.IconsFactory;
import com.jidesoft.margin.AbstractRowMargin;
import com.jidesoft.margin.RowMarginSupport;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;

class DiffMargin
extends AbstractRowMargin {
    private Map<Integer, Difference> _changeStart;
    private Set<Integer> _changeEnd;
    private boolean _original;
    private boolean _editable = true;
    private Icon _arrowIcon;
    private Icon _deleteIcon;
    private Handler _handler;
    private boolean _opposite;
    private boolean _merge;
    private int _delta = 0;

    public DiffMargin(RowMarginSupport rowMarginSupport, boolean bl) {
        super(rowMarginSupport);
        this._original = bl;
    }

    public Handler getHandler() {
        return this._handler;
    }

    public void setHandler(Handler handler) {
        this._handler = handler;
    }

    public boolean isEditable() {
        return this._editable;
    }

    public void setEditable(boolean bl) {
        this._editable = bl;
        this.invalidate();
    }

    public void setDifferences(Map<Integer, Difference> map, Set<Integer> set) {
        this._changeStart = map;
        this._changeEnd = set;
        this.repaint();
    }

    void setDelta(int n) {
        this._delta = n;
    }

    int getDelta() {
        return this._delta;
    }

    @Override
    public void paintRowMargin(Graphics graphics, Rectangle rectangle, int n) {
        if (this._changeStart == null || this._changeEnd == null) {
            return;
        }
        rectangle = new Rectangle(rectangle);
        rectangle.y += this.getDelta();
        int n2 = ((RowMarginSupport)this.getMarginSupport()).actualRowToVisualRow(n);
        Difference difference = this._changeStart.get(n2);
        if (difference != null) {
            if (rectangle.y >= 0) {
                graphics.setColor(Color.GRAY);
                graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y);
            }
            if (this.isEditable()) {
                this.paintIcons(graphics, difference, rectangle);
            }
        } else if (this._changeEnd.contains(n2) && rectangle.y >= 0) {
            graphics.setColor(Color.GRAY);
            graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y);
        }
        if (n + 1 >= ((RowMarginSupport)this._marginSupport).getRowCount() && (this._changeStart.get(n2 + 1) != null || this._changeEnd.contains(n2 + 1))) {
            graphics.setColor(Color.GRAY);
            graphics.drawLine(rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
            Difference difference2 = this._changeStart.get(n2 + 1);
            if (difference2 != null && this.isEditable()) {
                rectangle.y += rectangle.height;
                this.paintIcons(graphics, difference2, rectangle);
            }
        }
    }

    protected void paintIcons(Graphics graphics, Difference difference, Rectangle rectangle) {
        if (this._arrowIcon == null) {
            this._arrowIcon = IconsFactory.getImageIcon(DiffMargin.class, this._opposite ? "icons/right.png" : "icons/left.png");
        }
        if (this._deleteIcon == null) {
            this._deleteIcon = IconsFactory.getImageIcon(DiffMargin.class, "icons/delete.png");
        }
        if (this._merge) {
            if (this._opposite) {
                this._deleteIcon.paintIcon(this, graphics, rectangle.x + (rectangle.width / 2 - this._deleteIcon.getIconWidth()) / 2, rectangle.y + (rectangle.height - this._deleteIcon.getIconHeight()) / 2);
                this._arrowIcon.paintIcon(this, graphics, rectangle.x + rectangle.width / 2 + (rectangle.width / 2 - this._arrowIcon.getIconWidth()) / 2 - 1, rectangle.y + (rectangle.height - this._arrowIcon.getIconHeight()) / 2);
            } else {
                this._arrowIcon.paintIcon(this, graphics, rectangle.x + (rectangle.width / 2 - this._arrowIcon.getIconWidth()) / 2, rectangle.y + (rectangle.height - this._arrowIcon.getIconHeight()) / 2);
                this._deleteIcon.paintIcon(this, graphics, rectangle.x + rectangle.width / 2 + (rectangle.width / 2 - this._deleteIcon.getIconWidth()) / 2, rectangle.y + (rectangle.height - this._deleteIcon.getIconHeight()) / 2);
            }
        } else {
            boolean bl;
            boolean bl2 = this._original ? difference.getDeletedEnd() != -1 : (bl = difference.getAddedEnd() != -1 && difference.getDeletedEnd() == -1);
            if (bl) {
                if (this._original) {
                    this._arrowIcon.paintIcon(this, graphics, rectangle.x + (rectangle.width - this._arrowIcon.getIconWidth()) / 2, rectangle.y + (rectangle.height - this._arrowIcon.getIconHeight()) / 2);
                } else {
                    this._deleteIcon.paintIcon(this, graphics, rectangle.x + (rectangle.width - this._deleteIcon.getIconWidth()) / 2, rectangle.y + (rectangle.height - this._deleteIcon.getIconHeight()) / 2);
                }
            }
        }
    }

    protected String getResourceString(String string) {
        return DiffResource.getResourceBundle(Locale.getDefault()).getString(string);
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        if (this.isMerge()) {
            int n = ((RowMarginSupport)this._marginSupport).positionToRow(mouseEvent.getPoint().y);
            if (this._changeStart == null) {
                return null;
            }
            Difference difference = this._changeStart.get(n);
            if (this._opposite) {
                if (difference != null) {
                    return mouseEvent.getX() < this.getWidth() / 2 ? this.getResourceString("DiffMargin.ignore") : this.getResourceString("DiffMargin.replace");
                }
            } else if (difference != null) {
                return mouseEvent.getX() < this.getWidth() / 2 ? this.getResourceString("DiffMargin.replace") : this.getResourceString("DiffMargin.ignore");
            }
            return null;
        }
        return super.getToolTipText(mouseEvent);
    }

    @Override
    public String getToolTipText(int n) {
        if (this._changeStart == null) {
            return null;
        }
        Difference difference = this._changeStart.get(n);
        if (this._original) {
            if (difference != null) {
                return difference.getAddedEnd() == -1 ? this.getResourceString("DiffMargin.ignore") : this.getResourceString("DiffMargin.replace");
            }
        } else if (difference != null) {
            return this.getResourceString("DiffMargin.remove");
        }
        return null;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n = ((RowMarginSupport)this._marginSupport).positionToRow(mouseEvent.getPoint().y);
        if (this._changeStart != null) {
            Difference difference = this._changeStart.get(n);
            if (difference == null) {
                super.mousePressed(mouseEvent);
            }
        } else {
            super.mousePressed(mouseEvent);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Handler handler = this.getHandler();
        if (handler != null && this.isEditable()) {
            Difference difference;
            int n = ((RowMarginSupport)this._marginSupport).positionToRow(mouseEvent.getPoint().y);
            if (this._changeStart != null && (difference = this._changeStart.get(n)) != null) {
                handler.handle(difference, mouseEvent.getPoint().x);
            }
        }
    }

    public boolean isOpposite() {
        return this._opposite;
    }

    public void setOpposite(boolean bl) {
        this._opposite = bl;
    }

    public boolean isMerge() {
        return this._merge;
    }

    public void setMerge(boolean bl) {
        this._merge = bl;
    }

    @Override
    public int getPreferredWidth() {
        return !this.isEditable() ? 0 : (this._merge ? 24 : 12);
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(16384)) {
            Lm.showInvalidProductMessage(DiffMargin.class.getName(), 16384);
        }
    }

    public static interface Handler {
        public void handle(Difference var1, int var2);
    }
}

