/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.diff;

import com.jidesoft.diff.Difference;
import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.margin.LineNumberMargin;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Map;
import java.util.Set;

class DiffLineNumberMargin
extends LineNumberMargin {
    private Map<Integer, Difference> _changeStart;
    private Set<Integer> _changeEnd;

    public DiffLineNumberMargin(CodeEditor codeEditor) {
        super(codeEditor);
    }

    public void setDifferences(Map<Integer, Difference> map, Set<Integer> set) {
        this._changeStart = map;
        this._changeEnd = set;
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void paintLineMargin(Graphics graphics, Rectangle rectangle, int n) {
        super.paintLineMargin(graphics, rectangle, n);
        if (this._changeStart == null || this._changeEnd == null) {
            return;
        }
        if (this._changeStart.get(n) != null) {
            graphics.setColor(Color.GRAY);
            graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y);
        } else if (this._changeEnd.contains(n)) {
            graphics.setColor(Color.GRAY);
            graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y);
        }
        if (n + 1 >= this._editor.getLineCount() && (this._changeStart.get(n + 1) != null || this._changeEnd.contains(n + 1))) {
            graphics.setColor(Color.GRAY);
            graphics.drawLine(rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        }
    }
}

