/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.diff;

import com.jidesoft.diff.Difference;
import com.jidesoft.diff.DifferenceList;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;

public class Diff<T> {
    protected List<T> a;
    protected List<T> b;
    protected List<Difference> diffs = new DifferenceList();
    private Difference pending;
    private Comparator<T> comparator;
    private boolean _itemsConsistent = true;
    private TreeMap<Integer, Integer> thresh;

    public Diff(T[] TArray, T[] TArray2, Comparator<T> comparator) {
        this(Arrays.asList(TArray), Arrays.asList(TArray2), comparator);
    }

    public Diff(T[] TArray, T[] TArray2) {
        this(TArray, TArray2, null);
    }

    public Diff(List<T> list, List<T> list2, Comparator<T> comparator) {
        this.a = list;
        this.b = list2;
        this.comparator = comparator;
        this.thresh = null;
    }

    public Diff(List<T> list, List<T> list2) {
        this(list, list2, null);
    }

    public List<Difference> diff() {
        this.traverseSequences();
        if (this.pending != null) {
            this.diffs.add(this.pending);
        }
        return this.diffs;
    }

    private void traverseSequences() {
        int n;
        Integer[] integerArray = this.getLongestCommonSubsequences();
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        int n2 = this.a.size() - 1;
        int n3 = this.b.size() - 1;
        int n4 = 0;
        int n5 = integerArray.length - 1;
        int n6 = 0;
        for (n = 0; n <= n5; ++n) {
            Integer n7;
            if (++n6 >= 10000) {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                n6 = 0;
            }
            if ((n7 = integerArray[n]) == null) {
                this.onANotB(n, n4);
                continue;
            }
            while (n4 < n7) {
                this.onBNotA(n, n4++);
            }
            this.onMatch(n, n4++);
        }
        boolean bl = false;
        boolean bl2 = false;
        n6 = 0;
        while (n <= n2 || n4 <= n3) {
            if (++n6 >= 10000) {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                n6 = 0;
            }
            if (n == n2 + 1 && n4 <= n3) {
                if (!bl && this.callFinishedA()) {
                    this.finishedA(n2);
                    bl = true;
                } else {
                    while (n4 <= n3) {
                        this.onBNotA(n, n4++);
                    }
                }
            }
            if (n4 == n3 + 1 && n <= n2) {
                if (!bl2 && this.callFinishedB()) {
                    this.finishedB(n3);
                    bl2 = true;
                } else {
                    while (n <= n2) {
                        this.onANotB(n++, n4);
                    }
                }
            }
            if (n <= n2) {
                this.onANotB(n++, n4);
            }
            if (n4 > n3) continue;
            this.onBNotA(n, n4++);
        }
    }

    protected boolean callFinishedA() {
        return false;
    }

    protected boolean callFinishedB() {
        return false;
    }

    protected void finishedA(int n) {
    }

    protected void finishedB(int n) {
    }

    protected void onANotB(int n, int n2) {
        if (this.pending == null) {
            this.pending = new Difference(n, n, n2, -1);
        } else {
            this.pending.setDeleted(n);
        }
    }

    protected void onBNotA(int n, int n2) {
        if (this.pending == null) {
            this.pending = new Difference(n, -1, n2, n2);
        } else {
            this.pending.setAdded(n2);
        }
    }

    protected void onMatch(int n, int n2) {
        if (this.pending != null) {
            this.diffs.add(this.pending);
            this.pending = null;
        }
    }

    protected boolean equals(T t, T t2) {
        if (this.comparator == null) {
            return JideSwingUtilities.equals(t, t2, true);
        }
        return this.comparator.compare(t, t2) == 0;
    }

    public Integer[] getLongestCommonSubsequences() {
        Object object;
        Integer n10;
        ArrayList<Integer> arrayList;
        Object object2;
        int n2 = 0;
        int n3 = this.a.size() - 1;
        int n4 = 0;
        int n5 = this.b.size() - 1;
        TreeMap<Object, Integer> treeMap = new TreeMap<Object, Integer>();
        int n6 = 0;
        while (n2 <= n3 && n4 <= n5 && this.equals(this.a.get(n2), this.b.get(n4))) {
            if (++n6 >= 10000) {
                if (Thread.currentThread().isInterrupted()) {
                    return new Integer[0];
                }
                n6 = 0;
            }
            treeMap.put(n2++, n4++);
        }
        n6 = 0;
        while (n2 <= n3 && n4 <= n5 && this.equals(this.a.get(n3), this.b.get(n5))) {
            if (++n6 >= 10000) {
                if (Thread.currentThread().isInterrupted()) {
                    return new Integer[0];
                }
                n6 = 0;
            }
            treeMap.put(n3--, n5--);
        }
        AbstractMap abstractMap = this.comparator == null ? (this.a.size() > 0 && this.a.get(0) instanceof Comparable ? (this.isItemsConsistent() ? new TreeMap() : new HashMap()) : new HashMap()) : new TreeMap(this.comparator);
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        n6 = 0;
        for (int i = n4; i <= n5; ++i) {
            T t;
            if (++n6 >= 10000) {
                if (Thread.currentThread().isInterrupted()) {
                    return new Integer[0];
                }
                n6 = 0;
            }
            if ((object2 = (t = this.b.get(i))) == null) {
                arrayList2.add(i);
                continue;
            }
            arrayList = (ArrayList<Integer>)abstractMap.get(object2);
            if (arrayList == null) {
                arrayList = new ArrayList<Integer>();
                abstractMap.put(object2, arrayList);
            }
            arrayList.add(i);
        }
        this.thresh = new TreeMap();
        HashMap<Integer, Object[]> hashMap = new HashMap<Integer, Object[]>();
        n6 = 0;
        for (int i = n2; i <= n3; ++i) {
            if (++n6 >= 10000) {
                if (Thread.currentThread().isInterrupted()) {
                    return new Integer[0];
                }
                n6 = 0;
            }
            ArrayList<Integer> arrayList3 = arrayList = (object2 = this.a.get(i)) == null ? arrayList2 : (List)abstractMap.get(object2);
            if (arrayList == null) continue;
            n10 = 0;
            object = arrayList.listIterator(arrayList.size());
            while (object.hasPrevious()) {
                Integer n7;
                if (++n6 >= 10000) {
                    if (Thread.currentThread().isInterrupted()) {
                        return new Integer[0];
                    }
                    n6 = 0;
                }
                if ((n10 = this.insert(n7 = (Integer)object.previous(), n10)) == null) continue;
                Object var16_20 = n10 > 0 ? hashMap.get(n10 - 1) : null;
                hashMap.put(n10, new Object[]{var16_20, i, n7});
            }
        }
        if (this.thresh.size() > 0) {
            Integer n8 = this.thresh.lastKey();
            object2 = (Object[])hashMap.get(n8);
            n6 = 0;
            while (object2 != null) {
                if (++n6 >= 10000) {
                    if (Thread.currentThread().isInterrupted()) {
                        return new Integer[0];
                    }
                    n6 = 0;
                }
                arrayList = (Integer)object2[1];
                n10 = (Integer)object2[2];
                treeMap.put(arrayList, n10);
                object2 = (Object[])object2[0];
            }
        }
        int n9 = treeMap.size() == 0 ? 0 : 1 + (Integer)treeMap.lastKey();
        object2 = new Integer[n9];
        n6 = 0;
        for (Integer n10 : treeMap.keySet()) {
            if (++n6 >= 10000) {
                if (Thread.currentThread().isInterrupted()) {
                    return new Integer[0];
                }
                n6 = 0;
            }
            object = (Integer)treeMap.get(n10);
            object2[n10.intValue()] = object;
        }
        return object2;
    }

    protected static boolean isNonzero(Integer n) {
        return n != null && n != 0;
    }

    protected boolean isGreaterThan(Integer n, Integer n2) {
        Integer n3 = this.thresh.get(n);
        return n3 != null && n2 != null && n3.compareTo(n2) > 0;
    }

    protected boolean isLessThan(Integer n, Integer n2) {
        Integer n3 = this.thresh.get(n);
        return n3 != null && (n2 == null || n3.compareTo(n2) < 0);
    }

    protected Integer getLastValue() {
        return this.thresh.get(this.thresh.lastKey());
    }

    protected void append(Integer n) {
        Integer n2;
        if (this.thresh.size() == 0) {
            n2 = 0;
        } else {
            Integer n3 = this.thresh.lastKey();
            n2 = n3 + 1;
        }
        this.thresh.put(n2, n);
    }

    protected Integer insert(Integer n, Integer n2) {
        if (Diff.isNonzero(n2) && this.isGreaterThan(n2, n) && this.isLessThan(n2 - 1, n)) {
            this.thresh.put(n2, n);
        } else {
            int n3 = -1;
            if (Diff.isNonzero(n2)) {
                n3 = n2;
            } else if (this.thresh.size() > 0) {
                n3 = this.thresh.lastKey();
            }
            if (n3 == -1 || n.compareTo(this.getLastValue()) > 0) {
                this.append(n);
                n2 = n3 + 1;
            } else {
                int n4 = 0;
                while (n4 <= n3) {
                    int n5 = (n3 + n4) / 2;
                    Integer n6 = this.thresh.get(n5);
                    int n7 = n.compareTo(n6);
                    if (n7 == 0) {
                        return null;
                    }
                    if (n7 > 0) {
                        n4 = n5 + 1;
                        continue;
                    }
                    n3 = n5 - 1;
                }
                this.thresh.put(n4, n);
                n2 = n4;
            }
        }
        return n2;
    }

    public boolean isItemsConsistent() {
        return this._itemsConsistent;
    }

    public void setItemsConsistent(boolean bl) {
        this._itemsConsistent = bl;
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(16384)) {
            Lm.showInvalidProductMessage(Diff.class.getName(), 16384);
        }
    }
}

