/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.database;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class TableModelCache
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 7058096417725368128L;
    protected Map<Integer, Map<Integer, CachedValue>> _cache;
    protected int[] _conversionIndex = null;
    protected int _rowCount;
    protected int _columnCount;
    protected int _maximumCachedRows = 100;
    protected List<Integer> _cachedRowIndices;

    TableModelCache() {
    }

    public TableModelCache(int n, int n2) {
        this._rowCount = n;
        this._columnCount = n2;
    }

    public Map<Integer, Map<Integer, CachedValue>> getCache() {
        if (this._cache == null) {
            this._cache = new HashMap<Integer, Map<Integer, CachedValue>>();
        }
        if (this._cachedRowIndices == null) {
            this._cachedRowIndices = new ArrayList<Integer>();
        }
        return this._cache;
    }

    protected void tableRowsInserted(int n, int n2) {
    }

    protected void tableRowsDeleted(int n, int n2) {
        this.invalidateCache();
    }

    protected void tableRowsUpdated(int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            this.invalidateCache(i);
        }
    }

    protected void tableCellsUpdated(int n, int n2, int n3) {
        for (int i = n2; i <= n3; ++i) {
            this.invalidateCache(i, n);
        }
    }

    protected void tableDataChanged() {
        this.invalidateCache();
    }

    protected void tableStructureChanged() {
        this.invalidateCache();
    }

    public void setRowCount(int n) {
        this._rowCount = n;
    }

    public void setColumnCount(int n) {
        this._columnCount = n;
    }

    public synchronized int getRowCount() {
        return this._rowCount;
    }

    public List<Integer> getRowIndices() {
        return this._cachedRowIndices;
    }

    public synchronized int getColumnCount() {
        return this._columnCount;
    }

    protected boolean isCachedValueValid(int n, int n2) {
        CachedValue cachedValue = this.getCachedValue(n, n2);
        return cachedValue != null && cachedValue.valid;
    }

    public void invalidateCache() {
        this._cache = null;
        this._cachedRowIndices = null;
    }

    public void invalidateCache(int n) {
        this.getCache().remove(n);
        this._cachedRowIndices.remove(n);
    }

    public void invalidateCache(int n, int n2) {
        CachedValue cachedValue = this.getCachedValue(n, n2);
        if (cachedValue != null) {
            cachedValue.valid = false;
            cachedValue.value = null;
        }
    }

    protected void updateCachedValue(Object object, int n, int n2) {
        CachedValue cachedValue = this.getCachedValue(n, n2);
        if (cachedValue == null) {
            Map<Integer, Map<Integer, CachedValue>> map = this.getCache();
            cachedValue = new CachedValue();
            Map<Integer, CachedValue> map2 = map.get(n);
            if (map2 == null) {
                map2 = new HashMap<Integer, CachedValue>();
                int n3 = this.getMaximumCachedRows();
                if (n3 >= 0 && map.size() >= n3) {
                    map.remove(this._cachedRowIndices.get(0));
                    this._cachedRowIndices.remove(0);
                }
                map.put(n, map2);
                this._cachedRowIndices.add(n);
            }
            map2.put(n2, cachedValue);
        }
        cachedValue.valid = true;
        cachedValue.value = object;
    }

    private CachedValue getCachedValue(int n, int n2) {
        Map<Integer, CachedValue> map = this.getCache().get(n);
        return map != null ? map.get(n2) : null;
    }

    public synchronized Object getValueAt(int n, int n2) {
        CachedValue cachedValue = this.getCachedValue(n, n2);
        if (cachedValue != null && cachedValue.valid) {
            return cachedValue.value;
        }
        return null;
    }

    public void cacheIt() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.getValueAt(i, j);
            }
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        this.updateCachedValue(object, n, n2);
    }

    public int getMaximumCachedRows() {
        return this._maximumCachedRows;
    }

    public void setMaximumCachedRows(int n) {
        if (this._maximumCachedRows != n) {
            this._maximumCachedRows = n;
            this.invalidateCache();
        }
    }

    public class CachedValue {
        Object value = null;
        boolean valid = false;
    }
}

