/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.database;

import com.jidesoft.database.CrudRowOperations;
import com.jidesoft.database.DefaultRecord;
import com.jidesoft.database.Record;
import com.jidesoft.database.ResultSetTableModel;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class ResultSetTableModelCrudSupport
implements CrudRowOperations {
    private ResultSetTableModel _resultsetTableModel;

    public ResultSetTableModelCrudSupport(ResultSetTableModel resultSetTableModel) {
        this._resultsetTableModel = resultSetTableModel;
    }

    public ResultSetTableModel getResultSetTableModel() {
        return this._resultsetTableModel;
    }

    public void setResultSetTableModel(ResultSetTableModel resultSetTableModel) {
        this._resultsetTableModel = resultSetTableModel;
    }

    @Override
    public void insertRow(Record record) throws SQLException {
        if (record != Record.EMPTY && record != null) {
            ResultSet resultSet = this._resultsetTableModel.getResultSet();
            this.checkColumnValues(record);
            resultSet.moveToInsertRow();
            for (int i = this._resultsetTableModel.getColumnCount() - 1; i >= 0; --i) {
                String string = this._resultsetTableModel.getColumnName(i);
                if (record.isEmpty(string)) continue;
                resultSet.updateObject(i + 1, record.getValue(string));
            }
            resultSet.insertRow();
            resultSet.moveToCurrentRow();
        }
        this._resultsetTableModel.refreshData();
    }

    @Override
    public Record readRow(int n) throws SQLException {
        ResultSet resultSet = this._resultsetTableModel.getResultSet();
        int n2 = resultSet.getRow();
        resultSet.absolute(n + 1);
        int n3 = this._resultsetTableModel.getColumnCount();
        Record record = this.createRowRecord();
        for (int i = 0; i < n3; ++i) {
            record.setValue(this._resultsetTableModel.getColumnName(i), resultSet.getObject(i));
        }
        resultSet.absolute(n2);
        return record;
    }

    protected Record createRowRecord() {
        return new DefaultRecord();
    }

    @Override
    public void updateRow(int n, Record record) throws SQLException {
        ResultSet resultSet = this._resultsetTableModel.getResultSet();
        this.checkColumnValues(record);
        int n2 = resultSet.getRow();
        resultSet.absolute(n + 1);
        int n3 = this._resultsetTableModel.getColumnCount();
        for (int i = 0; i < n3; ++i) {
            String string = this._resultsetTableModel.getColumnName(i);
            if (record.isEmpty(string)) continue;
            resultSet.updateObject(i, record.getValue(string));
        }
        resultSet.updateRow();
        resultSet.absolute(n2);
        this._resultsetTableModel.refreshData();
    }

    @Override
    public void deleteRow(int n) throws SQLException {
        ResultSet resultSet = this._resultsetTableModel.getResultSet();
        int n2 = resultSet.getRow();
        resultSet.absolute(n + 1);
        resultSet.deleteRow();
        if (n2 >= this._resultsetTableModel.getRowCount()) {
            n2 = this._resultsetTableModel.getRowCount() - 1;
        }
        resultSet.absolute(n2);
        this._resultsetTableModel.refreshData();
    }

    private void checkColumnValues(Record record) throws SQLException {
        ResultSet resultSet = this._resultsetTableModel.getResultSet();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            if (resultSetMetaData.isNullable(i) != 1 || !record.isNull(this._resultsetTableModel.getColumnName(i - 1))) continue;
            throw new IllegalArgumentException();
        }
    }
}

