/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.dashboard;

import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

class DraggingImagePanel
extends JPanel {
    private BufferedImage _bufferedImage;
    private float _alpha;

    public DraggingImagePanel(BufferedImage bufferedImage) {
        this(bufferedImage, 0.3f);
    }

    public DraggingImagePanel(BufferedImage bufferedImage, float f) {
        this._bufferedImage = bufferedImage;
        this._alpha = f;
    }

    public void setBufferImage(BufferedImage bufferedImage) {
        this._bufferedImage = bufferedImage;
        this.invalidate();
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this._bufferedImage == null) {
            return super.getPreferredSize();
        }
        return new Dimension(this._bufferedImage.getWidth(), this._bufferedImage.getHeight());
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this._bufferedImage != null) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setComposite(AlphaComposite.getInstance(3, this._alpha));
            graphics2D.drawImage((Image)this._bufferedImage, 0, 0, this);
            graphics2D.dispose();
        }
    }
}

