/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.csv;

import com.jidesoft.csv.CsvParseEvent;
import com.jidesoft.csv.CsvParseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class CsvValueAccumulator {
    private char separator = (char)44;
    private char quote = (char)34;
    private StringBuilder characters = new StringBuilder();
    private EParsingState state = EParsingState.UNQUOTED;
    private List<CsvParseListener> listeners = Collections.synchronizedList(new ArrayList());
    private char previous = '\u0000';
    private List<String> tokens = new ArrayList<String>();
    private boolean trimming = true;

    public CsvValueAccumulator() {
    }

    public CsvValueAccumulator(char c) {
        this.setSeparator(c);
    }

    public char getSeparator() {
        return this.separator;
    }

    public void setSeparator(char c) {
        this.separator = c;
    }

    public boolean isTrimming() {
        return this.trimming;
    }

    public void setTrimming(boolean bl) {
        this.trimming = bl;
    }

    public void push(char c) {
        if (this.state == EParsingState.QUOTED) {
            if (c == this.quote) {
                this.state = EParsingState.UNQUOTED;
            } else {
                this.characters.append(c);
            }
        } else {
            if (c == '\r') {
                return;
            }
            if (c == this.separator) {
                this.fireTokenReceivedEvent();
            } else if (c == '\n') {
                this.fireTokenReceivedEvent();
                this.fireEndOfLineEvent();
            } else if (c == this.quote) {
                this.state = EParsingState.QUOTED;
                if (this.previous == this.quote) {
                    this.characters.append(this.quote);
                }
            } else {
                this.characters.append(c);
            }
        }
        this.previous = c;
    }

    public void newLine() {
        if (this.state == EParsingState.UNQUOTED) {
            this.fireTokenReceivedEvent();
            this.fireEndOfLineEvent();
        }
        this.previous = '\u0000';
    }

    public void addParseListener(CsvParseListener csvParseListener) {
        this.listeners.add(csvParseListener);
    }

    public void removeParseListener(CsvParseListener csvParseListener) {
        this.listeners.remove(csvParseListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireTokenReceivedEvent() {
        String string = this.trimming ? this.characters.toString().trim() : this.characters.toString();
        this.tokens.add(string);
        List<CsvParseListener> list = this.listeners;
        synchronized (list) {
            CsvParseEvent csvParseEvent = new CsvParseEvent(this, CsvParseEvent.EventType.TOKEN, string);
            for (CsvParseListener csvParseListener : this.listeners) {
                csvParseListener.parsed(csvParseEvent);
            }
            this.characters.delete(0, this.characters.length());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEndOfLineEvent() {
        ArrayList<String> arrayList = new ArrayList<String>(this.tokens);
        CsvValueAccumulator csvValueAccumulator = this;
        synchronized (csvValueAccumulator) {
            CsvParseEvent csvParseEvent = new CsvParseEvent((Object)this, arrayList);
            for (CsvParseListener csvParseListener : this.listeners) {
                csvParseListener.parsed(csvParseEvent);
            }
        }
        this.tokens.clear();
    }

    static enum EParsingState {
        QUOTED,
        UNQUOTED;

    }
}

