/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.PopupPanel;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.AutoScroll;
import com.jidesoft.swing.JideScrollPane;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.SearchableUtils;
import com.jidesoft.tree.TreeUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListDataListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeChooserPanel
extends PopupPanel
implements ItemListener {
    private Color _background = UIDefaultsLookup.getColor("controlLtHighlight");
    private Color _foreground = UIDefaultsLookup.getColor("textText");
    private Border _border = BorderFactory.createEmptyBorder(0, 0, 0, 0);
    private JTree _tree;
    protected TreeModel _model;
    private int _maximumRowCount;
    private TreeCellRenderer _cellRenderer;
    private AutoScroll _autoScroll;
    private boolean _doubleClickExpand;
    private boolean _searchUserObjectToSelect;
    private Handler handler;
    protected MouseMotionListener mouseMotionListener;
    protected MouseListener mouseListener;
    protected KeyListener keyListener;
    protected TreeSelectionListener treeSelectionListener;
    protected MouseListener treeMouseListener;
    protected MouseMotionListener treeMouseMotionListener;

    public TreeChooserPanel() {
        this(TreeChooserPanel.getDefaultTreeModel());
    }

    public TreeChooserPanel(Object object) {
        this(TreeChooserPanel.createTreeModel(object));
    }

    public TreeChooserPanel(Object[] objectArray) {
        this(TreeChooserPanel.createTreeModel(objectArray));
    }

    public TreeChooserPanel(Vector<?> vector) {
        this(TreeChooserPanel.createTreeModel(vector));
    }

    public TreeChooserPanel(Hashtable<?, ?> hashtable) {
        this(TreeChooserPanel.createTreeModel(hashtable));
    }

    public TreeChooserPanel(TreeModel treeModel) {
        this._model = treeModel;
        this.initComponents();
    }

    protected void initComponents() {
        this.setStretchToFit(true);
        this.setLayout(new BorderLayout());
        this.setBorder(this._border);
        this.setBackground(this._background);
        this.setForeground(this._foreground);
        this._tree = this.createTree(this._model);
        this.setupTree(this._tree);
        JideScrollPane jideScrollPane = new JideScrollPane(this._tree);
        jideScrollPane.setVerticalScrollBarPolicy(22);
        jideScrollPane.setVerticalScrollBarCoversWholeHeight(true);
        this.customizeScroller(jideScrollPane);
        this.add((Component)jideScrollPane, "Center");
        this.addItemListener(this);
        this._autoScroll = new AutoScroll(this._tree){

            @Override
            public void autoScrollingStarted(int n) {
            }

            @Override
            public void autoScrolling(int n) {
                TreeChooserPanel.this._tree.putClientProperty("PopupPanel.selectedByMouseRollover", Boolean.TRUE);
                if (n == 0 || n == 2) {
                    int n2 = TreeChooserPanel.this._tree.getRowForPath(TreeChooserPanel.this._tree.getSelectionPath());
                    if (n2 > 0) {
                        TreeChooserPanel.this.setTreeSelection(n2 - 1);
                        TreeChooserPanel.this._tree.scrollRowToVisible(n2 - 1);
                    }
                } else {
                    int n3;
                    int n4 = TreeChooserPanel.this._tree.getRowForPath(TreeChooserPanel.this._tree.getSelectionPath());
                    if (n4 < (n3 = TreeChooserPanel.this._tree.getRowCount() - 1)) {
                        TreeChooserPanel.this.setTreeSelection(n4 + 1);
                        TreeChooserPanel.this._tree.scrollRowToVisible(n4 + 1);
                    }
                }
                TreeChooserPanel.this._tree.putClientProperty("PopupPanel.selectedByMouseRollover", null);
            }

            @Override
            public void updateSelectionForEvent(MouseEvent mouseEvent, boolean bl) {
                Point point = mouseEvent.getPoint();
                if (TreeChooserPanel.this._tree == null) {
                    return;
                }
                int n = TreeChooserPanel.this._tree.getRowForLocation(point.x, point.y);
                if (n != -1) {
                    TreePath treePath = TreeChooserPanel.this._tree.getPathForRow(n);
                    if (TreeChooserPanel.this._tree.getSelectionPath() != treePath) {
                        TreeChooserPanel.this._tree.putClientProperty("PopupPanel.selectedByMouseRollover", Boolean.TRUE);
                        TreeChooserPanel.this._tree.setSelectionRow(n);
                        TreeChooserPanel.this._tree.putClientProperty("PopupPanel.selectedByMouseRollover", null);
                        if (bl) {
                            TreeChooserPanel.this._tree.makeVisible(treePath);
                        }
                    }
                }
            }
        };
    }

    protected void customizeScroller(JScrollPane jScrollPane) {
        jScrollPane.setFocusable(false);
        jScrollPane.getVerticalScrollBar().setFocusable(false);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
    }

    protected JTree createTree(TreeModel treeModel) {
        JTree jTree = new JTree(treeModel){

            @Override
            public TreePath getNextMatch(String string, int n, Position.Bias bias) {
                return null;
            }

            @Override
            public void processMouseEvent(MouseEvent mouseEvent) {
                if (JideSwingUtilities.isMenuShortcutKeyDown(mouseEvent)) {
                    mouseEvent = new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers() ^ Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                }
                super.processMouseEvent(mouseEvent);
            }
        };
        SearchableUtils.installSearchable(jTree);
        return jTree;
    }

    protected void setupTree(JTree jTree) {
        if (this.getCellRenderer() != null) {
            jTree.setCellRenderer(this.getCellRenderer());
        }
        this.installTreeListeners();
        this.registerKeyStrokes(jTree);
    }

    void registerKeyStrokes(JTree jTree) {
        AbstractAction abstractAction = new AbstractAction(){
            private static final long serialVersionUID = -7543677001664617720L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TreePath treePath = TreeChooserPanel.this._tree.getSelectionPath();
                if (treePath != null && TreeChooserPanel.this.isValidSelection(treePath)) {
                    TreeChooserPanel.this.setSelectedObject(treePath);
                }
            }
        };
        jTree.registerKeyboardAction(abstractAction, KeyStroke.getKeyStroke(10, 0), 1);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this._tree.putClientProperty("PopupPanel.selectedByMouseRollover", Boolean.TRUE);
        if (itemEvent.getStateChange() == 1) {
            if (itemEvent.getItem() instanceof TreePath) {
                this._tree.setSelectionPath((TreePath)itemEvent.getItem());
                this._tree.scrollPathToVisible((TreePath)itemEvent.getItem());
            } else if (itemEvent.getItem() != null && this.isSearchUserObjectToSelect()) {
                TreeUtils.expandAll(this._tree);
                for (int i = 0; i < this.getTree().getRowCount(); ++i) {
                    TreePath treePath = this._tree.getPathForRow(i);
                    if (treePath == null || treePath.getLastPathComponent() == null || !JideSwingUtilities.equals(((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject(), itemEvent.getItem())) continue;
                    this._tree.setSelectionPath(treePath);
                    this._tree.scrollPathToVisible(treePath);
                    break;
                }
            }
        } else if (itemEvent.getStateChange() == 2) {
            this._tree.clearSelection();
        }
        this._tree.putClientProperty("PopupPanel.selectedByMouseRollover", null);
    }

    public int getMaximumRowCount() {
        return this._maximumRowCount;
    }

    public void setMaximumRowCount(int n) {
        int n2 = this._maximumRowCount;
        this._maximumRowCount = n;
        this._tree.setVisibleRowCount(this._maximumRowCount);
        this.firePropertyChange("maximumRowCount", n2, this._maximumRowCount);
    }

    public TreeCellRenderer getCellRenderer() {
        return this._cellRenderer;
    }

    public void setCellRenderer(TreeCellRenderer treeCellRenderer) {
        this._cellRenderer = treeCellRenderer;
        if (this.getCellRenderer() != null) {
            this._tree.setCellRenderer(this.getCellRenderer());
        }
    }

    public JTree getTree() {
        return this._tree;
    }

    protected static TreeModel getDefaultTreeModel() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("JTree");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("colors");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("blue"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("violet"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("red"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("yellow"));
        defaultMutableTreeNode2 = new DefaultMutableTreeNode("sports");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("basketball"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("soccer"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("football"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("hockey"));
        defaultMutableTreeNode2 = new DefaultMutableTreeNode("food");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("hot dogs"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("pizza"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("ravioli"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("bananas"));
        return new DefaultTreeModel(defaultMutableTreeNode);
    }

    public static TreeModel createTreeModel(Object object) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        if (object == null) {
            return TreeChooserPanel.getDefaultTreeModel();
        }
        if (object instanceof TreeModel) {
            return (TreeModel)object;
        }
        if (object instanceof Object[] || object instanceof Hashtable || object instanceof Vector) {
            defaultMutableTreeNode = new DefaultMutableTreeNode("root");
            JTree.DynamicUtilTreeNode.createChildren(defaultMutableTreeNode, object);
        } else {
            if (object instanceof TreeNode) {
                return new DefaultTreeModel((TreeNode)object, false);
            }
            defaultMutableTreeNode = new JTree.DynamicUtilTreeNode((Object)"root", object);
        }
        return new DefaultTreeModel(defaultMutableTreeNode, false);
    }

    protected boolean isValidSelection(TreePath treePath) {
        return true;
    }

    public boolean isDoubleClickExpand() {
        return this._doubleClickExpand;
    }

    public void setDoubleClickExpand(boolean bl) {
        this._doubleClickExpand = bl;
    }

    public boolean isSearchUserObjectToSelect() {
        return this._searchUserObjectToSelect;
    }

    public void setSearchUserObjectToSelect(boolean bl) {
        this._searchUserObjectToSelect = bl;
    }

    protected MouseEvent convertMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this._tree) {
            return mouseEvent;
        }
        Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), this._tree);
        return new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
    }

    protected void updateTreeSelectionForEvent(MouseEvent mouseEvent, boolean bl) {
        Point point = mouseEvent.getPoint();
        if (this._tree == null) {
            return;
        }
        int n = this._tree.getRowForLocation(point.x, point.y);
        if (n != -1) {
            TreePath treePath = this._tree.getPathForRow(n);
            if (this._tree.getSelectionPath() != treePath) {
                this._tree.setSelectionRow(n);
                if (bl) {
                    this._tree.makeVisible(treePath);
                }
            }
        }
    }

    private void setTreeSelection(int n) {
        if (n == -1) {
            this._tree.clearSelection();
        } else {
            this._tree.setSelectionRow(n);
            this._tree.makeVisible(this._tree.getPathForRow(n));
        }
    }

    protected MouseListener createMouseListener() {
        return this.getHandler();
    }

    protected MouseMotionListener createMouseMotionListener() {
        return this.getHandler();
    }

    protected KeyListener createKeyListener() {
        return null;
    }

    protected TreeSelectionListener createTreeSelectionListener() {
        return null;
    }

    protected ListDataListener createListDataListener() {
        return null;
    }

    protected MouseListener createTreeMouseListener() {
        return this.getHandler();
    }

    protected MouseMotionListener createTreeMouseMotionListener() {
        return this.getHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    protected ItemListener createItemListener() {
        return this.getHandler();
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = this.createHandler();
        }
        return this.handler;
    }

    Handler createHandler() {
        return new Handler();
    }

    protected void installTreeListeners() {
        this.treeMouseListener = this.createTreeMouseListener();
        if (this.treeMouseListener != null) {
            this._tree.addMouseListener(this.treeMouseListener);
        }
        if ((this.treeMouseMotionListener = this.createTreeMouseMotionListener()) != null) {
            this._tree.addMouseMotionListener(this.treeMouseMotionListener);
        }
        if ((this.treeSelectionListener = this.createTreeSelectionListener()) != null) {
            this._tree.addTreeSelectionListener(this.treeSelectionListener);
        }
    }

    void uninstallTreeListeners() {
        if (this.treeMouseListener != null) {
            this._tree.removeMouseListener(this.treeMouseListener);
            this.treeMouseListener = null;
        }
        if (this.treeMouseMotionListener != null) {
            this._tree.removeMouseMotionListener(this.treeMouseMotionListener);
            this.treeMouseMotionListener = null;
        }
        if (this.treeSelectionListener != null) {
            this._tree.removeTreeSelectionListener(this.treeSelectionListener);
            this.treeSelectionListener = null;
        }
        this.handler = null;
    }

    class Handler
    implements ItemListener,
    MouseListener,
    MouseMotionListener,
    PropertyChangeListener,
    Serializable {
        private static final long serialVersionUID = 10293066769220954L;

        Handler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == TreeChooserPanel.this._tree) {
                if (TreeChooserPanel.this._tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY()) == -1) {
                    return;
                }
                TreePath treePath = TreeChooserPanel.this._tree.getSelectionPath();
                if (TreeChooserPanel.this.isDoubleClickExpand() && treePath.getLastPathComponent() instanceof TreeNode && !((TreeNode)treePath.getLastPathComponent()).isLeaf()) {
                    return;
                }
                if (treePath != null && TreeChooserPanel.this.isValidSelection(treePath)) {
                    TreeChooserPanel.this.setSelectedObject(treePath);
                }
                return;
            }
            Component component = (Component)mouseEvent.getSource();
            Dimension dimension = component.getSize();
            Rectangle rectangle = new Rectangle(0, 0, dimension.width - 1, dimension.height - 1);
            if (!rectangle.contains(mouseEvent.getPoint())) {
                TreePath treePath;
                MouseEvent mouseEvent2 = TreeChooserPanel.this.convertMouseEvent(mouseEvent);
                Point point = mouseEvent2.getPoint();
                Rectangle rectangle2 = new Rectangle();
                TreeChooserPanel.this._tree.computeVisibleRect(rectangle2);
                if (rectangle2.contains(point) && (treePath = TreeChooserPanel.this._tree.getSelectionPath()) != null && TreeChooserPanel.this.isValidSelection(treePath)) {
                    TreeChooserPanel.this.setSelectedObject(treePath);
                }
            }
            TreeChooserPanel.this._autoScroll.mouseReleased(mouseEvent);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            TreeChooserPanel.this._autoScroll.mouseMoved(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            TreeChooserPanel.this._autoScroll.mouseDragged(mouseEvent);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ComponentOrientation componentOrientation;
            JComboBox jComboBox = (JComboBox)propertyChangeEvent.getSource();
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("componentOrientation") && (componentOrientation = (ComponentOrientation)propertyChangeEvent.getNewValue()) != TreeChooserPanel.this.getComponentOrientation()) {
                TreeChooserPanel.this.setComponentOrientation(componentOrientation);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                if (itemEvent.getItem() instanceof TreePath) {
                    TreeChooserPanel.this._tree.setSelectionPath((TreePath)itemEvent.getItem());
                }
            } else if (itemEvent.getStateChange() == 2) {
                TreeChooserPanel.this._tree.clearSelection();
            }
        }
    }
}

