/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.ExComboBox;
import com.jidesoft.combobox.PopupPanel;
import com.jidesoft.combobox.TableChooserPanel;
import com.jidesoft.plaf.ExComboBoxUI;
import com.jidesoft.popup.JidePopup;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.Searchable;
import java.awt.Component;
import java.awt.Font;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableModel;

public class TableExComboBox
extends ExComboBox {
    protected int _maximumRowCount = 8;
    private TableModel _tableModel;
    private TableExComboBoxModel _comboBoxModel;
    private int _valueColumnIndex = 0;
    private boolean _toggleValueOnDoubleClick = true;
    private TableChooserPanel _panel;
    private TableModelListener _tableModelListener;
    private boolean _modelChanged = false;

    public TableExComboBox() {
        this(null, String.class);
    }

    public TableExComboBox(TableModel tableModel) {
        this(tableModel, String.class);
    }

    public TableExComboBox(TableModel tableModel, Class<?> clazz) {
        this(tableModel, clazz, 0);
    }

    public TableExComboBox(TableModel tableModel, int n) {
        this(tableModel, String.class, n);
    }

    public TableExComboBox(TableModel tableModel, Class<?> clazz, int n) {
        super(n);
        this.setType(clazz);
        this.setTableModel(tableModel);
    }

    @Override
    public void customizePopup(JidePopup jidePopup, PopupPanel popupPanel) {
        super.customizePopup(jidePopup, popupPanel);
        if (this._modelChanged && this.isKeepPopupSize() && this._tableModel.getRowCount() < this.getMaximumRowCount()) {
            jidePopup.setPreferredPopupSize(null);
        }
        this._modelChanged = false;
    }

    @Override
    public PopupPanel createPopupComponent() {
        TableChooserPanel tableChooserPanel = this.createTableChooserPanel(this._tableModel, this.getType());
        tableChooserPanel.setResizable(true);
        tableChooserPanel.setResizableCorners(16);
        tableChooserPanel.setMaximumRowCount(this.getMaximumRowCount());
        tableChooserPanel.setValueColumnIndex(this.getValueColumnIndex());
        tableChooserPanel.setAutoSelectionEnabled(this.getPopupType() != 1);
        this._panel = tableChooserPanel;
        return tableChooserPanel;
    }

    @Override
    public void setPopupType(int n) {
        super.setPopupType(n);
        if (this._panel != null) {
            this._panel.setAutoSelectionEnabled(this.getPopupType() != 1);
        }
    }

    @Override
    public boolean selectWithKeyChar(char c) {
        Object object = this.getClientProperty("Searchable");
        return !(object instanceof Searchable) && this.originalSelectWithKeyChar(c);
    }

    @Override
    public List<KeyStroke> getDelegateKeyStrokes() {
        List<KeyStroke> list = super.getDelegateKeyStrokes();
        list.remove(KeyStroke.getKeyStroke(37, 0));
        list.remove(KeyStroke.getKeyStroke(39, 0));
        return list;
    }

    protected JTable createTable(TableModel tableModel) {
        return null;
    }

    protected void setupTable(JTable jTable) {
        Font font = this.getFont();
        if (font != null && !(font instanceof UIResource)) {
            jTable.setFont(font);
        }
    }

    protected TableChooserPanel createTableChooserPanel(TableModel tableModel, Class<?> clazz) {
        return new TableChooserPanel(tableModel, clazz){

            @Override
            protected JTable createTable(TableModel tableModel) {
                JTable jTable = TableExComboBox.this.createTable(tableModel);
                if (jTable == null) {
                    return super.createTable(tableModel);
                }
                return jTable;
            }

            @Override
            protected void setupTable(final JTable jTable) {
                super.setupTable(jTable);
                jTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent listSelectionEvent) {
                        int n;
                        if (!listSelectionEvent.getValueIsAdjusting() && !Boolean.TRUE.equals(jTable.getClientProperty("PopupPanel.selectedByMouseRollover")) && (n = jTable.getSelectedRow()) != -1) {
                            Object object = jTable.getModel().getValueAt(n, this.getValueColumnIndex());
                            if (!JideSwingUtilities.equals(TableExComboBox.this.getEditor().getItem(), object, true)) {
                                TableExComboBox.this.setSelectedItem(object, false);
                            }
                        }
                    }
                });
                TableExComboBox.this.setupTable(jTable);
            }
        };
    }

    private boolean compareNull(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    @Override
    public void setMaximumRowCount(int n) {
        int n2 = this._maximumRowCount;
        if (n2 != n) {
            this._maximumRowCount = n;
            this.firePropertyChange("maximumRowCount", n2, this._maximumRowCount);
        }
    }

    @Override
    public int getMaximumRowCount() {
        return this._maximumRowCount;
    }

    @Override
    public void setSelectedIndex(int n) {
        int n2 = this.dataModel.getSize();
        if (n == -1) {
            this.setSelectedItem(null);
        } else {
            if (n < -1 || n >= n2) {
                throw new IllegalArgumentException("setSelectedIndex: " + n + " out of bounds");
            }
            this.setSelectedItem(this.dataModel.getElementAt(n));
        }
    }

    @Override
    public int getSelectedIndex() {
        Object object = this.dataModel.getSelectedItem();
        int n = this.dataModel.getSize();
        for (int i = 0; i < n; ++i) {
            Object e = this.dataModel.getElementAt(i);
            if (!JideSwingUtilities.equals(e, object)) continue;
            return i;
        }
        return -1;
    }

    public JTable getTable() {
        PopupPanel popupPanel;
        ComboBoxUI comboBoxUI = this.getUI();
        if (comboBoxUI instanceof ExComboBoxUI && (popupPanel = ((ExComboBoxUI)((Object)comboBoxUI)).getPopupPanel()) instanceof TableChooserPanel) {
            return ((TableChooserPanel)popupPanel).getTable();
        }
        return null;
    }

    public void addItem(Object object) {
        this.checkMutableComboBoxModel();
        ((MutableComboBoxModel)this.dataModel).addElement(object);
    }

    public void insertItemAt(Object object, int n) {
        this.checkMutableComboBoxModel();
        ((MutableComboBoxModel)this.dataModel).insertElementAt(object, n);
    }

    @Override
    public void removeItem(Object object) {
        this.checkMutableComboBoxModel();
        ((MutableComboBoxModel)this.dataModel).removeElement(object);
    }

    @Override
    public void removeItemAt(int n) {
        this.checkMutableComboBoxModel();
        ((MutableComboBoxModel)this.dataModel).removeElementAt(n);
    }

    @Override
    public void removeAllItems() {
        this.checkMutableComboBoxModel();
        MutableComboBoxModel mutableComboBoxModel = (MutableComboBoxModel)this.dataModel;
        int n = mutableComboBoxModel.getSize();
        if (mutableComboBoxModel instanceof DefaultComboBoxModel) {
            ((DefaultComboBoxModel)mutableComboBoxModel).removeAllElements();
        } else {
            for (int i = 0; i < n; ++i) {
                Object e = mutableComboBoxModel.getElementAt(0);
                mutableComboBoxModel.removeElement(e);
            }
        }
        this.selectedItemReminder = null;
        this.getEditor().setItem(null);
    }

    void checkMutableComboBoxModel() {
        if (!(this.dataModel instanceof MutableComboBoxModel)) {
            throw new RuntimeException("Cannot use this method with a non-Mutable data model.");
        }
    }

    public void setValueColumnIndex(int n) {
        int n2 = this._valueColumnIndex;
        if (n2 != n) {
            this._valueColumnIndex = n;
            this.firePropertyChange("valueColumnIndex", n2, this._valueColumnIndex);
        }
    }

    public int getValueColumnIndex() {
        return this._valueColumnIndex;
    }

    public TableModel getTableModel() {
        return this._tableModel;
    }

    public void setTableModel(TableModel tableModel) {
        if (this._tableModelListener == null) {
            this._tableModelListener = new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent tableModelEvent) {
                    if (tableModelEvent != null && tableModelEvent.getType() == 1) {
                        TableExComboBox.this._comboBoxModel.fireIntervalAdded(TableExComboBox.this._comboBoxModel, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
                    } else if (tableModelEvent != null && tableModelEvent.getType() == -1) {
                        TableExComboBox.this._comboBoxModel.fireIntervalRemoved(TableExComboBox.this._comboBoxModel, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
                    } else if (tableModelEvent != null && tableModelEvent.getType() == 0 && tableModelEvent.getFirstRow() >= 0 && tableModelEvent.getFirstRow() < TableExComboBox.this._tableModel.getRowCount() && tableModelEvent.getLastRow() >= 0 && tableModelEvent.getLastRow() < TableExComboBox.this._tableModel.getRowCount()) {
                        TableExComboBox.this._comboBoxModel.fireContentsChanged(TableExComboBox.this._comboBoxModel, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
                    } else {
                        TableExComboBox.this._comboBoxModel.fireContentsChanged(TableExComboBox.this._comboBoxModel, 0, TableExComboBox.this._comboBoxModel.getSize() - 1);
                    }
                    TableExComboBox.this._modelChanged = true;
                }
            };
        }
        if (this._tableModel != null) {
            this._tableModel.removeTableModelListener(this._tableModelListener);
        }
        this._tableModel = tableModel;
        this._comboBoxModel = new TableExComboBoxModel();
        this.setModel((ComboBoxModel)this._comboBoxModel);
        if (this._tableModel != null && this._tableModelListener != null) {
            this._tableModel.addTableModelListener(this._tableModelListener);
        }
    }

    @Override
    protected JComponent getDelegateTarget(PopupPanel popupPanel) {
        return popupPanel instanceof TableChooserPanel ? ((TableChooserPanel)popupPanel).getTable() : super.getDelegateTarget(popupPanel);
    }

    public boolean isToggleValueOnDoubleClick() {
        return this._toggleValueOnDoubleClick;
    }

    public void setToggleValueOnDoubleClick(boolean bl) {
        this._toggleValueOnDoubleClick = bl;
    }

    public void toggleValue(Component component, int n) {
        block21: {
            Object object;
            boolean bl;
            block22: {
                if (this.dataModel.getSize() == 0) {
                    return;
                }
                bl = this.getClientProperty("AbstractComboBox.isTableCellEditor") != null;
                object = this.getSelectedItem();
                if (n != 40) break block22;
                if (object == null) {
                    if (bl) {
                        this.setSelectedItem(this.dataModel.getElementAt(0), false);
                    } else {
                        this.setSelectedItem(this.dataModel.getElementAt(0));
                    }
                }
                for (int i = 0; i < this.dataModel.getSize(); ++i) {
                    Object e = this.dataModel.getElementAt(i);
                    if (!JideSwingUtilities.equals(e, object)) continue;
                    if (i < this.dataModel.getSize() - 1) {
                        if (bl) {
                            this.setSelectedItem(this.dataModel.getElementAt(i + 1), false);
                        } else {
                            this.setSelectedItem(this.dataModel.getElementAt(i + 1));
                        }
                    } else if (bl) {
                        this.setSelectedItem(this.dataModel.getElementAt(0), false);
                    } else {
                        this.setSelectedItem(this.dataModel.getElementAt(0));
                    }
                    break block21;
                }
                break block21;
            }
            if (n != 38) break block21;
            if (object == null) {
                if (bl) {
                    this.setSelectedItem(this.dataModel.getElementAt(this.dataModel.getSize() - 1), false);
                } else {
                    this.setSelectedItem(this.dataModel.getElementAt(this.dataModel.getSize() - 1));
                }
            }
            for (int i = 0; i < this.dataModel.getSize(); ++i) {
                Object e = this.dataModel.getElementAt(i);
                if (!JideSwingUtilities.equals(e, object)) continue;
                if (i > 0) {
                    if (bl) {
                        this.setSelectedItem(this.dataModel.getElementAt(i - 1), false);
                    } else {
                        this.setSelectedItem(this.dataModel.getElementAt(i - 1));
                    }
                } else if (bl) {
                    this.setSelectedItem(this.dataModel.getElementAt(this.dataModel.getSize() - 1), false);
                } else {
                    this.setSelectedItem(this.dataModel.getElementAt(this.dataModel.getSize() - 1));
                }
                break;
            }
        }
    }

    private class TableExComboBoxModel
    extends DefaultComboBoxModel {
        private static final long serialVersionUID = 3765916115399137049L;

        @Override
        public int getSize() {
            return TableExComboBox.this._tableModel == null ? 0 : TableExComboBox.this._tableModel.getRowCount();
        }

        @Override
        public void fireContentsChanged(Object object, int n, int n2) {
            super.fireContentsChanged(object, n, n2);
        }

        @Override
        public void fireIntervalAdded(Object object, int n, int n2) {
            super.fireIntervalAdded(object, n, n2);
        }

        @Override
        public void fireIntervalRemoved(Object object, int n, int n2) {
            super.fireIntervalRemoved(object, n, n2);
        }

        @Override
        public Object getElementAt(int n) {
            return TableExComboBox.this._tableModel == null ? null : TableExComboBox.this._tableModel.getValueAt(n, TableExComboBox.this.getValueColumnIndex());
        }
    }
}

