/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.AbstractComboBox;
import com.jidesoft.combobox.AbstractComboBoxSearchable;
import com.jidesoft.combobox.TableComboBox;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.IllegalComponentStateException;
import javax.swing.JTable;

public class TableComboBoxSearchable
extends AbstractComboBoxSearchable {
    private int[] _searchColumnIndices = null;

    public TableComboBoxSearchable(TableComboBox tableComboBox) {
        super(tableComboBox);
    }

    private JTable getTable() {
        return ((TableComboBox)this.getComboBox()).getTable();
    }

    @Override
    protected void setSelectedIndex(int n, boolean bl) {
        int n2;
        int n3;
        JTable jTable = this.getTable();
        if (jTable == null) {
            return;
        }
        if (this.isShowPopupDuringSearching()) {
            try {
                if (!((AbstractComboBox)this._component).isPopupVisible()) {
                    ((AbstractComboBox)this._component).showPopup();
                }
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
        if (this.isColumnSelectionAllowed(jTable)) {
            n3 = n;
            n2 = this.getMainIndex();
            this.addTableSelection(jTable, n3, n2, bl);
        } else if (this.isRowSelectionAllowed(jTable)) {
            n3 = n;
            n2 = this.getMainIndex();
            this.addTableSelection(jTable, n3, n2, bl);
        } else {
            int n4 = jTable.getColumnCount();
            if (n4 == 0) {
                return;
            }
            n3 = n / n4;
            n2 = n % n4;
            this.addTableSelection(jTable, n3, n2, bl);
        }
        jTable.scrollRectToVisible(jTable.getCellRect(n3, n2, true));
        if (this.getComboBox().getPopupLocation() == 1) {
            this.setPopupLocation(3);
        } else {
            this.setPopupLocation(1);
        }
    }

    @Override
    protected Object getElementAt(int n) {
        if (this.getSearchColumnIndices() == null) {
            TableComboBox tableComboBox = (TableComboBox)this.getComboBox();
            return this.getTable().getModel().getValueAt(n, tableComboBox.getValueColumnIndex());
        }
        JTable jTable = this.getTable();
        int n2 = jTable.convertColumnIndexToView(this.getMainIndex());
        if (n2 != -1) {
            return this.getValueAt(jTable, n, n2);
        }
        n2 = n % jTable.getColumnCount();
        int n3 = n / jTable.getColumnCount();
        return this.getValueAt(jTable, n3, n2);
    }

    @Override
    protected int getElementCount() {
        JTable jTable = this.getTable();
        if (this.isColumnSelectionAllowed(jTable)) {
            return jTable.getColumnCount();
        }
        if (this.isRowSelectionAllowed(jTable)) {
            return jTable.getRowCount();
        }
        return jTable.getColumnCount() * jTable.getRowCount();
    }

    @Override
    protected int getSelectedIndex() {
        JTable jTable = this.getTable();
        if (jTable == null) {
            return -1;
        }
        if (this.isColumnSelectionAllowed(jTable)) {
            return jTable.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
        }
        if (this.isRowSelectionAllowed(jTable)) {
            return jTable.getSelectionModel().getAnchorSelectionIndex();
        }
        return jTable.getSelectionModel().getAnchorSelectionIndex() * jTable.getColumnCount() + jTable.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
    }

    private Object getValueAt(JTable jTable, int n, int n2) {
        if (n >= 0 && n < jTable.getRowCount() && n2 >= 0 && n2 < jTable.getColumnCount()) {
            return jTable.getValueAt(n, n2);
        }
        return null;
    }

    protected void addTableSelection(JTable jTable, int n, int n2, boolean bl) {
        if (!bl) {
            jTable.clearSelection();
        }
        if (n >= 0 && n2 >= 0 && n < jTable.getRowCount() && n2 < jTable.getColumnCount() && !jTable.isCellSelected(n, n2)) {
            jTable.changeSelection(n, n2, true, false);
        }
    }

    protected boolean isColumnSelectionAllowed(JTable jTable) {
        return this.getSearchColumnIndices() != null && this.getSearchColumnIndices().length == 1 && jTable.getColumnSelectionAllowed() && !jTable.getRowSelectionAllowed();
    }

    protected boolean isRowSelectionAllowed(JTable jTable) {
        return (this.getSearchColumnIndices() == null || this.getSearchColumnIndices().length == 1) && !jTable.getColumnSelectionAllowed() && jTable.getRowSelectionAllowed();
    }

    public int[] getSearchColumnIndices() {
        return this._searchColumnIndices;
    }

    public int getMainIndex() {
        if (this._searchColumnIndices == null) {
            return ((TableComboBox)this.getComboBox()).getValueColumnIndex();
        }
        if (this._searchColumnIndices.length != 1) {
            return -1;
        }
        return this._searchColumnIndices[0];
    }

    public void setSearchColumnIndices(int[] nArray) {
        int[] nArray2 = this._searchColumnIndices;
        if (!JideSwingUtilities.equals(nArray2, nArray, true)) {
            this._searchColumnIndices = nArray;
            this.hidePopup();
        }
    }

    public void setMainIndex(int n) {
        int[] nArray;
        int[] nArray2 = new int[]{n};
        if (n < 0) {
            nArray2 = new int[]{};
        }
        if ((nArray = this._searchColumnIndices) != nArray2) {
            this._searchColumnIndices = nArray2;
            this.hidePopup();
        }
    }
}

