/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.PopupPanel;
import com.jidesoft.swing.AutoScroll;
import com.jidesoft.swing.JideScrollPane;
import com.jidesoft.utils.SystemInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class TableChooserPanel
extends PopupPanel
implements ItemListener {
    private Border _border = BorderFactory.createEmptyBorder(0, 0, 0, 0);
    protected JTable _table;
    private TableModel _model;
    protected Class<?> _class = String.class;
    private int _maximumRowCount;
    private JScrollPane _scroller;
    private AutoScroll _autoScroll;
    private int _valueColumnIndex = 0;
    private boolean _autoSelectionEnabled = true;
    protected boolean hasEntered = false;
    private Handler handler;
    protected MouseMotionListener mouseMotionListener;
    protected MouseListener mouseListener;
    protected MouseListener tableMouseListener;
    protected MouseMotionListener tableMouseMotionListener;

    public TableChooserPanel() {
        this(new DefaultTableModel(), Object.class);
    }

    public TableChooserPanel(TableModel tableModel, Class<?> clazz) {
        this._model = tableModel;
        this._class = clazz;
        this.initComponents();
    }

    protected void initComponents() {
        this.setStretchToFit(true);
        this.setLayout(new BorderLayout());
        this.setBorder(this._border);
        this._table = this.createTable(this._model);
        this._table.setName("ComboBox.table");
        this.setupTable(this._table);
        this._scroller = new JideScrollPane(this._table);
        ((JideScrollPane)this._scroller).setVerticalScrollBarCoversWholeHeight(true);
        this._scroller.setName("ComboBox.scrollPane");
        this.customzieScroller(this._scroller);
        this._scroller.setColumnHeaderView(this._table.getTableHeader());
        this.add((Component)this._scroller, "Center");
        this._table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                TableChooserPanel.this.setPreferredSize(null);
                TableChooserPanel.this.configurePreferredScrollViewportSize();
            }
        });
        this.configurePreferredScrollViewportSize();
        this.addItemListener(this);
        this._autoScroll = new AutoScroll(this._table){

            @Override
            public void autoScrollingStarted(int n) {
            }

            @Override
            public void autoScrolling(int n) {
                TableChooserPanel.this._table.putClientProperty("PopupPanel.selectedByMouseRollover", Boolean.TRUE);
                if (n == 0 || n == 2) {
                    int n2 = TableChooserPanel.this._table.getSelectedRow();
                    int n3 = TableChooserPanel.this._table.getSelectedColumn();
                    if (n2 > 0) {
                        TableChooserPanel.this._table.changeSelection(n2 - 1, n3, false, false);
                    }
                } else {
                    int n4 = TableChooserPanel.this._table.getSelectedRow();
                    int n5 = TableChooserPanel.this._table.getSelectedColumn();
                    if (n4 < TableChooserPanel.this._table.getRowCount() - 1) {
                        TableChooserPanel.this._table.changeSelection(n4 + 1, n5, false, false);
                    }
                }
                TableChooserPanel.this._table.putClientProperty("PopupPanel.selectedByMouseRollover", null);
            }

            @Override
            public void updateSelectionForEvent(MouseEvent mouseEvent, boolean bl) {
                Point point = mouseEvent.getPoint();
                if (TableChooserPanel.this._table == null) {
                    return;
                }
                int n = TableChooserPanel.this._table.rowAtPoint(point);
                if (n == -1) {
                    n = point.y < 0 ? 0 : TableChooserPanel.this._model.getRowCount() - 1;
                }
                if (TableChooserPanel.this._table.getSelectedRow() != n) {
                    TableChooserPanel.this._table.putClientProperty("PopupPanel.selectedByMouseRollover", Boolean.TRUE);
                    TableChooserPanel.this._table.changeSelection(n, TableChooserPanel.this.getDefaultColumnIndex(), false, false);
                    TableChooserPanel.this._table.putClientProperty("PopupPanel.selectedByMouseRollover", null);
                }
            }
        };
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (!(SystemInfo.isJdk15Above() && this.isPreferredSizeSet() || this._scroller.getColumnHeader() == null || this._scroller.getColumnHeader().getView() == this._table.getTableHeader() || this._table.getTableHeader() == null)) {
            dimension.height += this._table.getTableHeader().getPreferredSize().height;
        }
        return dimension;
    }

    private void configurePreferredScrollViewportSize() {
        if (this.getMaximumRowCount() < this._table.getModel().getRowCount() || this._table.getModel().getRowCount() == 0) {
            Dimension dimension = this._table.getPreferredScrollableViewportSize();
            dimension.height = this._table.getRowHeight() * this.getMaximumRowCount();
            this._table.setPreferredScrollableViewportSize(dimension);
            this._scroller.setVerticalScrollBarPolicy(22);
        } else {
            Dimension dimension = this._table.getPreferredScrollableViewportSize();
            dimension.height = this._table.getRowHeight() * this._table.getModel().getRowCount();
            this._table.setPreferredScrollableViewportSize(dimension);
            this._scroller.setVerticalScrollBarPolicy(20);
        }
    }

    protected void customzieScroller(JScrollPane jScrollPane) {
        jScrollPane.setFocusable(false);
        jScrollPane.getVerticalScrollBar().setFocusable(false);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
    }

    protected JTable createTable(TableModel tableModel) {
        return new JTable(tableModel);
    }

    protected void setupTable(JTable jTable) {
        jTable.setSelectionMode(0);
        this.installListListeners();
        this.registerKeyStrokes(jTable);
    }

    private void registerKeyStrokes(JTable jTable) {
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableChooserPanel.this.setSelectedObject(TableChooserPanel.this.getValueAtRowIndex(TableChooserPanel.this._table.getSelectedRow()));
            }
        };
        jTable.registerKeyboardAction(abstractAction, KeyStroke.getKeyStroke(10, 0), 1);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
    }

    public int getMaximumRowCount() {
        return this._maximumRowCount;
    }

    public void setMaximumRowCount(int n) {
        int n2 = this._maximumRowCount;
        this._maximumRowCount = n;
        this.configurePreferredScrollViewportSize();
        this.firePropertyChange("maximumRowCount", n2, this._maximumRowCount);
    }

    public JTable getTable() {
        return this._table;
    }

    protected Object getValueAtRowIndex(int n) {
        if (n < 0 || n >= this._table.getModel().getRowCount()) {
            return null;
        }
        return this._table.getModel().getValueAt(n, this.getValueColumnIndex());
    }

    @Override
    public void setSelectedObject(Object object) {
        super.setSelectedObject(object);
        if (this._table != null) {
            if (object == null) {
                this._table.getSelectionModel().clearSelection();
            } else {
                for (int i = 0; i < this._table.getRowCount(); ++i) {
                    Object object2 = this.getValueAtRowIndex(i);
                    if (!object.equals(object2)) continue;
                    this._table.changeSelection(i, 0, false, false);
                }
            }
        }
    }

    private void setSelectedIndex(int n, Object object) {
        super.setSelectedObject(object);
        if (this._table != null) {
            if (object == null) {
                this._table.getSelectionModel().clearSelection();
            } else {
                this._table.changeSelection(n, 0, false, false);
            }
        }
    }

    boolean isAutoSelectionEnabled() {
        return this._autoSelectionEnabled;
    }

    void setAutoSelectionEnabled(boolean bl) {
        this._autoSelectionEnabled = bl;
    }

    protected int getDefaultColumnIndex() {
        return 0;
    }

    protected MouseEvent convertMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this._table) {
            return mouseEvent;
        }
        Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), this._table);
        return new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
    }

    protected MouseListener createMouseListener() {
        return this.getHandler();
    }

    protected MouseMotionListener createMouseMotionListener() {
        return this.getHandler();
    }

    protected MouseListener createTableMouseListener() {
        return this.getHandler();
    }

    protected MouseMotionListener createTableMouseMotionListener() {
        return this.getHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected void installListListeners() {
        this.tableMouseListener = this.createTableMouseListener();
        if (this.tableMouseListener != null) {
            this._table.addMouseListener(this.tableMouseListener);
        }
        if ((this.tableMouseMotionListener = this.createTableMouseMotionListener()) != null) {
            this._table.addMouseMotionListener(this.tableMouseMotionListener);
        }
    }

    void uninstallListListeners() {
        if (this.tableMouseListener != null) {
            this._table.removeMouseListener(this.tableMouseListener);
            this.tableMouseListener = null;
        }
        if (this.tableMouseMotionListener != null) {
            this._table.removeMouseMotionListener(this.tableMouseMotionListener);
            this.tableMouseMotionListener = null;
        }
        this.handler = null;
    }

    public void setValueColumnIndex(int n) {
        int n2 = this._valueColumnIndex;
        if (n2 != n) {
            this._valueColumnIndex = n;
            this.firePropertyChange("valueColumnIndex", n2, this._valueColumnIndex);
        }
    }

    public int getValueColumnIndex() {
        return this._valueColumnIndex;
    }

    private class Handler
    implements MouseListener,
    MouseMotionListener,
    PropertyChangeListener,
    Serializable {
        private Handler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            int n = TableChooserPanel.this._table.getSelectedRow();
            if (mouseEvent.getSource() == TableChooserPanel.this._table) {
                TableChooserPanel.this._table.putClientProperty("PopupPanel.selectedByMouseRollover", Boolean.TRUE);
                TableChooserPanel.this.setSelectedIndex(n, TableChooserPanel.this.getValueAtRowIndex(n));
                TableChooserPanel.this._table.putClientProperty("PopupPanel.selectedByMouseRollover", null);
                return;
            }
            Component component = (Component)mouseEvent.getSource();
            Dimension dimension = component.getSize();
            Rectangle rectangle = new Rectangle(0, 0, dimension.width - 1, dimension.height - 1);
            if (!rectangle.contains(mouseEvent.getPoint())) {
                MouseEvent mouseEvent2 = TableChooserPanel.this.convertMouseEvent(mouseEvent);
                Point point = mouseEvent2.getPoint();
                Rectangle rectangle2 = new Rectangle();
                TableChooserPanel.this._table.computeVisibleRect(rectangle2);
                if (rectangle2.contains(point)) {
                    TableChooserPanel.this._table.putClientProperty("PopupPanel.selectedByMouseRollover", Boolean.TRUE);
                    TableChooserPanel.this.setSelectedIndex(n, TableChooserPanel.this.getValueAtRowIndex(n));
                    TableChooserPanel.this._table.putClientProperty("PopupPanel.selectedByMouseRollover", null);
                }
            }
            if (TableChooserPanel.this.isAutoSelectionEnabled()) {
                TableChooserPanel.this._autoScroll.mouseReleased(mouseEvent);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (TableChooserPanel.this.isAutoSelectionEnabled()) {
                TableChooserPanel.this._autoScroll.mouseMoved(mouseEvent);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (TableChooserPanel.this.isAutoSelectionEnabled()) {
                TableChooserPanel.this._autoScroll.mouseDragged(mouseEvent);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ComponentOrientation componentOrientation;
            JTable jTable = (JTable)propertyChangeEvent.getSource();
            String string = propertyChangeEvent.getPropertyName();
            if ("model".equals(string)) {
                TableModel tableModel = (TableModel)propertyChangeEvent.getNewValue();
                TableChooserPanel.this._table.setModel(tableModel);
                if (TableChooserPanel.this.isVisible()) {
                    TableChooserPanel.this.setVisible(false);
                }
            } else if ("componentOrientation".equals(string) && (componentOrientation = (ComponentOrientation)propertyChangeEvent.getNewValue()) != TableChooserPanel.this.getComponentOrientation()) {
                TableChooserPanel.this.setComponentOrientation(componentOrientation);
            }
        }
    }
}

