/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.ExComboBox;
import com.jidesoft.combobox.MultiSelectListChooserPanel;
import com.jidesoft.combobox.PopupPanel;
import com.jidesoft.converter.ConverterContext;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.SearchableUtils;
import java.awt.Font;
import java.lang.reflect.Array;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.UIResource;

public class MultiSelectListExComboBox
extends ExComboBox {
    private boolean _updateOnChange = true;
    private boolean _doubleClickEnabled = true;
    protected int maximumRowCount = 8;
    private JList _list;
    protected int _selectionMode = 2;
    public static final String PROPERTY_SELECTION_MODE = "selectionMode";

    public MultiSelectListExComboBox() {
        this(new Object[0]);
    }

    public MultiSelectListExComboBox(Object[] objectArray) {
        this(objectArray, Object[].class);
    }

    public MultiSelectListExComboBox(Vector<?> vector) {
        this(vector, Object[].class);
    }

    public MultiSelectListExComboBox(ComboBoxModel comboBoxModel) {
        this(comboBoxModel, Object[].class);
    }

    public MultiSelectListExComboBox(Object[] objectArray, Class<?> clazz) {
        super(0);
        this.setType(clazz);
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(objectArray);
        defaultComboBoxModel.setSelectedItem(null);
        this.setModel((ComboBoxModel)defaultComboBoxModel);
        this.setStretchToFit(true);
    }

    public MultiSelectListExComboBox(Vector<?> vector, Class<?> clazz) {
        super(0);
        this.setType(clazz);
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel(vector);
        defaultComboBoxModel.setSelectedItem(null);
        this.setModel((ComboBoxModel)defaultComboBoxModel);
        this.setStretchToFit(true);
    }

    public MultiSelectListExComboBox(ComboBoxModel comboBoxModel, Class<?> clazz) {
        super(0);
        this.setType(clazz);
        this.setModel(comboBoxModel);
        this.setStretchToFit(true);
    }

    @Override
    public PopupPanel createPopupComponent() {
        MultiSelectListChooserPanel multiSelectListChooserPanel = this.createListChooserPanel(this.dataModel, this.getType().getComponentType(), ConverterContext.getElementConverterContext(this.getConverterContext()));
        multiSelectListChooserPanel.setRenderer(this.getRenderer());
        multiSelectListChooserPanel.setResizable(true);
        multiSelectListChooserPanel.setResizableCorners(16);
        multiSelectListChooserPanel.setMaximumRowCount(this.getMaximumRowCount());
        this._list = multiSelectListChooserPanel.getList();
        return multiSelectListChooserPanel;
    }

    protected MultiSelectListChooserPanel createListChooserPanel(ComboBoxModel comboBoxModel, Class<?> clazz, ConverterContext converterContext) {
        MultiSelectListChooserPanel multiSelectListChooserPanel = new MultiSelectListChooserPanel(comboBoxModel, clazz, converterContext, this.getDefaultOKAction(), this.getDefaultCancelAction()){

            @Override
            protected void setupList(JList jList) {
                super.setupList(jList);
                MultiSelectListExComboBox.this.setupList(jList);
            }
        };
        multiSelectListChooserPanel.setDoubleClickEnabled(this.isDoubleClickEnabled());
        return multiSelectListChooserPanel;
    }

    @Override
    public void setMaximumRowCount(int n) {
        int n2 = this.maximumRowCount;
        this.maximumRowCount = n;
        this.firePropertyChange("maximumRowCount", n2, this.maximumRowCount);
    }

    @Override
    public int getMaximumRowCount() {
        return this.maximumRowCount;
    }

    @Override
    public void setSelectedIndex(int n) {
        int n2 = this.dataModel.getSize();
        if (n == -1) {
            super.setSelectedItem(null);
        } else {
            if (n < -1 || n >= n2) {
                throw new IllegalArgumentException("setSelectedIndex: " + n + " out of bounds");
            }
            Object object = Array.newInstance(this.getType().getComponentType(), 1);
            Array.set(object, 0, this.dataModel.getElementAt(n));
            super.setSelectedItem(object);
        }
    }

    @Override
    public int getSelectedIndex() {
        Object[] objectArray = this.getSelectedObjects();
        if (objectArray == null || objectArray.length == 0) {
            return -1;
        }
        int n = this.dataModel.getSize();
        for (int i = 0; i < n; ++i) {
            Object e = this.dataModel.getElementAt(i);
            int n2 = objectArray.length;
            for (int j = 0; j < n2; ++j) {
                if (e == null || !e.equals(objectArray[j])) continue;
                return i;
            }
        }
        return -1;
    }

    public void setSelectedIndices(int[] nArray) {
        int n = this.dataModel.getSize();
        if (nArray.length == 0) {
            super.setSelectedItem(null);
        } else {
            Object object = Array.newInstance(this.getType().getComponentType(), nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                int n2 = nArray[i];
                if (n2 < -1 || n2 >= n) {
                    throw new IllegalArgumentException("setSelectedIndices: " + n2 + " out of bounds");
                }
                Array.set(object, i, this.dataModel.getElementAt(n2));
            }
            this.setSelectedItem(object);
        }
    }

    public int[] getSelectedIndices() {
        Object[] objectArray = this.getSelectedObjects();
        int[] nArray = new int[objectArray.length];
        block0: for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            nArray[i] = -1;
            int n = this.dataModel.getSize();
            for (int j = 0; j < n; ++j) {
                Object e = this.dataModel.getElementAt(j);
                if (e == null || !e.equals(object)) continue;
                nArray[i] = j;
                continue block0;
            }
        }
        return nArray;
    }

    @Override
    public void setSelectedItem(Object object, boolean bl) {
        super.setSelectedItem(this.convertArrayType(object), bl);
    }

    public Object convertArrayType(Object object) {
        if (object == null || this.getType() == null) {
            return object;
        }
        if (object.getClass().isArray()) {
            Class<?> clazz = this.getType().getComponentType();
            if (clazz.isAssignableFrom(object.getClass().getComponentType())) {
                return object;
            }
            int n = Array.getLength(object);
            Object object2 = Array.newInstance(clazz, n);
            for (int i = 0; i < n; ++i) {
                Object object3 = Array.get(object, i);
                try {
                    Array.set(object2, i, object3);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return object2;
        }
        Object object4 = Array.newInstance(this.getType().getComponentType(), 1);
        Array.set(object4, 0, object);
        return object4;
    }

    public void setSelectedObjects(Object[] objectArray) {
        super.setSelectedItem(objectArray);
    }

    @Override
    public Object getSelectedItem() {
        Object object = super.getSelectedItem();
        return this.convertArrayType(object);
    }

    @Override
    public Object[] getSelectedObjects() {
        Object[] objectArray;
        Object object = super.getSelectedItem();
        if (object == null) {
            return new Object[0];
        }
        try {
            int n = Array.getLength(object);
            objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = Array.get(object, i);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArray = new Object[]{object};
        }
        return objectArray;
    }

    public JList getList() {
        if (this.isPopupVisible()) {
            return this._list;
        }
        return null;
    }

    @Override
    protected JComponent getDelegateTarget(PopupPanel popupPanel) {
        return popupPanel instanceof MultiSelectListChooserPanel ? ((MultiSelectListChooserPanel)popupPanel).getList() : super.getDelegateTarget(popupPanel);
    }

    @Override
    protected boolean validateValueForNonEditable(Object object) {
        if (object == null) {
            return true;
        }
        if (object.getClass().isArray()) {
            int n = Array.getLength(object);
            for (int i = 0; i < n; ++i) {
                boolean bl = super.validateValueForNonEditable(Array.get(object, i));
                if (bl) continue;
                return false;
            }
            return true;
        }
        return super.validateValueForNonEditable(object);
    }

    protected void setupList(final JList jList) {
        Font font;
        if (this.getClientProperty("Searchable") instanceof Searchable && jList.getClientProperty("Searchable") instanceof Searchable) {
            SearchableUtils.uninstallSearchable((Searchable)jList.getClientProperty("Searchable"));
        }
        if ((font = this.getFont()) != null && !(font instanceof UIResource)) {
            jList.setFont(font);
        }
        jList.getSelectionModel().setSelectionMode(this.getSelectionMode());
        jList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                Object[] objectArray;
                Object object;
                if (!listSelectionEvent.getValueIsAdjusting() && MultiSelectListExComboBox.this.isUpdateOnChange() && !Boolean.TRUE.equals(jList.getClientProperty("PopupPanel.selectedByMouseRollover")) && (object = MultiSelectListExComboBox.this.convertArrayType(objectArray = jList.getSelectedValues())) != null && !JideSwingUtilities.equals(MultiSelectListExComboBox.this.getEditor().getItem(), object, true)) {
                    MultiSelectListExComboBox.this.setSelectedItem(object, false);
                }
            }
        });
    }

    public void setSelectionMode(int n) {
        int n2 = this._selectionMode;
        if (n2 != n) {
            this._selectionMode = n;
            this.firePropertyChange(PROPERTY_SELECTION_MODE, n2, n);
        }
    }

    public int getSelectionMode() {
        return this._selectionMode;
    }

    public boolean isUpdateOnChange() {
        return this._updateOnChange;
    }

    public void setUpdateOnChange(boolean bl) {
        this._updateOnChange = bl;
    }

    public boolean isDoubleClickEnabled() {
        return this._doubleClickEnabled;
    }

    public void setDoubleClickEnabled(boolean bl) {
        this._doubleClickEnabled = bl;
    }
}

