/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.DateModel;
import com.jidesoft.combobox.DateModelEvent;
import com.jidesoft.combobox.DateModelListener;
import com.jidesoft.combobox.DateResource;
import com.jidesoft.combobox.DefaultDateModel;
import com.jidesoft.combobox.PopupPanel;
import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.icons.JideIconsFactory;
import com.jidesoft.icons.MaskFilter;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.spinner.SpinnerWheelSupport;
import com.jidesoft.swing.DelegateAction;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.NullLabel;
import com.jidesoft.swing.NullPanel;
import com.jidesoft.utils.PortingUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.JTextComponent;

public class MonthChooserPanel
extends PopupPanel
implements ItemListener,
ActionListener,
MouseListener,
MouseWheelListener,
DateModelListener {
    private Color _background = UIDefaultsLookup.getColor("TextField.background");
    private Color _foreground = UIDefaultsLookup.getColor("TextField.foreground");
    private Font _font = UIDefaultsLookup.getFont("TextField.font");
    private Border _border = BorderFactory.createEmptyBorder(6, 6, 6, 6);
    private Color _yearBackground = UIDefaultsLookup.getColor("InternalFrame.activeTitleBackground");
    private Color _yearForeground = UIDefaultsLookup.getColor("InternalFrame.activeTitleForeground");
    private Border _yearBorder = BorderFactory.createEmptyBorder(4, 4, 4, 4);
    private Border _buttonsBorder = BorderFactory.createEmptyBorder(4, 4, 4, 4);
    private Color _normalDateColor = UIDefaultsLookup.getColor("TextField.foreground");
    private Color _selectedDateForeground = UIDefaultsLookup.getColor("TextField.selectionForeground");
    private Color _selectedDateBackground = UIDefaultsLookup.getColor("TextField.selectionBackground");
    private int _horizontalGap = 5;
    private int _verticalGap = 0;
    private int _cellWidth = 70;
    private int _cellHeight = 25;
    private Border _cellBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    private Border _todayBorder = BorderFactory.createLineBorder(Color.red, 1);
    private int _labelAlignment = 0;
    private boolean _spinnerVisible = false;
    private DateFormat _monthFormatter;
    private DateFormat _yearFormatter;
    private DateFormat _weekFormatter;
    private int _todaysYear;
    private int _todaysMonth;
    private int _selectedYear;
    private int _selectedMonth;
    private HashMap<Component, Date> _dayMap = new HashMap();
    private Calendar _displayedCalendar;
    private Calendar _todaysCalendar;
    private Calendar _selectedCalendar;
    private JButton _nextButton;
    private JButton _prevButton;
    private JButton _noneButton;
    private JButton _thisMonthButton;
    private JComponent _yearLabel;
    private JComponent _yearSpinner;
    private JComponent[] _monthLabels = new JComponent[12];
    private JPanel _yearPanel;
    private boolean _showNoneButton = true;
    private boolean _showThisMonthButton = true;
    private boolean _viewOnly;
    private ButtonPanel _buttonPanel;
    public static final String VIEWONLY_PROPERTY = "viewonly";
    public static int NAVIGATION_BUTTON_HEIGHT = 18;
    public static int NAVIGATION_BUTTON_WIDTH = 20;
    private DateModel _dateModel;
    boolean _inited = false;

    public MonthChooserPanel() {
        this(new DefaultDateModel(), true);
    }

    public MonthChooserPanel(DateModel dateModel) {
        this(dateModel, true);
    }

    public MonthChooserPanel(boolean bl) {
        this(new DefaultDateModel(), bl);
    }

    public MonthChooserPanel(DateModel dateModel, boolean bl) {
        this(dateModel, bl, Locale.getDefault());
    }

    public MonthChooserPanel(DateModel dateModel, boolean bl, Locale locale) {
        this._dateModel = dateModel;
        this._showNoneButton = bl;
        this.setLocale(locale);
        this.initDateFormat(locale);
        this.initComponents();
        this.initCalendar();
        this.addItemListener(this);
        this.addMouseWheelListener(this);
        this.updateCalendar();
        this._inited = true;
    }

    public DateModel getDateModel() {
        return this._dateModel;
    }

    public void setDateModel(DateModel dateModel) {
        if (this._dateModel != dateModel) {
            if (this._dateModel != null) {
                this.removeModeListener();
            }
            this._dateModel = dateModel;
            if (this._dateModel != null) {
                this.addModelListener();
            }
        }
    }

    protected void addModelListener() {
        this._dateModel.addDateModelListener(this);
    }

    protected void removeModeListener() {
        this._dateModel.removeDateModelListener(this);
    }

    @Override
    public void dateModelChanged(DateModelEvent dateModelEvent) {
        this.updateCalendar();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (!this.isViewOnly()) {
            Component component;
            Object object = mouseEvent.getSource();
            if (object instanceof Component && this._dayMap.containsKey(component = (Component)object)) {
                this.setSelectedDate(this._dayMap.get(component));
                this.repaint();
            }
            this.mousePressed(mouseEvent);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.isViewOnly()) {
            Object object = mouseEvent.getSource();
            if (object == this._yearLabel) {
                this.showYearSpinner();
            } else {
                this.hideYearSpinner();
            }
        }
    }

    private void showYearSpinner() {
        if (!this._spinnerVisible) {
            this._yearPanel.remove(this._yearLabel);
            try {
                ((JSpinner)this._yearSpinner).setValue(this._displayedCalendar.get(1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this._yearPanel.add(this._yearSpinner);
            Container container = this.getTopLevelAncestor();
            if (container != null) {
                if (container instanceof Window) {
                    ((Window)container).setFocusableWindowState(true);
                }
                container.setFocusable(true);
            }
            this._yearSpinner.requestFocus();
            this._yearPanel.revalidate();
            this._yearPanel.repaint();
            this.repaint();
            this._spinnerVisible = true;
        }
    }

    private void hideYearSpinner() {
        if (this._spinnerVisible) {
            this._yearPanel.remove(this._yearSpinner);
            this._yearPanel.add(this._yearLabel);
            Object object = ((JSpinner)this._yearSpinner).getValue();
            if (object instanceof Integer) {
                this.setDisplayedYear((Integer)object);
                this._yearPanel.revalidate();
                this._yearPanel.repaint();
                this.updateCalendar();
            }
            this._spinnerVisible = false;
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        Object object;
        if (!this.isViewOnly() && (object = mouseEvent.getSource()) == this._yearLabel) {
            this.showYearSpinner();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        boolean bl;
        int n = mouseWheelEvent.getUnitsToScroll();
        boolean bl2 = bl = n < 0;
        if (bl) {
            if (JideSwingUtilities.isMenuShortcutKeyDown(mouseWheelEvent)) {
                this.prevYear();
            } else {
                this.prevMonth();
            }
        } else if (JideSwingUtilities.isMenuShortcutKeyDown(mouseWheelEvent)) {
            this.nextYear();
        } else {
            this.nextMonth();
        }
    }

    public void enableMouseWheel() {
        this.removeMouseWheelListener(this);
        this.addMouseWheelListener(this);
    }

    public void disableMouseWheel() {
        this.removeMouseWheelListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (!(object instanceof Component)) {
            return;
        }
        Component component = (Component)object;
        if (this._dayMap.containsKey(component)) {
            this.setSelectedDate(this._dayMap.get(component));
            this._selectedCalendar = this.getSelectedCalendar();
            this.changeSelectedCalender();
            this.updateCalendar();
        } else if (object instanceof JMenuItem) {
            Container container = ((JMenuItem)object).getParent();
            for (int i = 0; i < container.getComponentCount(); ++i) {
                Component component2 = container.getComponent(i);
                if (component2 != object) continue;
                this._displayedCalendar.set(2, i);
                this.updateCalendar();
                break;
            }
        } else if (object == this._prevButton) {
            this.hideYearSpinner();
            this._displayedCalendar.roll(1, -1);
            this.updateCalendar();
        } else if (object == this._nextButton) {
            this.hideYearSpinner();
            this._displayedCalendar.roll(1, 1);
            this.updateCalendar();
        } else if (object == this._noneButton) {
            this.hideYearSpinner();
            this.setSelectedDate(null);
        } else if (object == this._thisMonthButton) {
            this.hideYearSpinner();
            this.setSelectedCalendar(this._todaysCalendar);
        }
    }

    Calendar getSelectedDateInMemory() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, this._selectedYear);
        calendar.set(2, this._selectedMonth);
        return calendar;
    }

    public Date getSelectedDate() {
        if (this.getSelectedCalendar() != null) {
            return this.getSelectedCalendar().getTime();
        }
        return null;
    }

    public Calendar getSelectedCalendar() {
        Object object = this.getSelectedObject();
        if (object instanceof Calendar) {
            return (Calendar)((Calendar)object).clone();
        }
        if (object instanceof Date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)object);
            return calendar;
        }
        return null;
    }

    public void setSelectedDate(Date date) {
        if (date == null) {
            this.setSelectedObject(null);
        } else {
            Calendar calendar = this.getMonthCalendar();
            calendar.setTime(date);
            this.setSelectedCalendar(calendar);
        }
    }

    protected Calendar getMonthCalendar() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 1);
        calendar.set(10, 0);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    protected void updateMonthCalendar(Calendar calendar) {
        calendar.set(5, 1);
    }

    public void setSelectedCalendar(Calendar calendar) {
        if (this._dateModel.isValidDate(calendar)) {
            if (calendar != null) {
                this.setSelectedObject(calendar.clone());
            } else {
                this.setSelectedObject(null);
            }
        }
    }

    private void commit() {
        this.hideYearSpinner();
        Date date = this._selectedCalendar.getTime();
        if (date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            this.setSelectedCalendar(calendar);
        } else {
            this.setSelectedCalendar(null);
        }
    }

    public boolean setDisplayedYear(int n) {
        Calendar calendar = this.getMonthCalendar();
        calendar.set(1, n);
        if (this._dateModel.yearInRange(calendar)) {
            this._displayedCalendar = calendar;
            this.updateCalendar();
            return true;
        }
        return false;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            if (this.getSelectedCalendar() == null) {
                this._selectedYear = 0;
                this._selectedMonth = 0;
            } else {
                this._selectedCalendar = this.getSelectedCalendar();
                this.changeSelectedCalender();
                this.setDisplayedYear(this._selectedCalendar.get(1));
            }
            this.updateCalendar();
        }
    }

    protected Component createMonthsPanel() {
        JPanel jPanel = this.createPanel(new BorderLayout());
        jPanel.add(this.createMonthPanel(), "Center");
        jPanel.setBackground(this._background);
        jPanel.setForeground(this._foreground);
        return jPanel;
    }

    protected Component createMonthPanel() {
        JPanel jPanel = this.createPanel(new GridLayout(4, 3, this._horizontalGap, this._verticalGap));
        for (int i = 0; i < this._monthLabels.length; ++i) {
            this._monthLabels[i] = this.createMonthLabel(i);
            jPanel.add(this._monthLabels[i]);
        }
        jPanel.setBackground(this._background);
        jPanel.setForeground(this._foreground);
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        return jPanel;
    }

    @Override
    void configureSelectAction(DelegateAction delegateAction) {
        for (JComponent jComponent : this._monthLabels) {
            if (jComponent == null) continue;
            DelegateAction.replaceAction(jComponent, 0, KeyStroke.getKeyStroke(10, 0), delegateAction);
        }
    }

    private Dimension getPreferredCellSize(AbstractButton abstractButton) {
        Dimension dimension = BasicGraphicsUtils.getPreferredButtonSize(abstractButton, abstractButton.getIconTextGap());
        if (dimension.width < this._cellWidth) {
            dimension.width = this._cellWidth;
        }
        if (dimension.height < this._cellHeight) {
            dimension.height = this._cellHeight;
        }
        return dimension;
    }

    protected JComponent createMonthLabel(int n) {
        JideButton jideButton = new JideButton("0"){

            @Override
            public Dimension getPreferredSize() {
                return MonthChooserPanel.this.getPreferredCellSize(this);
            }
        };
        jideButton.setHorizontalAlignment(this._labelAlignment);
        jideButton.addMouseListener(this);
        jideButton.setBackground(this._background);
        jideButton.setForeground(this._foreground);
        jideButton.setBorder(this._cellBorder);
        jideButton.setFont(null);
        return jideButton;
    }

    protected JTextField getTextField(JSpinner jSpinner) {
        JComponent jComponent = jSpinner.getEditor();
        if (jComponent instanceof JSpinner.DefaultEditor) {
            return ((JSpinner.DefaultEditor)jComponent).getTextField();
        }
        System.err.println("Unexpected editor type: " + jSpinner.getEditor().getClass() + " isn't a descendent of DefaultEditor");
        return null;
    }

    protected Component createYearPanel() {
        this._yearLabel = this.createYearLabel();
        this._yearLabel.addMouseListener(this);
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(this.getMonthCalendar().get(1), 1900, 2100, 1);
        this._yearSpinner = new JSpinner(spinnerNumberModel);
        SpinnerWheelSupport.installMouseWheelSupport((JSpinner)this._yearSpinner);
        this._yearSpinner.setFont(this.getFont());
        ((JSpinner)this._yearSpinner).setEditor(new JSpinner.NumberEditor((JSpinner)this._yearSpinner, "#"));
        this._yearSpinner.setBorder(BorderFactory.createEmptyBorder());
        this._yearSpinner.setForeground(this._yearForeground);
        this._yearSpinner.setBackground(this._yearBackground);
        JTextField jTextField = this.getTextField((JSpinner)this._yearSpinner);
        if (jTextField != null) {
            jTextField.setBorder(BorderFactory.createEmptyBorder());
            jTextField.setColumns(3);
            jTextField.setHorizontalAlignment(4);
            jTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyChar() == '\n') {
                        MonthChooserPanel.this.hideYearSpinner();
                    }
                }
            });
        }
        ((JSpinner)this._yearSpinner).addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Object object = ((JSpinner)MonthChooserPanel.this._yearSpinner).getValue();
                if (object instanceof Integer) {
                    MonthChooserPanel.this.setDisplayedYear((Integer)object);
                    MonthChooserPanel.this.updateCalendar();
                }
            }
        });
        this._yearPanel = this.createPanel(new FlowLayout());
        this._yearPanel.setOpaque(false);
        this._yearPanel.add(this._yearLabel);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setFont(null);
        this._prevButton = new JideButton(new ImageIcon(MaskFilter.createImage(JideIconsFactory.getImageIcon("jide/direction_left.gif").getImage(), Color.BLACK, this._yearForeground)));
        this._prevButton.setPreferredSize(new Dimension(NAVIGATION_BUTTON_WIDTH, NAVIGATION_BUTTON_HEIGHT));
        PortingUtils.removeFocus(this._prevButton);
        this._prevButton.addActionListener(this);
        JPanel jPanel2 = JideSwingUtilities.createCenterPanel(this._prevButton);
        jPanel2.setOpaque(false);
        jPanel.add((Component)jPanel2, "Before");
        this._nextButton = new JideButton(new ImageIcon(MaskFilter.createImage(JideIconsFactory.getImageIcon("jide/direction_right.gif").getImage(), Color.BLACK, this._yearForeground)));
        this._nextButton.setPreferredSize(new Dimension(NAVIGATION_BUTTON_WIDTH, NAVIGATION_BUTTON_HEIGHT));
        PortingUtils.removeFocus(this._nextButton);
        this._nextButton.addActionListener(this);
        jPanel2 = JideSwingUtilities.createCenterPanel(this._nextButton);
        jPanel2.setOpaque(false);
        jPanel.add((Component)jPanel2, "After");
        jPanel.add((Component)this._yearPanel, "Center");
        this._prevButton.setVisible(!this.isViewOnly());
        this._nextButton.setVisible(!this.isViewOnly());
        jPanel.setBorder(this._yearBorder);
        jPanel.setBackground(this._yearBackground);
        jPanel.setForeground(this._yearForeground);
        return jPanel;
    }

    protected Component createButtonPanel() {
        this._buttonPanel = new ButtonPanel(){

            @Override
            public void updateUI() {
                super.updateUI();
                this.clearAttribute();
            }

            private void clearAttribute() {
                this.setFont(null);
                this.setBackground(null);
                this.setForeground(null);
            }
        };
        this._thisMonthButton = new JButton(this.getResourceString("Date.thismonth"));
        this._thisMonthButton.setName("Date.thismonth");
        this._thisMonthButton.setMnemonic(this.getResourceString("Date.thismonth.mnemonic").charAt(0));
        this._thisMonthButton.addActionListener(this);
        this._buttonPanel.addButton(this._thisMonthButton);
        this._noneButton = new JButton(this.getResourceString("Date.none"));
        this._noneButton.setName("Date.none");
        this._noneButton.setMnemonic(this.getResourceString("Date.none.mnemonic").charAt(0));
        this._noneButton.addActionListener(this);
        this._buttonPanel.addButton(this._noneButton);
        JPanel jPanel = this.createPanel(new FlowLayout());
        jPanel.add(this._buttonPanel);
        jPanel.setBorder(this._buttonsBorder);
        jPanel.setBackground(this._background);
        jPanel.setForeground(this._foreground);
        this.updateButtons();
        JideSwingUtilities.setOpaqueRecursively(jPanel, false);
        return jPanel;
    }

    protected void initCalendar() {
        this._todaysCalendar = this.getMonthCalendar();
        this._todaysYear = this._todaysCalendar.get(1);
        this._todaysMonth = this._todaysCalendar.get(2);
        this.setSelectedDate(null);
        this._selectedCalendar = this.getMonthCalendar();
        this._selectedYear = 0;
        this._selectedMonth = 0;
        this.setDisplayedYear(this._selectedCalendar.get(1));
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setBorder(this._border);
        this.setBackground(this._background);
        this.setForeground(this._foreground);
        this.setFont(this._font);
    }

    protected void initComponents() {
        this.setLayout(new BorderLayout(6, 6));
        this.setBorder(this._border);
        this.setBackground(this._background);
        this.setForeground(this._foreground);
        this.setFont(this._font);
        this.add(this.createYearPanel(), "First");
        this.add(this.createMonthsPanel(), "Center");
        if (this._showNoneButton || this._showThisMonthButton) {
            this.add(this.createButtonPanel(), "Last");
        }
        this.setRequestFocusEnabled(true);
        this.setFocusable(true);
        this.registerKeyStrokes();
        this.applyComponentOrientation(this.getComponentOrientation());
    }

    protected void updateCalendar() {
        if (this._displayedCalendar == null) {
            this._displayedCalendar = this.getMonthCalendar();
        } else if (!this.getDateModel().monthInRange(this._displayedCalendar)) {
            if (this.getDateModel().getMaxDate() != null && this._displayedCalendar.getTimeInMillis() > this.getDateModel().getMaxDate().getTimeInMillis()) {
                this._displayedCalendar = this.getDateModel().getMaxDate();
            } else if (this.getDateModel().getMinDate() != null && this._displayedCalendar.getTimeInMillis() < this.getDateModel().getMinDate().getTimeInMillis()) {
                this._displayedCalendar = this.getDateModel().getMinDate();
            }
        }
        this.updateYearLabel(this._yearLabel, this._displayedCalendar);
        this._displayedCalendar.set(2, 0);
        this.updateMonthCalendar(this._displayedCalendar);
        for (int i = 0; i < 12; ++i) {
            this._dayMap.put(this._monthLabels[i], this._displayedCalendar.getTime());
            boolean bl = this.isDateSelected(this._displayedCalendar);
            boolean bl2 = this.isToday(this._displayedCalendar);
            this.updateMonthLabel(this._monthLabels[i], this._displayedCalendar, bl, bl2);
            this._displayedCalendar.roll(2, 1);
            this.updateMonthCalendar(this._displayedCalendar);
        }
        this.invalidate();
    }

    private JPanel createPanel(LayoutManager layoutManager) {
        NullPanel nullPanel = new NullPanel(layoutManager);
        nullPanel.addMouseListener(this);
        return nullPanel;
    }

    public boolean isViewOnly() {
        return this._viewOnly;
    }

    public void setViewOnly(boolean bl) {
        boolean bl2 = this._viewOnly;
        if (bl2 != bl) {
            this._viewOnly = bl;
            this.firePropertyChange(VIEWONLY_PROPERTY, this._viewOnly, bl2);
            if (this._nextButton != null) {
                this._nextButton.setVisible(!bl);
            }
            if (this._prevButton != null) {
                this._prevButton.setVisible(!bl);
            }
            if (this._buttonPanel != null) {
                this._buttonPanel.setVisible(!bl);
                this._buttonPanel.getParent().setVisible(!bl);
            }
            this.revalidate();
            this.updateCalendar();
        }
    }

    protected void updateDayOfWeekLabel(JComponent jComponent, Calendar calendar) {
        if (jComponent instanceof JLabel) {
            ((JLabel)jComponent).setText(this._weekFormatter.format(calendar.getTime()));
        } else if (jComponent instanceof JTextComponent) {
            ((JTextComponent)jComponent).setText(this._weekFormatter.format(calendar.getTime()));
        }
    }

    protected void updateMonthLabel(JComponent jComponent, Calendar calendar, boolean bl, boolean bl2) {
        if (jComponent instanceof JLabel) {
            ((JLabel)jComponent).setText(this._monthFormatter.format(calendar.getTime()));
        } else if (jComponent instanceof AbstractButton) {
            ((AbstractButton)jComponent).setText(this._monthFormatter.format(calendar.getTime()));
        } else if (jComponent instanceof JTextComponent) {
            ((JTextComponent)jComponent).setText(String.valueOf(calendar.get(2)));
        }
        if (this.isViewOnly()) {
            bl = false;
            bl2 = false;
        }
        if (!this._dateModel.isValidDate(calendar)) {
            jComponent.setEnabled(false);
            jComponent.setBackground(new Color(230, 230, 230));
            if (jComponent instanceof AbstractButton) {
                ((AbstractButton)jComponent).setSelected(false);
            }
        } else {
            jComponent.setEnabled(true);
            if (bl) {
                if (jComponent instanceof AbstractButton) {
                    ((AbstractButton)jComponent).setSelected(bl);
                } else {
                    jComponent.setBackground(this._selectedDateBackground);
                    jComponent.setForeground(this._selectedDateForeground);
                }
            } else if (jComponent instanceof AbstractButton) {
                ((AbstractButton)jComponent).setSelected(bl);
            } else {
                jComponent.setBackground(this._background);
                jComponent.setForeground(this._normalDateColor);
            }
        }
        if (bl2) {
            jComponent.setBorder(this._todayBorder);
        } else {
            jComponent.setBorder(this._cellBorder);
        }
    }

    protected void updateYearLabel(JComponent jComponent, Calendar calendar) {
        if (jComponent instanceof JLabel) {
            ((JLabel)jComponent).setText(this._yearFormatter.format(this._displayedCalendar.getTime()));
        }
    }

    protected JComponent createYearLabel() {
        return new NullLabel("0000");
    }

    private void prevMonth() {
        this.hideYearSpinner();
        this._selectedCalendar.add(2, -1);
        if (this.isMonthOutOfRange(this._selectedCalendar)) {
            this._selectedCalendar.add(2, 1);
            return;
        }
        this.changeSelectedCalender();
        this.setDisplayedYear(this._selectedCalendar.get(1));
    }

    private void nextMonth() {
        this.hideYearSpinner();
        this._selectedCalendar.add(2, 1);
        if (this.isMonthOutOfRange(this._selectedCalendar)) {
            this._selectedCalendar.add(2, -1);
            return;
        }
        this.changeSelectedCalender();
        this.setDisplayedYear(this._selectedCalendar.get(1));
    }

    private void prevSeason() {
        this.hideYearSpinner();
        this._selectedCalendar.add(2, -3);
        if (this.isMonthOutOfRange(this._selectedCalendar)) {
            this._selectedCalendar.add(2, 3);
            return;
        }
        this.changeSelectedCalender();
        this.setDisplayedYear(this._selectedCalendar.get(1));
    }

    private void nextSeason() {
        this.hideYearSpinner();
        this._selectedCalendar.add(2, 3);
        if (this.isMonthOutOfRange(this._selectedCalendar)) {
            this._selectedCalendar.add(2, -3);
            return;
        }
        this.changeSelectedCalender();
        this.setDisplayedYear(this._selectedCalendar.get(1));
    }

    private void prevYear() {
        this.hideYearSpinner();
        this._selectedCalendar.add(1, -1);
        if (this.isMonthOutOfRange(this._selectedCalendar)) {
            this._selectedCalendar.add(1, 1);
            return;
        }
        this.changeSelectedCalender();
        this.setDisplayedYear(this._selectedCalendar.get(1));
    }

    private void nextYear() {
        this.hideYearSpinner();
        this._selectedCalendar.add(1, 1);
        if (this.isMonthOutOfRange(this._selectedCalendar)) {
            this._selectedCalendar.add(1, -1);
            return;
        }
        this.changeSelectedCalender();
        this.setDisplayedYear(this._selectedCalendar.get(1));
    }

    private void firstMonth() {
        this.hideYearSpinner();
        this._selectedCalendar.set(2, this._selectedCalendar.getActualMinimum(2));
        if (this.isMonthOutOfRange(this._selectedCalendar)) {
            this._selectedCalendar = this._dateModel.getMinDate();
        }
        this.changeSelectedCalender();
        this.setDisplayedYear(this._selectedCalendar.get(1));
    }

    private void lastMonth() {
        this.hideYearSpinner();
        this._selectedCalendar.set(2, this._selectedCalendar.getActualMaximum(2));
        if (this.isMonthOutOfRange(this._selectedCalendar)) {
            this._selectedCalendar = this._dateModel.getMaxDate();
        }
        this.changeSelectedCalender();
        this.setDisplayedYear(this._selectedCalendar.get(1));
    }

    protected void registerKeyStrokes() {
        this.registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = -8247297922204714531L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonthChooserPanel.this.prevMonth();
            }
        }, KeyStroke.getKeyStroke(37, 0), 1);
        this.registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = 3565852826159995687L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonthChooserPanel.this.nextMonth();
            }
        }, KeyStroke.getKeyStroke(39, 0), 1);
        this.registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = -5072751162756155084L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonthChooserPanel.this.prevSeason();
            }
        }, KeyStroke.getKeyStroke(38, 0), 1);
        this.registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = -6103410982451047429L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonthChooserPanel.this.nextSeason();
            }
        }, KeyStroke.getKeyStroke(40, 0), 1);
        this.registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = -8988153852759059530L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonthChooserPanel.this.prevYear();
            }
        }, KeyStroke.getKeyStroke(33, 0), 1);
        this.registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = 9194558310165823351L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonthChooserPanel.this.nextYear();
            }
        }, KeyStroke.getKeyStroke(34, 0), 1);
        this.registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = 6900079802750207259L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonthChooserPanel.this.firstMonth();
            }
        }, KeyStroke.getKeyStroke(36, 0), 1);
        this.registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = -1028437496809349369L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonthChooserPanel.this.lastMonth();
            }
        }, KeyStroke.getKeyStroke(35, 0), 1);
        this.registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = 7271057711901809362L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonthChooserPanel.this.commit();
            }
        }, KeyStroke.getKeyStroke(10, 0), 1);
    }

    private void changeSelectedCalender() {
        int n = this._selectedYear;
        int n2 = this._selectedMonth;
        this._selectedYear = this._selectedCalendar.get(1);
        this._selectedMonth = this._selectedCalendar.get(2);
        this.firePropertyChange("selectedYear", n, this._selectedYear);
        this.firePropertyChange("selectedMonth", n2, this._selectedMonth);
    }

    protected void updateButtons() {
        if (!this.isShowThisMonthButton()) {
            this._buttonPanel.removeButton(this._thisMonthButton);
        } else {
            this._buttonPanel.addButton(this._thisMonthButton);
        }
        if (!this.isShowNoneButton()) {
            this._buttonPanel.removeButton(this._noneButton);
        } else {
            this._buttonPanel.addButton(this._noneButton);
        }
        if (!this.isShowNoneButton() && !this.isShowThisMonthButton()) {
            this._buttonPanel.setVisible(false);
        } else {
            this._buttonPanel.setVisible(!this.isViewOnly());
        }
        this.revalidate();
    }

    public boolean isShowNoneButton() {
        return this._showNoneButton;
    }

    public void setShowNoneButton(boolean bl) {
        this._showNoneButton = bl;
        if (this._buttonPanel != null) {
            this.updateButtons();
        }
    }

    public boolean isShowThisMonthButton() {
        return this._showThisMonthButton;
    }

    public void setShowThisMonthButton(boolean bl) {
        this._showThisMonthButton = bl;
    }

    protected boolean isDateSelected(Calendar calendar) {
        return calendar.get(1) == this._selectedYear && calendar.get(2) == this._selectedMonth;
    }

    protected boolean isToday(Calendar calendar) {
        return calendar.get(1) == this._todaysYear && calendar.get(2) == this._todaysMonth;
    }

    protected String getResourceString(String string) {
        return DateResource.getResourceBundle(Locale.getDefault()).getString(string);
    }

    protected void initDateFormat(Locale locale) {
        this._monthFormatter = new SimpleDateFormat("MMMM", locale);
        this._yearFormatter = new SimpleDateFormat("yyyy", locale);
        this._weekFormatter = new SimpleDateFormat("E", locale);
    }

    @Override
    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.initDateFormat(locale);
        if (this._inited && this._dayMap != null) {
            this.updateCalendar();
        }
    }

    protected boolean isMonthOutOfRange(Calendar calendar) {
        if (this._dateModel.monthInRange(calendar)) {
            return false;
        }
        PortingUtils.notifyUser();
        return true;
    }

    public Calendar getDisplayedCalendar() {
        return this._selectedCalendar;
    }

    public DateFormat getMonthFormatter() {
        return this._monthFormatter;
    }

    public void setMonthFormatter(DateFormat dateFormat) {
        this._monthFormatter = dateFormat;
        this.updateCalendar();
    }
}

