/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.ExComboBox;
import com.jidesoft.combobox.ListChooserPanel;
import com.jidesoft.combobox.PopupPanel;
import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverter;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.Searchable;
import java.awt.Component;
import java.awt.Font;
import java.util.List;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.UIResource;

public class ListExComboBox
extends ExComboBox {
    public static Object[] BOOLEAN_ARRAY = new Object[]{Boolean.TRUE, Boolean.FALSE};
    private boolean _toggleValueOnDoubleClick = true;
    private JList _list;

    public ListExComboBox() {
        this(new Object[0]);
    }

    public ListExComboBox(Object[] objectArray) {
        this(objectArray, Object.class);
    }

    public ListExComboBox(Vector<?> vector) {
        this(vector, Object.class);
    }

    public ListExComboBox(ComboBoxModel comboBoxModel) {
        this(comboBoxModel, Object.class);
    }

    public ListExComboBox(Object[] objectArray, Class<?> clazz) {
        super(0);
        this.setModel((ComboBoxModel)new DefaultComboBoxModel<Object>(objectArray));
        this.setType(clazz);
        this.setStretchToFit(true);
    }

    public ListExComboBox(Vector<?> vector, Class<?> clazz) {
        super(0);
        this.setModel((ComboBoxModel)new DefaultComboBoxModel(vector));
        this.setType(clazz);
        this.setStretchToFit(true);
    }

    public ListExComboBox(ComboBoxModel comboBoxModel, Class<?> clazz) {
        super(0);
        this.setModel(comboBoxModel);
        this.setType(clazz);
        this.setStretchToFit(true);
    }

    @Override
    public PopupPanel createPopupComponent() {
        ListChooserPanel listChooserPanel = this.createListChooserPanel(this.dataModel, this.getType(), this.getConverter(), this.getConverterContext());
        listChooserPanel.setResizable(true);
        listChooserPanel.setResizableCorners(16);
        listChooserPanel.setMaximumRowCount(this.getMaximumRowCount());
        return listChooserPanel;
    }

    protected ListChooserPanel createListChooserPanel(final ComboBoxModel comboBoxModel, Class<?> clazz, ObjectConverter objectConverter, ConverterContext converterContext) {
        ListChooserPanel listChooserPanel = new ListChooserPanel(comboBoxModel, clazz, objectConverter, converterContext){

            @Override
            protected JList createList(ComboBoxModel comboBoxModel2) {
                JList jList = ListExComboBox.this.createList(comboBoxModel2);
                if (jList == null) {
                    jList = super.createList(comboBoxModel2);
                }
                ListExComboBox.this._list = jList;
                return jList;
            }

            @Override
            protected void setupList(final JList jList) {
                super.setupList(jList);
                jList.setFont(ListExComboBox.this.getFont());
                jList.setForeground(ListExComboBox.this.getForeground());
                jList.setBackground(ListExComboBox.this.getBackground());
                jList.setSelectionForeground(UIManager.getColor("ComboBox.selectionForeground"));
                jList.setSelectionBackground(UIManager.getColor("ComboBox.selectionBackground"));
                jList.setBorder(null);
                jList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent listSelectionEvent) {
                        int n;
                        if (!listSelectionEvent.getValueIsAdjusting() && !Boolean.TRUE.equals(jList.getClientProperty("PopupPanel.selectedByMouseRollover")) && (n = jList.getSelectedIndex()) != -1) {
                            Object e = comboBoxModel.getElementAt(n);
                            if (!JideSwingUtilities.equals(ListExComboBox.this.getEditor().getItem(), e)) {
                                ListExComboBox.this.setSelectedItem(e, false);
                            }
                        }
                    }
                });
                ListExComboBox.this.setupList(jList);
            }
        };
        listChooserPanel.setRenderer(this.getRenderer());
        return listChooserPanel;
    }

    protected JList createList(ComboBoxModel comboBoxModel) {
        return null;
    }

    public JList getList() {
        if (this.isPopupVisible()) {
            return this._list;
        }
        return null;
    }

    @Override
    public boolean selectWithKeyChar(char c) {
        Object object = this.getClientProperty("Searchable");
        return !(object instanceof Searchable) && this.originalSelectWithKeyChar(c);
    }

    protected void setupList(JList jList) {
        Font font = this.getFont();
        if (font != null && !(font instanceof UIResource)) {
            jList.setFont(font);
        }
    }

    @Override
    public List<KeyStroke> getDelegateKeyStrokes() {
        List<KeyStroke> list = super.getDelegateKeyStrokes();
        list.remove(KeyStroke.getKeyStroke(37, 0));
        list.remove(KeyStroke.getKeyStroke(39, 0));
        return list;
    }

    @Override
    protected JComponent getDelegateTarget(PopupPanel popupPanel) {
        return popupPanel instanceof ListChooserPanel ? ((ListChooserPanel)popupPanel).getList() : super.getDelegateTarget(popupPanel);
    }

    public boolean isToggleValueOnDoubleClick() {
        return this._toggleValueOnDoubleClick;
    }

    public void setToggleValueOnDoubleClick(boolean bl) {
        this._toggleValueOnDoubleClick = bl;
    }

    public void toggleValue(Component component, int n) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.dataModel.getSize() == 0) {
            return;
        }
        boolean bl = this.getClientProperty("AbstractComboBox.isTableCellEditor") != null;
        int n2 = this.getNextIndex(n);
        if (bl) {
            this.setSelectedItem(this.dataModel.getElementAt(n2), false);
        } else {
            this.setSelectedItem(this.dataModel.getElementAt(n2));
        }
    }

    private int getNextIndex(int n) {
        if (n == 33) {
            int n2 = this.getMaximumRowCount();
            int n3 = this.getSelectedIndex() - n2;
            return n3 < 0 ? 0 : n3;
        }
        if (n == 34) {
            int n4;
            int n5 = this.getMaximumRowCount();
            int n6 = this.getSelectedIndex() + n5;
            return n6 < (n4 = this.dataModel.getSize()) ? n6 : n4 - 1;
        }
        if (n == 36) {
            return 0;
        }
        if (n == 35) {
            return this.dataModel.getSize() - 1;
        }
        if (n == 40) {
            int n7;
            int n8 = this.getSelectedIndex() + 1;
            return n8 < (n7 = this.dataModel.getSize()) ? n8 : 0;
        }
        if (n == 38) {
            int n9 = this.getSelectedIndex() - 1;
            int n10 = this.dataModel.getSize();
            return n9 < 0 ? n10 - 1 : n9;
        }
        return this.getSelectedIndex();
    }
}

