/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.PopupPanel;
import com.jidesoft.plaf.basic.BasicFolderChooserUI;
import com.jidesoft.swing.FolderChooser;
import com.jidesoft.utils.PortingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import sun.awt.shell.ShellFolder;

public class FolderChooserPanel
extends PopupPanel {
    private FolderChooser _chooser;
    private String _currentDirectoryPath;

    public FolderChooserPanel() {
        this.initComponents();
    }

    public FolderChooserPanel(String string) {
        this._currentDirectoryPath = string;
        this.initComponents();
    }

    protected void initComponents() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.createFolderChooserPanel(), "Center");
    }

    public String getCurrentDirectoryPath() {
        return this._currentDirectoryPath;
    }

    public void setCurrentDirectoryPath(String string) {
        this._currentDirectoryPath = string;
        File file = new File(this._currentDirectoryPath);
        if (ShellFolder.isFileSystemRoot(file)) {
            file = new File(file, ""){
                private static final long serialVersionUID = -7142822461012267488L;

                @Override
                public boolean isDirectory() {
                    return true;
                }

                @Override
                public String getName() {
                    return this.getPath();
                }
            };
        }
        this._chooser.setCurrentDirectory(file);
    }

    protected JComponent createFolderChooserPanel() {
        this._chooser = this.createFolderChooser();
        this._chooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand() != null && actionEvent.getActionCommand().equals("ApproveSelection")) {
                    FolderChooserPanel.this.setSelectedObject(FolderChooserPanel.this._chooser.getSelectedFile());
                } else {
                    FolderChooserPanel.this.setSelectedObject(FolderChooserPanel.this.getSelectedObject());
                }
            }
        });
        PortingUtils.removeFocus(this._chooser);
        JScrollPane jScrollPane = new JScrollPane(this._chooser);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.setTitle(this._chooser.getDialogTitle());
        if (this._chooser != null && this._chooser.getUI() instanceof BasicFolderChooserUI) {
            this.setDefaultFocusComponent(((BasicFolderChooserUI)this._chooser.getUI()).getDefaultFocusComponent());
        }
        return jScrollPane;
    }

    protected FolderChooser createFolderChooser() {
        return new FolderChooser(this._currentDirectoryPath);
    }

    @Override
    public boolean needsButtons() {
        return false;
    }
}

