/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.PopupPanel;
import com.jidesoft.utils.PortingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JScrollPane;

public class FileNameChooserPanel
extends PopupPanel {
    private JFileChooser _chooser;
    private String _currentDirectoryPath;
    private File _currentDirectory;

    public FileNameChooserPanel() {
        this.initComponents();
    }

    public FileNameChooserPanel(String string) {
        this._currentDirectoryPath = string;
        this.initComponents();
    }

    public FileNameChooserPanel(File file) {
        this._currentDirectory = file;
        this.initComponents();
    }

    protected void initComponents() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.createFileChooserPanel(), "Center");
    }

    public File getCurrentDirectory() {
        return this._currentDirectory;
    }

    public void setCurrentDirectory(File file) {
        this._currentDirectory = file;
        this._currentDirectoryPath = file.getAbsolutePath();
        if (this._chooser != null) {
            this._chooser.setCurrentDirectory(this._currentDirectory);
        }
    }

    public String getCurrentDirectoryPath() {
        return this._currentDirectoryPath;
    }

    public void setCurrentDirectoryPath(String string) {
        this._currentDirectoryPath = string;
        this.setCurrentDirectory(new File(this._currentDirectoryPath));
    }

    protected JComponent createFileChooserPanel() {
        this._chooser = this.createFileChooser();
        this._chooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand() != null && actionEvent.getActionCommand().equals("ApproveSelection")) {
                    FileNameChooserPanel.this.setSelectedObject(FileNameChooserPanel.this._chooser.getSelectedFile().getAbsolutePath());
                } else {
                    FileNameChooserPanel.this.setSelectedObject(FileNameChooserPanel.this.getSelectedObject());
                }
            }
        });
        PortingUtils.removeFocus(this._chooser);
        JScrollPane jScrollPane = new JScrollPane(this._chooser);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        return jScrollPane;
    }

    protected JFileChooser createFileChooser() {
        if (this._currentDirectory != null) {
            JFileChooser jFileChooser = new JFileChooser(this._currentDirectory);
            jFileChooser.setSelectedFile(this._currentDirectory);
            return jFileChooser;
        }
        JFileChooser jFileChooser = new JFileChooser(this._currentDirectoryPath);
        try {
            jFileChooser.setSelectedFile(new File(this._currentDirectoryPath));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jFileChooser;
    }

    @Override
    public boolean needsButtons() {
        return false;
    }
}

