/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.PopupPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFileChooser;

public class FileChooserPanel
extends PopupPanel {
    private JFileChooser _chooser;
    private String _currentDirectoryPath;
    private File _currentDirectory;

    public FileChooserPanel() {
        this.initComponents();
    }

    public FileChooserPanel(String string) {
        this._currentDirectoryPath = string;
        this.initComponents();
    }

    public FileChooserPanel(File file) {
        this._currentDirectory = file;
        this.initComponents();
    }

    protected void initComponents() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.createFileChooserPanel(), "Center");
    }

    public File getCurrentDirectory() {
        return this._currentDirectory;
    }

    public void setCurrentDirectory(File file) {
        this._currentDirectory = file;
        if (this._chooser != null && this._currentDirectory != null) {
            this._currentDirectoryPath = this._currentDirectory.getAbsolutePath();
            this._chooser.setCurrentDirectory(new File(this._currentDirectoryPath));
        }
    }

    public String getCurrentDirectoryPath() {
        return this._currentDirectoryPath;
    }

    public void setCurrentDirectoryPath(String string) {
        this._currentDirectoryPath = string;
        if (this._currentDirectoryPath != null) {
            this.setCurrentDirectory(new File(this._currentDirectoryPath));
        }
    }

    protected JComponent createFileChooserPanel() {
        this._chooser = this.createFileChooser();
        this._chooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand() != null && actionEvent.getActionCommand().equals("ApproveSelection")) {
                    FileChooserPanel.this.setSelectedObject(FileChooserPanel.this._chooser.getSelectedFile());
                } else {
                    FileChooserPanel.this.setSelectedObject(FileChooserPanel.this.getSelectedObject());
                }
            }
        });
        this.setTitle(this._chooser.getDialogTitle());
        return this._chooser;
    }

    protected JFileChooser createFileChooser() {
        if (this._currentDirectory != null) {
            JFileChooser jFileChooser = new JFileChooser(this._currentDirectory);
            jFileChooser.setSelectedFile(this._currentDirectory);
            return jFileChooser;
        }
        JFileChooser jFileChooser = new JFileChooser(this._currentDirectoryPath);
        try {
            jFileChooser.setSelectedFile(new File(this._currentDirectoryPath));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jFileChooser;
    }

    @Override
    public boolean needsButtons() {
        return false;
    }
}

