/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.AbstractComboBox;
import com.jidesoft.combobox.ColorChooserPanel;
import com.jidesoft.combobox.PopupPanel;
import com.jidesoft.plaf.LookAndFeelFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class ColorComboBox
extends AbstractComboBox
implements PropertyChangeListener {
    private int _colorMode = 1;
    private boolean _colorValueVisible = true;
    private boolean _colorIconVisible = true;
    private boolean _useAlphaColorButtons = true;
    public static final String PROPERTY_COLOR_MODE = "colorMode";
    public static final String PROPERTY_SELECTED_COLOR = "selectedColor";
    public static final String PROPERTY_COLOR_VALUE_VISIBLE = "colorValueVisible";
    public static final String PROPERTY_COLOR_ICON_VISIBLE = "colorIconVisible";
    private boolean _crossBackGroundStyle = false;
    private boolean _AllowDefaultColor = true;
    private boolean _allowMoreColors = true;
    private boolean _invalidValueAllowed = false;

    public ColorComboBox() {
        super(0);
        this.setType(Color.class);
        this.initComponent();
    }

    public ColorComboBox(int n) {
        super(0);
        this.setType(Color.class);
        this._colorMode = n;
        this.initComponent();
    }

    @Override
    public AbstractComboBox.EditorComponent createEditorComponent() {
        if (this.isEditable()) {
            ColorEditorComponent colorEditorComponent = new ColorEditorComponent(Color.class);
            colorEditorComponent.setColorValueVisible(this.isColorValueVisible());
            colorEditorComponent.setColorIconVisible(this.isColorIconVisible());
            return colorEditorComponent;
        }
        ColorRendererComponent colorRendererComponent = new ColorRendererComponent(Color.class);
        colorRendererComponent.setColorValueVisible(this.isColorValueVisible());
        colorRendererComponent.setColorIconVisible(this.isColorIconVisible());
        return colorRendererComponent;
    }

    @Override
    public PopupPanel createPopupComponent() {
        ColorChooserPanel colorChooserPanel = new ColorChooserPanel(this.getColorMode(), this.isAllowMoreColors(), this.isAllowDefaultColor(), this.getLocale());
        colorChooserPanel.addPropertyChangeListener(PROPERTY_SELECTED_COLOR, this);
        if (this._editor != null && this._editor instanceof ColorEditorComponent) {
            Color color = ((ColorEditorComponent)this._editor)._colorLabel.getColor();
            int n = 255;
            if (color != null && this.isUseAlphaColorButtons()) {
                n = color.getAlpha();
            }
            colorChooserPanel.setAlphaValue(n);
        }
        return colorChooserPanel;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        PopupPanel popupPanel = this.getPopupPanel();
        if (popupPanel instanceof ColorChooserPanel) {
            Color color;
            Object object = propertyChangeEvent.getNewValue();
            if (!this.isUseAlphaColorButtons() && object instanceof Color && this._editor != null && this._editor instanceof ColorEditorComponent && (color = ((ColorEditorComponent)this._editor)._colorLabel.getColor()) != null) {
                object = new Color(((Color)object).getRed(), ((Color)object).getGreen(), ((Color)object).getBlue(), color.getAlpha());
            }
            this.getEditor().setItem(object);
        }
    }

    public int getColorMode() {
        return this._colorMode;
    }

    public void setColorMode(int n) {
        int n2 = this._colorMode;
        if (n2 != n) {
            this._colorMode = n;
            this.firePropertyChange(PROPERTY_COLOR_MODE, n2, this._colorMode);
            this.resetPopup();
        }
    }

    public boolean isAllowDefaultColor() {
        return this._AllowDefaultColor;
    }

    public void setAllowDefaultColor(boolean bl) {
        this._AllowDefaultColor = bl;
        this.resetPopup();
    }

    public boolean isAllowMoreColors() {
        return this._allowMoreColors;
    }

    public void setAllowMoreColors(boolean bl) {
        this._allowMoreColors = bl;
        this.resetPopup();
    }

    public Color getSelectedColor() {
        this.updateColorFromEditorComponent();
        if (this.getSelectedItem() instanceof Color) {
            return (Color)this.getSelectedItem();
        }
        return null;
    }

    protected void updateColorFromEditorComponent() {
        Object object = this.getEditor().getItem();
        Object object2 = this.getSelectedItem();
        if (object instanceof Color && !object.equals(object2)) {
            this.setSelectedItem(object, false);
        } else if (object == null && object2 != null) {
            this.setSelectedItem(null, false);
        }
    }

    public void setSelectedColor(Color color) {
        this.setSelectedItem(color);
    }

    @Override
    public void setSelectedItem(Object object, boolean bl) throws IllegalArgumentException {
        if (object instanceof Color) {
            if (this.isPopupVisible() && !this.isUseAlphaColorButtons()) {
                int n = 255;
                if (this._editor != null && this._editor instanceof ColorEditorComponent && ((ColorEditorComponent)this._editor)._colorLabel != null && ((ColorEditorComponent)this._editor)._colorLabel.getColor() != null) {
                    n = ((ColorEditorComponent)this._editor)._colorLabel.getColor().getAlpha();
                }
                object = new Color(((Color)object).getRed(), ((Color)object).getGreen(), ((Color)object).getBlue(), n);
            }
        } else if (!this.isInvalidValueAllowed() && object != null) {
            object = null;
            bl = false;
        }
        if (!this.isInvalidValueAllowed() && object == null && !this.isAllowDefaultColor()) {
            throw new IllegalArgumentException("Null color not accepted.");
        }
        super.setSelectedItem(object, bl);
    }

    public boolean isCrossBackGroundStyle() {
        return this._crossBackGroundStyle;
    }

    public void setCrossBackGroundStyle(boolean bl) {
        if (this._crossBackGroundStyle != bl) {
            this._crossBackGroundStyle = bl;
            this.repaint();
        }
    }

    public boolean isUseAlphaColorButtons() {
        return this._useAlphaColorButtons;
    }

    public void setUseAlphaColorButtons(boolean bl) {
        if (this._useAlphaColorButtons != bl) {
            this._useAlphaColorButtons = bl;
            if (this._editor != null) {
                this._editor.setItem(this.getSelectedColor());
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.isColorValueVisible()) {
            dimension.width += 20;
        }
        return dimension;
    }

    public boolean isColorValueVisible() {
        return this._colorValueVisible;
    }

    public void setColorValueVisible(boolean bl) {
        boolean bl2 = this._colorValueVisible;
        if (bl2 != bl) {
            this._colorValueVisible = bl;
            if (this.getEditor() instanceof ColorEditorComponent) {
                ((ColorEditorComponent)this.getEditor()).setColorValueVisible(this.isColorValueVisible());
            } else if (this.getEditor() instanceof ColorRendererComponent) {
                ((ColorRendererComponent)this.getEditor()).setColorValueVisible(this.isColorIconVisible());
            }
            this.firePropertyChange(PROPERTY_COLOR_VALUE_VISIBLE, bl2, bl);
        }
    }

    public boolean isColorIconVisible() {
        return this._colorIconVisible;
    }

    public void setColorIconVisible(boolean bl) {
        boolean bl2 = this._colorIconVisible;
        if (bl2 != bl) {
            this._colorIconVisible = bl;
            if (this.getEditor() instanceof ColorEditorComponent) {
                ((ColorEditorComponent)this.getEditor()).setColorIconVisible(this.isColorIconVisible());
            } else if (this.getEditor() instanceof ColorRendererComponent) {
                ((ColorRendererComponent)this.getEditor()).setColorIconVisible(this.isColorIconVisible());
            }
            this.firePropertyChange(PROPERTY_COLOR_ICON_VISIBLE, bl2, bl);
        }
    }

    public boolean isInvalidValueAllowed() {
        return this._invalidValueAllowed;
    }

    public void setInvalidValueAllowed(boolean bl) {
        this._invalidValueAllowed = bl;
    }

    public class ColorLabel
    extends JComponent {
        private static final int MARGIN = 2;
        private static final double RATIO = 1.618;
        private Color _color;

        public ColorLabel() {
            this.setOpaque(false);
        }

        public Color getColor() {
            return this._color;
        }

        public void setColor(Color color) {
            this._color = color;
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension((int)((double)this.getHeight() * 1.618), this.getHeight());
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            int n = this.getHeight();
            int n2 = ColorComboBox.this.isColorValueVisible() ? (int)((double)n * 1.618) : this.getWidth();
            graphics.setColor(Color.gray);
            graphics.drawRect(2, 2, n2 - 4, n - 4 - 1);
            if (ColorComboBox.this.isCrossBackGroundStyle()) {
                graphics.drawLine(2, 2, n2 - 2, n - 2 - 1);
                graphics.drawLine(2, n - 2 - 1, n2 - 2, 2);
            } else {
                graphics.setColor(new Color(204, 204, 204));
                int n3 = n2 - 2 - 1;
                int n4 = n - 2 - 2;
                int n5 = 4;
                int n6 = 4;
                boolean bl = false;
                for (int i = 3; i <= n4; i += n6) {
                    int n7 = bl ? 3 : 3 + n5;
                    boolean bl2 = bl = !bl;
                    while (n7 <= n3) {
                        graphics.fillRect(n7, i, Math.min(n5, n3 - n7 + 1), Math.min(n6, n4 - i + 1));
                        n7 += 2 * n5;
                    }
                }
            }
            if (this.getColor() != null) {
                graphics.setColor(this.getColor());
                graphics.fillRect(3, 3, n2 - 4 - 1, n - 4 - 2);
            }
        }
    }

    public class ColorEditorComponent
    extends AbstractComboBox.DefaultTextFieldEditorComponent {
        private ColorLabel _colorLabel;

        public ColorEditorComponent(Class<?> clazz) {
            super(clazz);
            this._colorLabel = new ColorLabel();
            MouseAdapter mouseAdapter = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() != 2 && SwingUtilities.isLeftMouseButton(mouseEvent) && ColorComboBox.this.isEnabled()) {
                        if (ColorEditorComponent.this._textField.isShowing()) {
                            ColorEditorComponent.this._textField.requestFocus();
                        } else {
                            ColorComboBox.this.requestFocus();
                        }
                        if (!ColorComboBox.this.isEditable() || !ColorComboBox.this.isColorValueVisible()) {
                            ColorComboBox.this.actionPerformed(null);
                        }
                    }
                }
            };
            this._colorLabel.addMouseListener(mouseAdapter);
            this._textField.addMouseListener(mouseAdapter);
            this._colorLabel.setOpaque(false);
            this.add((Component)this._colorLabel, "Before");
        }

        public void updateVisible() {
            if (ColorComboBox.this.isColorIconVisible() && ColorComboBox.this.isColorValueVisible()) {
                this.add((Component)this._colorLabel, "Before");
                this.add((Component)this._textField, "Center");
            } else if (ColorComboBox.this.isColorIconVisible() && !ColorComboBox.this.isColorValueVisible()) {
                this.add((Component)this._colorLabel, "Center");
                this.remove(this._textField);
            } else if (!ColorComboBox.this.isColorIconVisible() && ColorComboBox.this.isColorValueVisible()) {
                this.add((Component)this._textField, "Center");
                this.remove(this._colorLabel);
            } else {
                this.add((Component)this._colorLabel, "Before");
                this.add((Component)this._textField, "Center");
            }
            this.revalidate();
        }

        public void setColorValueVisible(boolean bl) {
            this.updateVisible();
        }

        public void setColorIconVisible(boolean bl) {
            this.updateVisible();
        }

        @Override
        public Object getItem() {
            Object object = super.getItem();
            if (object == null && this.isEditable() && ColorComboBox.this.isInvalidValueAllowed()) {
                object = this.getText();
            }
            return object;
        }

        @Override
        public void setItem(Object object) {
            super.setItem(object);
            if (object instanceof Color) {
                this._colorLabel.setColor((Color)object);
                this._colorLabel.repaint();
                if (ColorComboBox.this._popupPanel != null && ColorComboBox.this._popupPanel instanceof ColorChooserPanel) {
                    int n = 255;
                    if (ColorComboBox.this.isUseAlphaColorButtons()) {
                        n = ((Color)object).getAlpha();
                    }
                    ((ColorChooserPanel)ColorComboBox.this._popupPanel).setAlphaValue(n);
                }
            } else if (object == null) {
                this._colorLabel.setColor(null);
                this._colorLabel.repaint();
                if (ColorComboBox.this._popupPanel != null && ColorComboBox.this._popupPanel instanceof ColorChooserPanel) {
                    ((ColorChooserPanel)ColorComboBox.this._popupPanel).setAlphaValue(255);
                }
            } else if (ColorComboBox.this.isInvalidValueAllowed()) {
                this._colorLabel.setColor(null);
                this._colorLabel.repaint();
                if (ColorComboBox.this._popupPanel != null && ColorComboBox.this._popupPanel instanceof ColorChooserPanel) {
                    ((ColorChooserPanel)ColorComboBox.this._popupPanel).setAlphaValue(255);
                }
                this._textField.setText(object.toString());
            }
        }

        public ColorLabel getColorLabel() {
            return this._colorLabel;
        }
    }

    public class ColorRendererComponent
    extends AbstractComboBox.DefaultRendererComponent {
        private ColorLabel _colorLabel;

        public ColorRendererComponent(Class<?> clazz) {
            super(clazz);
            if (LookAndFeelFactory.isLnfInstalled("apple.laf.AquaLookAndFeel") && LookAndFeelFactory.isLnfInUse("apple.laf.AquaLookAndFeel") || LookAndFeelFactory.isLnfInstalled("com.apple.laf.AquaLookAndFeel") && LookAndFeelFactory.isLnfInUse("com.apple.laf.AquaLookAndFeel")) {
                this.setLayout(new BorderLayout(0, 0));
            } else {
                this.setLayout(new BorderLayout(2, 2));
            }
            this._colorLabel = new ColorLabel();
            this._colorLabel.setOpaque(false);
            this.removeAll();
            this.add((Component)this._colorLabel, "Before");
            this.add((Component)this._rendererPane, "Center");
        }

        public void updateVisible() {
            if (ColorComboBox.this.isColorIconVisible() && ColorComboBox.this.isColorValueVisible()) {
                this.add((Component)this._colorLabel, "Before");
                this.add((Component)this._rendererPane, "Center");
            } else if (ColorComboBox.this.isColorIconVisible() && !ColorComboBox.this.isColorValueVisible()) {
                this.add((Component)this._colorLabel, "Center");
                this.remove(this._rendererPane);
            } else if (!ColorComboBox.this.isColorIconVisible() && ColorComboBox.this.isColorValueVisible()) {
                this.add((Component)this._rendererPane, "Center");
                this.remove(this._colorLabel);
            } else {
                this.add((Component)this._colorLabel, "Before");
                this.add((Component)this._rendererPane, "Center");
            }
            this.revalidate();
        }

        public void setColorValueVisible(boolean bl) {
            this.updateVisible();
        }

        public void setColorIconVisible(boolean bl) {
            this.updateVisible();
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Object object = ColorComboBox.this.getSelectedItem();
            if (object instanceof Color || object == null) {
                this._colorLabel.setColor((Color)object);
            }
        }

        @Override
        protected void paintRendererPane(Graphics graphics, Component component) {
            if (component instanceof JComponent) {
                Insets insets = ((JComponent)component).getInsets();
                if (insets.top == 0 && insets.bottom == 0 && insets.left == 0 && insets.right == 0) {
                    insets = new Insets(1, 1, 1, 1);
                }
                insets.left = (int)((double)insets.left + (this._colorLabel.getBounds().getWidth() + (double)((BorderLayout)this.getLayout()).getVgap()));
                this._rendererPane.paintComponent(graphics, component, this, insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom, true);
            } else {
                this._rendererPane.paintComponent(graphics, component, this, 0, 0, this.getWidth(), this.getHeight(), true);
            }
        }
    }
}

