/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.DefaultButtonProvider;
import com.jidesoft.combobox.TreeChooserPanel;
import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.swing.CheckBoxTree;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.PartialEtchedBorder;
import com.jidesoft.swing.SearchableUtils;
import com.jidesoft.tree.TreeUtils;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JTree;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class CheckBoxTreeChooserPanel
extends TreeChooserPanel
implements DefaultButtonProvider {
    protected JButton _okButton;
    protected JButton _cancelButton;
    protected Action _okAction;
    protected Action _cancelAction;

    public CheckBoxTreeChooserPanel() {
        this(null, null);
    }

    public CheckBoxTreeChooserPanel(Action action, Action action2) {
        this.init(action, action2);
    }

    public CheckBoxTreeChooserPanel(TreeModel treeModel) {
        this(treeModel, null, null);
    }

    public CheckBoxTreeChooserPanel(TreeModel treeModel, Action action, Action action2) {
        super(treeModel);
        this.init(action, action2);
    }

    private void init(Action action, Action action2) {
        this._okAction = action;
        this._cancelAction = action2;
        Component component = this.createButtonPanel(4);
        if (component != null) {
            this.add(component, "Last");
        }
    }

    @Override
    protected JTree createTree(TreeModel treeModel) {
        return new CheckBoxTree(treeModel){

            @Override
            public TreePath getNextMatch(String string, int n, Position.Bias bias) {
                return null;
            }

            @Override
            public void processMouseEvent(MouseEvent mouseEvent) {
                if (JideSwingUtilities.isMenuShortcutKeyDown(mouseEvent)) {
                    mouseEvent = new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers() ^ Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                }
                super.processMouseEvent(mouseEvent);
            }
        };
    }

    @Override
    protected void setupTree(JTree jTree) {
        super.setupTree(jTree);
        SearchableUtils.installSearchable(jTree);
    }

    public void setOkAction(Action action) {
        this._okAction = action;
        if (this._okButton != null) {
            this._okButton.setAction(this._okAction);
        }
        this.init(this.getOkAction(), this.getCancelAction());
    }

    public Action getOkAction() {
        return this._okAction;
    }

    public void setCancelAction(Action action) {
        this._cancelAction = action;
        if (this._cancelButton != null) {
            this._cancelButton.setAction(this._cancelAction);
        }
        this.init(this.getOkAction(), this.getCancelAction());
    }

    public Action getCancelAction() {
        return this._cancelAction;
    }

    @Override
    public JButton getDefaultButton() {
        return this._okButton;
    }

    public Component createButtonPanel(int n) {
        String string = JideSwingUtilities.getOKString(this.getLocale());
        String string2 = JideSwingUtilities.getCancelString(this.getLocale());
        ButtonPanel buttonPanel = new ButtonPanel(n);
        buttonPanel.setBackground(this.getBackground());
        this._okButton = new JButton(string);
        this._okButton.setActionCommand("OK");
        Action action = this.getOkAction();
        if (action != null) {
            if (action.getValue("Name") == null) {
                action.putValue("Name", string);
                action.putValue("ActionCommandKey", "OK");
            }
            this._okButton.setAction(action);
        }
        this._okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CheckBoxTreeChooserPanel.this.getTree() instanceof CheckBoxTree) {
                    TreePath[] treePathArray = ((CheckBoxTree)CheckBoxTreeChooserPanel.this.getTree()).getCheckBoxTreeSelectionModel().getSelectionPaths();
                    if (treePathArray == null) {
                        treePathArray = new TreePath[]{};
                    }
                    CheckBoxTreeChooserPanel.this.setSelectedObject(treePathArray);
                }
            }
        });
        buttonPanel.addButton((AbstractButton)this._okButton, "AFFIRMATIVE");
        this._cancelButton = new JButton(string2);
        this._cancelButton.setActionCommand("Cancel");
        Action action2 = this.getCancelAction();
        if (action2 != null) {
            if (action2.getValue("Name") == null) {
                action2.putValue("Name", string2);
                action2.putValue("ActionCommandKey", "Cancel");
            }
            this._cancelButton.setAction(action2);
        }
        this._cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CheckBoxTreeChooserPanel.this.setSelectedObject(CheckBoxTreeChooserPanel.this.getPreviousSelectedObject());
            }
        });
        buttonPanel.addButton((AbstractButton)this._cancelButton, "CANCEL");
        if (n == 1 || n == 3) {
            buttonPanel.setBorder(BorderFactory.createCompoundBorder(new PartialEtchedBorder(8), BorderFactory.createEmptyBorder(6, 6, 6, 6)));
        } else {
            buttonPanel.setBorder(BorderFactory.createCompoundBorder(new PartialEtchedBorder(1), BorderFactory.createEmptyBorder(6, 6, 6, 6)));
        }
        return buttonPanel;
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        this.setDefaultFocusComponent(this.getTree());
    }

    @Override
    TreeChooserPanel.Handler createHandler() {
        return new CheckBoxTreeHandler();
    }

    @Override
    void registerKeyStrokes(JTree jTree) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        super.itemStateChanged(itemEvent);
        if (itemEvent.getStateChange() == 1) {
            if (itemEvent.getItem() instanceof TreePath) {
                ((CheckBoxTree)this.getTree()).getCheckBoxTreeSelectionModel().setSelectionPath((TreePath)itemEvent.getItem());
            } else if (itemEvent.getItem() instanceof TreePath[] && this.getTree() != null) {
                ((CheckBoxTree)this.getTree()).getCheckBoxTreeSelectionModel().setSelectionPaths((TreePath[])itemEvent.getItem());
            } else if ((itemEvent.getItem() instanceof String || itemEvent.getItem() instanceof String[]) && this.isSearchUserObjectToSelect() && this.getTree() != null) {
                TreeUtils.expandAll(this.getTree());
                String[] stringArray = itemEvent.getItem() instanceof String ? ((String)itemEvent.getItem()).split(";") : (String[])itemEvent.getItem();
                int n = 0;
                for (int i = 0; i < this.getTree().getRowCount(); ++i) {
                    TreePath treePath = this.getTree().getPathForRow(i);
                    if (treePath == null || treePath.getLastPathComponent() == null) continue;
                    for (String string : stringArray) {
                        if (!JideSwingUtilities.equals(((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject(), string.trim())) continue;
                        if (n == 0) {
                            ((CheckBoxTree)this.getTree()).getCheckBoxTreeSelectionModel().setSelectionPath(treePath);
                            ++n;
                            continue;
                        }
                        ((CheckBoxTree)this.getTree()).getCheckBoxTreeSelectionModel().addSelectionPath(treePath);
                    }
                }
            }
        }
    }

    class CheckBoxTreeHandler
    extends TreeChooserPanel.Handler {
        private static final long serialVersionUID = -2026202880324582577L;

        CheckBoxTreeHandler() {
            super(CheckBoxTreeChooserPanel.this);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == CheckBoxTreeChooserPanel.this.getTree()) {
                return;
            }
            super.mouseReleased(mouseEvent);
        }
    }
}

