/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.AbstractComboBox;
import com.jidesoft.combobox.CalculatorPopupPanel;
import com.jidesoft.combobox.PopupPanel;
import com.jidesoft.swing.Calculator;
import com.jidesoft.swing.DelegateAction;
import com.jidesoft.utils.PortingUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class CalculatorComboBox
extends AbstractComboBox {
    private Calculator _calculator;

    public CalculatorComboBox() {
        this(Double.TYPE);
    }

    public CalculatorComboBox(Class<?> clazz) {
        this.setType(clazz);
        this._calculator = this.createCalculator();
        this.initComponent();
        this.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                CalculatorComboBox.this._calculator.commit();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                CalculatorComboBox.this._calculator.commit();
            }
        });
    }

    protected Calculator createCalculator() {
        return new Calculator();
    }

    @Override
    public AbstractComboBox.EditorComponent createEditorComponent() {
        if (this.isEditable()) {
            return new AbstractComboBox.DefaultTextFieldEditorComponent(this.getType()){

                @Override
                protected void registerKeys(JComponent jComponent) {
                    AbstractAction abstractAction = new AbstractAction(){
                        private static final long serialVersionUID = 3102902114238819930L;

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            if (!CalculatorComboBox.this.isPopupVisible()) {
                                CalculatorComboBox.this.showPopup();
                            }
                        }
                    };
                    jComponent.registerKeyboardAction(abstractAction, KeyStroke.getKeyStroke(115, 0), 0);
                    jComponent.registerKeyboardAction(abstractAction, KeyStroke.getKeyStroke(40, 0), 0);
                    jComponent.registerKeyboardAction(abstractAction, KeyStroke.getKeyStroke(40, 512), 0);
                }

                @Override
                protected String convertElementToString(Object object) {
                    return CalculatorComboBox.this.convertElementToString(object);
                }
            };
        }
        return new AbstractComboBox.DefaultRendererComponent(this.getType()){

            @Override
            protected void registerKeys(JComponent jComponent) {
                AbstractAction abstractAction = new AbstractAction(){
                    private static final long serialVersionUID = -298356868151766036L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (!CalculatorComboBox.this.isPopupVisible()) {
                            CalculatorComboBox.this.showPopup();
                        }
                    }
                };
                jComponent.registerKeyboardAction(abstractAction, KeyStroke.getKeyStroke(115, 0), 0);
                jComponent.registerKeyboardAction(abstractAction, KeyStroke.getKeyStroke(40, 0), 0);
                jComponent.registerKeyboardAction(abstractAction, KeyStroke.getKeyStroke(40, 512), 0);
            }

            @Override
            protected String convertElementToString(Object object) {
                return CalculatorComboBox.this.convertElementToString(object);
            }
        };
    }

    @Override
    protected JTextField createTextField() {
        Object object;
        final JTextField jTextField = super.createTextField();
        jTextField.setHorizontalAlignment(11);
        jTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (!Calculator.isValidKeyEvent(keyEvent)) {
                    keyEvent.consume();
                    PortingUtils.notifyUser();
                } else if (Calculator.isEnterOrEqual(keyEvent)) {
                    if (CalculatorComboBox.this.isPopupVisible()) {
                        keyEvent.consume();
                        CalculatorComboBox.this._calculator.updateResult();
                        CalculatorComboBox.this.hidePopup();
                    }
                } else if (Calculator.isOperator(keyEvent) && !CalculatorComboBox.this.isPopupVisible()) {
                    CalculatorComboBox.this.showPopup();
                }
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        this._calculator.registerKeyboardActions(jTextField, 0);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        Object object2 = jTextField.getInputMap(0).get(keyStroke);
        if (object2 != null) {
            object = jTextField.getActionMap().get(object2);
            DelegateAction.replaceAction(jTextField, 0, keyStroke, new LazyDelegateAction(true, (Action)object, jTextField));
        }
        object = KeyStroke.getKeyStroke('=');
        object2 = jTextField.getInputMap(0).get((KeyStroke)object);
        if (object2 != null) {
            Action action = jTextField.getActionMap().get(object2);
            DelegateAction.replaceAction(jTextField, 0, (KeyStroke)object, new LazyDelegateAction(true, action, jTextField));
        }
        for (int i = 0; i <= 9; ++i) {
            KeyStroke keyStroke2 = KeyStroke.getKeyStroke(("" + i).charAt(0));
            object2 = jTextField.getInputMap(0).get(keyStroke2);
            if (object2 == null) continue;
            Action action = jTextField.getActionMap().get(object2);
            DelegateAction.replaceAction(jTextField, 0, keyStroke2, new LazyDelegateAction(false, action, jTextField));
        }
        this._calculator.addPropertyChangeListener("displayText", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                jTextField.setText("" + propertyChangeEvent.getNewValue());
            }
        });
        return jTextField;
    }

    @Override
    public PopupPanel createPopupComponent() {
        return new CalculatorPopupPanel(){

            @Override
            protected Calculator createCalculator() {
                return CalculatorComboBox.this._calculator;
            }
        };
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.getEditor().getEditorComponent()) {
            return;
        }
        ((Component)((Object)this.getEditor())).repaint();
        if (this.isEditable() && this.getEditor() != null) {
            ((Component)((Object)this.getEditor())).requestFocus();
        }
    }

    public Calculator getCalculator() {
        return this._calculator;
    }

    @Override
    public void setSelectedItem(Object object, boolean bl) {
        super.setSelectedItem(object, bl);
        this._calculator.setInitialValue(this.convertElementToString(object));
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        if (this.getPopupPanel() != null && this._calculator.isResultCalculated()) {
            this.getPopupPanel().setSelectedObject(this._calculator.getResult());
        }
        this.firePopupMenuCanceled();
    }

    protected String convertElementToString(Object object) {
        return object != null ? this._calculator.getDisplayFormat().format(object) : "";
    }

    private class LazyDelegateAction
    extends DelegateAction {
        private final boolean _isEuqalAction;
        private static final long serialVersionUID = 2258648528763679043L;

        public LazyDelegateAction(boolean bl, Action action, JComponent jComponent) {
            this._isEuqalAction = bl;
            this.setAction(action);
            this.setTarget(jComponent);
        }

        @Override
        public boolean isEnabled() {
            return this._isEuqalAction && !CalculatorComboBox.this._calculator.isResultCalculated() || !this._isEuqalAction;
        }

        @Override
        public boolean delegateActionPerformed(ActionEvent actionEvent) {
            Action action = this.getAction();
            if (action != null) {
                if (!this._isEuqalAction && CalculatorComboBox.this._calculator.isOverflow()) {
                    CalculatorComboBox.this._calculator.clear();
                }
                action.actionPerformed(new ActionEvent(this.getTarget(), actionEvent.getID(), actionEvent.getActionCommand()));
                return true;
            }
            return false;
        }
    }
}

