/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.util;

import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.GeneralPath;

public class ShapeFactory {
    private static final double root_2 = Math.sqrt(2.0);
    private static final double root_3 = Math.sqrt(3.0);

    private ShapeFactory() {
    }

    public static Shape createDownTriangle2D(double d, double d2, double d3) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)(d - 0.5 * d3), (float)(d2 - 0.5 * d3 / root_3));
        generalPath.lineTo((float)(d + 0.5 * d3), (float)(d2 - 0.5 * d3 / root_3));
        generalPath.lineTo((float)d, (float)(d2 + d3 / root_3));
        generalPath.closePath();
        return generalPath;
    }

    public static Shape createUpTriangle2D(double d, double d2, double d3) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)(d - 0.5 * d3), (float)(d2 + 0.5 * d3 / root_3));
        generalPath.lineTo((float)(d + 0.5 * d3), (float)(d2 + 0.5 * d3 / root_3));
        generalPath.lineTo((float)d, (float)(d2 - d3 / root_3));
        generalPath.closePath();
        return generalPath;
    }

    public static Polygon createDiamond(double d, double d2, double d3) {
        Polygon polygon = new Polygon();
        polygon.addPoint((int)d, (int)(d2 - d3 / root_2));
        polygon.addPoint((int)Math.ceil(d + d3 / root_2), (int)d2);
        polygon.addPoint((int)d, (int)Math.ceil(d2 + d3 / root_2));
        polygon.addPoint((int)(d - d3 / root_2), (int)d2);
        return polygon;
    }

    public static Shape createDiamond2D(double d, double d2, double d3) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(d, d2 - d3 / root_2);
        generalPath.lineTo(d + d3 / root_2, d2);
        generalPath.lineTo(d, d2 + d3 / root_2);
        generalPath.lineTo(d - d3 / root_2, d2);
        generalPath.closePath();
        return generalPath;
    }
}

