/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

abstract class Pool<T> {
    private long expirationTime = 30000L;
    private Map<T, Long> available = new LinkedHashMap<T, Long>();
    private int maxAvailable = 1000;

    protected Pool() {
    }

    public void setExpirationTime(long l) {
        this.expirationTime = l;
    }

    public void setMaxAvailable(int n) {
        this.maxAvailable = n;
    }

    protected abstract T create(Object ... var1);

    public abstract boolean validate(T var1, Object ... var2);

    protected abstract void onExpire(T var1);

    public synchronized T borrow(Object ... objectArray) {
        ArrayList<Object> arrayList;
        long l = System.currentTimeMillis();
        if (this.available.size() > 0) {
            arrayList = new ArrayList();
            for (Map.Entry<T, Long> entry : this.available.entrySet()) {
                T t = entry.getKey();
                long l2 = l - entry.getValue();
                if (l2 > this.expirationTime) {
                    arrayList.add(t);
                    this.onExpire(t);
                    continue;
                }
                if (this.validate(t, objectArray)) {
                    arrayList.add(t);
                    return t;
                }
                arrayList.add(t);
                this.onExpire(t);
            }
            for (Map.Entry<Object, Long> entry : arrayList) {
                this.available.remove(entry);
            }
        }
        arrayList = this.create(objectArray);
        return (T)arrayList;
    }

    public synchronized void replace(T t) {
        if (this.available.size() < this.maxAvailable) {
            this.available.put(t, System.currentTimeMillis());
        }
    }
}

