/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.util;

import java.awt.geom.Point2D;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class Point2DPool {
    private static Point2DPool instance = new Point2DPool();
    private final Queue<Point2D> available = new ConcurrentLinkedQueue<Point2D>();

    private Point2DPool() {
    }

    protected Point2D create(double d, double d2) {
        return new Point2D.Double(d, d2);
    }

    public Point2D borrow(double d, double d2) {
        Point2D point2D = this.available.poll();
        if (point2D == null) {
            point2D = this.create(d, d2);
        } else {
            point2D.setLocation(d, d2);
        }
        return point2D;
    }

    public void replace(Point2D point2D) {
        if (point2D != null) {
            this.available.offer(point2D);
        }
    }

    public void clear() {
        this.available.clear();
    }

    public static Point2DPool instance() {
        return instance;
    }
}

