/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.style;

import com.jidesoft.chart.Orientation;
import com.jidesoft.chart.style.AbstractStyle;
import com.jidesoft.chart.style.LineFillExtent;
import com.jidesoft.chart.xml.XmlBasicStrokeAdapter;
import com.jidesoft.chart.xml.XmlPaintAdapter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

public class LineStyle
extends AbstractStyle {
    public static final int DEFAULT_WIDTH = 1;
    public static final BasicStroke DEFAULT_STROKE = new BasicStroke(1.0f, 2, 2);
    private BasicStroke stroke = DEFAULT_STROKE;
    private Paint fill;
    private Orientation fillOrientation = Orientation.vertical;
    private LineFillExtent fillExtent = LineFillExtent.TO_ZERO;

    public LineStyle() {
    }

    public LineStyle(int n) {
        this.setWidth(n);
    }

    public LineStyle(BasicStroke basicStroke) {
        this.setStroke(basicStroke);
    }

    public LineStyle(Color color, int n) {
        super(color);
        this.setWidth(n);
    }

    public LineStyle(Color color, BasicStroke basicStroke) {
        super(color);
        this.setStroke(basicStroke);
    }

    @XmlJavaTypeAdapter(value=XmlPaintAdapter.class)
    public Paint getFill() {
        return this.fill;
    }

    public void setFill(Paint paint) {
        this.fill = paint;
    }

    public void setFillOrientation(Orientation orientation) {
        this.fillOrientation = orientation;
    }

    public Orientation getFillOrientation() {
        return this.fillOrientation;
    }

    public LineFillExtent getFillExtent() {
        return this.fillExtent;
    }

    public void setFillExtent(LineFillExtent lineFillExtent) {
        this.fillExtent = lineFillExtent;
    }

    public void setWidth(int n) {
        BasicStroke basicStroke = new BasicStroke(n, this.stroke.getEndCap(), this.stroke.getLineJoin(), this.stroke.getMiterLimit(), this.stroke.getDashArray(), this.stroke.getDashPhase());
        this.setStroke(basicStroke);
    }

    @XmlAttribute
    public int getWidth() {
        return this.stroke == null ? 1 : (int)this.stroke.getLineWidth();
    }

    @XmlJavaTypeAdapter(value=XmlBasicStrokeAdapter.class)
    public BasicStroke getStroke() {
        return this.stroke;
    }

    public void setStroke(BasicStroke basicStroke) {
        this.stroke = basicStroke;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.fill == null ? 0 : this.fill.hashCode());
        n = 31 * n + (this.stroke == null ? 0 : this.stroke.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        LineStyle lineStyle = (LineStyle)object;
        if (this.fill == null ? lineStyle.fill != null : !this.fill.equals(lineStyle.fill)) {
            return false;
        }
        return !(this.stroke == null ? lineStyle.stroke != null : !this.stroke.equals(lineStyle.stroke));
    }

    private String toString(BasicStroke basicStroke) {
        if (basicStroke == null) {
            return "<null>";
        }
        float f = basicStroke.getLineWidth();
        float f2 = basicStroke.getMiterLimit();
        int n = basicStroke.getLineJoin();
        int n2 = basicStroke.getEndCap();
        float f3 = basicStroke.getDashPhase();
        return String.format("#<BasicStroke lineWidth=%f miterLimit=%f lineJoin=%d endCap=%d dashPhase=%f>", Float.valueOf(f), Float.valueOf(f2), n, n2, Float.valueOf(f3));
    }

    public String toString() {
        String string = this.stroke == null ? null : this.toString(this.stroke);
        return String.format("#<LineStyle width=%d stroke=%s color=%s fill=%s>", this.getWidth(), string, this.getColor(), this.getFill());
    }
}

