/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.servlet;

import com.jidesoft.chart.servlet.HttpComponentFactory;
import com.jidesoft.chart.util.ChartUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.SwingUtilities;

public class ComponentServlet
extends HttpServlet {
    private static final long serialVersionUID = 7124400889703572316L;
    private Logger logger = Logger.getLogger(ComponentServlet.class.getName());
    private HttpComponentFactory<?> componentFactory;

    public ComponentServlet() {
    }

    public ComponentServlet(HttpComponentFactory<?> httpComponentFactory) {
        this.setComponentFactory(httpComponentFactory);
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
    }

    public HttpComponentFactory<?> getComponentFactory() {
        return this.componentFactory;
    }

    public void setComponentFactory(HttpComponentFactory<?> httpComponentFactory) {
        this.componentFactory = httpComponentFactory;
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        byte[] byArray = this.paintBytes(httpServletRequest);
        if (byArray == null) {
            httpServletResponse.sendError(400);
            return;
        }
        httpServletResponse.setContentType("image/png");
        httpServletResponse.setContentLength(byArray.length);
        httpServletResponse.getOutputStream().write(byArray);
        httpServletResponse.setStatus(200);
    }

    public byte[] paintBytes(final HttpServletRequest httpServletRequest) {
        if (this.componentFactory == null) {
            return null;
        }
        final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Object t = ComponentServlet.this.componentFactory.getInstance(httpServletRequest);
                    BufferedImage bufferedImage = ChartUtils.createImage(t, 2);
                    try {
                        ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        ComponentServlet.this.logger.severe(iOException.getMessage());
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            this.logger.info(interruptedException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            this.logger.info(invocationTargetException.getMessage());
        }
        return byteArrayOutputStream.toByteArray();
    }
}

