/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.render;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.render.AbstractPieLabelRenderer;
import com.jidesoft.chart.render.DefaultPointLabeler;
import com.jidesoft.chart.render.PieLabelRenderer2D;
import com.jidesoft.chart.render.PointLabeler;
import com.jidesoft.chart.style.ChartStyle;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;

public class SimplePieLabelRenderer
extends AbstractPieLabelRenderer
implements PieLabelRenderer2D {
    public static final String PROPERTY_RADIUS_PROPORTION = "Radius Proportion";
    public static final String PROPERTY_POINT_LABELER = "Point Labeler";
    public static final String PROPERTY_OUTLINE_COLOR = "Outline Color";
    public static final String PROPERTY_BACKGROUND = "Background";
    public static final String PROPERTY_FOREGROUND = "Foreground";
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private PointLabeler pointLabeler = new DefaultPointLabeler();
    private double radiusProportion = 0.85;
    private Color background = UIManager.getColor("ToolTip.background");
    private Color outlineColor = Color.darkGray;
    private Stroke outlineStroke = new BasicStroke(1.0f);

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public double getRadiusProportion() {
        return this.radiusProportion;
    }

    public void setRadiusProportion(double d) {
        double d2 = this.radiusProportion;
        this.radiusProportion = d;
        this.support.firePropertyChange(PROPERTY_RADIUS_PROPORTION, d2, d);
    }

    @Override
    public PointLabeler getPointLabeler() {
        return this.pointLabeler;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color color) {
        Color color2 = this.background;
        this.background = color;
        this.support.firePropertyChange(PROPERTY_BACKGROUND, color2, color);
    }

    protected Color createBackground(Chart chart, ChartModel chartModel, Chartable chartable) {
        return this.getBackground();
    }

    public Color getForeground() {
        return this.getLabelColor();
    }

    public void setForeground(Color color) {
        Color color2 = this.getLabelColor();
        this.setLabelColor(color);
        this.support.firePropertyChange(PROPERTY_FOREGROUND, color2, color);
    }

    protected Color createLabelColor(Chart chart, ChartModel chartModel, Chartable chartable) {
        return this.getLabelColor();
    }

    protected Font createLabelFont(Chart chart, ChartModel chartModel, Chartable chartable) {
        return this.getLabelFont();
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public void setOutlineColor(Color color) {
        Color color2 = this.outlineColor;
        this.outlineColor = color;
        this.support.firePropertyChange(PROPERTY_OUTLINE_COLOR, color2, color);
    }

    protected Color createOutlineColor(Chart chart, ChartModel chartModel, Chartable chartable) {
        return this.getOutlineColor();
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(Stroke stroke) {
        this.outlineStroke = stroke;
    }

    @Override
    public void setPointLabeler(PointLabeler pointLabeler) {
        PointLabeler pointLabeler2 = this.pointLabeler;
        this.pointLabeler = pointLabeler;
        this.support.firePropertyChange(PROPERTY_POINT_LABELER, pointLabeler2, pointLabeler);
    }

    @Override
    public int getTickLength() {
        return 0;
    }

    @Override
    public void setTickLength(int n) {
        throw new UnsupportedOperationException("This renderer does not support ticks");
    }

    @Override
    public void renderLabels(Graphics graphics, Chart chart, ChartModel chartModel, Point point, int n, int n2, int[] nArray, ChartStyle chartStyle) {
        float[] fArray = new float[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            fArray[i] = nArray[i];
        }
        this.renderLabels((Graphics2D)graphics, chart, chartModel, (Point2D)point, (double)n, (double)n2, fArray, chartStyle);
    }

    @Override
    public void renderLabels(Graphics2D graphics2D, Chart chart, ChartModel chartModel, Point2D point2D, double d, double d2, float[] fArray, ChartStyle chartStyle) {
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        double d3 = point2D.getX();
        double d4 = point2D.getY();
        double d5 = chartStyle.getPieOffsetAngle();
        graphics2D2.setFont(chart.getFont());
        graphics2D2.setStroke(new BasicStroke(1.0f, 0, 1));
        for (int i = 0; i < fArray.length; ++i) {
            Chartable chartable = chartModel.getPoint(i);
            double d6 = d5 + (double)(fArray[i] / 2.0f);
            double d7 = 0.2;
            ListSelectionModel listSelectionModel = chart.getSelectionsForModel(chartModel);
            boolean bl = listSelectionModel.isSelectedIndex(i);
            int n = bl && chart.isSelectionShowsExplodedSegments() ? (int)(d7 * d / 2.0 * Math.cos(Math.toRadians(d6))) : 0;
            int n2 = bl && chart.isSelectionShowsExplodedSegments() ? -((int)(d7 * d2 / 2.0 * Math.sin(Math.toRadians(d6)))) : 0;
            double d8 = d3 + (double)n + d / 2.0 * this.radiusProportion * Math.cos(Math.toRadians(d6));
            double d9 = d4 + (double)n2 - d2 / 2.0 * this.radiusProportion * Math.sin(Math.toRadians(d6));
            int n3 = d8 - d3 >= 0.0 ? 1 : -1;
            String string = this.pointLabeler.getDisplayText(chartable);
            Font font = this.createLabelFont(chart, chartModel, chartable);
            if (font == null) {
                font = graphics2D2.getFont();
            }
            if (string != null) {
                Serializable serializable;
                Color color;
                double d10;
                FontMetrics fontMetrics = graphics2D2.getFontMetrics(font);
                int n4 = fontMetrics.stringWidth(string);
                int n5 = fontMetrics.getAscent();
                int n6 = fontMetrics.getHeight();
                double d11 = d10 = n3 > 0 ? (double)((int)d8) : (double)((int)(d8 - (double)n4));
                if (d10 < 0.0) {
                    d10 = 0.0;
                } else if (d10 + (double)n4 > (double)chart.getXEnd()) {
                    d10 = chart.getXEnd() - n4;
                }
                double d12 = (int)d9 - fontMetrics.getHeight() / 2;
                int n7 = chart.getSize().height;
                int n8 = fontMetrics.getHeight();
                if (d12 < 0.0) {
                    d12 = 0.0;
                } else if (d12 + (double)n8 > (double)n7) {
                    d12 = n7 - n6;
                }
                Rectangle2D.Double double_ = new Rectangle2D.Double(d10, d12, n4 + 2, fontMetrics.getHeight());
                Color color2 = this.createBackground(chart, chartModel, chartable);
                if (color2 != null) {
                    graphics2D2.setColor(color2);
                    graphics2D2.fill(double_);
                }
                if ((color = this.createOutlineColor(chart, chartModel, chartable)) != null) {
                    graphics2D2.setColor(color);
                    graphics2D2.setStroke(this.getOutlineStroke());
                    serializable = new Rectangle2D.Double(((RectangularShape)double_).getX() - 1.0, ((RectangularShape)double_).getY() - 1.0, ((RectangularShape)double_).getWidth() + 1.0, ((RectangularShape)double_).getHeight() + 1.0);
                    graphics2D2.draw((Shape)((Object)serializable));
                }
                if ((serializable = this.createLabelColor(chart, chartModel, chartable)) != null) {
                    graphics2D2.setFont(font);
                    graphics2D2.setColor((Color)serializable);
                    graphics2D2.drawString(string, (float)(((RectangularShape)double_).getX() + 1.0), (float)(((RectangularShape)double_).getY() + (double)n5));
                }
            }
            d5 += (double)fArray[i];
        }
        graphics2D2.dispose();
    }
}

