/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.render;

import com.jidesoft.chart.util.ChartUtils;
import com.jidesoft.swing.ShadowRenderer;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class ShadowFactory
implements ShadowRenderer {
    public static final String PROPERTY_SHADOW_SIZE = "shadowSize";
    public static final String PROPERTY_SHADOW_OPACITY = "shadowOpacity";
    public static final String PROPERTY_SHADOW_COLOR = "shadowColor";
    private int size = 5;
    private float opacity = 0.5f;
    private Color color = Color.BLACK;
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    public ShadowFactory() {
        this(5, 0.5f, Color.BLACK);
    }

    public ShadowFactory(int n, float f, Color color) {
        this.setSize(n);
        this.setOpacity(f);
        this.setColor(color);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color != null) {
            Color color2 = this.color;
            this.color = color;
            this.changeSupport.firePropertyChange(PROPERTY_SHADOW_COLOR, color2, this.color);
        }
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void setOpacity(float f) {
        float f2 = this.opacity;
        this.opacity = (double)f < 0.0 ? 0.0f : (f > 1.0f ? 1.0f : f);
        this.changeSupport.firePropertyChange(PROPERTY_SHADOW_OPACITY, Float.valueOf(f2), Float.valueOf(this.opacity));
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        int n2 = this.size;
        this.size = n < 0 ? 0 : n;
        this.changeSupport.firePropertyChange(PROPERTY_SHADOW_SIZE, (Object)n2, (Object)this.size);
    }

    @Override
    public BufferedImage createShadow(BufferedImage bufferedImage) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = this.size * 2;
        int n8 = bufferedImage.getWidth();
        int n9 = bufferedImage.getHeight();
        int n10 = n8 + n7;
        int n11 = n9 + n7;
        int n12 = this.size;
        int n13 = n7 - n12;
        int n14 = n11 - n13;
        int n15 = this.color.getRGB() & 0xFFFFFF;
        int[] nArray = new int[n7];
        BufferedImage bufferedImage2 = new BufferedImage(n10, n11, 2);
        if (this.size == 0) {
            return bufferedImage2;
        }
        int[] nArray2 = new int[n10 * n11];
        int[] nArray3 = new int[n8 * n9];
        ChartUtils.getPixels(bufferedImage, 0, 0, n8, n9, nArray3);
        int n16 = n13 * n10;
        float f = 1.0f / (float)n7;
        float f2 = this.opacity / (float)n7;
        int[] nArray4 = new int[256 * n7];
        for (int i = 0; i < nArray4.length; ++i) {
            nArray4[i] = (int)((float)i * f);
        }
        int[] nArray5 = new int[256 * n7];
        for (n6 = 0; n6 < nArray5.length; ++n6) {
            nArray5[n6] = (int)((float)n6 * f2);
        }
        int n17 = n12 * n10;
        for (n5 = 0; n5 < n9; ++n5) {
            n4 = 0;
            while (n4 < n7) {
                nArray[n4++] = 0;
            }
            n3 = 0;
            n4 = 0;
            n6 = n5 * n8;
            for (n2 = 0; n2 < n8; ++n2) {
                n = nArray4[n3];
                nArray2[n17++] = n << 24;
                n3 -= nArray[n4];
                nArray[n4] = n = nArray3[n6 + n2] >>> 24;
                n3 += n;
                if (++n4 < n7) continue;
                n4 -= n7;
            }
            for (n2 = 0; n2 < n7; ++n2) {
                n = nArray4[n3];
                nArray2[n17++] = n << 24;
                n3 -= nArray[n4];
                if (++n4 < n7) continue;
                n4 -= n7;
            }
        }
        n5 = 0;
        n17 = 0;
        while (n5 < n10) {
            n3 = 0;
            n4 = 0;
            while (n4 < n12) {
                nArray[n4++] = 0;
            }
            n2 = 0;
            while (n2 < n13) {
                n = nArray2[n17] >>> 24;
                nArray[n4++] = n;
                n3 += n;
                ++n2;
                n17 += n10;
            }
            n17 = n5;
            n4 = 0;
            n2 = 0;
            while (n2 < n14) {
                n = nArray5[n3];
                nArray2[n17] = n << 24 | n15;
                n3 -= nArray[n4];
                nArray[n4] = n = nArray2[n17 + n16] >>> 24;
                n3 += n;
                if (++n4 >= n7) {
                    n4 -= n7;
                }
                ++n2;
                n17 += n10;
            }
            n2 = n14;
            while (n2 < n11) {
                n = nArray5[n3];
                nArray2[n17] = n << 24 | n15;
                n3 -= nArray[n4];
                if (++n4 >= n7) {
                    n4 -= n7;
                }
                ++n2;
                n17 += n10;
            }
            n17 = ++n5;
        }
        ChartUtils.setPixels(bufferedImage2, 0, 0, n10, n11, nArray2);
        return bufferedImage2;
    }
}

