/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.render;

import com.jidesoft.chart.model.Chartable;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.ColorUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

class Pie3DSegment
extends JComponent
implements Comparable<Pie3DSegment> {
    public static final double elevationRatio = 0.67;
    static float[] spotlightRatios = new float[]{0.48f, 0.49f, 0.5f, 0.53f};
    private float startAngle;
    private float extent;
    private boolean surfaceDisplayed = true;
    private float displayStartAngle;
    private float displayExtent;
    private int drop;
    private Paint color;
    private boolean selected;
    private int indexInModel;
    private Chartable _chartable;
    private List<Shape> shapes = new ArrayList<Shape>();

    public Pie3DSegment(float f, float f2, Paint paint) {
        this.displayStartAngle = f;
        this.displayExtent = f2;
        this.color = paint;
    }

    public Pie3DSegment(Chartable chartable, float f, float f2, Paint paint) {
        this._chartable = chartable;
        this.displayStartAngle = f;
        this.displayExtent = f2;
        this.color = paint;
    }

    public Chartable getChartable() {
        return this._chartable;
    }

    public List<Shape> getShapes() {
        return this.shapes;
    }

    public int getDrop() {
        return this.drop;
    }

    public void setDrop(int n) {
        this.drop = n;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public boolean isSurfaceDisplayed() {
        return this.surfaceDisplayed;
    }

    public void setSurfaceDisplayed(boolean bl) {
        this.surfaceDisplayed = bl;
    }

    public int getIndexInModel() {
        return this.indexInModel;
    }

    public void setIndexInModel(int n) {
        this.indexInModel = n;
    }

    public void setStartAngle(float f) {
        this.startAngle = f;
    }

    public void setExtent(float f) {
        this.extent = f;
    }

    public float getMidAngle() {
        return this.displayStartAngle + this.displayExtent / 2.0f;
    }

    public float getEndAngle() {
        return this.displayStartAngle + this.displayExtent;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        int n;
        int n2 = 0;
        int n3 = 0;
        Dimension dimension = this.getSize();
        int n4 = n = Math.min(dimension.width, dimension.height);
        this.drop = (int)Math.round((double)n * 0.2);
        int n5 = (int)Math.round(0.67 * (double)(n - this.drop));
        Point point = new Point(n2 + n4 / 2, n3 + n5 / 2);
        this.paintSegment(graphics, point, n4, n5);
    }

    public void paintSegment(Graphics graphics, Point2D point2D, int n, int n2) {
        Object object;
        float f;
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.shapes.clear();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double d = point2D.getX() - (double)n / 2.0;
        double d2 = point2D.getY() - (double)n2 / 2.0;
        Arc2D.Double double_ = new Arc2D.Double(d, d2, n, n2, this.startAngle, this.extent, 2);
        this.shapes.add(double_);
        Paint paint = this.color instanceof Color ? new GradientPaint((int)(d - (double)n / 5.0), 0.0f, ((Color)this.color).darker(), (int)(d + (double)(2 * n) / 5.0), 0.0f, ((Color)this.color).brighter(), true) : this.color;
        graphics2D.setPaint(paint);
        boolean bl = this.displayStartAngle == 0.0f && this.displayExtent == 360.0f;
        float f2 = this.displayStartAngle + this.displayExtent;
        if (Pie3DSegment.crosses360(this.displayStartAngle, this.displayExtent) && !bl) {
            f = 360.0f - this.displayStartAngle;
            object = this.getRim(graphics2D, point2D, n, n2, 0.0f, -f, paint, Color.white);
            graphics2D.fill((Shape)object);
            this.shapes.add((Shape)object);
        }
        if (Pie3DSegment.crosses180(this.displayStartAngle, this.displayExtent)) {
            Shape shape = this.getRim(graphics2D, point2D, n, n2, 180.0f, Pie3DSegment.getDegrees(f2 - 180.0f), paint, Color.white);
            graphics2D.fill(shape);
            this.shapes.add(shape);
        }
        if (this.displayStartAngle >= 180.0f && this.displayStartAngle + this.displayExtent <= 360.0f) {
            Shape shape = this.getRim(graphics2D, point2D, n, n2, this.displayStartAngle, this.displayExtent, paint, Color.white);
            graphics2D.fill(shape);
            this.shapes.add(shape);
        }
        if (this.color instanceof Color) {
            Color color = ColorUtils.getDerivedColor((Color)this.color, 0.48f);
            object = ColorUtils.getDerivedColor((Color)this.color, 0.42f);
            paint = new GradientPaint((float)d, (float)d2, color, (float)(d + (double)n), (float)(d2 + (double)((float)n2 / 2.0f)), (Color)object);
        }
        graphics2D.setPaint(paint);
        if ((Pie3DSegment.isQuadrant4(this.displayStartAngle) || Pie3DSegment.isQuadrant1(this.displayStartAngle)) && !bl) {
            Shape shape = this.getFace(graphics2D, point2D, n, n2, this.displayStartAngle, paint, Color.white);
            graphics2D.fill(shape);
        }
        if (Pie3DSegment.isQuadrant2(f2) || Pie3DSegment.isQuadrant3(f2)) {
            Shape shape = this.getFace(graphics2D, point2D, n, n2, this.displayStartAngle + this.displayExtent, paint, Color.white);
            graphics2D.fill(shape);
        }
        if (this.isSurfaceDisplayed()) {
            Paint paint2 = this.color instanceof Color ? this.getPaint((Color)this.color, point2D, n, n2) : this.color;
            graphics2D.setPaint(paint2);
            graphics2D.fill(double_);
        }
        if (this.displayStartAngle + this.displayExtent > 180.0f) {
            f = Math.max(this.displayStartAngle, 180.0f);
            float f3 = f + (this.displayStartAngle + this.displayExtent - f) < 360.0f ? this.displayStartAngle + this.displayExtent - f : 360.0f - f;
            Arc2D.Double double_2 = new Arc2D.Double(d, d2 + 0.02 * (double)n / 2.0, n, (double)n2 - 0.02 * (double)n, f, f3, 0);
            Arc2D.Double double_3 = new Arc2D.Double(d, d2 - 0.02 * (double)n / 2.0, n, (double)n2 + 0.02 * (double)n, f + f3, -f3, 0);
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo((float)d, (float)d2);
            generalPath.append(double_2, false);
            generalPath.append(double_3, true);
            generalPath.closePath();
            double d3 = point2D.getX() + (double)(n / 2) * Math.cos(Pie3DSegment.radians(240.0));
            double d4 = point2D.getY() - (double)(n2 / 2) * Math.sin(Pie3DSegment.radians(240.0));
            Paint paint3 = JideSwingUtilities.getRadialGradientPaint((float)d3, (float)d4, (float)((double)n / 2.0), new float[]{0.0f, 0.5f}, new Color[]{new Color(255, 255, 255, 100), new Color(255, 255, 255, 0)});
            graphics2D.setPaint(paint3);
            graphics2D.fill(generalPath);
        }
    }

    private Paint getPaint(Color color, Point2D point2D, int n, int n2) {
        double d = point2D.getX();
        double d2 = point2D.getY();
        Color color2 = ColorUtils.getDerivedColor(color, spotlightRatios[0]);
        Color color3 = ColorUtils.getDerivedColor(color, spotlightRatios[1]);
        Color color4 = ColorUtils.getDerivedColor(color, spotlightRatios[2]);
        Color color5 = ColorUtils.getDerivedColor(color, spotlightRatios[3]);
        return JideSwingUtilities.getRadialGradientPaint(new Point2D.Double(d - 0.05 * (double)n, d2 - 0.05 * (double)n2), ((float)n / 2.0f + (float)n2 / 2.0f) / 2.0f, new float[]{0.25f, 0.6f, 0.85f, 1.0f}, new Color[]{color5, color4, color3, color2});
    }

    private static Point2D pointOnEllipse(int n, int n2, float f) {
        double d = (double)n / 2.0 * Math.cos(Pie3DSegment.radians(f));
        double d2 = (double)n2 / 2.0 * Math.sin(Pie3DSegment.radians(f));
        return new Point2D.Double(d, d2);
    }

    private Shape getFace(Graphics2D graphics2D, Point2D point2D, int n, int n2, float f, Paint paint, Color color) {
        graphics2D.setPaint(paint);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)point2D.getX(), (float)point2D.getY());
        int n3 = (int)Math.round((double)n / 2.0 * Math.cos(Pie3DSegment.radians(f)));
        int n4 = (int)Math.round((double)n2 / 2.0 * Math.sin(Pie3DSegment.radians(f)));
        generalPath.lineTo((float)(point2D.getX() + (double)n3), (float)(point2D.getY() - (double)n4));
        generalPath.lineTo((float)(point2D.getX() + (double)n3), (float)(point2D.getY() - (double)n4 + (double)this.drop));
        generalPath.lineTo((float)point2D.getX(), (float)(point2D.getY() + (double)this.drop));
        generalPath.closePath();
        return generalPath;
    }

    private Shape getRim(Graphics2D graphics2D, Point2D point2D, int n, int n2, float f, float f2, Paint paint, Color color) {
        GeneralPath generalPath = new GeneralPath();
        Arc2D.Double double_ = new Arc2D.Double(point2D.getX() - (double)n / 2.0, point2D.getY() - (double)n2 / 2.0, n, n2, f, f2, 0);
        Arc2D.Double double_2 = new Arc2D.Double(point2D.getX() - (double)n / 2.0, point2D.getY() - (double)n2 / 2.0 + (double)this.drop, n, n2, f + f2, -f2, 0);
        Point2D point2D2 = Pie3DSegment.pointOnEllipse(n, n2, f);
        Point2D point2D3 = Pie3DSegment.pointOnEllipse(n, n2, f + f2);
        generalPath.moveTo((float)(point2D.getX() + point2D2.getX()), (float)(point2D.getY() - point2D2.getY()));
        generalPath.append(double_.getPathIterator(null), true);
        generalPath.lineTo((float)(point2D.getX() + point2D3.getX()), (float)(point2D.getY() - point2D3.getY() + (double)this.drop));
        generalPath.append(double_2.getPathIterator(null), true);
        generalPath.lineTo((float)(point2D.getX() + point2D2.getX()), (float)(point2D.getY() - point2D2.getY()));
        generalPath.closePath();
        return generalPath;
    }

    public static boolean crosses90(float f, float f2) {
        return Pie3DSegment.crosses360(f - 90.0f, f2);
    }

    public static boolean crosses180(float f, float f2) {
        return Pie3DSegment.crosses360(f - 180.0f, f2);
    }

    public static boolean crosses270(float f, float f2) {
        return Pie3DSegment.crosses360(f - 270.0f, f2);
    }

    public static boolean crosses360(float f, float f2) {
        if (f < 0.0f) {
            return Pie3DSegment.crosses360(f + 360.0f, f2);
        }
        return f + f2 >= 360.0f;
    }

    public static float getDegrees(float f) {
        float f2 = f % 360.0f;
        return f2 < 0.0f ? f2 + 360.0f : f2;
    }

    public static double radians(double d) {
        return Math.PI * 2 * d / 360.0;
    }

    public static boolean isQuadrant1(float f) {
        float f2 = Pie3DSegment.getDegrees(f);
        return f2 >= 0.0f && f2 < 90.0f;
    }

    public static boolean isQuadrant2(float f) {
        float f2 = Pie3DSegment.getDegrees(f);
        return f2 >= 90.0f && f2 < 180.0f;
    }

    public static boolean isQuadrant3(float f) {
        float f2 = Pie3DSegment.getDegrees(f);
        return f2 >= 180.0f && f2 < 270.0f;
    }

    public static boolean isQuadrant4(float f) {
        float f2 = Pie3DSegment.getDegrees(f);
        return f2 >= 270.0f && f2 < 360.0f;
    }

    @Override
    public int compareTo(Pie3DSegment pie3DSegment) {
        float f = Pie3DSegment.distanceFrom90((this.displayStartAngle + this.getEndAngle()) / 2.0f);
        float f2 = Pie3DSegment.distanceFrom90((pie3DSegment.displayStartAngle + pie3DSegment.getEndAngle()) / 2.0f);
        if (Pie3DSegment.crosses90(this.displayStartAngle, this.displayExtent)) {
            return -1;
        }
        if (Pie3DSegment.crosses90(pie3DSegment.displayStartAngle, pie3DSegment.displayExtent)) {
            return 1;
        }
        if (Pie3DSegment.crosses270(this.displayStartAngle, this.displayExtent)) {
            return 1;
        }
        if (Pie3DSegment.crosses270(pie3DSegment.displayStartAngle, pie3DSegment.displayExtent)) {
            return -1;
        }
        if (f < f2) {
            return -1;
        }
        if (f2 < f) {
            return 1;
        }
        return 0;
    }

    private static float distanceFrom90(float f) {
        float f2 = Pie3DSegment.getDegrees(f);
        if (f2 >= 90.0f && f2 <= 270.0f) {
            return f2 - 90.0f;
        }
        if (f2 < 90.0f) {
            return 90.0f - f2;
        }
        return 90.0f + (360.0f - f2);
    }

    public int hashCode() {
        int n = 1;
        n = (int)((float)(31 * n) + this.displayExtent);
        n = (int)((float)(31 * n) + this.displayStartAngle);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Pie3DSegment pie3DSegment = (Pie3DSegment)object;
        if (this.displayExtent != pie3DSegment.displayExtent) {
            return false;
        }
        return this.displayStartAngle == pie3DSegment.displayStartAngle;
    }

    @Override
    public String toString() {
        return String.format("#<Pie3DSegment startAngle=%.2f extent=%.2f endAngle=%.2f Color=%s>", Float.valueOf(this.displayStartAngle), Float.valueOf(this.displayExtent), Float.valueOf(this.getEndAngle()), this.color);
    }
}

