/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.render;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.ChartableND;
import com.jidesoft.chart.render.AbstractPointRenderer;
import com.jidesoft.chart.render.CandlestickChartType;
import com.jidesoft.chart.style.ChartStyle;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class CandlestickPointRenderer
extends AbstractPointRenderer {
    public static final String PROPERTY_CANDLESTICK_TYPE = "Candlestick Type";
    private CandlestickChartType candlestickType = CandlestickChartType.BAR;
    private double lineTickLengthProportion = 0.5;
    private Integer tickLength = null;

    public CandlestickPointRenderer() {
        this.setOutlineColor(Color.black);
    }

    public CandlestickPointRenderer(CandlestickChartType candlestickChartType) {
        this.setCandlestickType(candlestickChartType);
        this.setOutlineColor(Color.black);
    }

    public CandlestickChartType getCandlestickType() {
        return this.candlestickType;
    }

    public double getLineTickLengthProportion() {
        return this.lineTickLengthProportion;
    }

    public void setLineTickLengthProportion(double d) {
        this.lineTickLengthProportion = d;
    }

    public Integer getTickLength() {
        return this.tickLength;
    }

    public void setTickLength(Integer n) {
        this.tickLength = n;
    }

    public void setCandlestickType(CandlestickChartType candlestickChartType) {
        CandlestickChartType candlestickChartType2 = this.candlestickType;
        this.candlestickType = candlestickChartType;
        this.support.firePropertyChange(PROPERTY_CANDLESTICK_TYPE, (Object)candlestickChartType2, (Object)candlestickChartType);
    }

    @Override
    public Shape renderPoint(Graphics graphics, Chart chart, ChartModel chartModel, Chartable chartable, boolean bl, boolean bl2, boolean bl3, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        ChartStyle chartStyle = this.getStyle(chart, chartModel, chartable, bl, bl2, bl3);
        if (!chartStyle.isPointsVisible()) {
            return null;
        }
        if (chartable == null || !(chartable instanceof ChartableND)) {
            return null;
        }
        ChartableND chartableND = (ChartableND)chartable;
        double d = chartableND.get(0).position();
        double d2 = chartableND.get(1).position();
        double d3 = chartableND.get(2).position();
        double d4 = chartableND.get(3).position();
        Point2D point2D = chart.calculatePixelPoint2D(new Point2D.Double(d - d3 / 2.0, d2 - d4 / 2.0));
        Point2D point2D2 = chart.calculatePixelPoint2D(new Point2D.Double(d + d3 / 2.0, d2 + d4 / 2.0));
        double d5 = chartableND.get(4).position();
        double d6 = chartableND.get(5).position();
        Point point = chart.calculatePixelPoint(new Point2D.Double(d, d5));
        Point point2 = chart.calculatePixelPoint(new Point2D.Double(d, d6));
        Shape shape = this.candlestickType == CandlestickChartType.LINE ? this.renderPointAsLine(graphics2D, chart, n, n2, point2D, point2D2, point2, point, chartStyle) : this.renderPointAsBar(graphics2D, chart, n, n2, point2D, point2D2, point2, point, chartStyle);
        return shape;
    }

    private Shape renderPointAsLine(Graphics2D graphics2D, Chart chart, int n, int n2, Point2D point2D, Point2D point2D2, Point point, Point point2, ChartStyle chartStyle) {
        double d = point2D2.getX() - point2D.getX();
        double d2 = this.tickLength != null ? (double)this.tickLength.intValue() : d * this.lineTickLengthProportion;
        BasicStroke basicStroke = chartStyle.getLineStroke();
        if (basicStroke != null) {
            graphics2D.setStroke(basicStroke);
        }
        Color color = chartStyle.getPointColor();
        graphics2D.setColor(color);
        graphics2D.drawLine(n, point.y, n, point2.y);
        Line2D.Double double_ = new Line2D.Double((double)n - d2, point2D.getY(), n, point2D.getY());
        graphics2D.draw(double_);
        Line2D.Double double_2 = new Line2D.Double(n, point2D2.getY(), (double)n + d2, point2D2.getY());
        graphics2D.draw(double_2);
        return null;
    }

    private Shape renderPointAsBar(Graphics2D graphics2D, Chart chart, int n, int n2, Point2D point2D, Point2D point2D2, Point point, Point point2, ChartStyle chartStyle) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7 = Math.abs(point2D.getY() - point2D2.getY());
        double d8 = Math.abs(point2D2.getX() - point2D.getX());
        double d9 = point2D.getY() > point2D2.getY() ? point2D.getY() : point2D2.getY();
        double d10 = d6 = point2D.getY() > point2D2.getY() ? point2D2.getY() : point2D.getY();
        assert (d9 >= d6);
        graphics2D.setColor(this.getOutlineColor());
        if (chart.getAnimationPosition() == 1.0) {
            d5 = d6;
            d4 = d6;
            d3 = d9;
            d2 = point.y;
            d = point2.y;
        } else {
            double d11 = chart.getAnimationPosition();
            d5 = (int)((double)n2 - d11 * ((d7 - 1.0) / 2.0));
            d4 = (int)((double)n2 + d11 * (d6 - (double)n2));
            d3 = (int)((double)n2 + d11 * (d9 - (double)n2));
            d2 = (int)((double)n2 + d11 * (double)(point.y - n2));
            d = (int)((double)n2 + d11 * (double)(point2.y - n2));
        }
        Line2D.Double double_ = new Line2D.Double(n, d4, n, d);
        graphics2D.draw(double_);
        Line2D.Double double_2 = new Line2D.Double(n, d3, n, d2);
        graphics2D.draw(double_2);
        Color color = chartStyle.getPointColor();
        graphics2D.setColor(color);
        double d12 = (double)n - (d8 - 1.0) / 2.0;
        graphics2D.setColor(chartStyle.getPointColor());
        Rectangle2D.Double double_3 = new Rectangle2D.Double(d12, d5, d8, d7);
        graphics2D.fill(double_3);
        graphics2D.setColor(this.getOutlineColor());
        graphics2D.draw(double_3);
        return double_3;
    }
}

