/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.render;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.Orientation;
import com.jidesoft.chart.model.ChartCategory;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.Highlight;
import com.jidesoft.chart.render.AbstractBarRenderer;
import com.jidesoft.chart.render.BarRenderer2D;
import com.jidesoft.chart.render.ZAlignment;
import com.jidesoft.chart.style.ChartStyle;
import com.jidesoft.range.Positionable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class Bar3DRenderer
extends AbstractBarRenderer
implements BarRenderer2D,
Serializable {
    private int breadth;
    private double depthRatio = 0.3;
    private double angle = 35.0;
    private ZAlignment zAlignment = ZAlignment.CENTER;

    @Override
    public int getMinimumBreadth() {
        return this.breadth;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double d) {
        this.angle = d;
    }

    public double getDepthRatio() {
        return this.depthRatio;
    }

    public void setDepthRatio(double d) {
        this.depthRatio = d;
    }

    public ZAlignment getZAlignment() {
        return this.zAlignment;
    }

    public void setZAlignment(ZAlignment zAlignment) {
        this.zAlignment = zAlignment;
    }

    @Override
    public Shape renderBar(Graphics2D graphics2D, Chart chart, ChartModel chartModel, Chartable chartable, boolean bl, boolean bl2, boolean bl3, double d, double d2, double d3, double d4) {
        Highlight highlight;
        Object object;
        Positionable positionable;
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        ChartStyle chartStyle = chart.getStyle(chartModel);
        Orientation orientation = chartStyle == null ? Orientation.vertical : chartStyle.getBarOrientation();
        Positionable positionable2 = chartable == null ? null : chartable.getX();
        Positionable positionable3 = positionable = chartable == null ? null : chartable.getY();
        if (orientation == Orientation.vertical && positionable2 instanceof ChartCategory) {
            object = (ChartCategory)positionable2;
            highlight = ((ChartCategory)object).getHighlight();
            if (highlight != null) {
                chartStyle = chart.getHighlightStyle(highlight);
            }
        } else if (orientation == Orientation.horizontal && positionable instanceof ChartCategory && (highlight = ((ChartCategory)(object = (ChartCategory)positionable)).getHighlight()) != null) {
            chartStyle = chart.getHighlightStyle(highlight);
        }
        object = this.createBarPaint(chart, chartable, chartStyle, bl, bl2, bl3, (int)d, (int)d2, (int)d3, (int)d4);
        if (object == null) {
            object = this.getBarColor(chart, chartable, chartStyle, bl, bl2, bl3);
        }
        boolean bl4 = false;
        if (orientation == Orientation.vertical) {
            if (d3 > (double)bl4) {
                d3 -= (double)bl4;
                d += (double)((float)bl4 / 2.0f);
            } else {
                d3 = 0.0;
            }
        }
        if (orientation == Orientation.horizontal) {
            if (d4 > (double)bl4) {
                d4 -= (double)bl4;
                d2 += (double)((float)bl4 / 2.0f);
            } else {
                d4 = 0.0;
            }
        }
        assert (d3 >= 0.0);
        if (d4 < 0.0) {
            d2 += d4;
            d4 = -d4;
        }
        boolean bl5 = true;
        if ((d4 == 0.0 && orientation == Orientation.vertical || d3 == 0.0 && orientation == Orientation.horizontal) && !this.isZeroHeightBarsVisible()) {
            bl5 = false;
        }
        graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n = orientation == Orientation.vertical ? (int)(this.depthRatio * d3) : (int)(this.depthRatio * d4);
        GeneralPath generalPath = new GeneralPath();
        int n2 = (int)Math.round(Math.cos(Math.toRadians(this.angle)) * (double)n);
        int n3 = (int)Math.round(Math.sin(Math.toRadians(this.angle)) * (double)n);
        this.breadth = Math.max(n2, n3);
        int n4 = Math.round((float)n3 / 2.0f);
        int n5 = Math.round((float)n2 / 2.0f);
        if (this.zAlignment == ZAlignment.FRONT) {
            if (orientation == Orientation.vertical) {
                d2 -= (double)n4;
            } else {
                d += (double)n5;
            }
        } else if (this.zAlignment == ZAlignment.BACK) {
            if (orientation == Orientation.vertical) {
                d2 += (double)n4;
            } else {
                d -= (double)n5;
            }
        }
        if (orientation == Orientation.vertical) {
            d2 += (double)n4;
        } else {
            d -= (double)n5;
        }
        if (bl5) {
            this.paintTop(graphics2D2, (Paint)object, orientation, d, d2, d3, d4, n, n2, n3);
            this.paintSide(graphics2D2, (Paint)object, orientation, d, d2, d3, d4, n, n2, n3);
            this.paintFront(graphics2D2, (Paint)object, orientation, d, d2, d3, d4, n, n2, n3);
        }
        generalPath.moveTo(d + d3 + (double)n2, d2 + d4 - (double)n3);
        generalPath.lineTo(d + d3, d2 + d4);
        generalPath.lineTo(d, d2 + d4);
        generalPath.lineTo(d, d2);
        generalPath.lineTo(d + (double)n2, d2 - (double)n3);
        generalPath.lineTo(d + d3 + (double)n2, d2 - (double)n3);
        generalPath.closePath();
        if (this.alwaysShowOutlines || bl && chart.isSelectionShowsOutline()) {
            Color color = bl && chart.isSelectionShowsOutline() ? this.getSelectionColor() : (this.alwaysShowOutlines ? this.getOutlineColor() : chart.getBackground());
            if (bl5) {
                graphics2D2.setColor(color);
                graphics2D2.setStroke(new BasicStroke(this.getOutlineWidth()));
                graphics2D2.draw(generalPath);
            }
        }
        if (bl5 && this.isLabelsVisible()) {
            if (orientation == Orientation.vertical) {
                this.renderBarLabel(graphics2D2, chart, chartModel, chartable, bl, bl2, bl3, d + (double)n2 / 2.0, d2 - (double)n3, d3, d4);
            } else {
                this.renderBarLabel(graphics2D2, chart, chartModel, chartable, bl, bl2, bl3, d + (double)n2, d2 - (double)n3 / 2.0, d3, d4);
            }
        }
        graphics2D2.dispose();
        return generalPath;
    }

    private void paintSide(Graphics2D graphics2D, Paint paint, Orientation orientation, double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        Paint paint2 = paint instanceof Color ? this.createSidePaint(orientation, (Color)paint, (int)d, (int)d2, (int)d3, (int)d4, (int)d5) : paint;
        graphics2D.setPaint(paint2);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(d + d3, d2);
        generalPath.lineTo(d + d3, d2 + d4);
        generalPath.lineTo(d + d3 + d6, d2 + d4 - d7);
        generalPath.lineTo(d + d3 + d6, d2 - d7);
        generalPath.closePath();
        graphics2D.fill(generalPath);
    }

    private void paintFront(Graphics2D graphics2D, Paint paint, Orientation orientation, double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        Paint paint2 = paint instanceof Color ? this.createFrontPaint(orientation, (Color)paint, (int)d, (int)d2, (int)d3, (int)d4, (int)d5) : paint;
        graphics2D.setPaint(paint2);
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, d3, d4);
        graphics2D.fill(double_);
    }

    private void paintTop(Graphics2D graphics2D, Paint paint, Orientation orientation, double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        Paint paint2 = paint instanceof Color ? this.createTopPaint(orientation, (Color)paint, (int)d, (int)d2, (int)d3, (int)d4, (int)d5) : paint;
        graphics2D.setPaint(paint2);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(d, d2);
        generalPath.lineTo(d + d3, d2);
        generalPath.lineTo(d + d3 + d6, d2 - d7);
        generalPath.lineTo(d + d6, d2 - d7);
        graphics2D.fill(generalPath);
    }

    @Override
    public Shape renderBar(Graphics graphics, Chart chart, ChartModel chartModel, Chartable chartable, boolean bl, boolean bl2, boolean bl3, int n, int n2, int n3, int n4) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        return this.renderBar(graphics2D, chart, chartModel, chartable, bl, bl2, bl3, (double)n, (double)n2, (double)n3, (double)n4);
    }

    protected Paint createTopPaint(Orientation orientation, Color color, int n, int n2, int n3, int n4, int n5) {
        int n6 = (int)Math.round(Math.sin(Math.toRadians(this.angle)) * (double)n5);
        int n7 = Math.round((float)n6 / 2.0f);
        if (orientation == Orientation.vertical) {
            return new GradientPaint(n, n2 + n7, color, n + n3 + n5, n2 - n7, color.brighter());
        }
        return new GradientPaint(n, n2 - n6, color.brighter(), n + n3, n2 - n7, color.brighter().brighter());
    }

    protected Paint createSidePaint(Orientation orientation, Color color, int n, int n2, int n3, int n4, int n5) {
        return new GradientPaint(n, n2, color.darker(), n, n2 + n4, color.darker().darker());
    }

    protected Paint createFrontPaint(Orientation orientation, Color color, int n, int n2, int n3, int n4, int n5) {
        if (orientation == Orientation.vertical) {
            return new GradientPaint(n - n3 / 2, n2, color, n + n3 + n3 / 2, n2, color.darker(), true);
        }
        return new GradientPaint(n, n2, color, n, n2 + n4, color.darker());
    }
}

