/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.render;

import com.jidesoft.chart.Orientation;
import com.jidesoft.chart.render.AxisRenderer;
import com.jidesoft.chart.render.ZAlignment;
import com.jidesoft.utils.ColorUtils;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.io.Serializable;

public class Axis3DRenderer
implements AxisRenderer,
Serializable {
    private double angle = 35.0;
    private int breadth = 10;
    private double depthProportion = 1.0;
    private double frontHeightProportion = 0.3;
    private ZAlignment zAlignment = ZAlignment.CENTER;
    private Integer frontHeight = null;
    private Color color = Color.lightGray;

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double d) {
        this.angle = d;
    }

    public double getDepthProportion() {
        return this.depthProportion;
    }

    public void setDepthProportion(double d) {
        this.depthProportion = d;
    }

    @Override
    public int getBreadth() {
        return this.breadth;
    }

    @Override
    public void setBreadth(int n) {
        assert (n >= 0);
        this.breadth = n;
    }

    public int getFrontHeight() {
        if (this.frontHeight == null) {
            return (int)(this.frontHeightProportion * (double)this.breadth);
        }
        return this.frontHeight;
    }

    public void setFrontHeight(Integer n) {
        this.frontHeight = n;
    }

    public void setFrontHeightProportion(double d) {
        this.frontHeightProportion = d;
    }

    public ZAlignment getZAlignment() {
        return this.zAlignment;
    }

    public void setZAlignment(ZAlignment zAlignment) {
        this.zAlignment = zAlignment;
    }

    @Override
    public void renderAxis(Graphics graphics, int n, int n2, int n3, Orientation orientation) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n4 = this.getFrontHeight();
        int n5 = this.breadth - n4;
        graphics2D.setColor(this.color.brighter());
        if (orientation == Orientation.horizontal) {
            GeneralPath generalPath = new GeneralPath();
            int n6 = (int)((double)n5 * this.depthProportion * Math.sin(Math.toRadians(this.angle)));
            int n7 = (int)((double)n5 * this.depthProportion * Math.cos(Math.toRadians(this.angle)));
            if (this.zAlignment == ZAlignment.FRONT) {
                n += n7;
                n2 -= n6;
            } else if (this.zAlignment == ZAlignment.BACK) {
                n -= n7;
                n2 += n6;
            }
            graphics2D.setPaint(new GradientPaint(n - n7, n2 - n6, ColorUtils.getDerivedColor(this.color, 0.85f), n + n3 - n7, n2 + n6, ColorUtils.getDerivedColor(this.color, 0.55f)));
            generalPath.moveTo(n - n7, n2 + n6);
            generalPath.lineTo(n + n7, n2 - n6);
            generalPath.lineTo(n + n3 + n7, n2 - n6);
            generalPath.lineTo(n + n3 - n7, n2 + n6);
            generalPath.closePath();
            graphics2D.fill(generalPath);
            graphics2D.setColor(this.color);
            GeneralPath generalPath2 = new GeneralPath();
            generalPath2.moveTo(n - n7, n2 + n6);
            generalPath2.lineTo(n + n3 - n7, n2 + n6);
            generalPath2.lineTo(n + n3 - n7, n2 + n6 + n4);
            generalPath2.lineTo(n - n7, n2 + n6 + n4);
            generalPath2.closePath();
            graphics2D.fill(generalPath2);
            graphics2D.setColor(this.color.darker());
            GeneralPath generalPath3 = new GeneralPath();
            generalPath3.moveTo(n + n3 - n7, n2 + n6);
            generalPath3.lineTo(n + n3 - n7, n2 + n6 + n4);
            generalPath3.lineTo(n + n3 + n7, n2 + n4 - n6);
            generalPath3.lineTo(n + n3 + n7, n2 - n6);
            generalPath3.closePath();
            graphics2D.fill(generalPath3);
        } else {
            assert (n3 >= 0);
            int n8 = (int)((double)n5 * this.depthProportion * Math.sin(Math.toRadians(this.angle)));
            int n9 = (int)((double)n5 * this.depthProportion * Math.cos(Math.toRadians(this.angle)));
            GeneralPath generalPath = new GeneralPath();
            if (this.zAlignment == ZAlignment.FRONT) {
                n2 -= n8;
                n += n9;
            } else if (this.zAlignment == ZAlignment.BACK) {
                n2 += n8;
                n -= n9;
            }
            generalPath.moveTo(n - n9, n2 + n3 + n8);
            generalPath.lineTo(n + n9, n2 + n3 - n8);
            generalPath.lineTo(n + n9, n2 - n8);
            generalPath.lineTo(n - n9, n2 + n8);
            generalPath.closePath();
            graphics2D.setColor(this.color.darker());
            graphics2D.fill(generalPath);
            graphics2D.setColor(this.color);
            graphics2D.fillRect(n - n9 - n4, n2 + n8, n4, n3);
            GeneralPath generalPath4 = new GeneralPath();
            generalPath4.moveTo(n + n9 - n4, n2 - n8);
            generalPath4.lineTo(n + n9, n2 - n8);
            generalPath4.lineTo(n - n9, n2 + n8);
            generalPath4.lineTo(n - n9 - n4, n2 + n8);
            generalPath4.closePath();
            graphics2D.setColor(this.color.brighter());
            graphics2D.fill(generalPath4);
        }
    }
}

