/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.render;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.UserToPixelTransform;
import com.jidesoft.chart.axis.Axis;
import com.jidesoft.chart.axis.AxisPlacement;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.render.LineRenderer;
import com.jidesoft.chart.style.ChartStyle;
import com.jidesoft.chart.style.LineFillExtent;
import com.jidesoft.range.Range;
import java.awt.Paint;
import java.awt.Point;
import java.awt.geom.Point2D;

public abstract class AbstractLineRenderer
implements LineRenderer {
    protected Paint createLineFillPaint(ChartModel chartModel, ChartStyle chartStyle, int n, int n2, int n3, int n4) {
        return chartStyle.getLineFill();
    }

    protected float calculateYVerticalExtent(Chart chart, ChartModel chartModel, LineFillExtent lineFillExtent) {
        Point point;
        if (lineFillExtent == LineFillExtent.TO_LEADING_EDGE) {
            return chart.getYStart();
        }
        if (lineFillExtent == LineFillExtent.TO_TRAILING_EDGE) {
            return chart.getYEnd();
        }
        UserToPixelTransform userToPixelTransform = chart.getTransformForModel(chartModel);
        Axis axis = chart.getXAxis();
        Range<?> range = axis.getOutputRange();
        double d = 0.0;
        if (axis.getPlacement() == AxisPlacement.FLOATING) {
            d = axis.getFloatingPosition();
        }
        float f = (point = chart.calculatePixelPoint((Point2D)new Point2D.Double(range.minimum(), d), userToPixelTransform)) == null ? 0.0f : (float)point.getY();
        return f;
    }

    protected float calculateXHorizontalExtent(Chart chart, ChartModel chartModel, LineFillExtent lineFillExtent) {
        Point point;
        if (lineFillExtent == LineFillExtent.TO_LEADING_EDGE) {
            return chart.getXStart();
        }
        if (lineFillExtent == LineFillExtent.TO_TRAILING_EDGE) {
            return chart.getXEnd();
        }
        UserToPixelTransform userToPixelTransform = chart.getTransformForModel(chartModel);
        Axis axis = chart.getYAxis();
        Range<?> range = axis.getOutputRange();
        double d = 0.0;
        if (axis.getPlacement() == AxisPlacement.FLOATING) {
            d = axis.getFloatingPosition();
        }
        float f = (point = chart.calculatePixelPoint((Point2D)new Point2D.Double(d, range.minimum()), userToPixelTransform)) == null ? 0.0f : (float)point.getX();
        return f;
    }
}

