/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.model;

import com.jidesoft.chart.annotation.Annotation;
import com.jidesoft.chart.model.AbstractDelegatingChartModel;
import com.jidesoft.chart.model.AnnotatedChartModel;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.ChartPoint;
import com.jidesoft.chart.model.ChartPoint3D;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.Highlight;
import com.jidesoft.chart.model.RealPosition;
import com.jidesoft.range.Positionable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class WaterfallModelAdapter
extends AbstractDelegatingChartModel {
    public static final Highlight FIRST = new Highlight("First");
    public static final Highlight RISING = new Highlight("Rising");
    public static final Highlight FALLING = new Highlight("Falling");
    public static final Highlight LAST = new Highlight("Last");
    private List<Chartable> points;

    public WaterfallModelAdapter(ChartModel chartModel) {
        this.setDelegate(chartModel);
    }

    @Override
    protected void update() {
        this.points = new ArrayList<Chartable>();
        AnnotatedChartModel annotatedChartModel = this.getDelegate();
        int n = annotatedChartModel == null ? 0 : annotatedChartModel.getPointCount();
        Positionable positionable = null;
        for (int i = 0; i < n; ++i) {
            Chartable chartable = annotatedChartModel.getPoint(i);
            ChartPoint chartPoint = null;
            if (i == 0) {
                positionable = chartable.getY();
                chartPoint = new ChartPoint(chartable.getX(), positionable, FIRST);
            } else if (i == n - 1) {
                positionable = chartable.getY();
                chartPoint = new ChartPoint(chartable.getX(), positionable, LAST);
            } else {
                Positionable positionable2 = chartable.getX();
                Positionable positionable3 = chartable.getY();
                if (positionable3 != null && positionable2 != null) {
                    double d = positionable3.position();
                    if (d > 0.0) {
                        chartPoint = new ChartPoint3D(positionable2.position(), positionable.position() + d, d);
                        chartPoint.setHighlight(RISING);
                    } else {
                        chartPoint = new ChartPoint3D(positionable2.position(), positionable.position(), d);
                        chartPoint.setHighlight(FALLING);
                    }
                    positionable = new RealPosition(positionable.position() + d);
                }
            }
            if (chartPoint == null) continue;
            this.points.add(chartPoint);
        }
    }

    @Override
    public int getAnnotationCount() {
        AnnotatedChartModel annotatedChartModel = this.getDelegate();
        if (annotatedChartModel != null) {
            return annotatedChartModel.getAnnotationCount();
        }
        return 0;
    }

    @Override
    public Annotation getAnnotation(int n) {
        AnnotatedChartModel annotatedChartModel = this.getDelegate();
        if (annotatedChartModel != null) {
            return annotatedChartModel.getAnnotation(n);
        }
        return null;
    }

    @Override
    public boolean isAnnotationsVisible() {
        AnnotatedChartModel annotatedChartModel = this.getDelegate();
        return annotatedChartModel != null && annotatedChartModel.isAnnotationsVisible();
    }

    @Override
    public void setAnnotationsVisible(boolean bl) {
        AnnotatedChartModel annotatedChartModel = this.getDelegate();
        if (annotatedChartModel == null) {
            throw new UnsupportedOperationException("Delegate Model does not support annotations");
        }
        annotatedChartModel.setAnnotationsVisible(bl);
    }

    @Override
    public Chartable getPoint(int n) {
        if (this.points == null) {
            this.update();
        }
        return this.points.get(n);
    }

    @Override
    public int getPointCount() {
        if (this.points == null) {
            this.update();
        }
        return this.points.size();
    }

    @Override
    public boolean isCyclical() {
        return false;
    }

    @Override
    public Iterator<Chartable> iterator() {
        return this.points.iterator();
    }
}

