/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.model;

import com.jidesoft.range.Positionable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TimePosition
implements Positionable {
    private static final DateFormat dateFormat = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
    private long position;

    public TimePosition() {
        this(System.currentTimeMillis());
    }

    public TimePosition(long l) {
        this.position = l;
    }

    public TimePosition(String string, DateFormat dateFormat) throws ParseException {
        Date date = dateFormat.parse(string);
        this.position = date.getTime();
    }

    @Override
    public double position() {
        return this.position;
    }

    public Date getTime() {
        return new Date(this.position);
    }

    @Override
    public int compareTo(Positionable positionable) {
        double d = positionable.position();
        if ((double)this.position < d) {
            return -1;
        }
        if ((double)this.position > d) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        long l = (double)this.position != 0.0 ? Double.doubleToLongBits(this.position) : 0L;
        return (int)(l ^ l >>> 32);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TimePosition timePosition = (TimePosition)object;
        return Double.compare(timePosition.position, this.position) == 0;
    }

    public String toString() {
        String string = dateFormat.format(this.getTime());
        return String.format("#<TimePosition position=%d time='%s'>", this.position, string);
    }
}

