/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.model;

import com.jidesoft.chart.annotation.Annotation;
import com.jidesoft.chart.model.AnnotatedChartModel;
import com.jidesoft.chart.model.ChartCategory;
import com.jidesoft.chart.model.ChartModelIterator;
import com.jidesoft.chart.model.ChartModelListener;
import com.jidesoft.chart.model.ChartPoint;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.Highlight;
import com.jidesoft.chart.model.RealPosition;
import com.jidesoft.range.Category;
import com.jidesoft.range.CategoryRange;
import com.jidesoft.range.NumericRange;
import com.jidesoft.range.Positionable;
import com.jidesoft.range.Range;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class TableToChartAdapter
implements AnnotatedChartModel,
TableModelListener {
    public static final String PROPERTY_X_COLUMN = "XColumn";
    public static final String PROPERTY_Y_COLUMN = "YColumn";
    private TableModel delegate;
    private String name;
    private List<Annotation> annotations = new ArrayList<Annotation>();
    private final List<ChartModelListener> listeners = new CopyOnWriteArrayList<ChartModelListener>();
    private Map<Integer, Highlight> highlights = new HashMap<Integer, Highlight>();
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private Map<Integer, ChartPoint> points = new HashMap<Integer, ChartPoint>();
    private CategoryRange<?> categoryXRange = new CategoryRange();
    private CategoryRange<?> categoryYRange = new CategoryRange();
    private boolean computedRanges = false;
    private double minX;
    private double minY;
    private double maxX;
    private double maxY;
    private boolean cyclical = false;
    private int xColumn = 0;
    private int yColumn = 1;
    private Integer minRow = null;
    private Integer maxRow = null;

    public TableToChartAdapter(String string, TableModel tableModel) {
        this.setDelegate(tableModel);
        this.name = string;
    }

    public void setDelegate(TableModel tableModel) {
        if (this.delegate != null) {
            this.delegate.removeTableModelListener(this);
        }
        this.delegate = tableModel;
        if (this.delegate != null) {
            this.delegate.addTableModelListener(this);
        }
        this.update();
    }

    public TableModel getDelegate() {
        return this.delegate;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void addHighlight(int n, Highlight highlight) {
        this.highlights.put(n, highlight);
        this.points.remove(n);
    }

    public void removeHighlight(int n) {
        this.highlights.remove(n);
        this.points.remove(n);
    }

    public void setRowInterval(Integer n, Integer n2) {
        assert (n2 == null || n == null || n2 >= n);
        this.minRow = n;
        this.maxRow = n2;
        this.update();
    }

    public Integer getMinRow() {
        return this.minRow;
    }

    public void setMinRow(Integer n) {
        this.minRow = n;
        this.update();
    }

    public Integer getMaxRow() {
        return this.maxRow;
    }

    public void setMaxRow(Integer n) {
        this.maxRow = n;
        this.update();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getXColumn() {
        return this.xColumn;
    }

    public void setXColumn(int n) {
        int n2 = this.xColumn;
        this.xColumn = n;
        this.support.firePropertyChange(PROPERTY_X_COLUMN, n2, n);
        this.update();
    }

    public int getYColumn() {
        return this.yColumn;
    }

    public void setYColumn(int n) {
        int n2 = this.yColumn;
        this.yColumn = n;
        this.support.firePropertyChange(PROPERTY_Y_COLUMN, n2, n);
        this.update();
    }

    private void computeRanges() {
        this.maxX = Double.MIN_VALUE;
        this.minX = Double.MAX_VALUE;
        this.maxY = Double.MIN_VALUE;
        this.minY = Double.MAX_VALUE;
        int n = this.getPointCount();
        for (int i = 0; i < n; ++i) {
            Chartable chartable = this.getPoint(i);
            double d = chartable.getX().position();
            double d2 = chartable.getY().position();
            if (d < this.minX) {
                this.minX = d;
            }
            if (d > this.maxX) {
                this.maxX = d;
            }
            if (d2 < this.minY) {
                this.minY = d2;
            }
            if (!(d2 > this.maxY)) continue;
            this.maxY = d2;
        }
        this.computedRanges = true;
    }

    public Range<?> getXRange() {
        if (!this.computedRanges) {
            this.computeRanges();
        }
        if (this.categoryXRange.size() == 0.0) {
            return new NumericRange(this.minX, this.maxX);
        }
        return this.categoryXRange;
    }

    public Range<?> getYRange() {
        if (!this.computedRanges) {
            this.computeRanges();
        }
        if (this.categoryYRange.size() == 0.0) {
            return new NumericRange(this.minY, this.maxY);
        }
        return this.categoryYRange;
    }

    @Override
    public Chartable getPoint(int n) {
        ChartPoint chartPoint = this.points.get(n);
        if (chartPoint == null && n < this.getPointCount()) {
            Serializable serializable;
            Object object;
            Positionable positionable;
            int n2 = this.minRow == null ? 0 : this.minRow;
            Object object2 = this.delegate.getValueAt(n2 + n, this.xColumn);
            Object object3 = this.delegate.getValueAt(n2 + n, this.yColumn);
            if (object2 == null) {
                positionable = null;
            } else if (object2 instanceof Number) {
                object = (Number)object2;
                positionable = new RealPosition(((Number)object).doubleValue());
            } else {
                positionable = new ChartCategory<Object>(object2);
                this.categoryXRange.add((Category<?>)positionable);
            }
            if (object3 == null) {
                object = null;
            } else if (object3 instanceof Number) {
                serializable = (Number)object3;
                object = new RealPosition(serializable.doubleValue());
            } else {
                object = new ChartCategory<Object>(object3);
                this.categoryYRange.add((ChartCategory)object);
            }
            chartPoint = new ChartPoint(positionable, (Positionable)object);
            serializable = this.highlights.get(n);
            if (serializable != null) {
                chartPoint.setHighlight((Highlight)serializable);
            }
            this.points.put(n, chartPoint);
        }
        return chartPoint;
    }

    @Override
    public int getPointCount() {
        if (this.delegate == null) {
            return 0;
        }
        if (this.minRow == null || this.maxRow == null) {
            return this.delegate.getRowCount();
        }
        if (this.minRow < 0 || this.maxRow < 0) {
            return 0;
        }
        return this.maxRow - this.minRow + 1;
    }

    @Override
    public boolean isCyclical() {
        return this.cyclical;
    }

    public void setCyclical(boolean bl) {
        this.cyclical = bl;
    }

    @Override
    public int getAnnotationCount() {
        return this.annotations.size();
    }

    public void clearAnnotations() {
        this.annotations.clear();
    }

    @Override
    public Annotation getAnnotation(int n) {
        return this.annotations.get(n);
    }

    public void addAnnotation(Annotation annotation) {
        this.annotations.add(annotation);
    }

    public void removeAnnotation(Annotation annotation) {
        this.annotations.remove(annotation);
    }

    @Override
    public boolean isAnnotationsVisible() {
        return true;
    }

    @Override
    public void setAnnotationsVisible(boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addChartModelListener(ChartModelListener chartModelListener) {
        if (!this.listeners.contains(chartModelListener)) {
            this.listeners.add(chartModelListener);
        }
    }

    @Override
    public void removeChartModelListener(ChartModelListener chartModelListener) {
        this.listeners.remove(chartModelListener);
    }

    @Override
    public Iterator<Chartable> iterator() {
        return new ChartModelIterator(this);
    }

    public void update() {
        this.points.clear();
        this.categoryXRange = new CategoryRange();
        this.categoryYRange = new CategoryRange();
        this.computedRanges = false;
        this.fireModelChanged();
    }

    protected void fireModelChanged() {
        for (ChartModelListener chartModelListener : this.listeners) {
            chartModelListener.chartModelChanged();
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.update();
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4096)) {
            Lm.showInvalidProductMessage(TableToChartAdapter.class.getName(), 4096);
        }
    }
}

