/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

final class SortedList<E>
implements List<E> {
    protected Comparator<? super E> comparator;
    protected boolean sorted;
    private ArrayList<E> delegate = new ArrayList();

    public SortedList() {
    }

    public SortedList(Collection<E> collection, Comparator<? super E> comparator) {
        this.addAll(collection);
        this.setComparator(comparator);
    }

    @Override
    public void add(int n, E e) {
        this.delegate.add(n, e);
        this.sorted = false;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        this.sorted = false;
        return this.delegate.addAll(collection);
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        this.sorted = false;
        return this.delegate.addAll(n, collection);
    }

    @Override
    public E set(int n, E e) {
        this.sorted = false;
        return this.delegate.set(n, e);
    }

    @Override
    public E get(int n) {
        this.sort();
        return this.delegate.get(n);
    }

    @Override
    public void clear() {
        this.delegate.clear();
        this.sorted = true;
    }

    public Comparator<? super E> getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator<? super E> comparator) {
        if (this.comparator == null || comparator == null || !this.comparator.equals(comparator)) {
            this.sorted = false;
        }
        this.comparator = comparator;
    }

    public boolean isSorted() {
        return this.sorted;
    }

    @Override
    public Iterator<E> iterator() {
        this.sort();
        return this.delegate.iterator();
    }

    @Override
    public boolean add(E e) {
        this.sorted = false;
        return this.delegate.add(e);
    }

    @Override
    public boolean contains(Object object) {
        return this.delegate.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.delegate.containsAll(collection);
    }

    @Override
    public int indexOf(Object object) {
        this.sort();
        return this.delegate.indexOf(object);
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int lastIndexOf(Object object) {
        this.sort();
        return this.delegate.lastIndexOf(object);
    }

    @Override
    public ListIterator<E> listIterator() {
        this.sort();
        return this.delegate.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        this.sort();
        return this.delegate.listIterator(n);
    }

    @Override
    public boolean remove(Object object) {
        return this.delegate.remove(object);
    }

    @Override
    public E remove(int n) {
        return this.delegate.remove(n);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.delegate.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.delegate.retainAll(collection);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public List<E> subList(int n, int n2) {
        this.sort();
        return this.delegate.subList(n, n2);
    }

    @Override
    public Object[] toArray() {
        this.sort();
        return this.delegate.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        this.sort();
        return this.delegate.toArray(TArray);
    }

    public void sort() {
        if (this.sorted) {
            return;
        }
        if (this.comparator != null) {
            Collections.sort(this.delegate, this.comparator);
            this.sorted = true;
        } else {
            ArrayList<E> arrayList = this.delegate;
            Collections.sort(arrayList);
        }
    }
}

