/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.model;

import com.jidesoft.chart.Orientation;
import com.jidesoft.chart.annotation.Annotation;
import com.jidesoft.chart.model.AbstractDelegatingChartModel;
import com.jidesoft.chart.model.AnnotatedChartModel;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.ChartModelListener;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.range.Positionable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class SortedChartModel
extends AbstractDelegatingChartModel
implements AnnotatedChartModel,
ChartModelListener {
    private static final Integer NOT_FOUND_INDEX = -1;
    private Comparator<Integer> comparator = new ChartableComparator();
    private List<Integer> indices = new ArrayList<Integer>();
    private Orientation orientation = Orientation.horizontal;
    private boolean sorted = false;
    private boolean sortIncreasing = true;

    public SortedChartModel() {
    }

    public SortedChartModel(ChartModel chartModel, Orientation orientation) {
        this.setDelegate(chartModel);
        this.orientation = orientation;
    }

    public SortedChartModel(ChartModel chartModel, Orientation orientation, boolean bl) {
        this.setDelegate(chartModel);
        this.setOrientation(orientation);
        this.sortIncreasing = bl;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
    }

    @Override
    public void setDelegate(ChartModel chartModel) {
        AnnotatedChartModel annotatedChartModel = this.getDelegate();
        if (annotatedChartModel != null) {
            annotatedChartModel.removeChartModelListener(this);
        }
        if (chartModel != null) {
            super.setDelegate(chartModel);
        }
        this.sorted = false;
        if (chartModel != null) {
            chartModel.addChartModelListener(this);
        }
    }

    public boolean isSortIncreasing() {
        return this.sortIncreasing;
    }

    public void setSortIncreasing(boolean bl) {
        this.sortIncreasing = bl;
    }

    @Override
    public void chartModelChanged() {
        this.update();
        this.fireModelChanged();
    }

    public Integer getDelegateIndex(int n) {
        if (!this.sorted) {
            this.update();
        }
        try {
            Integer n2 = this.indices.get(n);
            return n2 == null ? NOT_FOUND_INDEX : n2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return NOT_FOUND_INDEX;
        }
    }

    @Override
    public void update() {
        this.indices.clear();
        AnnotatedChartModel annotatedChartModel = this.getDelegate();
        if (annotatedChartModel != null) {
            int n = annotatedChartModel.getPointCount();
            for (int i = 0; i < n; ++i) {
                this.indices.add(i);
            }
            if (this.sortIncreasing) {
                Collections.sort(this.indices, this.comparator);
            } else {
                Collections.sort(this.indices, Collections.reverseOrder(this.comparator));
            }
        }
        this.sorted = true;
    }

    @Override
    public String getName() {
        AnnotatedChartModel annotatedChartModel = this.getDelegate();
        return annotatedChartModel == null ? "" : annotatedChartModel.getName();
    }

    @Override
    public void setName(String string) {
        throw new RuntimeException("Setting name of a SortedChartModel");
    }

    @Override
    public Chartable getPoint(int n) {
        AnnotatedChartModel annotatedChartModel = this.getDelegate();
        int n2 = this.getDelegateIndex(n);
        return n2 < 0 ? null : annotatedChartModel.getPoint(n2);
    }

    @Override
    public int getPointCount() {
        AnnotatedChartModel annotatedChartModel = this.getDelegate();
        return annotatedChartModel == null ? 0 : annotatedChartModel.getPointCount();
    }

    @Override
    public boolean isCyclical() {
        AnnotatedChartModel annotatedChartModel = this.getDelegate();
        return annotatedChartModel != null && annotatedChartModel.isCyclical();
    }

    @Override
    public Iterator<Chartable> iterator() {
        if (!this.sorted) {
            this.update();
        }
        AnnotatedChartModel annotatedChartModel = this.getDelegate();
        ArrayList<Chartable> arrayList = new ArrayList<Chartable>();
        for (Integer n : this.indices) {
            arrayList.add(annotatedChartModel.getPoint(n));
        }
        return arrayList.iterator();
    }

    protected AnnotatedChartModel getAnnotatedDelegate() {
        return this.getDelegate();
    }

    @Override
    public Annotation getAnnotation(int n) {
        AnnotatedChartModel annotatedChartModel = this.getAnnotatedDelegate();
        return annotatedChartModel == null ? null : annotatedChartModel.getAnnotation(n);
    }

    @Override
    public int getAnnotationCount() {
        AnnotatedChartModel annotatedChartModel = this.getAnnotatedDelegate();
        return annotatedChartModel == null ? 0 : annotatedChartModel.getAnnotationCount();
    }

    @Override
    public boolean isAnnotationsVisible() {
        AnnotatedChartModel annotatedChartModel = this.getAnnotatedDelegate();
        return annotatedChartModel != null && annotatedChartModel.isAnnotationsVisible();
    }

    @Override
    public void setAnnotationsVisible(boolean bl) {
        AnnotatedChartModel annotatedChartModel = this.getAnnotatedDelegate();
        if (annotatedChartModel != null) {
            annotatedChartModel.setAnnotationsVisible(bl);
        }
    }

    private class ChartableComparator
    implements Comparator<Integer> {
        private ChartableComparator() {
        }

        @Override
        public int compare(Integer n, Integer n2) {
            Positionable positionable;
            Chartable chartable;
            if (n == null && n2 == null) {
                return 0;
            }
            if (n == null) {
                return -1;
            }
            if (n2 == null) {
                return 1;
            }
            if (n.equals(n2)) {
                return 0;
            }
            Orientation orientation = SortedChartModel.this.getOrientation();
            AnnotatedChartModel annotatedChartModel = SortedChartModel.this.getDelegate();
            Chartable chartable2 = annotatedChartModel.getPoint(n);
            if (chartable2 == (chartable = annotatedChartModel.getPoint(n2))) {
                return 0;
            }
            if (chartable2 == null) {
                return -1;
            }
            if (chartable == null) {
                return 1;
            }
            Positionable positionable2 = orientation == Orientation.vertical ? chartable2.getX() : chartable2.getY();
            Positionable positionable3 = positionable = orientation == Orientation.vertical ? chartable.getX() : chartable.getY();
            if (positionable2 == positionable) {
                return 0;
            }
            if (positionable2 == null) {
                return -1;
            }
            if (positionable == null) {
                return 1;
            }
            return positionable2.compareTo(positionable);
        }
    }
}

