/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.model;

import com.jidesoft.range.Positionable;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class RealPosition
implements Positionable {
    @XmlAttribute
    private double position = 0.0;

    public RealPosition() {
    }

    public RealPosition(double d) {
        this.position = d;
    }

    @Override
    public double position() {
        return this.position;
    }

    public String toString() {
        return String.format("#<RealPosition position=%f>", this.position);
    }

    @Override
    public int compareTo(Positionable positionable) {
        if (positionable == null) {
            return 1;
        }
        double d = positionable.position();
        if (Double.isNaN(this.position) || Double.isNaN(d)) {
            if (Double.isNaN(this.position) && Double.isNaN(d)) {
                return 0;
            }
            if (Double.isNaN(this.position)) {
                return 1;
            }
            return -1;
        }
        if (this.position < d) {
            return -1;
        }
        if (this.position > d) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.position);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RealPosition realPosition = (RealPosition)object;
        return Double.doubleToLongBits(this.position) == Double.doubleToLongBits(realPosition.position);
    }
}

